/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.reports;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import org.asf.cyan.fluid.reports.CallableReportEntry;
import org.asf.cyan.fluid.reports.ReportEntry;
import org.asf.cyan.fluid.reports.ReportEntryList;

public class ReportNode {
    public String name;
    public ReportEntryList entries;

    public ReportNode(String name) {
        this.name = name;
        this.entries = new ReportEntryList();
    }

    public ReportNode(String name, ReportEntryList entries) {
        this.name = name;
        this.entries = entries;
    }

    public ReportNode addAll(Collection<ReportEntry<?>> c) {
        this.entries.addAll(c);
        return this;
    }

    public ReportNode addAll(Map<String, ?> c) {
        c.forEach((k, v) -> this.add((String)k, (Object)v));
        return this;
    }

    public ReportNode addAll(int index, Collection<ReportEntry<?>> c) {
        this.entries.addAll(index, c);
        return this;
    }

    public ReportNode addAll(Object ... reportMap) {
        if (reportMap.length % 2 == 0) {
            for (int i = 0; i < reportMap.length; ++i) {
                if (!(reportMap[i] instanceof String)) {
                    throw new IllegalArgumentException("Invalid argument type, expected a " + String.class.getTypeName() + ", got " + reportMap[i].getClass().getTypeName());
                }
                String key = reportMap[i].toString();
                Object value = reportMap[i + 1];
                this.add(key, value);
                ++i;
            }
        } else {
            throw new IndexOutOfBoundsException("Not a valid value map.");
        }
        return this;
    }

    public ReportNode addAll(int index, Map<String, ?> c) {
        ArrayList items = new ArrayList();
        c.forEach((k, v) -> items.add(new ReportEntry<Object>((String)k, v)));
        this.addAll(index, items);
        return this;
    }

    public ReportNode add(int index, ReportEntry<?> entry) {
        this.entries.add(index, entry);
        return this;
    }

    public ReportNode add(ReportEntry<?> entry) {
        this.entries.add(entry);
        return this;
    }

    public <T> ReportNode add(T value) {
        this.entries.add(null, value);
        return this;
    }

    public <T> ReportNode add(int index, T value) {
        this.entries.add(index, null, value);
        return this;
    }

    public <T> ReportNode add(int index, String key, T value) {
        this.entries.add(index, key, value);
        return this;
    }

    public <T> ReportNode add(String key, T value) {
        this.entries.add(key, value);
        return this;
    }

    public ReportNode add(int index, CallableReportEntry entry) {
        this.entries.add(index, entry);
        return this;
    }

    public ReportNode add(CallableReportEntry entry) {
        this.entries.add(entry);
        return this;
    }

    public <T> ReportNode add(int index, String key, Supplier<?> value) {
        this.entries.add(index, key, value);
        return this;
    }

    public <T> ReportNode add(String key, Supplier<?> value) {
        this.entries.add(key, value);
        return this;
    }

    public <T> ReportNode add(int index, Supplier<?> value) {
        this.entries.add(index, value);
        return this;
    }

    public <T> ReportNode add(Supplier<?> value) {
        this.entries.add(value);
        return this;
    }
}

