/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid;

import java.io.File;
import java.io.IOException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.jar.JarFile;
import org.asf.cyan.fluid.DynamicClassLoader;
import org.asf.cyan.fluid.Fluid;
import org.asf.cyan.fluid.Transformers;
import org.asf.cyan.fluid.bytecode.sources.LoaderClassSourceProvider;

public class FluidAgent {
    private static boolean initialized = false;
    private static boolean loaded = false;
    private static ArrayList<ClassLoader> knownLoaders = new ArrayList();
    static boolean ranHooks = false;
    private static boolean loadedAgents = false;
    private static Instrumentation inst = null;

    public static void premain(String args, Instrumentation inst) {
        FluidAgent.agentmain(args, inst);
    }

    public static String getMarker() {
        return "Agent";
    }

    public static void initialize() {
        if (initialized) {
            throw new IllegalStateException("Cannot re-initialize FLUID!");
        }
        if (!Transformers.isInitialized()) {
            Transformers.initialize();
        }
    }

    public static void addToClassPath(File f) throws IOException {
        inst.appendToSystemClassLoaderSearch(new JarFile(f));
    }

    public static void agentmain(final String args, final Instrumentation inst) {
        if (FluidAgent.inst == null) {
            FluidAgent.inst = inst;
        }
        if (loaded) {
            return;
        }
        loaded = true;
        inst.addTransformer(new ClassFileTransformer(){

            @Override
            public synchronized byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
                if (!initialized) {
                    return null;
                }
                if (!loadedAgents) {
                    loadedAgents = true;
                    if (!DynamicClassLoader.knowsLoadedClassProvider("fluidagent")) {
                        DynamicClassLoader.registerLoadedClassProvider(new DynamicClassLoader.LoadedClassProvider(){

                            @Override
                            public String name() {
                                return "fluidagent";
                            }

                            @Override
                            public Class<?> provide(String name) {
                                return FluidAgent.getLoadedClass(name);
                            }
                        });
                    }
                    Fluid.getAgents().forEach((cls, meth) -> {
                        try {
                            Class<?> agent = FluidAgent.class.getClassLoader().loadClass((String)cls);
                            if (meth != null) {
                                Method mth = agent.getMethod((String)meth, String.class, Instrumentation.class);
                                mth.invoke(null, args, inst);
                            }
                        }
                        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                            // empty catch block
                        }
                    });
                }
                if (loader != null && !knownLoaders.contains(loader)) {
                    knownLoaders.add(loader);
                    Transformers.addClassSource(new LoaderClassSourceProvider(loader));
                }
                return Transformers.applyTransformers(className, classfileBuffer, loader);
            }
        });
    }

    public static void forAllClasses(Consumer<Class<?>> function) {
        Class[] classes;
        for (Class cls : classes = inst.getAllLoadedClasses()) {
            function.accept(cls);
        }
    }

    public static Class<?> getLoadedClass(String name) {
        Class[] classes;
        for (Class cls : classes = inst.getAllLoadedClasses()) {
            if (!cls.getTypeName().equals(name)) continue;
            return cls;
        }
        return null;
    }
}

