/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.xmls.quests;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import org.asf.edge.common.xmls.achievements.AchievementRewardData;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
public class MissionData {
    @JsonProperty(value="I")
    public int id;
    @JsonProperty(value="N")
    public String name;
    @JsonProperty(value="G")
    public int groupID;
    @JsonProperty(value="P")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public int parentQuestID;
    @JsonProperty(value="S")
    public String staticData;
    @JsonProperty(value="A")
    public boolean accepted;
    @JsonProperty(value="C")
    public int completed;
    @JsonProperty(value="MR")
    public MissionRulesBlock missionRules;
    @JsonProperty(value="V")
    public int version;
    @JsonProperty(value="AID")
    public int achievementID;
    @JsonProperty(value="AAID")
    public int acceptanceAchievementID;
    @JsonProperty(value="M")
    @JacksonXmlElementWrapper(useWrapping=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public MissionData[] childMissions;
    @JsonProperty(value="Task")
    @JacksonXmlElementWrapper(useWrapping=false)
    public TaskBlock[] tasks;
    @JsonProperty(value="AR")
    @JacksonXmlElementWrapper(useWrapping=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AchievementRewardData[] rewards;
    @JsonProperty(value="AAR")
    @JacksonXmlElementWrapper(useWrapping=false)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public AchievementRewardData[] acceptanceRewards;
    @JsonProperty(value="RPT")
    public String repeatable;

    public MissionData copy() {
        int i;
        MissionData cp = new MissionData();
        cp.staticData = this.staticData;
        cp.acceptanceAchievementID = this.acceptanceAchievementID;
        if (this.acceptanceRewards != null) {
            cp.acceptanceRewards = new AchievementRewardData[this.acceptanceRewards.length];
            for (i = 0; i < cp.acceptanceRewards.length; ++i) {
                cp.acceptanceRewards[i] = this.acceptanceRewards[i].copy();
            }
        }
        cp.accepted = this.accepted;
        cp.achievementID = this.achievementID;
        if (this.childMissions != null) {
            cp.childMissions = new MissionData[this.childMissions.length];
            for (i = 0; i < cp.childMissions.length; ++i) {
                cp.childMissions[i] = this.childMissions[i].copy();
            }
        }
        cp.completed = this.completed;
        cp.groupID = this.groupID;
        cp.id = this.id;
        if (this.missionRules != null) {
            cp.missionRules = this.missionRules.copy();
        }
        cp.name = this.name;
        cp.parentQuestID = this.parentQuestID;
        cp.repeatable = this.repeatable;
        if (this.tasks != null) {
            cp.tasks = new TaskBlock[this.tasks.length];
            for (i = 0; i < cp.tasks.length; ++i) {
                cp.tasks[i] = this.tasks[i].copy();
            }
        }
        if (this.rewards != null) {
            cp.rewards = new AchievementRewardData[this.rewards.length];
            for (i = 0; i < cp.rewards.length; ++i) {
                cp.rewards[i] = this.rewards[i].copy();
            }
        }
        cp.version = this.version;
        return cp;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
    public static class MissionRulesBlock {
        @JacksonXmlElementWrapper(useWrapping=false)
        public PrerequisiteInfoBlock[] prerequisites;
        public CriteriaBlock criteria;

        public MissionRulesBlock copy() {
            MissionRulesBlock cp = new MissionRulesBlock();
            if (this.criteria != null) {
                cp.criteria = this.criteria.copy();
            }
            if (this.prerequisites != null) {
                cp.prerequisites = new PrerequisiteInfoBlock[this.prerequisites.length];
                for (int i = 0; i < cp.prerequisites.length; ++i) {
                    cp.prerequisites[i] = this.prerequisites[i].copy();
                }
            }
            return cp;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
        public static class CriteriaBlock {
            public String type;
            public boolean ordered;
            public int min;
            public int repeat;
            @JsonProperty(value="RuleItems")
            @JacksonXmlElementWrapper(useWrapping=false)
            public RuleInfoBlock[] rules;

            public CriteriaBlock copy() {
                CriteriaBlock cp = new CriteriaBlock();
                cp.type = this.type;
                cp.ordered = this.ordered;
                cp.min = this.min;
                cp.repeat = this.repeat;
                if (this.rules != null) {
                    cp.rules = new RuleInfoBlock[this.rules.length];
                    for (int i = 0; i < cp.rules.length; ++i) {
                        cp.rules[i] = this.rules[i].copy();
                    }
                }
                return cp;
            }

            @JsonIgnoreProperties(ignoreUnknown=true)
            @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
            public static class RuleInfoBlock {
                public int type;
                public int missionID;
                @JsonProperty(value="ID")
                public int id;
                public int complete;

                public RuleInfoBlock copy() {
                    RuleInfoBlock cp = new RuleInfoBlock();
                    cp.type = this.type;
                    cp.missionID = this.missionID;
                    cp.id = this.id;
                    cp.complete = this.complete;
                    return cp;
                }

                public static class RuleInfoTypes {
                    public static final int TASK = 1;
                    public static final int MISSION = 2;
                }
            }
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
        public static class PrerequisiteInfoBlock {
            public int type;
            public String value;
            @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
            public int quantity;
            public boolean clientRule;

            public PrerequisiteInfoBlock copy() {
                PrerequisiteInfoBlock cp = new PrerequisiteInfoBlock();
                cp.type = this.type;
                cp.value = this.value;
                cp.quantity = this.quantity;
                cp.clientRule = this.clientRule;
                return cp;
            }

            public static class PrerequisiteRuleTypes {
                public static final int MEMBER = 1;
                public static final int ACCEPT = 2;
                public static final int MISSION = 3;
                public static final int RANK = 4;
                public static final int DATERANGE = 5;
                public static final int ITEM = 7;
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
    public static class TaskBlock {
        @JsonProperty(value="I")
        public int id;
        @JsonProperty(value="N")
        public String name;
        @JsonProperty(value="S")
        public String staticData;
        @JsonProperty(value="C")
        public int completed;
        @JsonProperty(value="F")
        public boolean failed;
        @JsonProperty(value="P")
        public String payload;

        public TaskBlock copy() {
            TaskBlock cp = new TaskBlock();
            cp.completed = this.completed;
            cp.failed = this.failed;
            cp.id = this.id;
            cp.name = this.name;
            cp.payload = this.payload;
            cp.staticData = this.staticData;
            return cp;
        }
    }
}

