/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.util.inventory.defaultvalidators;

import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.entities.items.PlayerInventory;
import org.asf.edge.common.entities.items.PlayerInventoryContainer;
import org.asf.edge.common.entities.items.PlayerInventoryItem;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.xmls.items.relation.ItemRelationData;
import org.asf.edge.gameplayapi.util.inventory.AbstractInventorySecurityValidator;
import org.asf.edge.gameplayapi.xmls.inventories.SetCommonInventoryRequestData;

public class BundleSecurityValidator
extends AbstractInventorySecurityValidator {
    @Override
    public boolean isValidRequest(SetCommonInventoryRequestData request, AccountDataContainer data, PlayerInventory inventory, PlayerInventoryContainer inventoryContainer, PlayerInventoryItem item) {
        int defID = request.itemID;
        ItemInfo def = ItemManager.getInstance().getItemDefinition(defID);
        if (def == null) {
            return false;
        }
        if (request.quantity < 0) {
            return true;
        }
        return !BundleSecurityValidator.isBundle(def);
    }

    private static boolean isBundle(ItemInfo def) {
        for (ItemRelationData n : def.getRawObject().relations) {
            if (!BundleSecurityValidator.isBundleItem(n)) continue;
            return true;
        }
        return false;
    }

    private static boolean isBundleItem(ItemRelationData rel) {
        return rel.type.equalsIgnoreCase("Bundle");
    }
}

