/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.util.inventory.defaulthandlers;

import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.xmls.items.ItemDefData;
import org.asf.edge.common.xmls.items.attributes.ItemAttributeData;
import org.asf.edge.gameplayapi.util.inventory.AbstractItemRedemptionHandler;
import org.asf.edge.gameplayapi.util.inventory.ItemRedemptionInfo;
import org.asf.edge.gameplayapi.xmls.inventories.InventoryUpdateResponseData;

public class GemItemRedemptionHandler
extends AbstractItemRedemptionHandler {
    @Override
    public boolean canHandle(ItemInfo item) {
        ItemDefData raw = item.getRawObject();
        for (ItemAttributeData n : raw.attributes) {
            if (!n.key.equalsIgnoreCase("VCashRedemptionValue")) continue;
            return true;
        }
        return false;
    }

    @Override
    public AbstractItemRedemptionHandler.RedemptionResult handleRedemption(ItemInfo item, ItemRedemptionInfo req, AccountObject account, AccountSaveContainer save, InventoryUpdateResponseData.CurrencyUpdateBlock currencyUpdate) {
        int amount = 0;
        ItemDefData raw = item.getRawObject();
        for (ItemAttributeData n : raw.attributes) {
            if (!n.key.equalsIgnoreCase("VCashRedemptionValue")) continue;
            amount = Integer.parseInt(n.value);
        }
        currencyUpdate.gemCount += amount * req.quantity;
        return AbstractItemRedemptionHandler.RedemptionResult.success();
    }
}

