/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import org.asf.edge.common.entities.achivements.RankTypeID;
import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.entities.items.PlayerInventory;
import org.asf.edge.common.entities.items.PlayerInventoryContainer;
import org.asf.edge.common.entities.items.PlayerInventoryItem;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.xmls.achievements.AchievementRewardData;
import org.asf.edge.common.xmls.items.inventory.InventoryItemEntryData;
import org.asf.edge.gameplayapi.xmls.dragons.DragonData;

public class RewardsUtil {
    private static Random rnd = new Random();

    public static AchievementRewardData[] giveRewardsTo(AccountSaveContainer save, AchievementRewardData[] rewardDefs, boolean wasGivenBefore, int invContainer) throws IOException {
        ArrayList<AchievementRewardData> rewards = new ArrayList<AchievementRewardData>();
        if (rewardDefs != null) {
            for (AchievementRewardData reward : rewardDefs) {
                if (!reward.allowMultiple && wasGivenBefore) continue;
                reward = reward.copy();
                reward.allowMultiple = false;
                reward.entityID = UUID.fromString(save.getSaveID());
                if (reward.minAmount != -1 && reward.maxAmount != -1) {
                    reward.amount = rnd.nextInt(reward.minAmount, reward.maxAmount + 1);
                    reward.minAmount = 0;
                    reward.maxAmount = 0;
                }
                switch (reward.pointTypeID) {
                    case 1: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        RankTypeID id = RankTypeID.getByTypeID((int)reward.pointTypeID);
                        String userID = RewardsUtil.rankUserID(save, id);
                        reward.entityID = UUID.fromString(userID);
                        reward.achievementID = 0;
                        if (userID == null) break;
                        reward.amount = AchievementManager.getInstance().getRank(save, userID, id).addPoints(reward.amount);
                        break;
                    }
                    case 2: {
                        AccountDataContainer currency = save.getSaveData().getChildContainer("currency");
                        int currentC = 300;
                        if (currency.entryExists("coins")) {
                            currentC = currency.getEntry("coins").getAsInt();
                        }
                        currency.setEntry("coins", (JsonElement)new JsonPrimitive((Number)(currentC + reward.amount)));
                        break;
                    }
                    case 5: {
                        AccountDataContainer currencyAccWide = save.getAccount().getAccountData().getChildContainer("currency");
                        int currentG = 0;
                        if (currencyAccWide.entryExists("gems")) {
                            currentG = currencyAccWide.getEntry("gems").getAsInt();
                        }
                        currencyAccWide.setEntry("gems", (JsonElement)new JsonPrimitive((Number)(currentG + reward.amount)));
                        break;
                    }
                    case 6: {
                        PlayerInventory inv = save.getInventory();
                        PlayerInventoryContainer cont = inv.getContainer(invContainer);
                        PlayerInventoryItem itm = cont.findFirst(reward.itemID);
                        if (itm != null) {
                            itm.add(reward.amount);
                        } else {
                            itm = cont.createItem(reward.itemID, reward.amount);
                        }
                        reward.achievementID = 0;
                        reward.uniqueRewardItemID = itm.getUniqueID();
                        InventoryItemEntryData block = new InventoryItemEntryData();
                        block.itemID = itm.getItemDefID();
                        block.quantity = itm.getQuantity();
                        block.uses = itm.getUses();
                        block.uniqueItemID = itm.getUniqueID();
                        ItemInfo def = ItemManager.getInstance().getItemDefinition(block.itemID);
                        if (def != null) {
                            block.data = def.getRawObject();
                        }
                        reward.rewardItem = block;
                        break;
                    }
                }
                rewards.add(reward);
            }
        }
        return (AchievementRewardData[])rewards.toArray(AchievementRewardData[]::new);
    }

    private static String rankUserID(AccountSaveContainer save, RankTypeID id) throws JsonMappingException, JsonProcessingException, IOException {
        String userID = save.getSaveID();
        if (id == RankTypeID.CLAN) {
            return null;
        }
        if (id == RankTypeID.DRAGON) {
            AccountDataContainer data = save.getSaveData();
            data = data.getChildContainer("dragons");
            JsonArray dragonIds = new JsonArray();
            if (data.entryExists("dragonlist")) {
                dragonIds = data.getEntry("dragonlist").getAsJsonArray();
            } else {
                data.setEntry("dragonlist", (JsonElement)dragonIds);
            }
            for (JsonElement ele : dragonIds) {
                String did = ele.getAsString();
                DragonData dragon = (DragonData)new XmlMapper().readValue(data.getEntry("dragon-" + did).getAsString(), DragonData.class);
                if (!dragon.isSelected) continue;
                userID = dragon.entityID;
                break;
            }
        }
        return userID;
    }

    public static void addRewards(AccountSaveContainer save, AchievementRewardData[] rewardDefs, boolean wasGivenBefore, int invContainer) throws IOException {
        if (rewardDefs != null) {
            block6: for (AchievementRewardData reward : rewardDefs) {
                if (!reward.allowMultiple && wasGivenBefore) continue;
                switch (reward.pointTypeID) {
                    case 1: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        RankTypeID id = RankTypeID.getByTypeID((int)reward.pointTypeID);
                        String userID = RewardsUtil.rankUserID(save, id);
                        reward.entityID = UUID.fromString(userID);
                        if (userID == null) continue block6;
                        reward.amount = AchievementManager.getInstance().getRank(save, userID, id).addPoints(reward.amount);
                        continue block6;
                    }
                    case 2: {
                        AccountDataContainer currency = save.getSaveData().getChildContainer("currency");
                        int currentC = 300;
                        if (currency.entryExists("coins")) {
                            currentC = currency.getEntry("coins").getAsInt();
                        }
                        currency.setEntry("coins", (JsonElement)new JsonPrimitive((Number)(currentC + reward.amount)));
                        continue block6;
                    }
                    case 5: {
                        AccountDataContainer currencyAccWide = save.getAccount().getAccountData().getChildContainer("currency");
                        int currentG = 0;
                        if (currencyAccWide.entryExists("gems")) {
                            currentG = currencyAccWide.getEntry("gems").getAsInt();
                        }
                        currencyAccWide.setEntry("gems", (JsonElement)new JsonPrimitive((Number)(currentG + reward.amount)));
                        continue block6;
                    }
                    case 6: {
                        PlayerInventory inv = save.getInventory();
                        PlayerInventoryContainer cont = inv.getContainer(invContainer);
                        PlayerInventoryItem itm = cont.findFirst(reward.itemID);
                        if (itm != null) {
                            itm.add(reward.amount);
                        } else {
                            itm = cont.createItem(reward.itemID, reward.amount);
                        }
                        InventoryItemEntryData block = new InventoryItemEntryData();
                        block.itemID = itm.getItemDefID();
                        block.quantity = itm.getQuantity();
                        block.uses = itm.getUses();
                        block.uniqueItemID = itm.getUniqueID();
                        ItemInfo def = ItemManager.getInstance().getItemDefinition(block.itemID);
                        if (def == null) continue block6;
                        block.data = def.getRawObject();
                        continue block6;
                    }
                }
            }
        }
    }
}

