/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.tools;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.services.AbstractService;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.services.items.impl.ItemManagerImpl;
import org.asf.edge.common.xmls.achievements.AchievementRewardData;
import org.asf.edge.common.xmls.items.ItemDefData;
import org.asf.edge.common.xmls.items.state.ItemStateData;
import org.asf.edge.gameplayapi.services.quests.QuestManager;
import org.asf.edge.gameplayapi.services.quests.impl.QuestManagerImpl;
import org.asf.edge.gameplayapi.xmls.achievements.AchievementRewardList;
import org.asf.edge.gameplayapi.xmls.achievements.StableQuestData;
import org.asf.edge.gameplayapi.xmls.achievements.StableQuestRewardBlock;
import org.asf.edge.gameplayapi.xmls.achievements.edgespecific.AchievementRewardDefData;
import org.asf.edge.gameplayapi.xmls.achievements.edgespecific.AchievementRewardDefList;
import org.asf.edge.gameplayapi.xmls.quests.MissionData;

public class AchievementRewardDataConverter {
    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws JsonSyntaxException, IOException {
        void var5_7;
        XmlMapper mapper = new XmlMapper();
        mapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        mapper.configure(ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL, true);
        File outputFile = new File(args[0]);
        if (outputFile.getParentFile() != null) {
            outputFile.getParentFile().mkdirs();
        }
        AchievementRewardDefList rewardDataList = new AchievementRewardDefList();
        LinkedHashMap<Integer, Object> rewards = new LinkedHashMap<Integer, Object>();
        if (outputFile.exists()) {
            rewardDataList = (AchievementRewardDefList)mapper.readValue(Files.readString(outputFile.toPath()), AchievementRewardDefList.class);
            if (rewardDataList.rewards != null) {
                for (AchievementRewardDefData achievementRewardDefData : rewardDataList.rewards) {
                    rewards.put(achievementRewardDefData.achievementID, achievementRewardDefData);
                }
            }
        }
        boolean bl = true;
        while (var5_7 < args.length) {
            AchievementRewardDataConverter.runForFiles(file -> {
                if (file.getName().equalsIgnoreCase("TimedMissionDO.xml")) {
                    System.out.println("Importing: " + file);
                    try {
                        StableQuestData stData = (StableQuestData)mapper.readValue(Files.readString(file.toPath()), StableQuestData.class);
                        if (stData.missions == null) return;
                        for (StableQuestData.MissionBlock data : stData.missions) {
                            AchievementRewardDefData.AchievementRewardEntryBlock entry;
                            AchievementRewardDefData def = (AchievementRewardDefData)rewards.get(data.winAchievementID);
                            if (def == null) {
                                def = new AchievementRewardDefData();
                            }
                            def.achievementID = data.winAchievementID;
                            LinkedHashMap<CallSite, Object> rewardEntries = new LinkedHashMap<CallSite, Object>();
                            if (def.rewards != null) {
                                for (AchievementRewardDefData.AchievementRewardEntryBlock achievementRewardEntryBlock : def.rewards) {
                                    rewardEntries.put((CallSite)((Object)(achievementRewardEntryBlock.rewardID + "-" + achievementRewardEntryBlock.pointTypeID)), achievementRewardEntryBlock);
                                }
                            }
                            for (StableQuestRewardBlock stableQuestRewardBlock : data.winRewards) {
                                entry = (AchievementRewardDefData.AchievementRewardEntryBlock)rewardEntries.get(stableQuestRewardBlock.rewardID + "-" + stableQuestRewardBlock.pointTypeID);
                                if (entry == null) {
                                    entry = new AchievementRewardDefData.AchievementRewardEntryBlock();
                                    entry.rewardID = stableQuestRewardBlock.rewardID;
                                    entry.pointTypeID = stableQuestRewardBlock.pointTypeID;
                                    entry.itemID = stableQuestRewardBlock.itemID;
                                    rewardEntries.put((CallSite)((Object)(stableQuestRewardBlock.rewardID + "-" + stableQuestRewardBlock.pointTypeID)), entry);
                                }
                                entry.entityTypeID = stableQuestRewardBlock.entityTypeID;
                                if (stableQuestRewardBlock.amount < entry.minAmount || entry.minAmount == 0) {
                                    entry.minAmount = stableQuestRewardBlock.amount;
                                }
                                if (stableQuestRewardBlock.amount <= entry.maxAmount) continue;
                                entry.maxAmount = stableQuestRewardBlock.amount;
                            }
                            def.rewards = (AchievementRewardDefData.AchievementRewardEntryBlock[])rewardEntries.values().toArray(AchievementRewardDefData.AchievementRewardEntryBlock[]::new);
                            rewards.put(data.winAchievementID, def);
                            def = (AchievementRewardDefData)rewards.get(data.loseAchievementID);
                            if (def == null) {
                                def = new AchievementRewardDefData();
                            }
                            def.achievementID = data.loseAchievementID;
                            rewardEntries = new LinkedHashMap();
                            if (def.rewards != null) {
                                for (AchievementRewardDefData.AchievementRewardEntryBlock achievementRewardEntryBlock : def.rewards) {
                                    rewardEntries.put((CallSite)((Object)(achievementRewardEntryBlock.rewardID + "-" + achievementRewardEntryBlock.pointTypeID)), achievementRewardEntryBlock);
                                }
                            }
                            for (StableQuestRewardBlock stableQuestRewardBlock : data.loseRewards) {
                                entry = (AchievementRewardDefData.AchievementRewardEntryBlock)rewardEntries.get(stableQuestRewardBlock.rewardID + "-" + stableQuestRewardBlock.pointTypeID);
                                if (entry == null) {
                                    entry = new AchievementRewardDefData.AchievementRewardEntryBlock();
                                    entry.rewardID = stableQuestRewardBlock.rewardID;
                                    entry.pointTypeID = stableQuestRewardBlock.pointTypeID;
                                    entry.itemID = stableQuestRewardBlock.itemID;
                                    rewardEntries.put((CallSite)((Object)(stableQuestRewardBlock.rewardID + "-" + stableQuestRewardBlock.pointTypeID)), entry);
                                }
                                entry.entityTypeID = stableQuestRewardBlock.entityTypeID;
                                if (stableQuestRewardBlock.amount < entry.minAmount || entry.minAmount == 0) {
                                    entry.minAmount = stableQuestRewardBlock.amount;
                                }
                                if (stableQuestRewardBlock.amount <= entry.maxAmount) continue;
                                entry.maxAmount = stableQuestRewardBlock.amount;
                            }
                            def.rewards = (AchievementRewardDefData.AchievementRewardEntryBlock[])rewardEntries.values().toArray(AchievementRewardDefData.AchievementRewardEntryBlock[]::new);
                            rewards.put(data.loseAchievementID, def);
                        }
                        return;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!file.getName().endsWith(".log")) return;
                System.out.println("Importing: " + file);
                FileInputStream sourceFile = null;
                try {
                    int b;
                    sourceFile = new FileInputStream((File)file);
                    Object buffer = "";
                    while ((b = sourceFile.read()) != -1) {
                        String resBody;
                        AchievementRewardList rewardData;
                        String url;
                        URL u;
                        JsonObject obj;
                        byte[] bufferD;
                        int read;
                        byte bb = (byte)b;
                        char ch = (char)bb;
                        if (ch == '\r' || ch == '\n') continue;
                        if (ch != '{') throw new IOException("Invalid file");
                        buffer = Character.toString(ch);
                        while ((read = sourceFile.read(bufferD = new byte[20480])) > 0) {
                            String bData = new String(bufferD, "UTF-8");
                            if (bData.contains("\n")) {
                                buffer = (String)buffer + bData.substring(0, bData.indexOf("\n"));
                                sourceFile.getChannel().position(sourceFile.getChannel().position() - (long)(read - bData.indexOf("\n")));
                                break;
                            }
                            buffer = (String)buffer + bData;
                        }
                        if (!((obj = JsonParser.parseString((String)buffer).getAsJsonObject()).has("time") && obj.has("request") && obj.has("response") && obj.get("request").getAsJsonObject().has("url") && obj.get("request").getAsJsonObject().has("method") && obj.get("request").getAsJsonObject().has("headers") && obj.get("request").getAsJsonObject().has("hasBody") && obj.get("response").getAsJsonObject().has("status") && obj.get("response").getAsJsonObject().has("statusMessage") && obj.get("response").getAsJsonObject().has("headers") && obj.get("response").getAsJsonObject().has("responseBody") || obj.has("type") && !obj.get("type").getAsString().equals("http"))) {
                            throw new IOException("Invalid file");
                        }
                        if (obj.has("type") && !obj.get("type").getAsString().equals("http") || !(u = new URL(url = obj.get("request").getAsJsonObject().get("url").getAsString())).getPath().equalsIgnoreCase("/AchievementWebService.asmx/SetUserAchievementAndGetReward") && !u.getPath().equalsIgnoreCase("/AchievementWebService.asmx/SetAchievementByEntityIDs")) continue;
                        byte[] dec = Base64.getDecoder().decode(obj.get("request").getAsJsonObject().get("requestBody").getAsString());
                        JsonObject headers = obj.get("request").getAsJsonObject().get("headers").getAsJsonObject();
                        if (headers.has("Content-Encoding") && headers.get("Content-Encoding").getAsString().equalsIgnoreCase("gzip")) {
                            GZIPInputStream gZIPInputStream = new GZIPInputStream(new ByteArrayInputStream(dec));
                            dec = gZIPInputStream.readAllBytes();
                            gZIPInputStream.close();
                        }
                        String string = new String(dec, "UTF-8");
                        Map<String, String> payload = AchievementRewardDataConverter.parseForm(string);
                        int achievementID = Integer.parseInt(payload.get("achievementID"));
                        dec = Base64.getDecoder().decode(obj.get("response").getAsJsonObject().get("responseBody").getAsString());
                        headers = obj.get("response").getAsJsonObject().get("headers").getAsJsonObject();
                        if (headers.has("Content-Encoding") && headers.get("Content-Encoding").getAsString().equalsIgnoreCase("gzip")) {
                            GZIPInputStream strm = new GZIPInputStream(new ByteArrayInputStream(dec));
                            dec = strm.readAllBytes();
                            strm.close();
                        }
                        if ((rewardData = (AchievementRewardList)mapper.readValue(resBody = new String(dec, "UTF-8"), AchievementRewardList.class)) == null) continue;
                        AchievementRewardDefData def = (AchievementRewardDefData)rewards.get(achievementID);
                        if (def == null) {
                            def = new AchievementRewardDefData();
                        }
                        def.achievementID = achievementID;
                        LinkedHashMap<CallSite, AchievementRewardDefData.AchievementRewardEntryBlock> rewardEntries = new LinkedHashMap<CallSite, AchievementRewardDefData.AchievementRewardEntryBlock>();
                        if (def.rewards != null) {
                            for (AchievementRewardDefData.AchievementRewardEntryBlock achievementRewardEntryBlock : def.rewards) {
                                rewardEntries.put((CallSite)((Object)(achievementRewardEntryBlock.rewardID + "-" + achievementRewardEntryBlock.pointTypeID)), achievementRewardEntryBlock);
                            }
                        }
                        if (rewardData.rewards != null) {
                            for (AchievementRewardDefData.AchievementRewardEntryBlock achievementRewardEntryBlock : rewardData.rewards) {
                                AchievementRewardDefData.AchievementRewardEntryBlock entry = (AchievementRewardDefData.AchievementRewardEntryBlock)rewardEntries.get(((AchievementRewardData)achievementRewardEntryBlock).rewardID + "-" + ((AchievementRewardData)achievementRewardEntryBlock).pointTypeID);
                                if (entry == null) {
                                    entry = new AchievementRewardDefData.AchievementRewardEntryBlock();
                                    entry.rewardID = ((AchievementRewardData)achievementRewardEntryBlock).rewardID;
                                    entry.pointTypeID = ((AchievementRewardData)achievementRewardEntryBlock).pointTypeID;
                                    entry.itemID = ((AchievementRewardData)achievementRewardEntryBlock).itemID;
                                    entry.allowMultiple = ((AchievementRewardData)achievementRewardEntryBlock).allowMultiple;
                                    rewardEntries.put((CallSite)((Object)(((AchievementRewardData)achievementRewardEntryBlock).rewardID + "-" + ((AchievementRewardData)achievementRewardEntryBlock).pointTypeID)), entry);
                                }
                                entry.entityTypeID = ((AchievementRewardData)achievementRewardEntryBlock).entityTypeID;
                                if (((AchievementRewardData)achievementRewardEntryBlock).amount / 2 < entry.minAmount || entry.minAmount == 0) {
                                    entry.minAmount = ((AchievementRewardData)achievementRewardEntryBlock).amount / 2;
                                }
                                if (((AchievementRewardData)achievementRewardEntryBlock).amount <= entry.maxAmount) continue;
                                entry.maxAmount = ((AchievementRewardData)achievementRewardEntryBlock).amount / 2;
                            }
                        }
                        def.rewards = (AchievementRewardDefData.AchievementRewardEntryBlock[])rewardEntries.values().toArray(AchievementRewardDefData.AchievementRewardEntryBlock[]::new);
                        rewards.put(achievementID, def);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    sourceFile.close();
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }, new File(args[var5_7]));
            ++var5_7;
        }
        System.out.println("Finding item states...");
        ServiceManager.registerServiceImplementation(ItemManager.class, (AbstractService)new ItemManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(ItemManager.class);
        for (ItemInfo itemInfo : ItemManager.getInstance().getAllItemDefinitions()) {
            ItemDefData iDef = itemInfo.getRawObject();
            if (iDef.states == null) continue;
            for (ItemStateData state : iDef.states) {
                void var15_28;
                if (state.rewards == null || state.rewards.length == 0) continue;
                System.out.println("Importing rewards of: " + iDef.id + " state " + state.stateID);
                int achievementID = state.achievementID;
                AchievementRewardDefData achievementRewardDefData = (AchievementRewardDefData)rewards.get(achievementID);
                if (achievementRewardDefData == null) {
                    AchievementRewardDefData achievementRewardDefData2 = new AchievementRewardDefData();
                }
                var15_28.achievementID = achievementID;
                LinkedHashMap<CallSite, AchievementRewardDefData.AchievementRewardEntryBlock> rewardEntries = new LinkedHashMap<CallSite, AchievementRewardDefData.AchievementRewardEntryBlock>();
                if (var15_28.rewards != null) {
                    for (AchievementRewardDefData.AchievementRewardEntryBlock achievementRewardEntryBlock : var15_28.rewards) {
                        rewardEntries.put((CallSite)((Object)(achievementRewardEntryBlock.rewardID + "-" + achievementRewardEntryBlock.pointTypeID)), achievementRewardEntryBlock);
                    }
                }
                for (AchievementRewardDefData.AchievementRewardEntryBlock achievementRewardEntryBlock : state.rewards) {
                    AchievementRewardDefData.AchievementRewardEntryBlock entry = (AchievementRewardDefData.AchievementRewardEntryBlock)rewardEntries.get(((AchievementRewardData)achievementRewardEntryBlock).rewardID + "-" + ((AchievementRewardData)achievementRewardEntryBlock).pointTypeID);
                    if (entry == null) {
                        entry = new AchievementRewardDefData.AchievementRewardEntryBlock();
                        entry.rewardID = ((AchievementRewardData)achievementRewardEntryBlock).rewardID;
                        entry.pointTypeID = ((AchievementRewardData)achievementRewardEntryBlock).pointTypeID;
                        entry.itemID = ((AchievementRewardData)achievementRewardEntryBlock).itemID;
                        entry.allowMultiple = ((AchievementRewardData)achievementRewardEntryBlock).allowMultiple;
                        rewardEntries.put((CallSite)((Object)(((AchievementRewardData)achievementRewardEntryBlock).rewardID + "-" + ((AchievementRewardData)achievementRewardEntryBlock).pointTypeID)), entry);
                    }
                    entry.entityTypeID = ((AchievementRewardData)achievementRewardEntryBlock).entityTypeID;
                    if (((AchievementRewardData)achievementRewardEntryBlock).amount < entry.minAmount || entry.minAmount == 0) {
                        entry.minAmount = ((AchievementRewardData)achievementRewardEntryBlock).amount;
                    }
                    if (((AchievementRewardData)achievementRewardEntryBlock).amount <= entry.maxAmount) continue;
                    entry.maxAmount = ((AchievementRewardData)achievementRewardEntryBlock).amount;
                }
                var15_28.rewards = (AchievementRewardDefData.AchievementRewardEntryBlock[])rewardEntries.values().toArray(AchievementRewardDefData.AchievementRewardEntryBlock[]::new);
                rewards.put(achievementID, var15_28);
            }
        }
        System.out.println("Finding quest reward data...");
        ServiceManager.registerServiceImplementation(QuestManager.class, (AbstractService)new QuestManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(QuestManager.class);
        for (MissionData missionData : QuestManager.getInstance().getAllQuestDefs()) {
            AchievementRewardDefData.AchievementRewardEntryBlock entry;
            LinkedHashMap<CallSite, AchievementRewardDefData.AchievementRewardEntryBlock> rewardEntries;
            AchievementRewardDefData def;
            int achievementID;
            if ((missionData.acceptanceRewards == null || missionData.acceptanceRewards.length == 0) && (missionData.rewards == null || missionData.rewards.length == 0)) continue;
            System.out.println("Importing rewards of: " + missionData.id);
            if (missionData.acceptanceRewards != null) {
                achievementID = missionData.acceptanceAchievementID;
                def = (AchievementRewardDefData)rewards.get(achievementID);
                if (def == null) {
                    def = new AchievementRewardDefData();
                }
                def.achievementID = achievementID;
                rewardEntries = new LinkedHashMap<CallSite, AchievementRewardDefData.AchievementRewardEntryBlock>();
                if (def.rewards != null) {
                    for (AchievementRewardDefData.AchievementRewardEntryBlock achievementRewardEntryBlock : def.rewards) {
                        rewardEntries.put((CallSite)((Object)(achievementRewardEntryBlock.rewardID + "-" + achievementRewardEntryBlock.pointTypeID)), achievementRewardEntryBlock);
                    }
                }
                for (AchievementRewardDefData.AchievementRewardEntryBlock achievementRewardEntryBlock : missionData.acceptanceRewards) {
                    entry = (AchievementRewardDefData.AchievementRewardEntryBlock)rewardEntries.get(((AchievementRewardData)achievementRewardEntryBlock).rewardID + "-" + ((AchievementRewardData)achievementRewardEntryBlock).pointTypeID);
                    if (entry == null) {
                        entry = new AchievementRewardDefData.AchievementRewardEntryBlock();
                        entry.rewardID = ((AchievementRewardData)achievementRewardEntryBlock).rewardID;
                        entry.pointTypeID = ((AchievementRewardData)achievementRewardEntryBlock).pointTypeID;
                        entry.itemID = ((AchievementRewardData)achievementRewardEntryBlock).itemID;
                        entry.allowMultiple = ((AchievementRewardData)achievementRewardEntryBlock).allowMultiple;
                        rewardEntries.put((CallSite)((Object)(((AchievementRewardData)achievementRewardEntryBlock).rewardID + "-" + ((AchievementRewardData)achievementRewardEntryBlock).pointTypeID)), entry);
                    }
                    entry.entityTypeID = ((AchievementRewardData)achievementRewardEntryBlock).entityTypeID;
                    entry.minAmount = ((AchievementRewardData)achievementRewardEntryBlock).minAmount;
                    entry.maxAmount = ((AchievementRewardData)achievementRewardEntryBlock).maxAmount;
                }
                def.rewards = (AchievementRewardDefData.AchievementRewardEntryBlock[])rewardEntries.values().toArray(AchievementRewardDefData.AchievementRewardEntryBlock[]::new);
                rewards.put(achievementID, def);
            }
            if (missionData.rewards == null) continue;
            achievementID = missionData.achievementID;
            def = (AchievementRewardDefData)rewards.get(achievementID);
            if (def == null) {
                def = new AchievementRewardDefData();
            }
            def.achievementID = achievementID;
            rewardEntries = new LinkedHashMap();
            if (def.rewards != null) {
                for (AchievementRewardDefData.AchievementRewardEntryBlock achievementRewardEntryBlock : def.rewards) {
                    rewardEntries.put((CallSite)((Object)(achievementRewardEntryBlock.rewardID + "-" + achievementRewardEntryBlock.pointTypeID)), achievementRewardEntryBlock);
                }
            }
            for (AchievementRewardDefData.AchievementRewardEntryBlock achievementRewardEntryBlock : missionData.rewards) {
                entry = (AchievementRewardDefData.AchievementRewardEntryBlock)rewardEntries.get(((AchievementRewardData)achievementRewardEntryBlock).rewardID + "-" + ((AchievementRewardData)achievementRewardEntryBlock).pointTypeID);
                if (entry == null) {
                    entry = new AchievementRewardDefData.AchievementRewardEntryBlock();
                    entry.rewardID = ((AchievementRewardData)achievementRewardEntryBlock).rewardID;
                    entry.pointTypeID = ((AchievementRewardData)achievementRewardEntryBlock).pointTypeID;
                    entry.itemID = ((AchievementRewardData)achievementRewardEntryBlock).itemID;
                    entry.allowMultiple = ((AchievementRewardData)achievementRewardEntryBlock).allowMultiple;
                    rewardEntries.put((CallSite)((Object)(((AchievementRewardData)achievementRewardEntryBlock).rewardID + "-" + ((AchievementRewardData)achievementRewardEntryBlock).pointTypeID)), entry);
                }
                entry.entityTypeID = ((AchievementRewardData)achievementRewardEntryBlock).entityTypeID;
                entry.minAmount = ((AchievementRewardData)achievementRewardEntryBlock).minAmount;
                entry.maxAmount = ((AchievementRewardData)achievementRewardEntryBlock).maxAmount;
            }
            def.rewards = (AchievementRewardDefData.AchievementRewardEntryBlock[])rewardEntries.values().toArray(AchievementRewardDefData.AchievementRewardEntryBlock[]::new);
            rewards.put(achievementID, def);
        }
        System.out.println("Imported " + rewards.size() + " rewards");
        rewardDataList.rewards = (AchievementRewardDefData[])rewards.values().toArray(AchievementRewardDefData[]::new);
        Files.writeString(outputFile.toPath(), (CharSequence)mapper.writer().withDefaultPrettyPrinter().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("RewardManifest").writeValueAsString((Object)rewardDataList), new OpenOption[0]);
    }

    private static Map<String, String> parseForm(String payload) {
        HashMap<String, String> frm = new HashMap<String, String>();
        Object key = "";
        Object value = "";
        boolean isKey = true;
        for (int i = 0; i < payload.length(); ++i) {
            char ch = payload.charAt(i);
            if (ch == '&') {
                if (isKey && !((String)key).isEmpty()) {
                    frm.put((String)key, "");
                    key = "";
                    continue;
                }
                if (isKey || ((String)key).isEmpty()) continue;
                try {
                    frm.put((String)key, URLDecoder.decode((String)value, "UTF-8"));
                }
                catch (Exception e) {
                    frm.put((String)key, (String)value);
                }
                isKey = true;
                key = "";
                value = "";
                continue;
            }
            if (ch == '=') {
                isKey = !isKey;
                continue;
            }
            if (isKey) {
                key = (String)key + ch;
                continue;
            }
            value = (String)value + ch;
        }
        if (!((String)key).isEmpty() || !((String)value).isEmpty()) {
            try {
                frm.put((String)key, URLDecoder.decode((String)value, "UTF-8"));
            }
            catch (Exception e) {
                frm.put((String)key, (String)value);
            }
        }
        return frm;
    }

    private static void runForFiles(Consumer<File> callback, File source) {
        if (!source.exists()) {
            return;
        }
        if (source.isFile()) {
            callback.accept(source);
            return;
        }
        for (File f : source.listFiles(t -> t.isDirectory())) {
            AchievementRewardDataConverter.runForFiles(callback, f);
        }
        for (File f : source.listFiles(t -> !t.isDirectory())) {
            AchievementRewardDataConverter.runForFiles(callback, f);
        }
    }
}

