/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.tools;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultCaret;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.EdgeServerEnvironment;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.util.HttpUpgradeUtil;

public class AccountDownloader {
    private static AccountDownloader downloadWindowInstance;
    private JFrame frmEdgeAccountDownloader;
    private JTextField boxServer;
    private JTextField boxUsername;
    private JTextField boxPassword;
    private JTextField textField;
    private JCheckBox chckbxGuestAcc;
    private JTextArea textArea = new JTextArea();
    private JProgressBar progressBar;
    private JButton btnNewButton_1;

    public static void main(String[] args) {
        EdgeServerEnvironment.initLogging();
        try {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e1) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AccountDownloader window;
                    downloadWindowInstance = window = new AccountDownloader();
                    WindowAppender.setup();
                    window.frmEdgeAccountDownloader.setVisible(true);
                    Logger logger = LogManager.getLogger((String)"Downloader");
                    logger.info("Waiting...");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public AccountDownloader() {
        this.initialize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadData() {
        String u;
        this.setValue(0);
        Logger logger = LogManager.getLogger((String)"Downloader");
        logger.info("Verifying settings...");
        Object url = this.boxServer.getText();
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        try {
            new URL((String)url);
        }
        catch (Exception e) {
            logger.error("Invalid server URL, unable to continue.");
            JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Server URL is not valid, please check the settings", "Error", 0);
            return;
        }
        if (this.textField.getText().isBlank()) {
            logger.error("Invalid target folder, unable to continue.");
            JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Please select an output folder", "Error", 0);
            return;
        }
        File outputDir = new File(this.textField.getText());
        if (!outputDir.exists()) {
            logger.error("Invalid target folder, unable to continue.");
            JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Invalid output folder, please make sure the folder you entered exists", "Error", 0);
            return;
        }
        logger.info("Processing login details...");
        String token = null;
        String[] guestIDs = null;
        if (this.chckbxGuestAcc.isSelected()) {
            String os = "";
            os = System.getProperty("os.name").toLowerCase().contains("win") && !System.getProperty("os.name").toLowerCase().contains("darwin") ? "win" : (System.getProperty("os.name").toLowerCase().contains("darwin") || System.getProperty("os.name").toLowerCase().contains("mac") ? "osx" : (System.getProperty("os.name").toLowerCase().contains("linux") ? "linux" : "generic"));
            if (!os.equals("win")) {
                String[] obj;
                File userReg;
                JFileChooser f;
                block79: {
                    logger.info("Non-windows system, requesting path to wine prefix...");
                    do {
                        if (JOptionPane.showConfirmDialog(this.frmEdgeAccountDownloader, "You are on a non-windows system, if you are running the game via wine, please select the wine prefix folder in the next popup.", "More information required", 2, 1) != 0) {
                            return;
                        }
                        f = new JFileChooser(System.getProperty("user.home"));
                        f.setDialogTitle("Select wine prefix folder...");
                        f.setFileSelectionMode(1);
                        f.showSaveDialog(this.frmEdgeAccountDownloader);
                        if (f.getSelectedFile() == null) {
                            return;
                        }
                        userReg = new File(f.getSelectedFile(), "user.reg");
                        if (userReg.exists()) break block79;
                        logger.error("Invalid wine prefix selected");
                    } while (JOptionPane.showConfirmDialog(this.frmEdgeAccountDownloader, "Invalid wine prefix selected, please select a valid wine prefix", "Error", 2, 0) == 0);
                    return;
                }
                logger.info("Selected wine prefix: " + f.getSelectedFile());
                logger.info("Parsing registry... Please wait...");
                try {
                    fIn = new FileInputStream(userReg);
                    try {
                        Object line;
                        String start = this.readLine(fIn);
                        if (!start.equalsIgnoreCase("WINE REGISTRY Version 2")) {
                            throw new IOException("Incompatible registry header: " + start + ": expected 'WINE REGISTRY Version 2', if the format updated please contact the Edge developers.");
                        }
                        while ((line = this.readLine(fIn)) != null && !((String)line).startsWith("[")) {
                        }
                        reg = new HashMap();
                        block25: while (line != null) {
                            obj = ((String)line).substring(1);
                            obj = obj.substring(0, obj.lastIndexOf("]"));
                            HashMap<String, String> keys = new HashMap<String, String>();
                            reg.put(obj, keys);
                            while (line != null && (line = this.readLine(fIn)) != null) {
                                String ln2;
                                if (((String)line).isEmpty()) continue;
                                if (((String)line).startsWith("[")) continue block25;
                                while (((String)line).endsWith("\\") && (ln2 = this.readLine(fIn)) != null) {
                                    while (ln2.startsWith(" ")) {
                                        ln2 = ln2.substring(1);
                                    }
                                    line = ((String)line).substring(0, ((String)line).lastIndexOf("\\")) + ln2;
                                }
                                if (((String)line).startsWith("#") || ((String)line).startsWith(";;") || !((String)line).contains("=")) continue;
                                String key = "";
                                Object val = "";
                                boolean isKey = true;
                                char[] argarray = ((String)line).toCharArray();
                                boolean ignoreEquals = false;
                                int i = 0;
                                for (char c : ((String)line).toCharArray()) {
                                    if (c == '\"' && (i == 0 || argarray[i - 1] != '\\')) {
                                        ignoreEquals = !ignoreEquals;
                                    } else if (c == '=' && isKey && !ignoreEquals && (i == 0 || argarray[i - 1] != '\\')) {
                                        key = val;
                                        val = "";
                                        isKey = false;
                                    } else if (c != '\\' || i + 1 < argarray.length && argarray[i + 1] != '\"' && (argarray[i + 1] != ' ' || ignoreEquals)) {
                                        val = (String)val + c;
                                    }
                                    ++i;
                                }
                                keys.put(key, (String)val);
                            }
                        }
                    }
                    finally {
                        fIn.close();
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to parse wine user registry!", (Throwable)e);
                    JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "An error occurred while reading the registry file!", "Error", 0);
                    return;
                }
                logger.info("Locating guest ID...");
                if (!reg.containsKey("Software\\\\JumpStart\\\\SoD")) {
                    logger.error("Unable to locate guest account information");
                    JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Unable to locate guest account details, please make sure you have selected the right wine prefix.", "Error", 0);
                    return;
                }
                sodReg = (HashMap)reg.get("Software\\\\JumpStart\\\\SoD");
                if (!sodReg.keySet().stream().anyMatch(t -> t.startsWith("UNIQRE_ID_h"))) {
                    logger.error("Unable to locate guest account information");
                    JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Unable to locate guest account details, please make sure you have selected the right wine prefix.", "Error", 0);
                    return;
                }
                keyV = (String)sodReg.get(sodReg.keySet().stream().filter(t -> t.startsWith("UNIQRE_ID_h")).findFirst().get());
                if (((String)keyV).startsWith("hex:")) {
                    String o;
                    int i;
                    hex = ((String)keyV).substring(4);
                    keyV = "";
                    obj = hex.split(",");
                    int keys = obj.length;
                    for (int key = 0; key < keys && (i = Integer.parseInt(o = obj[key], 16)) != 0; ++key) {
                        keyV = (String)keyV + (char)i;
                    }
                }
                keyVF = keyV;
                guestIDs = (String[])EdgeWebService.API_SECRET_MAP.keySet().stream().map(t -> t + keyVF).toArray(String[]::new);
                logger.info("Located potential guest IDs: {}", (Object)guestIDs);
            } else {
                String[] keys;
                File r;
                logger.info("Exporting registry key...");
                try {
                    r = File.createTempFile("regsod-", ".reg");
                    ProcessBuilder builder = new ProcessBuilder("reg", "export", "HKEY_CURRENT_USER\\Software\\JumpStart\\SoD", r.getCanonicalPath(), "/y");
                    if (builder.start().waitFor() == 1) {
                        logger.error("Unable to locate guest account information");
                        JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Unable to locate guest account details.", "Error", 0);
                        return;
                    }
                }
                catch (Exception e) {
                    logger.error("Unable to create temporary file for guest detection", (Throwable)e);
                    JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Unable to create temporary file for guest detection!", "Error", 0);
                    return;
                }
                logger.info("Parsing registry... Please wait...");
                try {
                    fIn = new FileInputStream(r);
                    try {
                        Object line;
                        while ((line = this.readLineUTF16LE(fIn)) != null && !((String)line).startsWith("[")) {
                        }
                        reg = new HashMap();
                        block32: while (line != null) {
                            String obj = ((String)line).substring(1);
                            obj = obj.substring(0, obj.lastIndexOf("]"));
                            keys = new HashMap();
                            reg.put(obj, keys);
                            while (line != null && (line = this.readLineUTF16LE(fIn)) != null) {
                                String ln2;
                                if (((String)line).isEmpty()) continue;
                                if (((String)line).startsWith("[")) continue block32;
                                while (((String)line).endsWith("\\") && (ln2 = this.readLineUTF16LE(fIn)) != null) {
                                    while (ln2.startsWith(" ")) {
                                        ln2 = ln2.substring(1);
                                    }
                                    line = ((String)line).substring(0, ((String)line).lastIndexOf("\\")) + ln2;
                                }
                                if (((String)line).startsWith("#") || ((String)line).startsWith(";;") || !((String)line).contains("=")) continue;
                                String key = "";
                                Object val = "";
                                boolean isKey = true;
                                char[] argarray = ((String)line).toCharArray();
                                boolean ignoreEquals = false;
                                int i = 0;
                                for (char c : ((String)line).toCharArray()) {
                                    if (c == '\"' && (i == 0 || argarray[i - 1] != '\\')) {
                                        ignoreEquals = !ignoreEquals;
                                    } else if (c == '=' && isKey && !ignoreEquals && (i == 0 || argarray[i - 1] != '\\')) {
                                        key = val;
                                        val = "";
                                        isKey = false;
                                    } else if (c != '\\' || i + 1 < argarray.length && argarray[i + 1] != '\"' && (argarray[i + 1] != ' ' || ignoreEquals)) {
                                        val = (String)val + c;
                                    }
                                    ++i;
                                }
                                keys.put(key, val);
                            }
                        }
                    }
                    finally {
                        fIn.close();
                        r.delete();
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to parse user registry!", (Throwable)e);
                    JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "An error occurred while reading the registry file!", "Error", 0);
                    return;
                }
                logger.info("Locating guest ID...");
                if (!reg.containsKey("HKEY_CURRENT_USER\\Software\\JumpStart\\SoD")) {
                    logger.error("Unable to locate guest account information");
                    JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Unable to locate guest account details.", "Error", 0);
                    return;
                }
                sodReg = (HashMap)reg.get("HKEY_CURRENT_USER\\Software\\JumpStart\\SoD");
                if (!sodReg.keySet().stream().anyMatch(t -> t.startsWith("UNIQRE_ID_h"))) {
                    logger.error("Unable to locate guest account information");
                    JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Unable to locate guest account details.", "Error", 0);
                    return;
                }
                keyV = (String)sodReg.get(sodReg.keySet().stream().filter(t -> t.startsWith("UNIQRE_ID_h")).findFirst().get());
                if (((String)keyV).startsWith("hex:")) {
                    String o;
                    int i;
                    hex = ((String)keyV).substring(4);
                    keyV = "";
                    keys = hex.split(",");
                    int key = keys.length;
                    for (int val = 0; val < key && (i = Integer.parseInt(o = keys[val], 16)) != 0; ++val) {
                        keyV = (String)keyV + (char)i;
                    }
                }
                keyVF = keyV;
                guestIDs = (String[])EdgeWebService.API_SECRET_MAP.keySet().stream().map(t -> t + keyVF).toArray(String[]::new);
                logger.info("Located potential guest IDs: {}", (Object)guestIDs);
            }
            if (guestIDs.length == 0) {
                logger.error("Unable to locate guest account information");
                JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Unable to locate guest account details.", "Error", 0);
                return;
            }
            logger.info("Contacting server...");
            HashMap<String, GuestData> guests = new HashMap<String, GuestData>();
            for (String id : guestIDs) {
                logger.info("Trying to authenticate as guest " + id);
                String u2 = (String)url + "AuthenticateGuest";
                try {
                    URL u22 = new URL(u2);
                    HttpURLConnection conn = (HttpURLConnection)u22.openConnection();
                    conn.setRequestMethod("POST");
                    JsonObject req = new JsonObject();
                    req.addProperty("guestID", id);
                    conn.setDoOutput(true);
                    conn.getOutputStream().write(req.toString().getBytes("UTF-8"));
                    if (conn.getResponseCode() < 400) {
                        JsonObject resp = JsonParser.parseString((String)new String(conn.getInputStream().readAllBytes(), "UTF-8")).getAsJsonObject();
                        if (resp.has("token")) {
                            GuestData obj = new GuestData();
                            obj.id = id;
                            obj.token = resp.get("token").getAsString();
                            obj.response = resp;
                            guests.put(id, obj);
                            logger.info("Authenticated successfully");
                            continue;
                        }
                        logger.info("Failed to authenticate");
                        continue;
                    }
                    logger.info("Failed to authenticate");
                }
                catch (IOException e) {
                    logger.info("Failed to authenticate", (Throwable)e);
                    JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Authentication failure: failed to contact the server", "Error", 0);
                    return;
                }
            }
            if (guests.size() == 0) {
                logger.error("Unable to locate guest account information");
                JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Unable to locate guest account details.", "Error", 0);
                return;
            }
            if (guests.size() == 1) {
                token = ((GuestData)guests.values().stream().findFirst().get()).token;
            } else {
                Object res = JOptionPane.showInputDialog(this.frmEdgeAccountDownloader, "Please select a guest account", "Guest selection", 3, null, guests.values().toArray(Object[]::new), "");
                if (res == null) {
                    return;
                }
                token = ((GuestData)res).token;
            }
            if (token == null) {
                logger.error("Unable to locate guest account information");
                JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Unable to locate guest account details.", "Error", 0);
                return;
            }
            logger.info("Guest account found!");
        } else {
            logger.info("Authenticating...");
            u = (String)url + "Authenticate";
            try {
                URL u2 = new URL(u);
                HttpURLConnection conn = (HttpURLConnection)u2.openConnection();
                conn.setRequestMethod("POST");
                JsonObject req = new JsonObject();
                req.addProperty("username", this.boxUsername.getText());
                req.addProperty("password", this.boxPassword.getText());
                conn.setDoOutput(true);
                conn.getOutputStream().write(req.toString().getBytes("UTF-8"));
                if (conn.getResponseCode() >= 400) {
                    JsonObject resp = JsonParser.parseString((String)new String(conn.getErrorStream().readAllBytes(), "UTF-8")).getAsJsonObject();
                    String errorMessage = resp.get("error").getAsString();
                    if (errorMessage.equalsIgnoreCase("invalid_credentials")) {
                        errorMessage = "Credentials are invalid";
                    }
                    logger.info("Failed to authenticate: " + errorMessage);
                    JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Authentication failure: " + errorMessage, "Error", 0);
                    return;
                }
                JsonObject resp = JsonParser.parseString((String)new String(conn.getInputStream().readAllBytes(), "UTF-8")).getAsJsonObject();
                token = resp.get("token").getAsString();
                logger.info("Authenticated successfully, logged in as " + resp.get("accountUsername").getAsString());
            }
            catch (IOException e) {
                logger.info("Failed to authenticate", (Throwable)e);
                JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "Authentication failure: failed to contact the server", "Error", 0);
                return;
            }
        }
        logger.info("Contacting servers... Preparing to download...");
        u = (String)url + "DownloadAccount";
        try {
            Socket conn = HttpUpgradeUtil.upgradeRequest((String)u, (String)"POST", null, (long)-1L, Map.of("X-Request-ID", UUID.randomUUID().toString(), "Authorization", "Bearer " + token), new HashMap(), (String)"EDGEBINPROT/EDGESERVICES/DOWNLOADACCOUNT", (String)"EDGEBINPROT/EDGESERVICES/DOWNLOADACCOUNT");
            logger.info("Downloading headers...");
            String accID = this.readString(conn.getInputStream());
            String username = this.readString(conn.getInputStream());
            String email = null;
            if (this.readBoolean(conn.getInputStream())) {
                email = this.readString(conn.getInputStream());
            }
            long lastLogin = this.readLong(conn.getInputStream());
            long registerTime = this.readLong(conn.getInputStream());
            boolean isGuest = this.readBoolean(conn.getInputStream());
            boolean multiplayerEnabled = this.readBoolean(conn.getInputStream());
            boolean chatEnabled = this.readBoolean(conn.getInputStream());
            boolean strictChatEnabled = this.readBoolean(conn.getInputStream());
            logger.info("Server is indexing save data... This may take a while...");
            long dataSize = this.readLong(conn.getInputStream());
            this.setMax((int)dataSize);
            logger.info("Preparing output...");
            FileOutputStream fO = new FileOutputStream(new File(outputDir, "account-" + accID + ".spf"));
            ZipOutputStream output = new ZipOutputStream(fO);
            try {
                output.putNextEntry(new ZipEntry("payloadinfo"));
                output.write("Type: resource\nResource-Target: server\nResource-Target-Path: accountimports".getBytes("UTF-8"));
                output.closeEntry();
                output.putNextEntry(new ZipEntry("payloaddata/"));
                output.closeEntry();
                output.putNextEntry(new ZipEntry("payloaddata/account-" + accID + ".ead"));
                logger.info("Writing headers...");
                this.writeString(output, accID);
                this.writeString(output, username);
                this.writeBoolean(output, email != null);
                if (email != null) {
                    this.writeString(output, email);
                }
                this.writeLong(output, lastLogin);
                this.writeLong(output, registerTime);
                this.writeBoolean(output, isGuest);
                this.writeBoolean(output, multiplayerEnabled);
                this.writeBoolean(output, chatEnabled);
                this.writeBoolean(output, strictChatEnabled);
                this.writeLong(output, dataSize);
                logger.info("Downloading account data containers...");
                this.downloadDataContainer(logger, conn.getInputStream(), output, "/");
                int saveCount = this.readInt(conn.getInputStream());
                this.writeInt(output, saveCount);
                logger.info("Downloading " + saveCount + " save(s)...");
                for (int i = 0; i < saveCount; ++i) {
                    String id = this.readString(conn.getInputStream());
                    String name = this.readString(conn.getInputStream());
                    long creationTime = this.readLong(conn.getInputStream());
                    logger.info("Downloading save: " + name);
                    this.writeString(output, id);
                    this.writeString(output, name);
                    this.writeLong(output, creationTime);
                    this.downloadDataContainer(logger, conn.getInputStream(), output, "/");
                    this.increaseProgress();
                }
                logger.info("");
                logger.info("");
                logger.info("Finished downloading account data!");
                logger.info("Downloaded to: " + new File(outputDir, "account-" + accID + ".spf"));
            }
            finally {
                output.close();
                fO.close();
            }
        }
        catch (Exception e) {
            logger.info("An error occurred while downloading account data", (Throwable)e);
            JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "An error occurred while downloading account data!", "Error", 0);
            return;
        }
    }

    private void downloadDataContainer(Logger logger, InputStream input, OutputStream output, String pth) throws IOException {
        String key;
        int i;
        logger.info("Downloading data container: " + pth);
        int length = this.readInt(input);
        this.writeInt(output, length);
        for (i = 0; i < length; ++i) {
            key = this.readString(input);
            logger.info("Downloading data key: " + (pth.equals("/") ? "/" + key : pth + "/" + key));
            boolean nonNull = this.readBoolean(input);
            String data = null;
            if (nonNull) {
                data = this.readString(input);
            }
            this.writeString(output, key);
            this.writeBoolean(output, nonNull);
            if (nonNull) {
                this.writeString(output, data);
            }
            this.increaseProgress();
        }
        length = this.readInt(input);
        this.writeInt(output, length);
        for (i = 0; i < length; ++i) {
            key = this.readString(input);
            this.writeString(output, key);
            this.downloadDataContainer(logger, input, output, pth.equals("/") ? "/" + key : pth + "/" + key);
            this.increaseProgress();
        }
    }

    private boolean readBoolean(InputStream strm) throws IOException {
        return strm.read() == 1;
    }

    private String readString(InputStream strm) throws IOException {
        return new String(this.readByteArray(strm), "UTF-8");
    }

    private int readInt(InputStream strm) throws IOException {
        return ByteBuffer.wrap(strm.readNBytes(4)).getInt();
    }

    private long readLong(InputStream strm) throws IOException {
        return ByteBuffer.wrap(strm.readNBytes(8)).getLong();
    }

    private byte[] readByteArray(InputStream strm) throws IOException {
        return strm.readNBytes(this.readInt(strm));
    }

    private void writeInt(OutputStream strm, int val) throws IOException {
        strm.write(ByteBuffer.allocate(4).putInt(val).array());
    }

    private void writeLong(OutputStream strm, long val) throws IOException {
        strm.write(ByteBuffer.allocate(8).putLong(val).array());
    }

    private void writeString(OutputStream strm, String str) throws IOException {
        byte[] data = str.getBytes("UTF-8");
        this.writeByteArray(strm, data);
    }

    private void writeByteArray(OutputStream strm, byte[] data) throws IOException {
        this.writeInt(strm, data.length);
        strm.write(data);
    }

    private void writeBoolean(OutputStream strm, boolean b) throws IOException {
        strm.write(b ? 1 : 0);
    }

    private String readLine(FileInputStream fIn) throws IOException {
        Object buffer = "";
        while (true) {
            int i;
            if ((i = fIn.read()) == -1) {
                return null;
            }
            char ch = (char)i;
            if (ch == '\r') continue;
            if (ch == '\n') break;
            buffer = (String)buffer + ch;
        }
        return buffer;
    }

    private String readLineUTF16LE(FileInputStream fIn) throws IOException {
        Object buffer = "";
        while (true) {
            int i;
            if ((i = fIn.read()) == -1) {
                return null;
            }
            char ch = new String(new byte[]{(byte)i, (byte)fIn.read()}, "UTF-16LE").charAt(0);
            if (ch == '\r') continue;
            if (ch == '\n') break;
            buffer = (String)buffer + ch;
        }
        return buffer;
    }

    private void initialize() {
        this.frmEdgeAccountDownloader = new JFrame();
        this.frmEdgeAccountDownloader.setResizable(false);
        this.frmEdgeAccountDownloader.setTitle("Edge Account Downloader");
        this.frmEdgeAccountDownloader.setBounds(100, 100, 630, 707);
        this.frmEdgeAccountDownloader.setDefaultCloseOperation(3);
        this.frmEdgeAccountDownloader.getContentPane().setLayout(new FlowLayout(1, 5, 5));
        this.frmEdgeAccountDownloader.setLocationRelativeTo(null);
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(600, 650));
        this.frmEdgeAccountDownloader.getContentPane().add(panel);
        panel.setLayout(null);
        final JButton btnNewButton = new JButton("Download account data");
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AccountDownloader.this.boxServer.setEnabled(false);
                AccountDownloader.this.chckbxGuestAcc.setEnabled(false);
                if (!AccountDownloader.this.chckbxGuestAcc.isSelected()) {
                    AccountDownloader.this.boxUsername.setEnabled(false);
                    AccountDownloader.this.boxPassword.setEnabled(false);
                }
                AccountDownloader.this.textField.setEnabled(false);
                AccountDownloader.this.textField.setEnabled(false);
                AccountDownloader.this.btnNewButton_1.setEnabled(false);
                btnNewButton.setEnabled(false);
                AsyncTaskManager.runAsync(() -> {
                    AccountDownloader.this.downloadData();
                    SwingUtilities.invokeLater(() -> {
                        AccountDownloader.this.boxServer.setEnabled(true);
                        if (!AccountDownloader.this.chckbxGuestAcc.isSelected()) {
                            AccountDownloader.this.boxUsername.setEnabled(true);
                            AccountDownloader.this.boxPassword.setEnabled(true);
                        }
                        AccountDownloader.this.chckbxGuestAcc.setEnabled(true);
                        AccountDownloader.this.textField.setEnabled(true);
                        AccountDownloader.this.textField.setEnabled(true);
                        AccountDownloader.this.btnNewButton_1.setEnabled(true);
                        btnNewButton.setEnabled(true);
                    });
                });
            }
        });
        btnNewButton.setBounds(12, 605, 576, 45);
        panel.add(btnNewButton);
        JLabel lblNewLabel = new JLabel("Server");
        lblNewLabel.setBounds(12, 12, 576, 17);
        panel.add(lblNewLabel);
        this.boxServer = new JTextField();
        this.boxServer.setText("https://aerialworks.ddns.net:5320/API/ProjectEdge/");
        this.boxServer.setBounds(12, 32, 576, 21);
        panel.add(this.boxServer);
        this.boxServer.setColumns(10);
        JLabel lblUsername = new JLabel("Username");
        lblUsername.setBounds(12, 81, 576, 17);
        panel.add(lblUsername);
        this.boxUsername = new JTextField();
        this.boxUsername.setBounds(12, 99, 576, 21);
        panel.add(this.boxUsername);
        this.boxUsername.setColumns(10);
        JLabel lblPassword = new JLabel("Password");
        lblPassword.setBounds(12, 132, 576, 17);
        panel.add(lblPassword);
        this.boxPassword = new JPasswordField();
        this.boxPassword.setColumns(10);
        this.boxPassword.setBounds(12, 150, 576, 21);
        panel.add(this.boxPassword);
        this.chckbxGuestAcc = new JCheckBox("Use guest account");
        this.chckbxGuestAcc.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (AccountDownloader.this.chckbxGuestAcc.isEnabled()) {
                    AccountDownloader.this.boxUsername.setEnabled(!AccountDownloader.this.chckbxGuestAcc.isSelected());
                    AccountDownloader.this.boxPassword.setEnabled(!AccountDownloader.this.chckbxGuestAcc.isSelected());
                }
            }
        });
        this.chckbxGuestAcc.setBounds(10, 178, 584, 25);
        panel.add(this.chckbxGuestAcc);
        JLabel lblTargetFolder = new JLabel("Target folder");
        lblTargetFolder.setBounds(12, 223, 576, 17);
        panel.add(lblTargetFolder);
        this.textField = new JTextField();
        this.textField.setColumns(10);
        this.textField.setBounds(12, 242, 462, 32);
        panel.add(this.textField);
        this.btnNewButton_1 = new JButton("Browse...");
        this.btnNewButton_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser f = new JFileChooser(AccountDownloader.this.textField.getText());
                f.setDialogTitle("Select target folder...");
                f.setFileSelectionMode(1);
                f.showSaveDialog(AccountDownloader.this.frmEdgeAccountDownloader);
                if (f.getSelectedFile() != null) {
                    AccountDownloader.this.textField.setText(f.getSelectedFile().getAbsolutePath());
                }
            }
        });
        this.btnNewButton_1.setBounds(483, 242, 105, 32);
        panel.add(this.btnNewButton_1);
        JLabel lblProgress = new JLabel("Progress");
        lblProgress.setBounds(12, 297, 60, 17);
        panel.add(lblProgress);
        this.progressBar = new JProgressBar();
        this.progressBar.setBounds(12, 315, 576, 21);
        panel.add(this.progressBar);
        this.textArea.setFont(new Font("Liberation Mono", 0, 12));
        this.textArea.setEditable(false);
        JScrollPane pane = new JScrollPane(this.textArea);
        pane.setLocation(12, 341);
        pane.setSize(new Dimension(576, 230));
        pane.setVerticalScrollBarPolicy(22);
        pane.setBorder(new BevelBorder(1, null, null, null, null));
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(2);
        panel.add(pane);
    }

    public void log(String message) {
        Object log = this.textArea.getText() + message;
        while (((String)log).split("\n").length >= 200) {
            log = ((String)log).substring(((String)log).indexOf("\n") + 1);
        }
        this.textArea.setText((String)log + "\n");
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    public void addMax(int max) {
        SwingUtilities.invokeLater(() -> this.progressBar.setMaximum(this.progressBar.getMaximum() + max));
    }

    public void setMax(int max) {
        SwingUtilities.invokeLater(() -> this.progressBar.setMaximum(max));
    }

    public void setValue(int val) {
        SwingUtilities.invokeLater(() -> this.progressBar.setValue(val));
    }

    public int getMax() {
        return this.progressBar.getMaximum();
    }

    public int getValue() {
        return this.progressBar.getValue();
    }

    public void increaseProgress() {
        SwingUtilities.invokeLater(() -> {
            if (this.progressBar.getValue() + 1 > this.progressBar.getMaximum()) {
                return;
            }
            this.progressBar.setValue(this.progressBar.getValue() + 1);
        });
    }

    public void fatalError(String msg) {
        JOptionPane.showMessageDialog(this.frmEdgeAccountDownloader, "A fatal error occured:\n" + msg, "Fatal Error", 0);
    }

    private class GuestData {
        public String token;
        public String id;
        public JsonObject response;

        private GuestData() {
        }

        public String toString() {
            Object str = "Last login: ";
            str = (String)str + new Date(this.response.get("lastLoginTime").getAsLong()).toString();
            str = (String)str + " (" + this.id + ")";
            return str;
        }
    }

    public static class WindowAppender
    extends AbstractAppender {
        protected WindowAppender(PatternLayout layout) {
            super("Window Appender", null, (Layout)layout);
            this.start();
        }

        public void append(LogEvent event) {
            if (downloadWindowInstance == null) {
                return;
            }
            if (!event.getLevel().isInRange(Level.FATAL, Level.INFO)) {
                return;
            }
            String message = new String(this.getLayout().toByteArray(event));
            if (message.endsWith("\n")) {
                message = message.substring(0, message.length() - 1);
            }
            if (message.contains("\n")) {
                for (String ln : message.split("\n")) {
                    downloadWindowInstance.log(ln);
                }
            } else {
                downloadWindowInstance.log(message);
            }
        }

        public static void setup() {
            LoggerContext context = LoggerContext.getContext((boolean)false);
            Configuration config = context.getConfiguration();
            PatternLayout layout = PatternLayout.createDefaultLayout();
            WindowAppender appender = new WindowAppender(layout);
            config.addAppender((Appender)appender);
            WindowAppender.updateLoggers((Appender)appender, context.getConfiguration());
        }

        private static void updateLoggers(Appender appender, Configuration config) {
            Level level = null;
            Filter filter = null;
            for (LoggerConfig loggerConfig : config.getLoggers().values()) {
                loggerConfig.addAppender(appender, level, filter);
            }
            config.getRootLogger().addAppender(appender, level, filter);
        }
    }
}

