/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.services.rooms.impl;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.entities.coordinates.Vector3D;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.xmls.data.KeyValuePairSetData;
import org.asf.edge.gameplayapi.entities.rooms.PlayerRoomInfo;
import org.asf.edge.gameplayapi.entities.rooms.RoomItemInfo;
import org.asf.edge.gameplayapi.services.rooms.PlayerRoomManager;
import org.asf.edge.gameplayapi.xmls.rooms.RoomItemData;

public class PlayerRoomManagerImpl
extends PlayerRoomManager {
    private Logger logger;
    private static Random rnd = new Random();

    public void initService() {
        this.logger = LogManager.getLogger((String)"PlayerRoomManager");
        this.logger.info("Player room manager is ready");
    }

    @Override
    public PlayerRoomInfo[] getRooms(AccountSaveContainer save) {
        ArrayList<PlayerRoomInfoImpl> rooms = new ArrayList<PlayerRoomInfoImpl>();
        try {
            AccountDataContainer data = save.getSaveData();
            data = data.getChildContainer("rooms");
            for (String id : data.getEntryKeys()) {
                if (!id.startsWith("room-")) continue;
                String roomID = id.substring(5);
                rooms.add(new PlayerRoomInfoImpl(roomID, save));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return (PlayerRoomInfo[])rooms.toArray(PlayerRoomInfo[]::new);
    }

    @Override
    protected PlayerRoomInfo createRoom(String roomID, int categoryID, AccountSaveContainer save) {
        try {
            AccountDataContainer data = save.getSaveData();
            data = data.getChildContainer("rooms");
            if (!data.entryExists("room-" + roomID)) {
                JsonObject roomD = new JsonObject();
                roomD.addProperty("roomCategory", (Number)categoryID);
                roomD.addProperty("roomName", save.getUsername());
                roomD.addProperty("itemID", (Number)-1);
                roomD.addProperty("creativePoints", (Number)0);
                roomD.add("items", (JsonElement)new JsonArray());
                data.setEntry("room-" + roomID, (JsonElement)roomD);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.getRoom(roomID, save);
    }

    @Override
    public PlayerRoomInfo getRoom(String roomID, AccountSaveContainer save) {
        try {
            AccountDataContainer data = save.getSaveData();
            data = data.getChildContainer("rooms");
            if (data.entryExists("room-" + roomID)) {
                return new PlayerRoomInfoImpl(roomID, save);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public boolean roomExists(String roomID, AccountSaveContainer save) {
        try {
            AccountDataContainer data = save.getSaveData();
            data = data.getChildContainer("rooms");
            return data.entryExists("room-" + roomID);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean roomItemExists(int itemID, AccountSaveContainer save) {
        try {
            AccountDataContainer data = save.getSaveData();
            data = data.getChildContainer("roomitems");
            return data.entryExists("item-" + itemID);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void deleteRoomItem(int itemID, AccountSaveContainer save) {
        try {
            AccountDataContainer data = save.getSaveData();
            data = data.getChildContainer("roomitems");
            if (data.entryExists("item-" + itemID)) {
                data.deleteEntry("item-" + itemID);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RoomItemInfo getRoomItem(int itemID, AccountSaveContainer save) {
        try {
            AccountDataContainer data = save.getSaveData();
            data = data.getChildContainer("roomitems");
            if (data.entryExists("item-" + itemID)) {
                JsonObject rObj = data.getEntry("item-" + itemID).getAsJsonObject();
                RoomItemInfo item = new RoomItemInfo();
                item.roomItemID = itemID;
                item.roomID = rObj.get("roomID").getAsString();
                item.parentID = rObj.get("parentID").getAsInt();
                item.itemID = rObj.get("itemID").getAsInt();
                item.itemUniqueID = rObj.get("itemUniqueID").getAsInt();
                item.uses = rObj.get("uses").getAsInt();
                item.currentStateID = rObj.get("currentStateID").getAsInt();
                item.lastStateChange = rObj.get("lastStateChange").getAsLong();
                if (rObj.has("inventoryModificationDate")) {
                    item.inventoryModificationDate = rObj.get("inventoryModificationDate").getAsString();
                }
                if (rObj.has("itemAttributes")) {
                    item.itemAttributes = (KeyValuePairSetData)new XmlMapper().readValue(rObj.get("itemAttributes").getAsString(), KeyValuePairSetData.class);
                }
                if (rObj.has("itemStats")) {
                    item.itemStats = (RoomItemData.ItemStatBlock)new XmlMapper().readValue(rObj.get("itemStats").getAsString(), RoomItemData.ItemStatBlock.class);
                }
                item.position = new Vector3D(rObj.get("position").getAsJsonObject().get("x").getAsDouble(), rObj.get("position").getAsJsonObject().get("y").getAsDouble(), rObj.get("position").getAsJsonObject().get("z").getAsDouble());
                item.rotation = new Vector3D(rObj.get("rotation").getAsJsonObject().get("x").getAsDouble(), rObj.get("rotation").getAsJsonObject().get("y").getAsDouble(), rObj.get("rotation").getAsJsonObject().get("z").getAsDouble());
                return item;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void saveRoomItem(RoomItemInfo itm, AccountSaveContainer save) {
        try {
            XmlMapper mapper = new XmlMapper();
            mapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
            JsonObject rI = new JsonObject();
            rI.addProperty("roomID", itm.roomID);
            rI.addProperty("parentID", (Number)itm.parentID);
            rI.addProperty("itemID", (Number)itm.itemID);
            rI.addProperty("itemUniqueID", (Number)itm.itemUniqueID);
            rI.addProperty("uses", (Number)itm.getCurrentUses(save));
            rI.addProperty("currentStateID", (Number)itm.currentStateID);
            rI.addProperty("lastStateChange", (Number)itm.lastStateChange);
            if (itm.inventoryModificationDate != null) {
                rI.addProperty("inventoryModificationDate", itm.inventoryModificationDate);
            }
            if (itm.itemAttributes != null) {
                rI.addProperty("itemAttributes", mapper.writer().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("ItemAttributeData").writeValueAsString((Object)itm.itemAttributes));
            }
            if (itm.itemStats != null) {
                rI.addProperty("itemStats", mapper.writer().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("ItemStatData").writeValueAsString((Object)itm.itemStats));
            }
            JsonObject pos = new JsonObject();
            pos.addProperty("x", (Number)itm.position.x);
            pos.addProperty("y", (Number)itm.position.y);
            pos.addProperty("z", (Number)itm.position.z);
            rI.add("position", (JsonElement)pos);
            JsonObject rot = new JsonObject();
            rot.addProperty("x", (Number)itm.rotation.x);
            rot.addProperty("y", (Number)itm.rotation.y);
            rot.addProperty("z", (Number)itm.rotation.z);
            rI.add("rotation", (JsonElement)rot);
            AccountDataContainer data = save.getSaveData();
            data = data.getChildContainer("roomitems");
            data.setEntry("item-" + itm.roomItemID, (JsonElement)rI);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RoomItemInfo createRoomItem(RoomItemInfo itm, AccountSaveContainer save) {
        int id = rnd.nextInt(0, Integer.MAX_VALUE);
        while (this.roomItemExists(id, save)) {
            id = rnd.nextInt(0, Integer.MAX_VALUE);
        }
        itm.roomItemID = id;
        this.saveRoomItem(itm, save);
        return itm;
    }

    public class PlayerRoomInfoImpl
    extends PlayerRoomInfo {
        private String roomID;
        private AccountSaveContainer save;
        private JsonObject roomData;

        public PlayerRoomInfoImpl(String roomID, AccountSaveContainer save) throws IOException {
            this.roomID = roomID;
            this.save = save;
            this.roomData = save.getSaveData().getChildContainer("rooms").getEntry("room-" + roomID).getAsJsonObject();
        }

        @Override
        public String getID() {
            return this.roomID;
        }

        @Override
        public double getCreativePoints() {
            return this.roomData.get("creativePoints").getAsDouble();
        }

        @Override
        public int getItemID() {
            return this.roomData.get("itemID").getAsInt();
        }

        @Override
        public String getName() {
            return this.roomData.get("roomName").getAsString();
        }

        @Override
        public RoomItemInfo[] getItems() {
            JsonArray itms = this.roomData.get("items").getAsJsonArray();
            ArrayList<RoomItemInfo> items = new ArrayList<RoomItemInfo>();
            for (JsonElement ele : itms) {
                RoomItemInfo itm = PlayerRoomManagerImpl.this.getRoomItem(ele.getAsInt(), this.save);
                if (itm == null || !itm.roomID.equals(this.roomID)) continue;
                items.add(itm);
            }
            return (RoomItemInfo[])items.toArray(RoomItemInfo[]::new);
        }

        @Override
        public void setItems(RoomItemInfo[] items) {
            JsonArray arr = new JsonArray();
            XmlMapper mapper = new XmlMapper();
            mapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
            for (RoomItemInfo itm : items) {
                if (itm.roomItemID == -1) {
                    itm = PlayerRoomManagerImpl.this.createRoomItem(itm, this.save);
                }
                itm.roomID = this.roomID;
                arr.add((Number)itm.roomItemID);
                PlayerRoomManagerImpl.this.saveRoomItem(itm, this.save);
            }
            this.roomData.add("items", (JsonElement)arr);
            try {
                this.save.getSaveData().getChildContainer("rooms").setEntry("room-" + this.roomID, (JsonElement)this.roomData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setName(String newName) {
            this.roomData.addProperty("roomName", newName);
            try {
                this.save.getSaveData().getChildContainer("rooms").setEntry("room-" + this.roomID, (JsonElement)this.roomData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setItemID(int newID) {
            this.roomData.addProperty("itemID", (Number)newID);
            try {
                this.save.getSaveData().getChildContainer("rooms").setEntry("room-" + this.roomID, (JsonElement)this.roomData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setCreativePoints(double newPoints) {
            this.roomData.addProperty("creativePoints", (Number)newPoints);
            try {
                this.save.getSaveData().getChildContainer("rooms").setEntry("room-" + this.roomID, (JsonElement)this.roomData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int getCategoryID() {
            return this.roomData.get("roomCategory").getAsInt();
        }

        @Override
        public void setCategoryID(int newID) {
            this.roomData.addProperty("roomCategory", (Number)newID);
            try {
                this.save.getSaveData().getChildContainer("rooms").setEntry("room-" + this.roomID, (JsonElement)this.roomData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

