/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.services.quests.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.entities.achivements.RankTypeID;
import org.asf.edge.common.entities.items.PlayerInventoryItem;
import org.asf.edge.common.events.achievements.RankChangedEvent;
import org.asf.edge.common.events.items.InventoryItemCreateEvent;
import org.asf.edge.common.events.items.InventoryItemDeleteEvent;
import org.asf.edge.common.events.items.InventoryItemQuantityUpdateEvent;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.config.ConfigProviderService;
import org.asf.edge.gameplayapi.entities.quests.UserQuestInfo;
import org.asf.edge.gameplayapi.events.quests.QuestAcceptedEvent;
import org.asf.edge.gameplayapi.events.quests.QuestCompletedEvent;
import org.asf.edge.gameplayapi.events.quests.QuestManagerLoadEvent;
import org.asf.edge.gameplayapi.events.quests.QuestResetEvent;
import org.asf.edge.gameplayapi.events.quests.QuestStartedEvent;
import org.asf.edge.gameplayapi.events.quests.QuestTaskCompletionEvent;
import org.asf.edge.gameplayapi.events.quests.QuestTaskProgressionEvent;
import org.asf.edge.gameplayapi.events.quests.QuestUnlockEvent;
import org.asf.edge.gameplayapi.services.quests.QuestManager;
import org.asf.edge.gameplayapi.util.InventoryUtils;
import org.asf.edge.gameplayapi.util.RewardsUtil;
import org.asf.edge.gameplayapi.xmls.dragons.DragonData;
import org.asf.edge.gameplayapi.xmls.inventories.SetCommonInventoryRequestData;
import org.asf.edge.gameplayapi.xmls.quests.MissionData;
import org.asf.edge.gameplayapi.xmls.quests.SetTaskStateResultData;
import org.asf.edge.gameplayapi.xmls.quests.edgespecific.QuestRegistryManifest;
import org.asf.edge.modules.ModuleManager;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventListener;
import org.asf.edge.modules.eventbus.EventObject;

public class QuestManagerImpl
extends QuestManager {
    private Logger logger;
    private HashMap<Integer, MissionData> quests = new HashMap();
    private HashMap<Integer, MissionData> allQuests = new HashMap();
    private long lastReloadTime;
    private long lastQuestUpdateTime;
    private String questDataVersion;
    private String lastQuestUpdateVersion;

    @EventListener
    public void rankXpChanged(RankChangedEvent event) throws IOException {
        boolean updated = false;
        for (MissionData def : this.getAllQuestDefs()) {
            if (def.missionRules != null && def.missionRules.prerequisites != null) {
                for (MissionData.MissionRulesBlock.PrerequisiteInfoBlock req : def.missionRules.prerequisites) {
                    if (!req.clientRule) {
                        switch (req.type) {
                            case 4: {
                                String[] idsStrs = req.value.split(",");
                                int typeID = 0;
                                if (idsStrs.length >= 1) {
                                    typeID = Integer.parseInt(idsStrs[0]);
                                }
                                if (typeID != event.getEntityRank().getTypeID().getPointTypeID()) break;
                                updated = true;
                                break;
                            }
                        }
                    }
                    if (updated) break;
                }
            }
            if (updated) break;
        }
        if (updated) {
            AsyncTaskManager.runAsync(() -> this.recomputeQuests(event.getSave()));
        }
    }

    @EventListener
    public void itemCreated(InventoryItemCreateEvent event) {
        this.itemChanged(event.getAccount(), event.getSaveData(), event.getItem());
    }

    @EventListener
    public void itemDeleted(InventoryItemDeleteEvent event) {
        this.itemChanged(event.getAccount(), event.getSaveData(), event.getItem());
    }

    @EventListener
    public void itemQuantityChanged(InventoryItemQuantityUpdateEvent event) {
        this.itemChanged(event.getAccount(), event.getSaveData(), event.getItem());
    }

    private void itemChanged(AccountObject account, AccountDataContainer saveData, PlayerInventoryItem item) {
        if (saveData.getSave() == null) {
            return;
        }
        boolean hasPrerequisite = false;
        for (MissionData def : this.getAllQuestDefs()) {
            if (def.missionRules != null && def.missionRules.prerequisites != null) {
                for (MissionData.MissionRulesBlock.PrerequisiteInfoBlock req : def.missionRules.prerequisites) {
                    if (!req.clientRule) {
                        switch (req.type) {
                            case 7: {
                                int itmId = Integer.parseInt(req.value);
                                if (item.getItemDefID() != itmId) break;
                                hasPrerequisite = true;
                                break;
                            }
                        }
                    }
                    if (hasPrerequisite) break;
                }
            }
            if (hasPrerequisite) break;
        }
        if (hasPrerequisite) {
            AsyncTaskManager.runAsync(() -> this.recomputeQuests(saveData.getSave()));
        }
    }

    public void initService() {
        this.logger = LogManager.getLogger((String)"QuestManager");
        this.loadQuests();
        try {
            if (!ConfigProviderService.getInstance().configExists("server", "questversion")) {
                try {
                    JsonObject conf = new JsonObject();
                    conf.addProperty("__COMMENT1__", "this file controls the quest version, each time quest data is updated this file should also be updated to hold a new version ID");
                    conf.addProperty("__COMMENT2__", "you MUST update this file manually otherwise quests wont be recomputed after user content updates");
                    conf.addProperty("version", (Number)System.currentTimeMillis());
                    ConfigProviderService.getInstance().saveConfig("server", "questversion", conf);
                }
                catch (IOException conf) {
                    // empty catch block
                }
            }
            try {
                this.lastQuestUpdateVersion = ConfigProviderService.getInstance().loadConfig("server", "questversion").get("version").getAsString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to load update time", (Throwable)e);
        }
        try {
            CommonDataContainer cont = CommonDataManager.getInstance().getContainer("QUESTMANAGER");
            try {
                if (!cont.entryExists("lastreload")) {
                    this.lastReloadTime = System.currentTimeMillis();
                    cont.setEntry("lastreload", (JsonElement)new JsonPrimitive((Number)this.lastReloadTime));
                } else {
                    this.lastReloadTime = cont.getEntry("lastreload").getAsLong();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            AsyncTaskManager.runAsync(() -> {
                while (true) {
                    try {
                        long reload = cont.getEntry("lastreload").getAsLong();
                        if (reload > this.lastReloadTime) {
                            this.lastReloadTime = reload;
                            this.loadQuests();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            });
            try {
                if (!cont.entryExists("lastupdate")) {
                    this.lastQuestUpdateTime = System.currentTimeMillis();
                    cont.setEntry("lastupdate", (JsonElement)new JsonPrimitive((Number)this.lastQuestUpdateTime));
                } else {
                    this.lastQuestUpdateTime = cont.getEntry("lastupdate").getAsLong();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            AsyncTaskManager.runAsync(() -> {
                while (true) {
                    try {
                        void var7_14;
                        JsonArray allDateActiveDefsLast = new JsonArray();
                        if (cont.entryExists("activedefs")) {
                            allDateActiveDefsLast = cont.getEntry("activedefs").getAsJsonArray();
                        }
                        ArrayList<String> defsActiveLast = new ArrayList<String>();
                        ArrayList<CallSite> defsActiveCurrent = new ArrayList<CallSite>();
                        for (JsonElement el : allDateActiveDefsLast) {
                            defsActiveLast.add(el.getAsString());
                        }
                        MissionData[] missionDataArray = this.getAllQuestDefs();
                        int el = missionDataArray.length;
                        boolean bl = false;
                        while (var7_14 < el) {
                            MissionData missionData = missionDataArray[var7_14];
                            boolean active = true;
                            if (missionData.missionRules != null && missionData.missionRules.prerequisites != null) {
                                block16: for (MissionData.MissionRulesBlock.PrerequisiteInfoBlock req : missionData.missionRules.prerequisites) {
                                    if (req.clientRule) continue;
                                    switch (req.type) {
                                        case 5: {
                                            String[] dStrs = req.value.split(",");
                                            if (dStrs.length != 2) continue block16;
                                            String startDate = dStrs[0];
                                            String endDate = dStrs[1];
                                            try {
                                                SimpleDateFormat fmt = new SimpleDateFormat("MM'-'dd'-'yyyy HH':'mm':'ss");
                                                Date start = fmt.parse(startDate);
                                                Date end = fmt.parse(endDate);
                                                Date now = new Date(System.currentTimeMillis());
                                                if (!start.before(now) && !end.after(now)) continue block16;
                                                active = false;
                                                continue block16;
                                            }
                                            catch (ParseException e) {
                                                try {
                                                    SimpleDateFormat fmt = new SimpleDateFormat("MM'-'dd'-'yyyy");
                                                    Date start = fmt.parse(startDate);
                                                    Date end = fmt.parse(endDate);
                                                    Date now = new Date(System.currentTimeMillis());
                                                    if (!start.before(now) && !end.after(now)) continue block16;
                                                    active = false;
                                                    continue block16;
                                                }
                                                catch (ParseException e2) {
                                                    try {
                                                        SimpleDateFormat fmt = new SimpleDateFormat("dd'/'MM'/'yyyy");
                                                        Date start = fmt.parse(startDate);
                                                        Date end = fmt.parse(endDate);
                                                        Date now = new Date(System.currentTimeMillis());
                                                        if (!start.before(now) && !end.after(now)) continue block16;
                                                        active = false;
                                                        continue block16;
                                                    }
                                                    catch (ParseException e3) {
                                                        throw new RuntimeException(e);
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            if (active) {
                                defsActiveCurrent.add((CallSite)((Object)(missionData.id + "-" + missionData.version)));
                            }
                            ++var7_14;
                        }
                        boolean changed = false;
                        if (defsActiveCurrent.size() != defsActiveLast.size()) {
                            changed = true;
                        } else {
                            for (String string : defsActiveCurrent) {
                                if (defsActiveLast.contains(string)) continue;
                                changed = true;
                                break;
                            }
                            for (String string : defsActiveLast) {
                                if (defsActiveCurrent.contains(string)) continue;
                                changed = true;
                                break;
                            }
                        }
                        if (changed) {
                            JsonArray newDefs = new JsonArray();
                            for (String string : defsActiveCurrent) {
                                newDefs.add(string);
                            }
                            cont.setEntry("activedefs", (JsonElement)newDefs);
                            this.lastQuestUpdateTime = System.currentTimeMillis();
                            cont.setEntry("lastupdate", (JsonElement)new JsonPrimitive((Number)this.lastQuestUpdateTime));
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Failed to start watchdogs!", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void loadQuests() {
        this.logger.info("Loading quest data...");
        try {
            InputStream strm = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("questdata.xml");
            String data = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
            XmlMapper mapper = new XmlMapper();
            QuestRegistryManifest questReg = (QuestRegistryManifest)mapper.readValue(data, QuestRegistryManifest.class);
            this.questDataVersion = questReg.questDataVersion;
            this.logger.info("Loading quest definitions...");
            HashMap<Integer, MissionData> quests = new HashMap<Integer, MissionData>();
            for (MissionData missionData : questReg.defaultQuestDefs.questDefs) {
                quests.put(missionData.id, missionData);
                this.scanQuest(missionData);
            }
            this.logger.info("Loading quest transformers...");
            this.loadTransformers(((Object)((Object)this)).getClass(), quests);
            for (MissionData missionData : ModuleManager.getLoadedModules()) {
                this.loadTransformers(missionData.getClass(), quests);
            }
            File transformersQuests = new File("questtransformers");
            if (transformersQuests.exists()) {
                void var9_15;
                File[] fileArray = transformersQuests.listFiles(t -> t.getName().endsWith(".xml") || t.isDirectory());
                int n = fileArray.length;
                boolean bl = false;
                while (var9_15 < n) {
                    File transformer = fileArray[var9_15];
                    this.loadTransformer(transformer, quests);
                    ++var9_15;
                }
            }
            this.quests = quests;
            this.logger.info("Dispatching load event...");
            EventBus.getInstance().dispatchEvent((EventObject)new QuestManagerLoadEvent(this));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void applyTransformer(MissionData def, HashMap<Integer, MissionData> quests) {
        MissionData old = quests.get(def.id);
        if (old == null) {
            quests.put(def.id, def);
            this.scanQuest(def);
        } else {
            if (def.staticData != null) {
                old.staticData = def.staticData;
            }
            if (def.acceptanceAchievementID != 0) {
                old.acceptanceAchievementID = def.acceptanceAchievementID;
            }
            if (def.acceptanceRewards != null && def.acceptanceRewards.length != 0) {
                old.acceptanceRewards = def.acceptanceRewards;
            }
            if (def.achievementID != 0) {
                old.achievementID = def.achievementID;
            }
            if (def.childMissions != null && def.childMissions.length != 0) {
                old.childMissions = def.childMissions;
            }
            if (def.groupID != 0) {
                old.groupID = def.groupID;
            }
            if (def.missionRules != null) {
                old.missionRules = def.missionRules;
            }
            if (def.name != null) {
                old.name = def.name;
            }
            if (def.name != null) {
                old.name = def.name;
            }
            if (def.repeatable != null) {
                old.repeatable = def.repeatable;
            }
            if (def.tasks != null && def.tasks.length != 0) {
                old.tasks = def.tasks;
            }
            if (def.rewards != null && def.rewards.length != 0) {
                old.rewards = def.rewards;
            }
            if (def.version != 0) {
                old.version = def.version;
            }
            this.updateQuest(old);
        }
    }

    private void loadTransformer(File transformer, HashMap<Integer, MissionData> quests) {
        if (transformer.isFile()) {
            this.logger.debug("Loading transformer: '" + transformer.getPath() + "'...");
            try {
                FileInputStream strm = new FileInputStream(transformer);
                XmlMapper mapper = new XmlMapper();
                MissionData def = (MissionData)mapper.reader().readValue(new String(((InputStream)strm).readAllBytes(), "UTF-8"), MissionData.class);
                ((InputStream)strm).close();
                this.applyTransformer(def, quests);
            }
            catch (Exception e) {
                this.logger.error("Transformer failed to load: " + transformer.getPath(), (Throwable)e);
            }
        } else {
            this.logger.debug("Loading transformers from " + transformer.getPath() + "...");
            for (File tr : transformer.listFiles(t -> t.getName().endsWith(".xml") || t.isDirectory())) {
                this.loadTransformer(tr, quests);
            }
        }
    }

    private void loadTransformers(Class<?> cls, HashMap<Integer, MissionData> quests) {
        URL source = cls.getProtectionDomain().getCodeSource().getLocation();
        Object baseURL = "";
        String fileName = "";
        try {
            File sourceFile = new File(source.toURI());
            fileName = sourceFile.getName();
            baseURL = sourceFile.isDirectory() ? source + (source.toString().endsWith("/") ? "" : "/") : "jar:" + source + "!/";
        }
        catch (Exception e) {
            return;
        }
        try {
            this.logger.debug("Loading transformers from " + fileName + "...");
            InputStream strm = new URL((String)baseURL + "questtransformers/index.json").openStream();
            JsonArray index = JsonParser.parseString((String)new String(strm.readAllBytes(), "UTF-8")).getAsJsonArray();
            strm.close();
            for (JsonElement ele : index) {
                this.logger.debug("Loading transformer: 'questtransformers/" + ele.getAsString() + ".xml'...");
                try {
                    strm = new URL((String)baseURL + "questtransformers/" + ele.getAsString() + ".xml").openStream();
                    XmlMapper mapper = new XmlMapper();
                    MissionData def = (MissionData)mapper.reader().readValue(new String(strm.readAllBytes(), "UTF-8"), MissionData.class);
                    strm.close();
                    this.applyTransformer(def, quests);
                }
                catch (Exception e) {
                    this.logger.error("Transformer failed to load: " + ele.getAsString() + " (" + fileName + ")", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                return;
            }
            throw new RuntimeException(e);
        }
    }

    private void scanQuest(MissionData quest) {
        this.allQuests.put(quest.id, quest);
        this.logger.debug("Registered quest definition: " + quest.id + ": " + quest.name);
        if (quest.childMissions != null) {
            for (MissionData cQuest : quest.childMissions) {
                cQuest.parentQuestID = quest.id;
                this.scanQuest(cQuest);
            }
        }
    }

    private void updateQuest(MissionData quest) {
        this.allQuests.put(quest.id, quest);
        this.logger.debug("Updated quest definition: " + quest.id + ": " + quest.name);
        if (quest.childMissions != null) {
            for (MissionData cQuest : quest.childMissions) {
                cQuest.parentQuestID = quest.id;
                this.updateQuest(cQuest);
            }
        }
    }

    @Override
    public int[] getQuestIDs() {
        int[] ids = new int[this.quests.size()];
        int i = 0;
        for (int id : this.quests.keySet()) {
            ids[i++] = id;
        }
        return ids;
    }

    @Override
    public int[] getAllQuestIDs() {
        int[] ids = new int[this.allQuests.size()];
        int i = 0;
        for (int id : this.allQuests.keySet()) {
            ids[i++] = id;
        }
        return ids;
    }

    @Override
    public MissionData getQuestDef(int id) {
        return this.allQuests.get(id);
    }

    @Override
    public MissionData[] getQuestDefs() {
        return (MissionData[])this.quests.values().toArray(MissionData[]::new);
    }

    @Override
    public MissionData[] getAllQuestDefs() {
        return (MissionData[])this.allQuests.values().toArray(MissionData[]::new);
    }

    @Override
    public UserQuestInfo getUserQuest(AccountSaveContainer save, int id) {
        MissionData def = this.getQuestDef(id);
        if (def == null) {
            return null;
        }
        return new UserQuestInfoImpl(def, save);
    }

    @Override
    public UserQuestInfo[] getCompletedQuests(AccountSaveContainer save) {
        try {
            AccountDataContainer data = save.getSaveData().getChildContainer("quests");
            if (!data.entryExists("completedquests")) {
                return new UserQuestInfo[0];
            }
            ArrayList<UserQuestInfo> quests = new ArrayList<UserQuestInfo>();
            JsonArray completedQuests = data.getEntry("completedquests").getAsJsonArray();
            for (JsonElement ele : completedQuests) {
                quests.add(this.getUserQuest(save, ele.getAsInt()));
            }
            return (UserQuestInfo[])quests.toArray(UserQuestInfo[]::new);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public UserQuestInfo[] getActiveQuests(AccountSaveContainer save) {
        try {
            AccountDataContainer data = save.getSaveData().getChildContainer("quests");
            if (!(data.entryExists("activequests") && data.entryExists("lastupdate") && data.getEntry("lastupdate").getAsLong() == this.lastQuestUpdateTime && data.entryExists("lastupdate_serverdata") && data.getEntry("lastupdate_serverdata").getAsString().equals(this.lastQuestUpdateVersion) && data.entryExists("lastupdate_serverver") && data.getEntry("lastupdate_serverver").getAsString().equals(this.questDataVersion))) {
                this.recomputeActiveQuests(save);
                return this.getActiveQuests(save);
            }
            ArrayList<UserQuestInfo> quests = new ArrayList<UserQuestInfo>();
            JsonArray activeQuests = data.getEntry("activequests").getAsJsonArray();
            for (JsonElement ele : activeQuests) {
                quests.add(this.getUserQuest(save, ele.getAsInt()));
            }
            return (UserQuestInfo[])quests.toArray(UserQuestInfo[]::new);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public UserQuestInfo[] getUpcomingQuests(AccountSaveContainer save) {
        try {
            AccountDataContainer data = save.getSaveData().getChildContainer("quests");
            if (!(data.entryExists("activequests") && data.entryExists("lastupdate") && data.getEntry("lastupdate").getAsLong() == this.lastQuestUpdateTime && data.entryExists("lastupdate_serverdata") && data.getEntry("lastupdate_serverdata").getAsString().equals(this.lastQuestUpdateVersion) && data.entryExists("lastupdate_serverver") && data.getEntry("lastupdate_serverver").getAsString().equals(this.questDataVersion))) {
                this.recomputeUpcomingQuests(save);
                return this.getUpcomingQuests(save);
            }
            ArrayList<UserQuestInfo> quests = new ArrayList<UserQuestInfo>();
            JsonArray upcomingQuests = data.getEntry("upcomingquests").getAsJsonArray();
            for (JsonElement ele : upcomingQuests) {
                quests.add(this.getUserQuest(save, ele.getAsInt()));
            }
            return (UserQuestInfo[])quests.toArray(UserQuestInfo[]::new);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void recomputeActiveQuests(AccountSaveContainer save) {
        try {
            AccountDataContainer data = save.getSaveData().getChildContainer("quests");
            JsonArray active = new JsonArray();
            JsonArray activeOld = data.entryExists("activequests") ? data.getEntry("activequests").getAsJsonArray() : new JsonArray();
            ArrayList<Integer> activeQuests = new ArrayList<Integer>();
            ArrayList<Integer> prevActiveQuests = new ArrayList<Integer>();
            for (JsonElement ele : activeOld) {
                prevActiveQuests.add(ele.getAsInt());
            }
            for (MissionData mission : this.quests.values()) {
                UserQuestInfo q = this.getUserQuest(save, mission.id);
                if ((mission.repeatable == null || !mission.repeatable.equalsIgnoreCase("true")) && q.isCompleted() || !q.isActive()) continue;
                active.add((Number)q.getQuestID());
                activeQuests.add(q.getQuestID());
                if (prevActiveQuests.contains(q.getQuestID())) continue;
                EventBus.getInstance().dispatchEvent((EventObject)new QuestUnlockEvent(q, save, this));
            }
            data.setEntry("activequests", (JsonElement)active);
            data.setEntry("lastupdate", (JsonElement)new JsonPrimitive((Number)this.lastQuestUpdateTime));
            data.setEntry("lastupdate_serverdata", (JsonElement)new JsonPrimitive(this.lastQuestUpdateVersion));
            data.setEntry("lastupdate_serverver", (JsonElement)new JsonPrimitive(this.questDataVersion));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void recomputeUpcomingQuests(AccountSaveContainer save) {
        try {
            AccountDataContainer data = save.getSaveData().getChildContainer("quests");
            JsonArray upcoming = new JsonArray();
            for (MissionData mission : this.quests.values()) {
                UserQuestInfo q = this.getUserQuest(save, mission.id);
                if (q.isCompleted() || q.isActive()) continue;
                upcoming.add((Number)q.getQuestID());
            }
            data.setEntry("upcomingquests", (JsonElement)upcoming);
            data.setEntry("lastupdate", (JsonElement)new JsonPrimitive((Number)this.lastQuestUpdateTime));
            data.setEntry("lastupdate_serverdata", (JsonElement)new JsonPrimitive(this.lastQuestUpdateVersion));
            data.setEntry("lastupdate_serverver", (JsonElement)new JsonPrimitive(this.questDataVersion));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void recomputeQuests(AccountSaveContainer save) {
        try {
            UserQuestInfo q;
            AccountDataContainer data = save.getSaveData().getChildContainer("quests");
            JsonArray active = new JsonArray();
            JsonArray upcoming = new JsonArray();
            JsonArray activeOld = data.entryExists("activequests") ? data.getEntry("activequests").getAsJsonArray() : new JsonArray();
            ArrayList<Integer> activeQuests = new ArrayList<Integer>();
            ArrayList<Integer> prevActiveQuests = new ArrayList<Integer>();
            for (JsonElement ele : activeOld) {
                prevActiveQuests.add(ele.getAsInt());
            }
            for (MissionData mission : this.quests.values()) {
                q = this.getUserQuest(save, mission.id);
                if ((mission.repeatable == null || !mission.repeatable.equalsIgnoreCase("true")) && q.isCompleted() || !q.isActive()) continue;
                active.add((Number)q.getQuestID());
                activeQuests.add(q.getQuestID());
                if (prevActiveQuests.contains(q.getQuestID())) continue;
                EventBus.getInstance().dispatchEvent((EventObject)new QuestUnlockEvent(q, save, this));
            }
            for (MissionData mission : this.quests.values()) {
                q = this.getUserQuest(save, mission.id);
                if (activeQuests.contains(q.getQuestID()) || q.isCompleted()) continue;
                upcoming.add((Number)q.getQuestID());
            }
            data.setEntry("activequests", (JsonElement)active);
            data.setEntry("upcomingquests", (JsonElement)upcoming);
            data.setEntry("lastupdate", (JsonElement)new JsonPrimitive((Number)this.lastQuestUpdateTime));
            data.setEntry("lastupdate_serverdata", (JsonElement)new JsonPrimitive(this.lastQuestUpdateVersion));
            data.setEntry("lastupdate_serverver", (JsonElement)new JsonPrimitive(this.questDataVersion));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void reload() {
        this.lastReloadTime = System.currentTimeMillis();
        try {
            CommonDataManager.getInstance().getContainer("QUESTMANAGER").setEntry("lastreload", (JsonElement)new JsonPrimitive((Number)this.lastReloadTime));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logger.info("Reloading quest manager...");
        this.loadQuests();
    }

    private class UserQuestInfoImpl
    extends UserQuestInfo {
        private MissionData def;
        private AccountDataContainer data;
        private AccountSaveContainer save;
        private JsonObject questInfoData;
        private Object questInfoLock = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void populateQuestInfoIfNeeded() {
            if (this.questInfoData != null) {
                return;
            }
            Object object = this.questInfoLock;
            synchronized (object) {
                if (this.questInfoData != null) {
                    return;
                }
                try {
                    this.data = this.save.getSaveData().getChildContainer("quests");
                    if (this.data.entryExists("quest-" + this.def.id)) {
                        this.questInfoData = this.data.getEntry("quest-" + this.def.id).getAsJsonObject();
                        if (!this.questInfoData.has("accepted")) {
                            this.questInfoData.addProperty("accepted", Boolean.valueOf(false));
                        }
                        if (!this.questInfoData.has("started")) {
                            this.questInfoData.addProperty("started", Boolean.valueOf(false));
                        }
                        if (!this.questInfoData.has("completed")) {
                            this.questInfoData.addProperty("completed", Boolean.valueOf(false));
                        }
                    } else {
                        this.questInfoData = new JsonObject();
                        this.questInfoData.addProperty("completed", Boolean.valueOf(false));
                        this.questInfoData.addProperty("accepted", Boolean.valueOf(false));
                        this.questInfoData.addProperty("started", Boolean.valueOf(false));
                        this.questInfoData.add("payload", (JsonElement)new JsonObject());
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public UserQuestInfoImpl(MissionData def, AccountSaveContainer save) {
            this.def = def;
            this.save = save;
            try {
                this.data = save.getSaveData().getChildContainer("quests");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public int getQuestID() {
            return this.def.id;
        }

        @Override
        public MissionData getDef() {
            return this.def;
        }

        @Override
        public MissionData getData() {
            this.populateQuestInfoIfNeeded();
            MissionData data = this.def.copy();
            if (data.childMissions != null) {
                for (int i = 0; i < data.childMissions.length; ++i) {
                    data.childMissions[i] = QuestManagerImpl.this.getUserQuest(this.save, data.childMissions[i].id).getData();
                }
            }
            JsonObject payload = this.questInfoData.get("payload").getAsJsonObject();
            if (this.questInfoData.has("accepted")) {
                data.accepted = this.questInfoData.get("accepted").getAsBoolean();
            }
            if (this.questInfoData.has("completed")) {
                int n = data.completed = this.questInfoData.get("completed").getAsBoolean() ? 1 : 0;
            }
            if (payload.has("tasks") && data.tasks != null) {
                JsonObject tasksBase = payload.get("tasks").getAsJsonObject();
                MissionData.TaskBlock[] taskBlockArray = data.tasks;
                int n = taskBlockArray.length;
                for (int i = 0; i < n; ++i) {
                    MissionData.TaskBlock task = taskBlockArray[i];
                    if (!tasksBase.has(Integer.toString(task.id))) continue;
                    JsonObject taskPayload = tasksBase.get(Integer.toString(task.id)).getAsJsonObject();
                    if (taskPayload.has("completed")) {
                        int n2 = task.completed = taskPayload.get("completed").getAsBoolean() ? 1 : 0;
                    }
                    if (!taskPayload.has("payload")) continue;
                    task.payload = taskPayload.get("payload").getAsString();
                }
            }
            if (data.missionRules != null && data.missionRules.criteria != null && data.missionRules.criteria.rules != null) {
                for (MissionData.MissionRulesBlock.CriteriaBlock.RuleInfoBlock rule : data.missionRules.criteria.rules) {
                    Optional<MissionData.TaskBlock> opt;
                    if (rule.type == 2) {
                        int missionID = rule.id;
                        if (missionID == data.id) {
                            rule.complete = data.completed;
                            continue;
                        }
                        UserQuestInfo i = QuestManagerImpl.this.getUserQuest(this.save, missionID);
                        if (i == null) continue;
                        rule.complete = i.isCompleted() ? 1 : 0;
                        continue;
                    }
                    UserQuestInfo i = this;
                    int missionID = rule.missionID;
                    if (missionID != data.id) {
                        i = QuestManagerImpl.this.getUserQuest(this.save, missionID);
                    }
                    if (i == null) continue;
                    MissionData d = data;
                    if (missionID != data.id) {
                        d = i.getData();
                    }
                    if (!(opt = Stream.of(d.tasks).filter(t -> t.id == rule.id).findFirst()).isPresent()) continue;
                    rule.complete = opt.get().completed;
                }
            }
            return data;
        }

        @Override
        public void acceptQuest() {
            this.populateQuestInfoIfNeeded();
            if (this.questInfoData.get("started").getAsBoolean()) {
                return;
            }
            this.startQuest();
            this.questInfoData.addProperty("accepted", Boolean.valueOf(true));
            try {
                this.data.setEntry("quest-" + this.def.id, (JsonElement)this.questInfoData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                RewardsUtil.addRewards(this.save, this.def.acceptanceRewards, this.isCompleted(), 1);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            EventBus.getInstance().dispatchEvent((EventObject)new QuestAcceptedEvent(this, this.save, QuestManagerImpl.this));
            AsyncTaskManager.runAsync(() -> QuestManagerImpl.this.recomputeQuests(this.save));
        }

        @Override
        public SetTaskStateResultData handleTaskCall(int taskID, String payloadStr, boolean completed, int invContainer, SetCommonInventoryRequestData[] requests) throws IOException {
            JsonObject taskPayload;
            JsonObject tasksBase;
            MissionData.TaskBlock task;
            this.populateQuestInfoIfNeeded();
            MissionData mission = this.getData();
            Optional<MissionData.TaskBlock> opt = Stream.of(mission.tasks).filter(t -> t.id == taskID).findFirst();
            MissionData.TaskBlock taskBlock = task = opt.isPresent() ? opt.get() : null;
            if (task == null) {
                SetTaskStateResultData resp = new SetTaskStateResultData();
                resp.success = false;
                resp.status = 8;
                return resp;
            }
            JsonObject payload = this.questInfoData.get("payload").getAsJsonObject();
            if (payload.has("tasks")) {
                tasksBase = payload.get("tasks").getAsJsonObject();
            } else {
                tasksBase = new JsonObject();
                payload.add("tasks", (JsonElement)tasksBase);
            }
            if (this.isCompleted() && (mission.repeatable == null || mission.repeatable.equalsIgnoreCase("false")) && !tasksBase.has(Integer.toString(taskID))) {
                SetTaskStateResultData resp = new SetTaskStateResultData();
                resp.success = false;
                resp.status = 15;
                return resp;
            }
            if (!this.questInfoData.get("started").getAsBoolean()) {
                this.startQuest();
            }
            if (tasksBase.has(Integer.toString(taskID))) {
                taskPayload = tasksBase.get(Integer.toString(taskID)).getAsJsonObject();
            } else {
                taskPayload = new JsonObject();
                tasksBase.add(Integer.toString(taskID), (JsonElement)taskPayload);
            }
            taskPayload.addProperty("payload", payloadStr);
            if (completed) {
                taskPayload.addProperty("completed", Boolean.valueOf(true));
                task.completed = 1;
            } else {
                task.completed = taskPayload.has("completed") && taskPayload.get("completed").getAsBoolean() ? 1 : 0;
            }
            task.payload = payloadStr;
            try {
                this.data.setEntry("quest-" + this.def.id, (JsonElement)this.questInfoData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            SetTaskStateResultData resp = new SetTaskStateResultData();
            resp.status = 12;
            resp.success = true;
            if (requests != null && requests.length != 0) {
                resp.inventoryUpdate = InventoryUtils.processCommonInventorySet(requests, this.save.getSaveData(), invContainer);
            }
            if (invContainer == -1) {
                invContainer = 1;
            }
            EventBus.getInstance().dispatchEvent((EventObject)new QuestTaskProgressionEvent(this, task, payloadStr, this.save, QuestManagerImpl.this));
            if (completed) {
                EventBus.getInstance().dispatchEvent((EventObject)new QuestTaskCompletionEvent(this, task, payloadStr, this.save, QuestManagerImpl.this));
                boolean missionCompleted = this.isCompletedMission(mission);
                if (missionCompleted) {
                    ArrayList<SetTaskStateResultData.CompletedMissionInfoBlock> completedMissions = new ArrayList<SetTaskStateResultData.CompletedMissionInfoBlock>();
                    SetTaskStateResultData.CompletedMissionInfoBlock i = new SetTaskStateResultData.CompletedMissionInfoBlock();
                    boolean wasCompleted = this.isCompleted();
                    this.completeQuest();
                    i.missionID = this.getQuestID();
                    MissionData missionD = this.getDef();
                    i.rewards = RewardsUtil.giveRewardsTo(this.save, missionD.rewards, wasCompleted, invContainer);
                    completedMissions.add(i);
                    resp.completedMissions = (SetTaskStateResultData.CompletedMissionInfoBlock[])completedMissions.toArray(SetTaskStateResultData.CompletedMissionInfoBlock[]::new);
                    AsyncTaskManager.runAsync(() -> QuestManagerImpl.this.recomputeQuests(this.save));
                }
            }
            return resp;
        }

        private boolean isCompletedMission(MissionData mission) {
            if (mission.missionRules != null && mission.missionRules.criteria != null && mission.missionRules.criteria.rules != null && mission.missionRules.criteria.rules.length != 0) {
                int minCompletedRules = mission.missionRules.criteria.min;
                if (mission.missionRules.criteria.type.equals("all")) {
                    minCompletedRules = mission.missionRules.criteria.rules.length;
                }
                int completedRules = 0;
                block4: for (MissionData.MissionRulesBlock.CriteriaBlock.RuleInfoBlock rule : mission.missionRules.criteria.rules) {
                    switch (rule.type) {
                        case 1: {
                            Optional<MissionData.TaskBlock> task;
                            MissionData questD = mission;
                            if (rule.missionID != mission.id) {
                                UserQuestInfo uQuest = QuestManagerImpl.this.getUserQuest(this.save, rule.missionID);
                                if (uQuest == null) continue block4;
                                questD = uQuest.getData();
                            }
                            if (questD.tasks == null || !(task = Stream.of(questD.tasks).filter(t -> t.id == rule.id).findFirst()).isPresent() || task.get().completed <= 0) continue block4;
                            ++completedRules;
                            continue block4;
                        }
                        case 2: {
                            MissionData tMission = QuestManagerImpl.this.getQuestDef(rule.id);
                            if (tMission == null || !QuestManagerImpl.this.getUserQuest(this.save, rule.id).isCompleted()) continue block4;
                            ++completedRules;
                            continue block4;
                        }
                        default: {
                            ++completedRules;
                        }
                    }
                }
                if (completedRules < minCompletedRules) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void startQuest() {
            this.populateQuestInfoIfNeeded();
            if (this.questInfoData.get("started").getAsBoolean()) {
                throw new IllegalArgumentException("Quest is already started");
            }
            this.questInfoData.addProperty("started", Boolean.valueOf(true));
            try {
                this.data.setEntry("quest-" + this.def.id, (JsonElement)this.questInfoData);
                if (this.def.parentQuestID > 0) {
                    return;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            EventBus.getInstance().dispatchEvent((EventObject)new QuestStartedEvent(this, this.save, QuestManagerImpl.this));
            AsyncTaskManager.runAsync(() -> QuestManagerImpl.this.recomputeQuests(this.save));
        }

        @Override
        public void completeQuest() {
            this.populateQuestInfoIfNeeded();
            this.questInfoData.addProperty("completed", Boolean.valueOf(true));
            this.questInfoData.addProperty("accepted", Boolean.valueOf(false));
            this.questInfoData.addProperty("started", Boolean.valueOf(false));
            try {
                this.data.setEntry("quest-" + this.def.id, (JsonElement)this.questInfoData);
                if (this.def.parentQuestID > 0) {
                    return;
                }
                JsonArray completedQuests = !this.data.entryExists("completedquests") ? new JsonArray() : this.data.getEntry("completedquests").getAsJsonArray();
                boolean found = false;
                for (JsonElement ele : completedQuests) {
                    if (ele.getAsInt() != this.def.id) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    completedQuests.add((Number)this.def.id);
                    this.data.setEntry("completedquests", (JsonElement)completedQuests);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            EventBus.getInstance().dispatchEvent((EventObject)new QuestCompletedEvent(this, this.save, QuestManagerImpl.this));
            AsyncTaskManager.runAsync(() -> QuestManagerImpl.this.recomputeQuests(this.save));
        }

        @Override
        public boolean isActive() {
            UserQuestInfo quest;
            if (this.def.parentQuestID > 0 && (quest = QuestManagerImpl.this.getUserQuest(this.save, this.def.parentQuestID)) != null && !quest.isActive()) {
                return false;
            }
            this.populateQuestInfoIfNeeded();
            if (this.def.missionRules != null && this.def.missionRules.prerequisites != null) {
                block16: for (MissionData.MissionRulesBlock.PrerequisiteInfoBlock req : this.def.missionRules.prerequisites) {
                    if (req.clientRule) continue;
                    switch (req.type) {
                        case 2: {
                            if (!req.value.equalsIgnoreCase("true") || this.questInfoData.get("accepted").getAsBoolean()) continue block16;
                            return false;
                        }
                        case 3: {
                            int missionID = Integer.parseInt(req.value);
                            UserQuestInfo quest2 = QuestManagerImpl.this.getUserQuest(this.save, missionID);
                            if (quest2 == null) {
                                return false;
                            }
                            if (quest2.isCompleted()) continue block16;
                            return false;
                        }
                        case 5: {
                            String[] dStrs = req.value.split(",");
                            if (dStrs.length != 2) continue block16;
                            String startDate = dStrs[0];
                            String endDate = dStrs[1];
                            try {
                                SimpleDateFormat fmt = new SimpleDateFormat("MM'-'dd'-'yyyy HH':'mm':'ss");
                                Date start = fmt.parse(startDate);
                                Date end = fmt.parse(endDate);
                                Date now = new Date(System.currentTimeMillis());
                                if (start.before(now) || end.after(now)) {
                                    return false;
                                }
                                continue block16;
                            }
                            catch (ParseException e) {
                                try {
                                    SimpleDateFormat fmt = new SimpleDateFormat("MM'-'dd'-'yyyy");
                                    Date start = fmt.parse(startDate);
                                    Date end = fmt.parse(endDate);
                                    Date now = new Date(System.currentTimeMillis());
                                    if (!start.before(now) && !end.after(now)) continue block16;
                                    return false;
                                }
                                catch (ParseException e2) {
                                    try {
                                        SimpleDateFormat fmt = new SimpleDateFormat("dd'/'MM'/'yyyy");
                                        Date start = fmt.parse(startDate);
                                        Date end = fmt.parse(endDate);
                                        Date now = new Date(System.currentTimeMillis());
                                        if (!start.before(now) && !end.after(now)) continue block16;
                                        return false;
                                    }
                                    catch (ParseException e3) {
                                        throw new RuntimeException(e);
                                    }
                                }
                            }
                        }
                        case 7: {
                            int itmId = Integer.parseInt(req.value);
                            Optional<PlayerInventoryItem> opt = Stream.of(this.save.getInventory().getContainers()).map(t -> t.findFirst(itmId)).filter(t -> t != null).findFirst();
                            if (opt.isPresent()) {
                                if (req.quantity <= opt.get().getQuantity()) continue block16;
                                return false;
                            }
                            return false;
                        }
                        case 1: {
                            if (!req.value.equalsIgnoreCase("true")) continue block16;
                            return false;
                        }
                        case 4: {
                            String[] idsStrs = req.value.split(",");
                            int typeID = 0;
                            int minimal = 0;
                            int maximum = 0;
                            if (idsStrs.length >= 1) {
                                typeID = Integer.parseInt(idsStrs[0]);
                            }
                            if (idsStrs.length >= 2) {
                                minimal = Integer.parseInt(idsStrs[1]);
                            }
                            if (idsStrs.length >= 3) {
                                maximum = Integer.parseInt(idsStrs[2]);
                            }
                            RankTypeID id = RankTypeID.getByTypeID((int)typeID);
                            try {
                                String userID = UserQuestInfoImpl.rankUserID(this.save, id);
                                int value = AchievementManager.getInstance().getRankIndex(AchievementManager.getInstance().getRank(this.save, userID, id).getRank()) + 1;
                                if (value >= minimal && value < maximum) {
                                    continue block16;
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            return false;
                        }
                    }
                }
            }
            return true;
        }

        private static String rankUserID(AccountSaveContainer save, RankTypeID id) throws JsonMappingException, JsonProcessingException, IOException {
            String userID = save.getSaveID();
            if (id == RankTypeID.CLAN) {
                return null;
            }
            if (id == RankTypeID.DRAGON) {
                AccountDataContainer data = save.getSaveData();
                data = data.getChildContainer("dragons");
                JsonArray dragonIds = new JsonArray();
                if (data.entryExists("dragonlist")) {
                    dragonIds = data.getEntry("dragonlist").getAsJsonArray();
                } else {
                    data.setEntry("dragonlist", (JsonElement)dragonIds);
                }
                for (JsonElement ele : dragonIds) {
                    String did = ele.getAsString();
                    DragonData dragon = (DragonData)new XmlMapper().readValue(data.getEntry("dragon-" + did).getAsString(), DragonData.class);
                    if (!dragon.isSelected) continue;
                    userID = dragon.entityID;
                    break;
                }
            }
            return userID;
        }

        @Override
        public boolean isCompleted() {
            this.populateQuestInfoIfNeeded();
            return this.questInfoData.get("completed").getAsBoolean();
        }

        @Override
        public boolean isStarted() {
            this.populateQuestInfoIfNeeded();
            return this.questInfoData.get("started").getAsBoolean();
        }

        @Override
        public void resetQuest() {
            UserQuestInfoImpl.questReset(this, QuestManagerImpl.this);
            AsyncTaskManager.runAsync(() -> QuestManagerImpl.this.recomputeQuests(this.save));
        }

        private static void questReset(UserQuestInfoImpl quest, QuestManager manager) {
            quest.questInfoData = new JsonObject();
            quest.questInfoData.addProperty("completed", Boolean.valueOf(false));
            quest.questInfoData.addProperty("accepted", Boolean.valueOf(false));
            quest.questInfoData.addProperty("started", Boolean.valueOf(false));
            quest.questInfoData.add("payload", (JsonElement)new JsonObject());
            try {
                JsonArray completedQuests = !quest.data.entryExists("completedquests") ? new JsonArray() : quest.data.getEntry("completedquests").getAsJsonArray();
                boolean found = false;
                for (JsonElement ele : completedQuests) {
                    if (ele.getAsInt() != quest.def.id) continue;
                    found = true;
                    completedQuests.remove(ele);
                    break;
                }
                if (found) {
                    completedQuests.add((Number)quest.def.id);
                    quest.data.setEntry("completedquests", (JsonElement)completedQuests);
                }
                quest.data.setEntry("quest-" + quest.def.id, (JsonElement)quest.questInfoData);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            EventBus.getInstance().dispatchEvent((EventObject)new QuestResetEvent(quest, quest.save, manager));
            if (quest.def.childMissions != null) {
                for (MissionData ch : quest.def.childMissions) {
                    UserQuestInfoImpl q = (UserQuestInfoImpl)manager.getUserQuest(quest.save, ch.id);
                    UserQuestInfoImpl.questReset(q, manager);
                }
            }
        }
    }
}

