/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.http.handlers.gameplayapi;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.entities.items.ItemStoreInfo;
import org.asf.edge.common.entities.items.PlayerInventoryItem;
import org.asf.edge.common.entities.minigamedata.MinigameData;
import org.asf.edge.common.entities.minigamedata.MinigameDataRequest;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.Function;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionResult;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequest;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequestParam;
import org.asf.edge.common.http.apihandlerutils.functions.SodTokenSecured;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireCapability;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireSave;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.services.minigamedata.MinigameDataManager;
import org.asf.edge.common.services.textfilter.TextFilterService;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.common.tokens.TokenParseResult;
import org.asf.edge.common.xmls.items.inventory.InventoryItemEntryData;
import org.asf.edge.gameplayapi.EdgeGameplayApiServer;
import org.asf.edge.gameplayapi.entities.quests.UserQuestInfo;
import org.asf.edge.gameplayapi.services.quests.QuestManager;
import org.asf.edge.gameplayapi.util.InventoryUtils;
import org.asf.edge.gameplayapi.util.inventory.ItemRedemptionInfo;
import org.asf.edge.gameplayapi.xmls.avatars.SetAvatarResultData;
import org.asf.edge.gameplayapi.xmls.avatars.SetDisplayNameRequestData;
import org.asf.edge.gameplayapi.xmls.dragons.CreatePetResponseData;
import org.asf.edge.gameplayapi.xmls.dragons.DragonData;
import org.asf.edge.gameplayapi.xmls.dragons.DragonListData;
import org.asf.edge.gameplayapi.xmls.dragons.PetCreateRequestData;
import org.asf.edge.gameplayapi.xmls.dragons.PetUpdateResponseData;
import org.asf.edge.gameplayapi.xmls.inventories.CommonInventoryData;
import org.asf.edge.gameplayapi.xmls.inventories.CommonInventoryRequestData;
import org.asf.edge.gameplayapi.xmls.inventories.InventoryUpdateResponseData;
import org.asf.edge.gameplayapi.xmls.inventories.SetCommonInventoryRequestData;
import org.asf.edge.gameplayapi.xmls.items.ItemPurchaseRequestData;
import org.asf.edge.gameplayapi.xmls.minigamedata.GameDataSummaryData;
import org.asf.edge.gameplayapi.xmls.names.DisplayNameUniqueResponseData;
import org.asf.edge.gameplayapi.xmls.names.NameValidationRequest;
import org.asf.edge.gameplayapi.xmls.names.NameValidationResponseData;
import org.asf.edge.gameplayapi.xmls.quests.MissionData;
import org.asf.edge.gameplayapi.xmls.quests.QuestListResponseData;
import org.asf.edge.gameplayapi.xmls.quests.RequestFilterData;
import org.asf.edge.gameplayapi.xmls.quests.SetTaskStateResultData;

public class ContentWebServiceV2Processor
extends EdgeWebService<EdgeGameplayApiServer> {
    private static AccountManager manager;
    private static ItemManager itemManager;
    private static QuestManager questManager;
    private static Random rnd;

    public ContentWebServiceV2Processor(EdgeGameplayApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new ContentWebServiceV2Processor((EdgeGameplayApiServer)this.getServerInstance());
    }

    public String path() {
        return "/v2/ContentWebService.asmx";
    }

    public void fallbackRequestProcessor(String path, String method, RemoteClient client, String contentType) throws IOException {
        this.setResponseStatus(404, "Not found");
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getGameData(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger());
        if (req == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        this.setResponseContent("text/xml", "<GetGameDataResponse />");
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setTaskState(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (questManager == null) {
            questManager = QuestManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        AccountSaveContainer save = account.getSave(userID);
        if (save != null) {
            int invContainer = Integer.parseInt((String)req.payload.get("ContainerId"));
            int taskID = Integer.parseInt((String)req.payload.get("taskId"));
            int missionId = Integer.parseInt((String)req.payload.get("missionId"));
            boolean completed = ((String)req.payload.get("completed")).equalsIgnoreCase("true");
            String payload = (String)req.payload.get("xmlPayload");
            String invReq = (String)req.payload.get("commonInventoryRequestXml");
            SetCommonInventoryRequestData[] requests = !invReq.trim().equals("<?xml version=\"1.0\" encoding=\"utf-8\"?>") ? (SetCommonInventoryRequestData[])req.parseXmlValue(invReq, SetCommonInventoryRequestData[].class) : new SetCommonInventoryRequestData[]{};
            UserQuestInfo quest = questManager.getUserQuest(save, missionId);
            if (quest != null) {
                this.setResponseContent("text/xml", req.generateXmlValue("SetTaskStateResult", (Object)quest.handleTaskCall(taskID, payload, completed, invContainer, requests)));
            } else {
                SetTaskStateResultData resp = new SetTaskStateResultData();
                resp.success = false;
                resp.status = 8;
                this.setResponseContent("text/xml", req.generateXmlValue("SetTaskStateResult", (Object)resp));
            }
        } else {
            this.setResponseStatus(404, "Not found");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getUserMissionState(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (questManager == null) {
            questManager = QuestManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        AccountSaveContainer save = account.getSave(userID);
        if (save != null) {
            MissionData[] quests = questManager.getAllQuestDefs();
            RequestFilterData filter = (RequestFilterData)req.parseXmlValue((String)req.payload.get("filter"), RequestFilterData.class);
            ArrayList<Integer> addedQuests = new ArrayList<Integer>();
            ArrayList<MissionData> questLst = new ArrayList<MissionData>();
            QuestListResponseData resp = new QuestListResponseData();
            resp.userID = userID;
            boolean hasExplicitRequests = false;
            if (filter.missions != null && filter.missions.length != 0) {
                hasExplicitRequests = true;
                for (RequestFilterData.MissionPairBlock pair : filter.missions) {
                    UserQuestInfo quest;
                    if (addedQuests.contains(pair.missionID) || (quest = questManager.getUserQuest(save, pair.missionID)) == null || !filter.getCompletedMissions && quest.isCompleted() || pair.versionID != -1 && quest.getDef().version != pair.versionID) continue;
                    questLst.add(quest.getData());
                    addedQuests.add(quest.getQuestID());
                }
            }
            if (filter.groupIDs != null && filter.groupIDs.length != 0) {
                hasExplicitRequests = true;
                IntStream strm = IntStream.of(filter.groupIDs);
                MissionData[] missionDataArray = quests;
                int n = missionDataArray.length;
                for (int pair = 0; pair < n; ++pair) {
                    UserQuestInfo quest;
                    MissionData data = missionDataArray[pair];
                    if (addedQuests.contains(data.id) || !strm.anyMatch(t -> t == data.groupID) || (quest = questManager.getUserQuest(save, data.id)) == null || !filter.getCompletedMissions && quest.isCompleted()) continue;
                    questLst.add(quest.getData());
                    addedQuests.add(quest.getQuestID());
                }
            }
            if (!hasExplicitRequests) {
                if (filter.getCompletedMissions) {
                    for (UserQuestInfo quest : questManager.getCompletedQuests(save)) {
                        if (addedQuests.contains(quest.getQuestID())) continue;
                        d = quest.getData();
                        questLst.add(d);
                        addedQuests.add(quest.getQuestID());
                    }
                } else {
                    for (UserQuestInfo quest : questManager.getActiveQuests(save)) {
                        if (addedQuests.contains(quest.getQuestID())) continue;
                        d = quest.getData();
                        questLst.add(d);
                        addedQuests.add(quest.getQuestID());
                    }
                    for (UserQuestInfo quest : questManager.getUpcomingQuests(save)) {
                        if (addedQuests.contains(quest.getQuestID())) continue;
                        d = quest.getDef();
                        questLst.add(d);
                        addedQuests.add(quest.getQuestID());
                    }
                }
            }
            resp.quests = (MissionData[])questLst.toArray(MissionData[]::new);
            this.setResponseContent("text/xml", req.generateXmlValue("UserMissionStateResult", (Object)resp));
        } else {
            this.setResponseStatus(404, "Not found");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getUserCompletedMissionState(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (questManager == null) {
            questManager = QuestManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        AccountSaveContainer save = account.getSave(userID);
        if (save != null) {
            UserQuestInfo[] quests = questManager.getCompletedQuests(save);
            QuestListResponseData resp = new QuestListResponseData();
            resp.userID = userID;
            resp.quests = new MissionData[quests.length];
            for (int i = 0; i < resp.quests.length; ++i) {
                MissionData data;
                resp.quests[i] = data = quests[i].getData();
            }
            this.setResponseContent("text/xml", req.generateXmlValue("UserMissionStateResult", (Object)resp));
        } else {
            this.setResponseStatus(404, "Not found");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getUserActiveMissionState(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (questManager == null) {
            questManager = QuestManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        AccountSaveContainer save = account.getSave(userID);
        if (save != null) {
            UserQuestInfo[] quests = questManager.getActiveQuests(save);
            QuestListResponseData resp = new QuestListResponseData();
            resp.userID = userID;
            resp.quests = new MissionData[quests.length];
            for (int i = 0; i < resp.quests.length; ++i) {
                MissionData data;
                resp.quests[i] = data = quests[i].getData();
            }
            this.setResponseContent("text/xml", req.generateXmlValue("UserMissionStateResult", (Object)resp));
        } else {
            this.setResponseStatus(404, "Not found");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getUserUpcomingMissionState(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (questManager == null) {
            questManager = QuestManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        AccountSaveContainer save = account.getSave(userID);
        if (save != null) {
            UserQuestInfo[] quests = questManager.getUpcomingQuests(save);
            QuestListResponseData resp = new QuestListResponseData();
            resp.userID = userID;
            ArrayList<MissionData> questLst = new ArrayList<MissionData>();
            for (UserQuestInfo i : quests) {
                MissionData d = i.getDef();
                questLst.add(d);
            }
            resp.quests = (MissionData[])questLst.toArray(MissionData[]::new);
            this.setResponseContent("text/xml", req.generateXmlValue("UserMissionStateResult", (Object)resp));
        } else {
            this.setResponseStatus(404, "Not found");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setDisplayName(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        AccountSaveContainer save = account.getSave(tkn.saveID);
        SetDisplayNameRequestData request = (SetDisplayNameRequestData)req.parseXmlValue((String)req.payload.get("request"), SetDisplayNameRequestData.class);
        ItemStoreInfo store = itemManager.getStore(request.storeID);
        if (store == null) {
            SetAvatarResultData resp = new SetAvatarResultData();
            resp.success = false;
            resp.statusCode = 255;
            resp.suggestions = null;
            this.setResponseContent("text/xml", req.generateXmlValue("SetAvatarResult", (Object)resp));
            return;
        }
        ItemInfo itm = store.getItem(request.itemID);
        if (itm == null) {
            SetAvatarResultData resp = new SetAvatarResultData();
            resp.success = false;
            resp.statusCode = 255;
            resp.suggestions = null;
            this.setResponseContent("text/xml", req.generateXmlValue("SetAvatarResult", (Object)resp));
            return;
        }
        String name = request.displayName;
        if (!manager.isValidUsername(name)) {
            SetAvatarResultData resp = new SetAvatarResultData();
            resp.success = false;
            resp.statusCode = 10;
            resp.suggestions = null;
            this.setResponseContent("text/xml", req.generateXmlValue("SetAvatarResult", (Object)resp));
            return;
        }
        if (TextFilterService.getInstance().isFiltered(name, true)) {
            SetAvatarResultData resp = new SetAvatarResultData();
            resp.success = false;
            resp.statusCode = 10;
            resp.suggestions = null;
            this.setResponseContent("text/xml", req.generateXmlValue("SetAvatarResult", (Object)resp));
            return;
        }
        if (!name.equalsIgnoreCase(save.getUsername())) {
            boolean inUse = false;
            if (!account.getUsername().equalsIgnoreCase(name) && manager.isUsernameTaken(name)) {
                inUse = true;
            } else if (Stream.of(account.getSaveIDs()).map(t -> account.getSave(t)).anyMatch(t -> {
                try {
                    return t.getUsername().equalsIgnoreCase(name) && t.getSaveData().entryExists("avatar");
                }
                catch (IOException e) {
                    return false;
                }
            })) {
                inUse = true;
            }
            if (inUse) {
                SetAvatarResultData resp = new SetAvatarResultData();
                resp.success = false;
                resp.statusCode = 10;
                resp.suggestions = new DisplayNameUniqueResponseData.SuggestionResultBlock();
                Random rnd = new Random();
                ArrayList<CallSite> suggestions = new ArrayList<CallSite>();
                for (int i = 1000; i < 9999 && suggestions.size() != 6; ++i) {
                    if (manager.isUsernameTaken(name + rnd.nextInt(1000, 9999))) continue;
                    suggestions.add((CallSite)((Object)(name + rnd.nextInt(1000, 9999))));
                }
                resp.suggestions.suggestions = (String[])suggestions.toArray(String[]::new);
                this.setResponseContent("text/xml", req.generateXmlValue("SetAvatarResult", (Object)resp));
                return;
            }
            XmlMapper mapper = new XmlMapper();
            ObjectNode aviCurrent = (ObjectNode)mapper.readValue(save.getSaveData().getEntry("avatar").getAsString(), ObjectNode.class);
            aviCurrent.set("DisplayName", (JsonNode)new TextNode(name));
            save.getSaveData().setEntry("avatar", (JsonElement)new JsonPrimitive(mapper.writer().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_XML_DECLARATION}).withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("AvatarData").writeValueAsString((Object)aviCurrent)));
            if (!save.updateUsername(name)) {
                SetAvatarResultData resp = new SetAvatarResultData();
                resp.success = false;
                resp.statusCode = 10;
                resp.suggestions = null;
                this.setResponseContent("text/xml", req.generateXmlValue("SetAvatarResult", (Object)resp));
                return;
            }
        }
        AccountDataContainer currency = save.getSaveData().getChildContainer("currency");
        int currentC = 300;
        if (currency.entryExists("coins")) {
            currentC = currency.getEntry("coins").getAsInt();
        }
        AccountDataContainer currencyAccWide = save.getAccount().getAccountData().getChildContainer("currency");
        int currentG = 0;
        if (currencyAccWide.entryExists("gems")) {
            currentG = currencyAccWide.getEntry("gems").getAsInt();
        }
        if (!itm.isFree()) {
            if (itm.costsGems()) {
                currencyAccWide.setEntry("gems", (JsonElement)new JsonPrimitive((Number)(currentG - itm.getGemCost())));
            }
            if (itm.costsCoins()) {
                currency.setEntry("coins", (JsonElement)new JsonPrimitive((Number)(currentC - itm.getCoinCost())));
            }
        }
        SetAvatarResultData resp = new SetAvatarResultData();
        resp.statusCode = 1;
        resp.success = true;
        resp.displayName = name;
        resp.suggestions = null;
        this.setResponseContent("text/xml", req.generateXmlValue("SetAvatarResult", (Object)resp));
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    @Function(allowedMethods={"POST"})
    public FunctionResult setAvatar(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, AccountSaveContainer save, @SodRequestParam ObjectNode contentXML) throws IOException {
        ObjectNode aviData;
        String name;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (!manager.isValidUsername(name = (aviData = contentXML).get("DisplayName").asText())) {
            SetAvatarResultData resp = new SetAvatarResultData();
            resp.success = false;
            resp.statusCode = 10;
            resp.suggestions = null;
            return this.ok("text/xml", req.generateXmlValue("SetAvatarResult", (Object)resp));
        }
        if (TextFilterService.getInstance().isFiltered(name, true)) {
            SetAvatarResultData resp = new SetAvatarResultData();
            resp.success = false;
            resp.statusCode = 10;
            resp.suggestions = null;
            return this.ok("text/xml", req.generateXmlValue("SetAvatarResult", (Object)resp));
        }
        if (!name.equalsIgnoreCase(save.getUsername())) {
            boolean inUse = false;
            if (!account.getUsername().equalsIgnoreCase(name) && manager.isUsernameTaken(name)) {
                inUse = true;
            } else if (Stream.of(account.getSaveIDs()).map(t -> account.getSave(t)).anyMatch(t -> {
                try {
                    return t.getUsername().equalsIgnoreCase(name) && t.getSaveData().entryExists("avatar");
                }
                catch (IOException e) {
                    return false;
                }
            })) {
                inUse = true;
            }
            if (inUse) {
                SetAvatarResultData resp = new SetAvatarResultData();
                resp.success = false;
                resp.statusCode = 10;
                resp.suggestions = new DisplayNameUniqueResponseData.SuggestionResultBlock();
                Random rnd = new Random();
                ArrayList<CallSite> suggestions = new ArrayList<CallSite>();
                for (int i = 1000; i < 9999 && suggestions.size() != 6; ++i) {
                    if (manager.isUsernameTaken(name + rnd.nextInt(1000, 9999))) continue;
                    suggestions.add((CallSite)((Object)(name + rnd.nextInt(1000, 9999))));
                }
                resp.suggestions.suggestions = (String[])suggestions.toArray(String[]::new);
                return this.ok("text/xml", req.generateXmlValue("SetAvatarResult", (Object)resp));
            }
            if (!save.updateUsername(name)) {
                SetAvatarResultData resp = new SetAvatarResultData();
                resp.success = false;
                resp.statusCode = 10;
                resp.suggestions = null;
                return this.ok("text/xml", req.generateXmlValue("SetAvatarResult", (Object)resp));
            }
        }
        save.getSaveData().setEntry("avatar", (JsonElement)new JsonPrimitive((String)req.payload.get("contentXML")));
        if (!save.getSaveData().entryExists("received_default_items") || !save.getSaveData().getEntry("received_default_items").getAsBoolean()) {
            save.getInventory().giveDefaultItems();
            save.getSaveData().setEntry("received_default_items", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        SetAvatarResultData resp = new SetAvatarResultData();
        resp.statusCode = 1;
        resp.success = true;
        resp.displayName = name;
        resp.suggestions = null;
        return this.ok("text/xml", req.generateXmlValue("SetAvatarResult", (Object)resp));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void validateName(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        SessionToken tkn = new SessionToken();
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        TokenParseResult res = tkn.parseToken(apiToken);
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        NameValidationRequest request = (NameValidationRequest)req.parseXmlValue((String)req.payload.get("nameValidationRequest"), NameValidationRequest.class);
        NameValidationResponseData resp = new NameValidationResponseData();
        resp.result = 1;
        if (request.category == 4) {
            if (!manager.isValidUsername(request.name)) {
                resp.result = 4;
                resp.errorMessage = "Invalid";
                this.setResponseContent("text/xml", req.generateXmlValue("NameValidationResponse", (Object)resp));
                return;
            }
        } else if (request.category == 3) {
            if (TextFilterService.getInstance().isFiltered(request.name, true)) {
                resp.result = 2;
                resp.errorMessage = "Invalid";
                this.setResponseContent("text/xml", req.generateXmlValue("NameValidationResponse", (Object)resp));
                return;
            }
        } else if (request.category == 2) {
            if (TextFilterService.getInstance().isFiltered(request.name, true)) {
                resp.result = 2;
                resp.errorMessage = "Invalid";
                this.setResponseContent("text/xml", req.generateXmlValue("NameValidationResponse", (Object)resp));
                return;
            }
        } else if (request.category == 4 && TextFilterService.getInstance().isFiltered(request.name, true)) {
            resp.result = 2;
            resp.errorMessage = "Invalid";
            this.setResponseContent("text/xml", req.generateXmlValue("NameValidationResponse", (Object)resp));
            return;
        }
        this.setResponseContent("text/xml", req.generateXmlValue("NameValidationResponse", (Object)resp));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void createPet(LegacyFunctionInfo func) throws IOException {
        boolean found;
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        PetCreateRequestData request = (PetCreateRequestData)req.parseXmlValue((String)req.payload.get("request"), PetCreateRequestData.class);
        AccountSaveContainer save = account.getSave(tkn.saveID);
        AccountDataContainer data = save.getSaveData();
        CreatePetResponseData resp = new CreatePetResponseData();
        data = data.getChildContainer("dragons");
        JsonArray dragonIds = new JsonArray();
        if (data.entryExists("dragonlist")) {
            dragonIds = data.getEntry("dragonlist").getAsJsonArray();
        } else {
            data.setEntry("dragonlist", (JsonElement)dragonIds);
        }
        if (dragonIds.size() >= 0x7FFFFFFE) {
            this.setResponseStatus(400, "Bad request, too many dragons");
            return;
        }
        String entID = UUID.randomUUID().toString();
        int id = rnd.nextInt(0, Integer.MAX_VALUE);
        while (data.entryExists("dragon-" + id)) {
            id = rnd.nextInt(0, Integer.MAX_VALUE);
        }
        block1: do {
            found = false;
            for (JsonElement ele : dragonIds) {
                String did = ele.getAsString();
                ObjectNode d = (ObjectNode)req.parseXmlValue(data.getEntry("dragon-" + did).getAsString(), ObjectNode.class);
                if (!d.get("eid").asText().equals(entID)) continue;
                entID = UUID.randomUUID().toString();
                found = true;
                continue block1;
            }
        } while (found);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        ObjectNode dragon = request.dragonData;
        dragon.set("id", (JsonNode)new IntNode(id));
        dragon.set("ip", (JsonNode)new IntNode(dragonIds.size()));
        dragon.set("eid", (JsonNode)new TextNode(entID));
        if (!dragon.has("n") || dragon.get("n").asText().isBlank()) {
            dragon.set("n", (JsonNode)new TextNode("Dragon-" + System.currentTimeMillis()));
        }
        dragon.set("cdt", (JsonNode)new TextNode(fmt.format(new Date())));
        dragon.set("upd", (JsonNode)new TextNode(fmt.format(new Date())));
        if (request.setAsSelected) {
            for (JsonElement ele : dragonIds) {
                String did = ele.getAsString();
                ObjectNode ddragon = (ObjectNode)req.parseXmlValue(data.getEntry("dragon-" + did).getAsString(), ObjectNode.class);
                if (!ddragon.get("is").asBoolean()) continue;
                ddragon.set("is", (JsonNode)BooleanNode.FALSE);
                data.setEntry("dragon-" + did, (JsonElement)new JsonPrimitive(req.generateXmlValue("RaisedPetData", (Object)ddragon)));
            }
            dragon.set("is", (JsonNode)BooleanNode.TRUE);
        }
        dragonIds = data.getEntry("dragonlist").getAsJsonArray();
        dragonIds.add((Number)id);
        data.setEntry("dragonlist", (JsonElement)dragonIds);
        data.setEntry("dragon-" + id, (JsonElement)new JsonPrimitive(req.generateXmlValue("RaisedPetData", (Object)dragon)));
        if (request.commonInventoryRequests != null && request.commonInventoryRequests.length != 0) {
            resp.inventoryUpdate = InventoryUtils.processCommonInventorySet(request.commonInventoryRequests, save.getSaveData(), request.containerID == -1 ? 1 : request.containerID);
        }
        resp.dragonData = dragon.deepCopy();
        resp.dragonData.set("ispetcreated", (JsonNode)BooleanNode.TRUE);
        this.setResponseContent("text/xml", req.generateXmlValue("CPR", (Object)resp));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getCommonInventory(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        CommonInventoryRequestData request = (CommonInventoryRequestData)req.parseXmlValue((String)req.payload.get("getCommonInventoryRequestXml"), CommonInventoryRequestData.class);
        AccountDataContainer data = account.getAccountData();
        if (tkn.saveID != null) {
            data = account.getSave(tkn.saveID).getSaveData();
        }
        CommonInventoryData resp = new CommonInventoryData();
        resp.userID = account.getAccountID();
        if (tkn.saveID != null) {
            resp.userID = tkn.saveID;
        }
        ArrayList<InventoryItemEntryData> items = new ArrayList<InventoryItemEntryData>();
        for (PlayerInventoryItem itm : itemManager.getCommonInventory(data).getContainer(request.containerID).getItems()) {
            InventoryItemEntryData block = new InventoryItemEntryData();
            block.itemID = itm.getItemDefID();
            block.quantity = itm.getQuantity();
            block.uses = itm.getUses();
            block.uniqueItemID = itm.getUniqueID();
            ItemInfo def = ItemManager.getInstance().getItemDefinition(block.itemID);
            if (def != null) {
                block.data = def.getRawObject();
            }
            items.add(block);
        }
        resp.items = (InventoryItemEntryData[])items.toArray(InventoryItemEntryData[]::new);
        this.setResponseContent("text/xml", req.generateXmlValue("CI", (Object)resp));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getAllActivePetsByuserId(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        if (userID.equals(account.getAccountID()) || account.getSave(userID) != null) {
            AccountDataContainer data = account.getAccountData();
            if (!userID.equals(account.getAccountID())) {
                data = account.getSave(userID).getSaveData();
            }
            data = data.getChildContainer("dragons");
            JsonArray dragonIds = new JsonArray();
            if (data.entryExists("dragonlist")) {
                dragonIds = data.getEntry("dragonlist").getAsJsonArray();
            } else {
                data.setEntry("dragonlist", (JsonElement)dragonIds);
            }
            ArrayList<DragonData> dragons = new ArrayList<DragonData>();
            for (JsonElement ele : dragonIds) {
                String id = ele.getAsString();
                if (data.getEntry("dragon-" + id) == null) continue;
                DragonData dragon = (DragonData)req.parseXmlValue(data.getEntry("dragon-" + id).getAsString(), DragonData.class);
                if (TextFilterService.getInstance().isFiltered(dragon.name, true)) {
                    dragon.name = TextFilterService.getInstance().filterString(dragon.name, account.isStrictChatFilterEnabled());
                    ArrayList<ObjectNode> attrs = new ArrayList<ObjectNode>(List.of(dragon.attributes));
                    Optional<ObjectNode> att = attrs.stream().filter(t -> t.get("k").asText().equalsIgnoreCase("NameCustomized")).findFirst();
                    if (att.isPresent()) {
                        attrs.remove(att.get());
                    }
                    dragon.attributes = (ObjectNode[])attrs.toArray(ObjectNode[]::new);
                    data.setEntry("dragon-" + id, (JsonElement)new JsonPrimitive(req.generateXmlValue("RaisedPetData", (Object)dragon)));
                }
                dragons.add(dragon);
            }
            if (dragons.size() != 0) {
                DragonListData ls = new DragonListData();
                ls.dragons = (DragonData[])dragons.toArray(DragonData[]::new);
                this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfRaisedPetData", (Object)ls));
            } else {
                this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfRaisedPetData", null));
            }
        } else {
            this.setResponseStatus(403, "Forbidden");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void purchaseItems(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger());
        if (req == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        if (!tkn.hasCapability("gp")) {
            String[] saves = account.getSaveIDs();
            if (saves.length == 0) {
                this.setResponseStatus(404, "Not found");
                return;
            }
            tkn.saveID = account.getSaveIDs()[0];
        }
        AccountSaveContainer save = account.getSave(tkn.saveID);
        ItemPurchaseRequestData request = (ItemPurchaseRequestData)req.parseXmlValue((String)req.payload.get("purchaseItemRequest"), ItemPurchaseRequestData.class);
        HashMap<Integer, ItemRedemptionInfo> items = new HashMap<Integer, ItemRedemptionInfo>();
        for (int id : request.itemIDs) {
            if (!items.containsKey(id)) {
                ItemRedemptionInfo itm = new ItemRedemptionInfo();
                itm.containerID = request.containerID;
                itm.defID = id;
                items.put(id, itm);
            }
            ++((ItemRedemptionInfo)items.get((Object)Integer.valueOf((int)id))).quantity;
        }
        InventoryUpdateResponseData response = InventoryUtils.purchaseItems(request.storeID, (ItemRedemptionInfo[])items.values().toArray(ItemRedemptionInfo[]::new), account, save, !request.addBoxesAsItem);
        if (!tkn.hasCapability("gp") && response.currencyUpdate != null) {
            response.currencyUpdate.userID = account.getAccountID();
        }
        this.setResponseContent("text/xml", req.generateXmlValue("CIRS", (Object)response));
    }

    @SodRequest
    @SodTokenSecured
    public FunctionResult getGameDataByGameForDateRange(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, @SodRequestParam String userId) throws IOException, ParseException {
        AccountSaveContainer save;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((save = account.getSave(userId)) == null) {
            return this.response(404, "Not found");
        }
        SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy hh:mm:ss a", Locale.US);
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        String sD = (String)req.payload.get("startDate");
        String eD = (String)req.payload.get("endDate");
        MinigameDataRequest srq = new MinigameDataRequest();
        srq.gameLevel = Integer.parseInt((String)req.payload.get("gameLevel"));
        srq.difficulty = Integer.parseInt((String)req.payload.get("difficulty"));
        srq.friendsOnly = ((String)req.payload.get("buddyFilter")).equalsIgnoreCase("true");
        srq.maxEntries = Integer.parseInt((String)req.payload.get("count"));
        srq.key = (String)req.payload.get("key");
        srq.minimalPlayedAtTime = fmt.parse(sD).getTime();
        srq.maximumPlayedAtTime = fmt.parse(eD).getTime();
        MinigameData[] list = MinigameDataManager.getInstance().getAllGameData(userId, Integer.parseInt((String)req.payload.get("gameId")), srq);
        fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        GameDataSummaryData resp = new GameDataSummaryData();
        resp.gameID = Integer.parseInt((String)req.payload.get("gameId"));
        resp.difficulty = srq.difficulty;
        resp.isMultiplayer = ((String)req.payload.get("isMultiplayer")).equalsIgnoreCase("true");
        resp.key = srq.key;
        resp.userPosition = -1;
        resp.entries = new GameDataSummaryData.GameDataBlock[list.length];
        for (int i = 0; i < resp.entries.length; ++i) {
            MinigameData data = list[i];
            resp.entries[i] = new GameDataSummaryData.GameDataBlock();
            resp.entries[i].datePlayed = fmt.format(new Date(data.timePlayed));
            resp.entries[i].rankID = i + 1;
            resp.entries[i].timesLost = data.timesLost;
            resp.entries[i].timesWon = data.timesWon;
            resp.entries[i].userID = data.userID;
            resp.entries[i].userName = AccountManager.getInstance().getSaveByID(data.userID).getUsername();
            resp.entries[i].value = data.value;
            if (!resp.entries[i].userID.equals(userId)) continue;
            resp.userPosition = i;
        }
        return this.ok("text/xml", req.generateXmlValue("GameDataSummary", (Object)resp));
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    @Function(allowedMethods={"POST"})
    public FunctionResult setRaisedPet(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, AccountSaveContainer save, @SodRequestParam DragonData raisedPetData) throws IOException {
        String newName;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        AccountDataContainer data = save.getSaveData();
        PetUpdateResponseData resp = new PetUpdateResponseData();
        resp.raisedPetSetResult = 1;
        data = data.getChildContainer("dragons");
        JsonArray dragonIds = new JsonArray();
        if (data.entryExists("dragonlist")) {
            dragonIds = data.getEntry("dragonlist").getAsJsonArray();
        } else {
            data.setEntry("dragonlist", (JsonElement)dragonIds);
        }
        int id = raisedPetData.id;
        if (!data.entryExists("dragon-" + id)) {
            resp.raisedPetSetResult = 3;
            resp.errorMessage = "Dragon ID not found";
            return this.ok("text/xml", req.generateXmlValue("SetRaisedPetResponse", (Object)resp));
        }
        if (TextFilterService.getInstance().isFiltered(raisedPetData.name, true)) {
            resp.raisedPetSetResult = 4;
            resp.errorMessage = "Invalid name";
            return this.ok("text/xml", req.generateXmlValue("SetRaisedPetResponse", (Object)resp));
        }
        DragonData cdragon = (DragonData)req.parseXmlValue(data.getEntry("dragon-" + id).getAsString(), DragonData.class);
        if (!(cdragon.name.equals(raisedPetData.name) || (newName = raisedPetData.name).length() <= 100 && newName.replace(" ", "").length() >= 1)) {
            resp.raisedPetSetResult = 4;
            resp.errorMessage = "Invalid name";
            return this.ok("text/xml", req.generateXmlValue("SetRaisedPetResponse", (Object)resp));
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        DragonData dragonUpdate = raisedPetData;
        if (dragonUpdate.accessories != null) {
            cdragon.accessories = dragonUpdate.accessories;
        }
        if (dragonUpdate.attributes != null) {
            if (cdragon.attributes == null) {
                cdragon.attributes = new ObjectNode[0];
            }
            for (ObjectNode attr : dragonUpdate.attributes) {
                String key = attr.get("k").asText();
                Optional<ObjectNode> optA = Stream.of(cdragon.attributes).filter(t -> t.get("k").asText().equals(key)).findFirst();
                if (optA.isPresent()) {
                    optA.get().set("v", attr.get("v"));
                    optA.get().set("dt", attr.get("dt"));
                    continue;
                }
                int i = 0;
                ObjectNode[] newA = new ObjectNode[cdragon.attributes.length + 1];
                for (i = 0; i < cdragon.attributes.length; ++i) {
                    newA[i] = cdragon.attributes[i];
                }
                newA[i] = attr;
                cdragon.attributes = newA;
            }
        }
        if (dragonUpdate.colors != null) {
            cdragon.colors = dragonUpdate.colors;
        }
        if (dragonUpdate.gender != null) {
            cdragon.gender = dragonUpdate.gender;
        }
        if (dragonUpdate.geometry != null) {
            cdragon.geometry = dragonUpdate.geometry;
        }
        if (dragonUpdate.texture != null) {
            cdragon.texture = dragonUpdate.texture;
        }
        if (dragonUpdate.skills != null) {
            cdragon.skills = dragonUpdate.skills;
        }
        if (dragonUpdate.growthState != null) {
            cdragon.growthState = dragonUpdate.growthState;
        }
        if (dragonUpdate.imagePosition != null) {
            cdragon.imagePosition = dragonUpdate.imagePosition;
        }
        if (dragonUpdate.states != null) {
            cdragon.states = dragonUpdate.states;
        }
        if (dragonUpdate.typeID != null) {
            cdragon.typeID = dragonUpdate.typeID;
        }
        if (dragonUpdate.name != null) {
            cdragon.name = dragonUpdate.name;
        }
        cdragon.updateDate = fmt.format(new Date());
        data.setEntry("dragon-" + id, (JsonElement)new JsonPrimitive(req.generateXmlValue("RaisedPetData", (Object)cdragon)));
        return this.ok("text/xml", req.generateXmlValue("SetRaisedPetResponse", (Object)resp));
    }

    static {
        rnd = new Random();
    }
}

