/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.http.handlers.gameplayapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.asf.connective.RemoteClient;
import org.asf.connective.TlsSecuredHttpServer;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.entities.coordinates.Vector3D;
import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.entities.items.PlayerInventory;
import org.asf.edge.common.entities.items.PlayerInventoryContainer;
import org.asf.edge.common.entities.items.PlayerInventoryItem;
import org.asf.edge.common.entities.minigamedata.MinigameData;
import org.asf.edge.common.entities.minigamedata.MinigameDataRequest;
import org.asf.edge.common.entities.minigamedata.MinigameSaveRequest;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.Function;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionResult;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequest;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequestParam;
import org.asf.edge.common.http.apihandlerutils.functions.SodTokenSecured;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireCapability;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireSave;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.services.minigamedata.MinigameDataManager;
import org.asf.edge.common.services.textfilter.TextFilterService;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.common.tokens.TokenParseResult;
import org.asf.edge.common.xmls.data.EmptyKeyValuePairSetData;
import org.asf.edge.common.xmls.data.KeyValuePairData;
import org.asf.edge.common.xmls.data.KeyValuePairSetData;
import org.asf.edge.common.xmls.items.ItemDefData;
import org.asf.edge.common.xmls.items.inventory.InventoryItemEntryData;
import org.asf.edge.common.xmls.items.state.ItemStateCriteriaWrapperData;
import org.asf.edge.common.xmls.items.state.ItemStateData;
import org.asf.edge.common.xmls.items.state.criteria.ItemStateConsumableCriteriaData;
import org.asf.edge.common.xmls.items.state.criteria.ItemStateExpiryCriteriaData;
import org.asf.edge.common.xmls.items.state.criteria.ItemStateLengthCriteriaData;
import org.asf.edge.common.xmls.items.state.criteria.ItemStateSpeedUpCriteriaData;
import org.asf.edge.gameplayapi.EdgeGameplayApiServer;
import org.asf.edge.gameplayapi.entities.quests.UserQuestInfo;
import org.asf.edge.gameplayapi.entities.rooms.PlayerRoomInfo;
import org.asf.edge.gameplayapi.entities.rooms.RoomItemInfo;
import org.asf.edge.gameplayapi.services.quests.QuestManager;
import org.asf.edge.gameplayapi.services.rooms.PlayerRoomManager;
import org.asf.edge.gameplayapi.util.InventoryUtils;
import org.asf.edge.gameplayapi.util.RewardsUtil;
import org.asf.edge.gameplayapi.util.inventory.ItemRedemptionInfo;
import org.asf.edge.gameplayapi.xmls.dragons.DragonData;
import org.asf.edge.gameplayapi.xmls.dragons.DragonListData;
import org.asf.edge.gameplayapi.xmls.inventories.CommonInventoryData;
import org.asf.edge.gameplayapi.xmls.inventories.InventoryUpdateResponseData;
import org.asf.edge.gameplayapi.xmls.inventories.SetCommonInventoryRequestData;
import org.asf.edge.gameplayapi.xmls.items.ItemRedeemRequestData;
import org.asf.edge.gameplayapi.xmls.minigamedata.GameDataSummaryData;
import org.asf.edge.gameplayapi.xmls.names.DisplayNameUniqueResponseData;
import org.asf.edge.gameplayapi.xmls.quests.MissionData;
import org.asf.edge.gameplayapi.xmls.quests.QuestListResponseData;
import org.asf.edge.gameplayapi.xmls.quests.RequestFilterDataLegacy;
import org.asf.edge.gameplayapi.xmls.quests.SetTaskStateResultData;
import org.asf.edge.gameplayapi.xmls.rooms.RoomItemData;
import org.asf.edge.gameplayapi.xmls.rooms.RoomItemList;
import org.asf.edge.gameplayapi.xmls.rooms.RoomItemUpdateRequestData;
import org.asf.edge.gameplayapi.xmls.rooms.RoomItemUpdateResponseData;
import org.asf.edge.gameplayapi.xmls.rooms.RoomList;
import org.asf.edge.gameplayapi.xmls.rooms.RoomListEntryData;
import org.asf.edge.gameplayapi.xmls.rooms.RoomListRequestData;
import org.asf.edge.gameplayapi.xmls.rooms.RoomUpdateResponseData;
import org.asf.edge.gameplayapi.xmls.rooms.SetItemStateRequestData;
import org.asf.edge.gameplayapi.xmls.rooms.SetItemStateResponseData;

public class ContentWebServiceV1Processor
extends EdgeWebService<EdgeGameplayApiServer> {
    private static AccountManager manager;
    private static PlayerRoomManager roomManager;
    private static ItemManager itemManager;
    private static QuestManager questManager;

    public ContentWebServiceV1Processor(EdgeGameplayApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new ContentWebServiceV1Processor((EdgeGameplayApiServer)this.getServerInstance());
    }

    public String path() {
        return "/ContentWebService.asmx";
    }

    public void fallbackRequestProcessor(String path, String method, RemoteClient client, String contentType) throws IOException {
        if (path.equals("")) {
            this.setResponseStatus(200, "OK");
        } else {
            this.setResponseStatus(404, "Not found");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getDefaultNameSuggestion(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger());
        if (req == null) {
            return;
        }
        DisplayNameUniqueResponseData resp = new DisplayNameUniqueResponseData();
        resp.suggestions = new DisplayNameUniqueResponseData.SuggestionResultBlock();
        resp.suggestions.suggestions = new String[0];
        this.setResponseContent("text/xml", req.generateXmlValue("DisplayNameUniqueResponse", (Object)resp));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getAuthoritativeTime(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger());
        if (req == null) {
            return;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.setResponseContent("text/xml", req.generateXmlValue("dateTime", (Object)fmt.format(new Date(System.currentTimeMillis()))));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void purchaseItems(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger());
        if (req == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        if (!tkn.hasCapability("gp")) {
            String[] saves = account.getSaveIDs();
            if (saves.length == 0) {
                this.setResponseStatus(404, "Not found");
                return;
            }
            tkn.saveID = account.getSaveIDs()[0];
        }
        AccountSaveContainer save = account.getSave(tkn.saveID);
        int storeID = Integer.parseInt((String)req.payload.get("storeId"));
        int containerID = Integer.parseInt(req.payload.getOrDefault("ContainerID", "1"));
        int[] itemIds = (int[])req.parseXmlValue((String)req.payload.get("itemIDArrayXml"), int[].class);
        HashMap<Integer, ItemRedemptionInfo> items = new HashMap<Integer, ItemRedemptionInfo>();
        for (int id : itemIds) {
            if (!items.containsKey(id)) {
                ItemRedemptionInfo itm = new ItemRedemptionInfo();
                itm.containerID = containerID;
                itm.defID = id;
                items.put(id, itm);
            }
            ++((ItemRedemptionInfo)items.get((Object)Integer.valueOf((int)id))).quantity;
        }
        InventoryUpdateResponseData response = InventoryUtils.purchaseItems(storeID, (ItemRedemptionInfo[])items.values().toArray(ItemRedemptionInfo[]::new), account, save, true);
        if (!tkn.hasCapability("gp") && response.currencyUpdate != null) {
            response.currencyUpdate.userID = account.getAccountID();
        }
        this.setResponseContent("text/xml", req.generateXmlValue("CIRS", (Object)response));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getUserGameCurrency(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (questManager == null) {
            questManager = QuestManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        AccountSaveContainer save = account.getSave(userID);
        if (save == null) {
            this.setResponseStatus(403, "Forbidden");
            return;
        }
        InventoryUpdateResponseData.CurrencyUpdateBlock c = new InventoryUpdateResponseData.CurrencyUpdateBlock();
        AccountDataContainer currency = save.getSaveData().getChildContainer("currency");
        int currentC = 300;
        if (currency.entryExists("coins")) {
            currentC = currency.getEntry("coins").getAsInt();
        }
        AccountDataContainer currencyAccWide = save.getAccount().getAccountData().getChildContainer("currency");
        int currentG = 0;
        if (currencyAccWide.entryExists("gems")) {
            currentG = currencyAccWide.getEntry("gems").getAsInt();
        }
        c.coinCount = currentC;
        c.gemCount = currentG;
        c.userID = save.getSaveID();
        this.setResponseContent("text/xml", req.generateXmlValue("UserGameCurrency", (Object)c));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void acceptMission(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (questManager == null) {
            questManager = QuestManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        AccountSaveContainer save = account.getSave(userID);
        if (save != null) {
            int missionId = Integer.parseInt((String)req.payload.get("missionId"));
            UserQuestInfo quest = questManager.getUserQuest(save, missionId);
            if (quest == null) {
                this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)false));
                return;
            }
            quest.acceptQuest();
            this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
        } else {
            this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)false));
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getCommonInventory(LegacyFunctionInfo func) throws IOException {
        ItemInfo def;
        InventoryItemEntryData block;
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        AccountDataContainer data = account.getAccountData();
        int containerID = Integer.parseInt((String)req.payload.get("ContainerId"));
        CommonInventoryData resp = new CommonInventoryData();
        resp.userID = account.getAccountID();
        ArrayList<InventoryItemEntryData> items = new ArrayList<InventoryItemEntryData>();
        for (PlayerInventoryItem itm : itemManager.getCommonInventory(data).getContainer(containerID).getItems()) {
            block = new InventoryItemEntryData();
            block.itemID = itm.getItemDefID();
            block.quantity = itm.getQuantity();
            block.uses = itm.getUses();
            block.uniqueItemID = itm.getUniqueID();
            def = ItemManager.getInstance().getItemDefinition(block.itemID);
            if (def != null) {
                block.data = def.getRawObject();
            }
            items.add(block);
        }
        if (tkn.saveID != null) {
            data = account.getSave(tkn.saveID).getSaveData();
            resp = new CommonInventoryData();
            resp.userID = account.getAccountID();
            for (PlayerInventoryItem itm : itemManager.getCommonInventory(data).getContainer(containerID).getItems()) {
                block = new InventoryItemEntryData();
                block.itemID = itm.getItemDefID();
                block.quantity = itm.getQuantity();
                block.uses = itm.getUses();
                block.uniqueItemID = itm.getUniqueID();
                def = ItemManager.getInstance().getItemDefinition(block.itemID);
                if (def != null) {
                    block.data = def.getRawObject();
                }
                items.add(block);
            }
        }
        resp.items = (InventoryItemEntryData[])items.toArray(InventoryItemEntryData[]::new);
        this.setResponseContent("text/xml", req.generateXmlValue("CI", (Object)resp));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setCommonInventory(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        SetCommonInventoryRequestData[] requests = (SetCommonInventoryRequestData[])req.parseXmlValue((String)req.payload.get("commonInventoryRequestXml"), SetCommonInventoryRequestData[].class);
        AccountDataContainer data = account.getAccountData();
        if (tkn.saveID != null) {
            data = account.getSave(tkn.saveID).getSaveData();
        }
        this.setResponseContent("text/xml", req.generateXmlValue("CIRS", (Object)InventoryUtils.processCommonInventorySet(requests, data, Integer.parseInt((String)req.payload.get("ContainerId")))));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getKeyValuePair(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        AccountDataContainer data = account.getAccountData();
        if (tkn.saveID != null) {
            data = account.getSave(tkn.saveID).getSaveData();
        }
        data = data.getChildContainer("keyvaluedata");
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (data.entryExists("pairs-" + pair)) {
            int i = 0;
            JsonObject pairs = data.getEntry("pairs-" + pair).getAsJsonObject();
            KeyValuePairSetData setData = new KeyValuePairSetData();
            setData.items = new KeyValuePairData[pairs.size()];
            for (String key : pairs.keySet()) {
                JsonObject obj = pairs.get(key).getAsJsonObject();
                KeyValuePairData p = new KeyValuePairData();
                p.key = key;
                p.value = obj.get("value").getAsString();
                p.updateDate = fmt.format(new Date(obj.get("time").getAsLong()));
                setData.items[i++] = p;
            }
            if (pair == 2017 && !Stream.of(setData.items).anyMatch(t -> t.key.equals("HubBerkDOFirstCommon"))) {
                JsonObject o = new JsonObject();
                o.addProperty("value", "1");
                o.addProperty("time", (Number)System.currentTimeMillis());
                pairs.add("HubBerkDOFirstCommon", (JsonElement)o);
                data.setEntry("pairs-" + pair, (JsonElement)pairs);
                KeyValuePairData d = new KeyValuePairData();
                d.key = "HubBerkDOFirstCommon";
                d.value = "1";
                d.updateDate = fmt.format(new Date(o.get("time").getAsLong()));
                data.setEntry("pairs-" + pair, (JsonElement)pairs);
                setData.items = ContentWebServiceV1Processor.appendTo(setData.items, d);
            }
            if (setData.items.length != 0) {
                this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)setData));
            } else {
                this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)new EmptyKeyValuePairSetData()));
            }
        } else {
            if (pair == 2017) {
                KeyValuePairSetData setData = new KeyValuePairSetData();
                setData.items = new KeyValuePairData[1];
                JsonObject pairs = new JsonObject();
                JsonObject o = new JsonObject();
                o.addProperty("value", "1");
                o.addProperty("time", (Number)System.currentTimeMillis());
                pairs.add("HubBerkDOFirstCommon", (JsonElement)o);
                data.setEntry("pairs-" + pair, (JsonElement)pairs);
                KeyValuePairData d = new KeyValuePairData();
                d.key = "HubBerkDOFirstCommon";
                d.value = "1";
                d.updateDate = fmt.format(new Date(o.get("time").getAsLong()));
                this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)setData));
            }
            this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)new EmptyKeyValuePairSetData()));
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getKeyValuePairByUserID(LegacyFunctionInfo func) throws IOException {
        AccountDataContainer data;
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        String userID = (String)req.payload.get("userId");
        boolean isDragon = false;
        AccountDataContainer dragonData = null;
        if (!userID.equals(account.getAccountID()) && account.getSave(userID) == null && tkn.hasCapability("gp")) {
            data = account.getSave(tkn.saveID).getSaveData().getChildContainer("dragons");
            JsonArray dragonIds = new JsonArray();
            if (data.entryExists("dragonlist")) {
                dragonIds = data.getEntry("dragonlist").getAsJsonArray();
            } else {
                data.setEntry("dragonlist", (JsonElement)dragonIds);
            }
            for (JsonElement ele : dragonIds) {
                String id = ele.getAsString();
                ObjectNode dragon = (ObjectNode)req.parseXmlValue(data.getEntry("dragon-" + id).getAsString(), ObjectNode.class);
                if (!dragon.get("eid").asText().equals(userID)) continue;
                isDragon = true;
                dragonData = data.getChildContainer("dragondata-" + userID);
                break;
            }
        }
        if (isDragon || userID.equals(account.getAccountID()) || account.getSave(userID) != null) {
            data = dragonData;
            if (data == null) {
                data = account.getAccountData();
                if (!userID.equals(account.getAccountID())) {
                    data = account.getSave(userID).getSaveData();
                }
            }
            data = data.getChildContainer("keyvaluedata");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
            fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            if (data.entryExists("pairs-" + pair)) {
                int i = 0;
                pairs = data.getEntry("pairs-" + pair).getAsJsonObject();
                KeyValuePairSetData setData = new KeyValuePairSetData();
                setData.items = new KeyValuePairData[pairs.size()];
                for (String key : pairs.keySet()) {
                    JsonObject obj = pairs.get(key).getAsJsonObject();
                    KeyValuePairData p = new KeyValuePairData();
                    p.key = key;
                    p.value = obj.get("value").getAsString();
                    p.updateDate = fmt.format(new Date(obj.get("time").getAsLong()));
                    setData.items[i++] = p;
                }
                if (pair == 2017 && !Stream.of(setData.items).anyMatch(t -> t.key.equals("HubBerkDOFirstCommon"))) {
                    JsonObject o = new JsonObject();
                    o.addProperty("value", "1");
                    o.addProperty("time", (Number)System.currentTimeMillis());
                    pairs.add("HubBerkDOFirstCommon", (JsonElement)o);
                    KeyValuePairData d = new KeyValuePairData();
                    d.key = "HubBerkDOFirstCommon";
                    d.value = "1";
                    d.updateDate = fmt.format(new Date(o.get("time").getAsLong()));
                    data.setEntry("pairs-" + pair, (JsonElement)pairs);
                    setData.items = ContentWebServiceV1Processor.appendTo(setData.items, d);
                }
                if (setData.items.length != 0) {
                    this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)setData));
                } else {
                    this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)new EmptyKeyValuePairSetData()));
                }
            } else {
                if (pair == 2017) {
                    KeyValuePairSetData setData = new KeyValuePairSetData();
                    setData.items = new KeyValuePairData[1];
                    pairs = new JsonObject();
                    JsonObject o = new JsonObject();
                    o.addProperty("value", "1");
                    o.addProperty("time", (Number)System.currentTimeMillis());
                    pairs.add("HubBerkDOFirstCommon", (JsonElement)o);
                    data.setEntry("pairs-" + pair, (JsonElement)pairs);
                    KeyValuePairData d = new KeyValuePairData();
                    d.key = "HubBerkDOFirstCommon";
                    d.value = "1";
                    d.updateDate = fmt.format(new Date(o.get("time").getAsLong()));
                    this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)setData));
                }
                this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)new EmptyKeyValuePairSetData()));
            }
        } else {
            this.setResponseStatus(403, "Forbidden");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setKeyValuePair(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        KeyValuePairSetData updateData = (KeyValuePairSetData)req.parseXmlValue((String)req.payload.get("contentXML"), KeyValuePairSetData.class);
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        AccountDataContainer data = account.getAccountData();
        if (tkn.saveID != null) {
            data = account.getSave(tkn.saveID).getSaveData();
        }
        data = data.getChildContainer("keyvaluedata");
        JsonObject pairData = new JsonObject();
        if (data.entryExists("pairs-" + pair)) {
            pairData = data.getEntry("pairs-" + pair).getAsJsonObject();
        }
        if (updateData != null && updateData.items != null) {
            for (KeyValuePairData pairI : updateData.items) {
                JsonObject p = new JsonObject();
                p.addProperty("value", pairI.value);
                p.addProperty("time", (Number)System.currentTimeMillis());
                pairData.add(pairI.key, (JsonElement)p);
            }
            data.setEntry("pairs-" + pair, (JsonElement)pairData);
        }
        this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setKeyValuePairByUserID(LegacyFunctionInfo func) throws IOException {
        AccountDataContainer data;
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        KeyValuePairSetData updateData = (KeyValuePairSetData)req.parseXmlValue((String)req.payload.get("contentXML"), KeyValuePairSetData.class);
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        String userID = (String)req.payload.get("userId");
        boolean isDragon = false;
        AccountDataContainer dragonData = null;
        if (!userID.equals(account.getAccountID()) && account.getSave(userID) == null && tkn.hasCapability("gp")) {
            data = account.getSave(tkn.saveID).getSaveData().getChildContainer("dragons");
            JsonArray dragonIds = new JsonArray();
            if (data.entryExists("dragonlist")) {
                dragonIds = data.getEntry("dragonlist").getAsJsonArray();
            } else {
                data.setEntry("dragonlist", (JsonElement)dragonIds);
            }
            for (JsonElement ele : dragonIds) {
                String id = ele.getAsString();
                ObjectNode dragon = (ObjectNode)req.parseXmlValue(data.getEntry("dragon-" + id).getAsString(), ObjectNode.class);
                if (!dragon.get("eid").asText().equals(userID)) continue;
                isDragon = true;
                dragonData = data.getChildContainer("dragondata-" + userID);
                break;
            }
        }
        if (isDragon || userID.equals(account.getAccountID()) || account.getSave(userID) != null) {
            data = dragonData;
            if (data == null) {
                data = account.getAccountData();
                if (!userID.equals(account.getAccountID())) {
                    data = account.getSave(userID).getSaveData();
                }
            }
            data = data.getChildContainer("keyvaluedata");
            JsonObject pairData = new JsonObject();
            if (data.entryExists("pairs-" + pair)) {
                pairData = data.getEntry("pairs-" + pair).getAsJsonObject();
            }
            for (KeyValuePairData pairI : updateData.items) {
                JsonObject p = new JsonObject();
                p.addProperty("value", pairI.value);
                p.addProperty("time", (Number)System.currentTimeMillis());
                pairData.add(pairI.key, (JsonElement)p);
            }
            data.setEntry("pairs-" + pair, (JsonElement)pairData);
            this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
        } else {
            this.setResponseStatus(403, "Forbidden");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void delKeyValuePair(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        AccountDataContainer data = account.getAccountData();
        if (tkn.saveID != null) {
            data = account.getSave(tkn.saveID).getSaveData();
        }
        if ((data = data.getChildContainer("keyvaluedata")).entryExists("pairs-" + pair)) {
            data.deleteEntry("pairs-" + pair);
        }
        this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void delKeyValuePairByUserID(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        String userID = (String)req.payload.get("userId");
        if (userID.equals(account.getAccountID()) || account.getSave(userID) != null) {
            AccountDataContainer data = account.getAccountData();
            if (!userID.equals(account.getAccountID())) {
                data = account.getSave(userID).getSaveData();
            }
            if ((data = data.getChildContainer("keyvaluedata")).entryExists("pairs-" + pair)) {
                data.deleteEntry("pairs-" + pair);
            }
            this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
        } else {
            this.setResponseStatus(403, "Forbidden");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void delKeyValuePairByKey(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        String userID = (String)req.payload.get("userId");
        if (userID.equals(account.getAccountID()) || account.getSave(userID) != null) {
            JsonObject pairData;
            AccountDataContainer data = account.getAccountData();
            if (!userID.equals(account.getAccountID())) {
                data = account.getSave(userID).getSaveData();
            }
            if ((data = data.getChildContainer("keyvaluedata")).entryExists("pairs-" + pair) && (pairData = data.getEntry("pairs-" + pair).getAsJsonObject()).has((String)req.payload.get("pairKey"))) {
                pairData.remove((String)req.payload.get("pairKey"));
                data.setEntry("pairs-" + pair, (JsonElement)pairData);
            }
            this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
        } else {
            this.setResponseStatus(403, "Forbidden");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getSelectedRaisedPet(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        if (userID.equals(account.getAccountID()) || account.getSave(userID) != null) {
            AccountDataContainer data = account.getAccountData();
            if (!userID.equals(account.getAccountID())) {
                data = account.getSave(userID).getSaveData();
            }
            data = data.getChildContainer("dragons");
            JsonArray dragonIds = new JsonArray();
            if (data.entryExists("dragonlist")) {
                dragonIds = data.getEntry("dragonlist").getAsJsonArray();
            } else {
                data.setEntry("dragonlist", (JsonElement)dragonIds);
            }
            ArrayList<DragonData> dragons = new ArrayList<DragonData>();
            for (JsonElement ele : dragonIds) {
                String id = ele.getAsString();
                DragonData dragon = (DragonData)req.parseXmlValue(data.getEntry("dragon-" + id).getAsString(), DragonData.class);
                if (TextFilterService.getInstance().isFiltered(dragon.name, true)) {
                    dragon.name = TextFilterService.getInstance().filterString(dragon.name, account.isStrictChatFilterEnabled());
                    ArrayList<ObjectNode> attrs = new ArrayList<ObjectNode>(List.of(dragon.attributes));
                    Optional<ObjectNode> att = attrs.stream().filter(t -> t.get("k").asText().equalsIgnoreCase("NameCustomized")).findFirst();
                    if (att.isPresent()) {
                        attrs.remove(att.get());
                    }
                    dragon.attributes = (ObjectNode[])attrs.toArray(ObjectNode[]::new);
                    data.setEntry("dragon-" + id, (JsonElement)new JsonPrimitive(req.generateXmlValue("RaisedPetData", (Object)dragon)));
                }
                if (!dragon.isSelected) continue;
                dragons.add(dragon);
            }
            if (dragons.size() != 0) {
                DragonListData ls = new DragonListData();
                ls.dragons = (DragonData[])dragons.toArray(DragonData[]::new);
                this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfRaisedPetData", (Object)ls));
            } else {
                this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfRaisedPetData", null));
            }
        } else {
            this.setResponseStatus(403, "Forbidden, attempted to interact with other user's data (devs please inspect)");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setSelectedPet(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String dragonID = (String)req.payload.get("raisedPetID");
        AccountDataContainer data = account.getSave(tkn.saveID).getSaveData();
        data = data.getChildContainer("dragons");
        JsonArray dragonIds = new JsonArray();
        if (data.entryExists("dragonlist")) {
            dragonIds = data.getEntry("dragonlist").getAsJsonArray();
        } else {
            data.setEntry("dragonlist", (JsonElement)dragonIds);
        }
        boolean found = false;
        for (JsonElement ele : dragonIds) {
            String id = ele.getAsString();
            ObjectNode dragon = (ObjectNode)req.parseXmlValue(data.getEntry("dragon-" + id).getAsString(), ObjectNode.class);
            if (!id.equals(dragonID) && !dragon.get("is").asBoolean()) continue;
            if (id.equals(dragonID)) {
                dragon.set("is", (JsonNode)BooleanNode.TRUE);
                found = true;
            } else {
                dragon.set("is", (JsonNode)BooleanNode.FALSE);
            }
            data.setEntry("dragon-" + id, (JsonElement)new JsonPrimitive(req.generateXmlValue("RaisedPetData", (Object)dragon)));
        }
        this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)found));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getUnselectedPetByTypes(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        String[] types = ((String)req.payload.get("petTypeIDs")).split(",");
        if (userID.equals(account.getAccountID()) || account.getSave(userID) != null) {
            AccountDataContainer data = account.getAccountData();
            if (!userID.equals(account.getAccountID())) {
                data = account.getSave(userID).getSaveData();
            }
            data = data.getChildContainer("dragons");
            JsonArray dragonIds = new JsonArray();
            if (data.entryExists("dragonlist")) {
                dragonIds = data.getEntry("dragonlist").getAsJsonArray();
            } else {
                data.setEntry("dragonlist", (JsonElement)dragonIds);
            }
            ArrayList<DragonData> dragons = new ArrayList<DragonData>();
            for (JsonElement ele : dragonIds) {
                String id = ele.getAsString();
                DragonData dragon = (DragonData)req.parseXmlValue(data.getEntry("dragon-" + id).getAsString(), DragonData.class);
                if (TextFilterService.getInstance().isFiltered(dragon.name, true)) {
                    dragon.name = TextFilterService.getInstance().filterString(dragon.name, account.isStrictChatFilterEnabled());
                    ArrayList<ObjectNode> attrs = new ArrayList<ObjectNode>(List.of(dragon.attributes));
                    Optional<ObjectNode> att = attrs.stream().filter(t -> t.get("k").asText().equalsIgnoreCase("NameCustomized")).findFirst();
                    if (att.isPresent()) {
                        attrs.remove(att.get());
                    }
                    dragon.attributes = (ObjectNode[])attrs.toArray(ObjectNode[]::new);
                    data.setEntry("dragon-" + id, (JsonElement)new JsonPrimitive(req.generateXmlValue("RaisedPetData", (Object)dragon)));
                }
                if (types.length != 0 && !Stream.of(types).anyMatch(t -> t.equals(dragon.typeID))) continue;
                dragons.add(dragon);
            }
            if (dragons.size() != 0) {
                DragonListData ls = new DragonListData();
                ls.dragons = (DragonData[])dragons.toArray(DragonData[]::new);
                this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfRaisedPetData", (Object)ls));
            } else {
                this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfRaisedPetData", null));
            }
        } else {
            this.setResponseStatus(403, "Forbidden");
        }
    }

    @LegacyFunction(allowedMethods={"POST", "GET"})
    public void getImage(LegacyFunctionInfo func) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (func.getQuery().containsKey("edgereq") && ((String)func.getQuery().get("edgereq")).equals("true")) {
            String slot = (String)func.getQuery().get("slot");
            String type = (String)func.getQuery().get("type");
            String account = (String)func.getQuery().get("account");
            String save = (String)func.getQuery().get("save");
            AccountObject acc = manager.getAccount(account);
            if (acc == null || acc.getSave(save) == null) {
                this.setResponseStatus(404, "Not found");
                return;
            }
            AccountDataContainer data = acc.getSave(save).getSaveData().getChildContainer("images");
            if (!data.entryExists("imagefile-" + slot + "-" + type)) {
                this.setResponseStatus(404, "Not found");
                return;
            }
            this.getResponse().setContent("image/jpeg", Base64.getDecoder().decode(data.getEntry("imagefile-" + slot + "-" + type).getAsString()));
            return;
        }
        EdgeWebService.ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger());
        if (req == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String slot = (String)req.payload.get("ImageSlot");
        String type = (String)req.payload.get("ImageType");
        AccountDataContainer data = account.getSave(tkn.saveID).getSaveData().getChildContainer("images");
        if (!data.entryExists("imageslotinfo-" + slot + "-" + type)) {
            this.setResponseContent("text/xml", req.generateXmlValue("ImageData", null));
            return;
        }
        ObjectNode imgD = (ObjectNode)req.parseXmlValue(data.getEntry("imageslotinfo-" + slot + "-" + type).getAsString(), ObjectNode.class);
        if (imgD.has("ImageURL")) {
            URL u = new URL(imgD.get("ImageURL").asText());
            String prot = "http://";
            if (((EdgeGameplayApiServer)this.getServerInstance()).getServer() instanceof TlsSecuredHttpServer) {
                prot = "https://";
            }
            imgD.put("ImageURL", prot + this.getHeader("Host") + "/" + u.getFile());
        }
        this.setResponseContent("text/xml", req.generateXmlValue("ImageData", (Object)imgD));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setImage(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String xml = (String)req.payload.get("contentXML");
        String slot = (String)req.payload.get("ImageSlot");
        String type = (String)req.payload.get("ImageType");
        AccountDataContainer data = account.getSave(tkn.saveID).getSaveData().getChildContainer("images");
        ObjectNode imgD = (ObjectNode)req.parseXmlValue(xml, ObjectNode.class);
        String prot = "http://";
        if (((EdgeGameplayApiServer)this.getServerInstance()).getServer() instanceof TlsSecuredHttpServer) {
            prot = "https://";
        }
        imgD.set("ImageURL", (JsonNode)new TextNode(prot + this.getHeader("Host") + "/" + this.getRequest().getRequestPath().substring(0, this.getRequest().getRequestPath().toLowerCase().lastIndexOf("setimage")) + "GetImage?edgereq=true&slot=" + URLEncoder.encode(slot, "UTF-8") + "&account=" + URLEncoder.encode(account.getAccountID(), "UTF-8") + "&save=" + URLEncoder.encode(tkn.saveID, "UTF-8") + "&type=" + URLEncoder.encode(type, "UTF-8") + "&file=image.jpg"));
        data.setEntry("imageslotinfo-" + slot + "-" + type, (JsonElement)new JsonPrimitive(req.generateXmlValue("ImageData", (Object)imgD)));
        data.setEntry("imagefile-" + slot + "-" + type, (JsonElement)new JsonPrimitive((String)req.payload.get("imageFile")));
        this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getUserMissionState(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (questManager == null) {
            questManager = QuestManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        AccountSaveContainer save = account.getSave(userID);
        if (save != null) {
            MissionData[] quests = questManager.getAllQuestDefs();
            RequestFilterDataLegacy filter = (RequestFilterDataLegacy)req.parseXmlValue((String)req.payload.get("filter"), RequestFilterDataLegacy.class);
            ArrayList<Integer> addedQuests = new ArrayList<Integer>();
            ArrayList<MissionData> questLst = new ArrayList<MissionData>();
            QuestListResponseData resp = new QuestListResponseData();
            resp.userID = userID;
            boolean hasExplicitRequests = false;
            if (filter.missionID != -1) {
                hasExplicitRequests = true;
                UserQuestInfo userQuestInfo = questManager.getUserQuest(save, filter.missionID);
                if (userQuestInfo != null && (filter.getCompletedMissions || !userQuestInfo.isCompleted())) {
                    questLst.add(userQuestInfo.getData());
                    addedQuests.add(userQuestInfo.getQuestID());
                }
            }
            if (filter.groupID != -1) {
                hasExplicitRequests = true;
                for (MissionData missionData : quests) {
                    UserQuestInfo quest;
                    if (addedQuests.contains(missionData.id) || missionData.groupID != filter.groupID || (quest = questManager.getUserQuest(save, missionData.id)) == null || !filter.getCompletedMissions && quest.isCompleted()) continue;
                    questLst.add(quest.getData());
                    addedQuests.add(quest.getQuestID());
                }
            }
            if (!hasExplicitRequests) {
                if (filter.getCompletedMissions) {
                    for (UserQuestInfo userQuestInfo : questManager.getCompletedQuests(save)) {
                        if (addedQuests.contains(userQuestInfo.getQuestID())) continue;
                        questDef = userQuestInfo.getDef();
                        if (questDef.missionRules != null && questDef.missionRules.prerequisites != null && Stream.of(questDef.missionRules.prerequisites).anyMatch(new Predicate<MissionData.MissionRulesBlock.PrerequisiteInfoBlock>(){

                            @Override
                            public boolean test(MissionData.MissionRulesBlock.PrerequisiteInfoBlock t) {
                                MissionData def;
                                if (t.type >= 7) {
                                    return true;
                                }
                                return t.type == 3 && ((def = questManager.getQuestDef(Integer.parseInt(t.value))) == null || Stream.of(def.missionRules.prerequisites).anyMatch(this));
                            }
                        })) continue;
                        MissionData d = userQuestInfo.getData();
                        d.accepted = true;
                        questLst.add(d);
                        addedQuests.add(userQuestInfo.getQuestID());
                    }
                    if (!addedQuests.contains(1000)) {
                        MissionData missionData = questManager.getQuestDef(999).copy();
                        missionData.id = 1000;
                        missionData.completed = 1;
                        missionData.version = 1;
                        missionData.acceptanceAchievementID = -1;
                        missionData.achievementID = -1;
                        missionData.accepted = true;
                        questLst.add(missionData);
                    }
                } else {
                    MissionData d;
                    for (UserQuestInfo userQuestInfo : questManager.getActiveQuests(save)) {
                        if (addedQuests.contains(userQuestInfo.getQuestID())) continue;
                        questDef = userQuestInfo.getDef();
                        if (questDef.missionRules != null && questDef.missionRules.prerequisites != null && Stream.of(questDef.missionRules.prerequisites).anyMatch(new Predicate<MissionData.MissionRulesBlock.PrerequisiteInfoBlock>(){

                            @Override
                            public boolean test(MissionData.MissionRulesBlock.PrerequisiteInfoBlock t) {
                                MissionData def;
                                if (t.type >= 7) {
                                    return true;
                                }
                                return t.type == 3 && ((def = questManager.getQuestDef(Integer.parseInt(t.value))) == null || Stream.of(def.missionRules.prerequisites).anyMatch(this));
                            }
                        })) continue;
                        d = userQuestInfo.getData();
                        d.accepted = userQuestInfo.isStarted();
                        questLst.add(d);
                        addedQuests.add(userQuestInfo.getQuestID());
                    }
                    for (UserQuestInfo userQuestInfo : questManager.getUpcomingQuests(save)) {
                        if (addedQuests.contains(userQuestInfo.getQuestID())) continue;
                        questDef = userQuestInfo.getDef();
                        if (questDef.missionRules != null && questDef.missionRules.prerequisites != null && Stream.of(questDef.missionRules.prerequisites).anyMatch(new Predicate<MissionData.MissionRulesBlock.PrerequisiteInfoBlock>(){

                            @Override
                            public boolean test(MissionData.MissionRulesBlock.PrerequisiteInfoBlock t) {
                                MissionData def;
                                if (t.type >= 7) {
                                    return true;
                                }
                                return t.type == 3 && ((def = questManager.getQuestDef(Integer.parseInt(t.value))) == null || Stream.of(def.missionRules.prerequisites).anyMatch(this));
                            }
                        })) continue;
                        d = userQuestInfo.getData();
                        d.accepted = false;
                        questLst.add(d);
                        addedQuests.add(userQuestInfo.getQuestID());
                    }
                    if (!addedQuests.contains(1000)) {
                        MissionData missionData = questManager.getQuestDef(999).copy();
                        missionData.id = 1000;
                        missionData.completed = 1;
                        missionData.version = 1;
                        missionData.acceptanceAchievementID = -1;
                        missionData.achievementID = -1;
                        missionData.accepted = true;
                        questLst.add(missionData);
                    }
                    if (!addedQuests.contains(999)) {
                        questLst.add(questManager.getUserQuest(save, 999).getData());
                    }
                }
            }
            resp.quests = (MissionData[])questLst.toArray(MissionData[]::new);
            this.setResponseContent("text/xml", req.generateXmlValue("UserMissionStateResult", (Object)resp));
        } else {
            this.setResponseStatus(404, "Not found");
        }
    }

    @SodRequest
    @SodTokenSecured
    @Function(allowedMethods={"POST"})
    public FunctionResult setTaskState(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, @SodRequestParam String userId, @SodRequestParam int missionId, @SodRequestParam int taskId, @SodRequestParam boolean completed, @SodRequestParam String xmlPayload) throws IOException {
        AccountSaveContainer save;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (questManager == null) {
            questManager = QuestManager.getInstance();
        }
        if ((save = account.getSave(userId)) != null) {
            int invContainer = Integer.parseInt(req.payload.getOrDefault("ContainerId", "1"));
            UserQuestInfo quest = questManager.getUserQuest(save, missionId);
            if (quest != null) {
                return this.ok("text/xml", req.generateXmlValue("SetTaskStateResult", (Object)quest.handleTaskCall(taskId, xmlPayload, completed, invContainer, new SetCommonInventoryRequestData[0])));
            }
            SetTaskStateResultData resp = new SetTaskStateResultData();
            resp.success = false;
            resp.status = 8;
            return this.ok("text/xml", req.generateXmlValue("SetTaskStateResult", (Object)resp));
        }
        return this.response(404, "Not found");
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void redeemMysteryBoxItems(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        AccountSaveContainer save = account.getSave(tkn.saveID);
        ItemRedeemRequestData request = (ItemRedeemRequestData)req.parseXmlValue((String)req.payload.get("request"), ItemRedeemRequestData.class);
        int id = request.itemID;
        int containerId = Integer.parseInt(req.payload.getOrDefault("ContainerId", "1"));
        PlayerInventoryContainer cont = save.getInventory().getContainer(containerId);
        PlayerInventoryItem itm = cont.findFirst(id);
        if (itm == null || itm.getQuantity() < 1) {
            InventoryUpdateResponseData resp = new InventoryUpdateResponseData();
            resp.success = false;
            this.setResponseContent("text/xml", req.generateXmlValue("CIRS", (Object)resp));
            return;
        }
        itm.remove(1);
        ItemRedemptionInfo rReq = new ItemRedemptionInfo();
        rReq.containerID = containerId;
        rReq.defID = id;
        rReq.quantity = 1;
        InventoryUpdateResponseData response = InventoryUtils.redeemItems(new ItemRedemptionInfo[]{rReq}, account, save, true);
        if (itm.getQuantity() > 0) {
            if (response.updateItems == null) {
                response.updateItems = new InventoryUpdateResponseData.ItemUpdateBlock[0];
            }
            InventoryUpdateResponseData.ItemUpdateBlock b = new InventoryUpdateResponseData.ItemUpdateBlock();
            b.itemID = itm.getItemDefID();
            b.itemUniqueID = itm.getUniqueID();
            b.addedQuantity = -1;
            response.updateItems = ContentWebServiceV1Processor.appendTo(response.updateItems, b);
        }
        this.setResponseContent("text/xml", req.generateXmlValue("CIRS", (Object)response));
    }

    @SodRequest
    public FunctionResult getDisplayNameByUserID(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, @SodRequestParam String userId) throws IOException {
        AccountSaveContainer save;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((save = manager.getSaveByID(userId)) == null) {
            return this.response(404, "Not found");
        }
        return this.ok("text/xml", req.generateXmlValue("string", (Object)save.getUsername()));
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult useInventory(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, @SodRequestParam int userInventoryId, @SodRequestParam int numberOfUses) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        AccountDataContainer data = account.getAccountData();
        if (tkn.saveID != null) {
            data = account.getSave(tkn.saveID).getSaveData();
        }
        int containerId = Integer.parseInt(req.payload.getOrDefault("ContainerId", "1"));
        PlayerInventory inv = itemManager.getCommonInventory(data);
        PlayerInventoryContainer cont = inv.getContainer(containerId);
        PlayerInventoryItem itm = cont.getItem(userInventoryId);
        if (itm == null) {
            return this.ok("text/xml", req.generateXmlValue("boolean", (Object)false));
        }
        int usesLeft = itm.getUses();
        if (usesLeft == -1) {
            usesLeft = 1;
        }
        if (numberOfUses > usesLeft) {
            return this.ok("text/xml", req.generateXmlValue("boolean", (Object)false));
        }
        if (!itm.useItem(numberOfUses)) {
            return this.ok("text/xml", req.generateXmlValue("boolean", (Object)false));
        }
        return this.ok("text/xml", req.generateXmlValue("boolean", (Object)true));
    }

    @SodRequest
    @SodTokenSecured
    public FunctionResult getGameDataByUser(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, @SodRequestParam String userId) throws IOException {
        AccountSaveContainer save;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((save = account.getSave(userId)) == null) {
            return this.response(404, "Not found");
        }
        MinigameDataRequest srq = new MinigameDataRequest();
        srq.gameLevel = Integer.parseInt((String)req.payload.get("gameLevel"));
        srq.difficulty = Integer.parseInt((String)req.payload.get("difficulty"));
        srq.friendsOnly = ((String)req.payload.get("buddyFilter")).equalsIgnoreCase("true");
        srq.maxEntries = Integer.parseInt((String)req.payload.get("count"));
        srq.key = (String)req.payload.get("key");
        MinigameData data = MinigameDataManager.getInstance().getGameDataOf(save, Integer.parseInt((String)req.payload.get("gameId")), srq);
        GameDataSummaryData resp = new GameDataSummaryData();
        resp.gameID = Integer.parseInt((String)req.payload.get("gameId"));
        resp.difficulty = srq.difficulty;
        resp.isMultiplayer = ((String)req.payload.get("isMultiplayer")).equalsIgnoreCase("true");
        resp.userPosition = 0;
        resp.key = srq.key;
        resp.entries = new GameDataSummaryData.GameDataBlock[1];
        resp.entries[0] = new GameDataSummaryData.GameDataBlock();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        resp.entries[0].datePlayed = fmt.format(new Date(data.timePlayed));
        resp.entries[0].rankID = 1;
        resp.entries[0].timesLost = data.timesLost;
        resp.entries[0].timesWon = data.timesWon;
        resp.entries[0].userID = data.userID;
        resp.entries[0].userName = AccountManager.getInstance().getSaveByID(data.userID).getUsername();
        resp.entries[0].value = data.value;
        return this.ok("text/xml", req.generateXmlValue("GameDataSummary", (Object)resp));
    }

    @SodRequest
    @SodTokenSecured
    public FunctionResult getGameDataByGame(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, @SodRequestParam String userId) throws IOException {
        AccountSaveContainer save;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((save = account.getSave(userId)) == null) {
            return this.response(404, "Not found");
        }
        MinigameDataRequest srq = new MinigameDataRequest();
        srq.gameLevel = Integer.parseInt((String)req.payload.get("gameLevel"));
        srq.difficulty = Integer.parseInt((String)req.payload.get("difficulty"));
        srq.friendsOnly = ((String)req.payload.get("buddyFilter")).equalsIgnoreCase("true");
        srq.maxEntries = Integer.parseInt((String)req.payload.get("count"));
        srq.key = (String)req.payload.get("key");
        MinigameData[] list = MinigameDataManager.getInstance().getAllGameData(userId, Integer.parseInt((String)req.payload.get("gameId")), srq);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        GameDataSummaryData resp = new GameDataSummaryData();
        resp.gameID = Integer.parseInt((String)req.payload.get("gameId"));
        resp.difficulty = srq.difficulty;
        resp.isMultiplayer = ((String)req.payload.get("isMultiplayer")).equalsIgnoreCase("true");
        resp.key = srq.key;
        resp.userPosition = -1;
        resp.entries = new GameDataSummaryData.GameDataBlock[list.length];
        for (int i = 0; i < resp.entries.length; ++i) {
            MinigameData data = list[i];
            resp.entries[i] = new GameDataSummaryData.GameDataBlock();
            resp.entries[i].datePlayed = fmt.format(new Date(data.timePlayed));
            resp.entries[i].rankID = i + 1;
            resp.entries[i].timesLost = data.timesLost;
            resp.entries[i].timesWon = data.timesWon;
            resp.entries[i].userID = data.userID;
            resp.entries[i].userName = AccountManager.getInstance().getSaveByID(data.userID).getUsername();
            resp.entries[i].value = data.value;
            if (!resp.entries[i].userID.equals(userId)) continue;
            resp.userPosition = i;
        }
        return this.ok("text/xml", req.generateXmlValue("GameDataSummary", (Object)resp));
    }

    @SodRequest
    @SodTokenSecured
    public FunctionResult sendRawGameData(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, @SodRequestParam String userId) throws IOException {
        AccountSaveContainer save;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((save = manager.getSaveByID(userId)) == null) {
            return this.ok("text/xml", req.generateXmlValue("boolean", (Object)false));
        }
        MinigameSaveRequest srq = new MinigameSaveRequest();
        srq.gameLevel = Integer.parseInt((String)req.payload.get("gameLevel"));
        srq.difficulty = Integer.parseInt((String)req.payload.get("difficulty"));
        srq.isLoss = ((String)req.payload.get("loss")).equalsIgnoreCase("true");
        srq.isWin = ((String)req.payload.get("win")).equalsIgnoreCase("true");
        srq.data = new HashMap();
        ObjectNode nd = (ObjectNode)req.parseXmlValue((String)req.payload.get("xmlDocumentData"), ObjectNode.class);
        Iterator names = nd.fieldNames();
        while (names.hasNext()) {
            String key = (String)names.next();
            srq.data.put(key, nd.get(key).asInt());
        }
        MinigameDataManager.getInstance().saveGameData(save, Integer.parseInt((String)req.payload.get("gameId")), srq);
        return this.ok("text/xml", req.generateXmlValue("boolean", (Object)true));
    }

    @SodRequest
    @SodTokenSecured
    public FunctionResult getUserRoomList(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, @SodRequestParam RoomListRequestData request) throws IOException {
        AccountSaveContainer save;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (roomManager == null) {
            roomManager = PlayerRoomManager.getInstance();
        }
        if ((save = account.getSave(request.userID.toString())) == null) {
            return this.ok("text/xml", req.generateXmlValue("URR", (Object)new RoomList()));
        }
        RoomList list = new RoomList();
        ArrayList<RoomListEntryData> rooms = new ArrayList<RoomListEntryData>();
        for (PlayerRoomInfo room : roomManager.getRooms(save)) {
            if (room.getCategoryID() != request.categoryID) continue;
            RoomListEntryData entry = new RoomListEntryData();
            entry.roomID = room.getID();
            entry.name = room.getName();
            entry.itemID = room.getItemID();
            entry.creativePoints = room.getCreativePoints();
            entry.categoryID = room.getCategoryID();
            rooms.add(entry);
        }
        list.rooms = (RoomListEntryData[])rooms.toArray(RoomListEntryData[]::new);
        return this.ok("text/xml", req.generateXmlValue("URR", (Object)list));
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult setUserRoom(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, AccountSaveContainer save, @SodRequestParam RoomListEntryData request) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (roomManager == null) {
            roomManager = PlayerRoomManager.getInstance();
        }
        PlayerRoomInfo room = roomManager.createOrGetRoom(request.roomID, request.categoryID, save);
        room.setName(request.name);
        room.setCreativePoints(request.creativePoints);
        room.setItemID(request.itemID);
        room.setCategoryID(request.categoryID);
        return this.ok("text/xml", req.generateXmlValue("URSR", (Object)new RoomUpdateResponseData()));
    }

    @SodRequest
    @SodTokenSecured
    public FunctionResult getUserRoomItemPositions(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, @SodRequestParam String userId, @SodRequestParam String roomID) throws IOException {
        AccountSaveContainer save;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (roomManager == null) {
            roomManager = PlayerRoomManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((save = account.getSave(userId)) == null) {
            return this.ok("text/xml", req.generateXmlValue("ArrayOfUserItemPosition", (Object)new RoomItemList()));
        }
        if (!roomManager.roomExists(roomID, save)) {
            return this.ok("text/xml", req.generateXmlValue("ArrayOfUserItemPosition", (Object)new RoomItemList()));
        }
        PlayerRoomInfo room = roomManager.getRoom(roomID, save);
        RoomItemList list = new RoomItemList();
        RoomItemInfo[] items = room.getItems();
        ArrayList<Integer> addingItems = new ArrayList<Integer>();
        ArrayList<RoomItemData> itmData = new ArrayList<RoomItemData>();
        for (RoomItemInfo data : items) {
            this.addItem(itmData, data, items, save, addingItems);
        }
        list.roomItems = (RoomItemData[])itmData.toArray(RoomItemData[]::new);
        String res = req.generateXmlValue("ArrayOfUserItemPosition", (Object)list);
        return this.ok("text/xml", res);
    }

    private void addItem(ArrayList<RoomItemData> itmData, RoomItemInfo it, RoomItemInfo[] itms, AccountSaveContainer save, ArrayList<Integer> addingItems) {
        if (addingItems.contains(it.roomItemID)) {
            return;
        }
        addingItems.add(it.roomItemID);
        if (it.parentID != -1 && Stream.of(itms).anyMatch(t -> t.roomItemID == it.parentID)) {
            RoomItemInfo p = Stream.of(itms).filter(t -> t.roomItemID == it.parentID).findFirst().get();
            this.addItem(itmData, p, itms, save, addingItems);
        }
        RoomItemData d = new RoomItemData();
        d.itemPositionID = new RoomItemData.IntWrapper(it.roomItemID);
        if (it.parentID != -1) {
            d.parentID = new RoomItemData.IntWrapper(it.parentID);
        }
        if (it.itemID != -1) {
            d.itemID = new RoomItemData.IntWrapper(it.itemID);
        }
        if (it.itemUniqueID != -1) {
            d.itemUniqueID = new RoomItemData.IntWrapper(it.itemUniqueID);
            d.itemDef = ItemManager.getInstance().getItemDefinition(it.itemID).getRawObject();
        }
        d.uses = new RoomItemData.IntWrapper(it.getCurrentUses(save));
        if (it.inventoryModificationDate != null) {
            d.inventoryModificationDate = new RoomItemData.StringWrapper(it.inventoryModificationDate);
        }
        if (it.itemAttributes != null) {
            d.itemAttributes = it.itemAttributes;
        }
        if (it.itemStats != null) {
            d.itemStats = it.itemStats;
        }
        d.posX = new RoomItemData.DoubleWrapper(it.position.x);
        d.posY = new RoomItemData.DoubleWrapper(it.position.y);
        d.posZ = new RoomItemData.DoubleWrapper(it.position.z);
        d.rotX = new RoomItemData.DoubleWrapper(it.rotation.x);
        d.rotY = new RoomItemData.DoubleWrapper(it.rotation.y);
        d.rotZ = new RoomItemData.DoubleWrapper(it.rotation.z);
        if (it.currentStateID != -1) {
            d.itemState = new RoomItemData.ItemStateBlock();
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
            fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            d.itemState.itemStateID = it.currentStateID;
            d.itemState.stateChangeDate = fmt.format(new Date(it.lastStateChange));
            d.itemState.itemDefID = it.itemID;
            d.itemState.itemUniqueID = it.itemUniqueID;
            d.itemState.itemPositionID = it.roomItemID;
        }
        itmData.add(d);
    }

    /*
     * WARNING - void declaration
     */
    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult setUserRoomItemPositions(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, AccountSaveContainer save, @SodRequestParam String roomID, @SodRequestParam RoomItemUpdateRequestData[] createXml, @SodRequestParam RoomItemUpdateRequestData[] updateXml, @SodRequestParam int[] removeXml) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (roomManager == null) {
            roomManager = PlayerRoomManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        RoomItemUpdateResponseData resp = new RoomItemUpdateResponseData();
        ArrayList<RoomItemData.ItemStateBlock> states = new ArrayList<RoomItemData.ItemStateBlock>();
        ArrayList<Integer> createdItems = new ArrayList<Integer>();
        resp.success = true;
        PlayerRoomInfo room = roomManager.createOrGetRoom(roomID, roomID.equals("") ? 541 : -1, save);
        HashMap<Integer, RoomItemInfo> newItemData = new HashMap<Integer, RoomItemInfo>();
        for (RoomItemInfo itm : room.getItems()) {
            newItemData.put(itm.roomItemID, itm);
        }
        ArrayList<RoomItemUpdateRequestData> ls = new ArrayList<RoomItemUpdateRequestData>();
        for (RoomItemUpdateRequestData crReq : createXml) {
            if (this.handleCreate(newItemData, room, save, crReq, createXml, resp, ls, states, createdItems)) continue;
            resp.success = false;
            return this.ok("text/xml", req.generateXmlValue("UIPSRS", (Object)resp));
        }
        for (RoomItemUpdateRequestData crReq : updateXml) {
            ItemInfo def;
            if (crReq.itemPositionID == null || !newItemData.containsKey(crReq.itemPositionID.value)) continue;
            RoomItemInfo info = newItemData.get(crReq.itemPositionID.value);
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
            fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            if (crReq.uses != null) {
                info.uses = crReq.uses.value;
            }
            if (crReq.inventoryModificationDate != null) {
                info.inventoryModificationDate = crReq.inventoryModificationDate.value;
            }
            if (crReq.itemID != null) {
                info.itemID = crReq.itemID.value;
                info.inventoryModificationDate = fmt.format(new Date(System.currentTimeMillis()));
            }
            if (crReq.itemUniqueID != null) {
                info.itemUniqueID = crReq.itemUniqueID.value;
                info.inventoryModificationDate = fmt.format(new Date(System.currentTimeMillis()));
            }
            if (crReq.itemAttributes != null) {
                info.itemAttributes = crReq.itemAttributes;
            }
            if (crReq.itemStats != null) {
                info.itemStats = crReq.itemStats;
            }
            if ((def = itemManager.getItemDefinition(info.itemID)) == null) {
                resp.success = false;
                resp.status = 7;
                return this.ok("text/xml", req.generateXmlValue("UIPSRS", (Object)resp));
            }
            info.position = new Vector3D(crReq.posX.value, crReq.posY.value, crReq.posZ.value);
            info.rotation = new Vector3D(crReq.rotX.value, crReq.rotY.value, crReq.rotZ.value);
            boolean addedState = false;
            if (crReq.itemState != null) {
                info.currentStateID = crReq.itemState.itemStateID;
                addedState = true;
            }
            if (!addedState) continue;
            info.lastStateChange = System.currentTimeMillis();
        }
        for (int id : removeXml) {
            if (!newItemData.containsKey(id)) continue;
            newItemData.remove(id);
        }
        if (resp.success) {
            void var16_21;
            resp.createdRoomItemIDs = new int[createdItems.size()];
            boolean bl = false;
            while (var16_21 < resp.createdRoomItemIDs.length) {
                resp.createdRoomItemIDs[var16_21] = createdItems.get((int)var16_21);
                ++var16_21;
            }
            resp.states = (RoomItemData.ItemStateBlock[])states.toArray(RoomItemData.ItemStateBlock[]::new);
            room.setItems((RoomItemInfo[])newItemData.values().toArray(RoomItemInfo[]::new));
        }
        String string = req.generateXmlValue("UIPSRS", (Object)resp);
        return this.ok("text/xml", string);
    }

    private boolean handleCreate(HashMap<Integer, RoomItemInfo> newItemData, PlayerRoomInfo room, AccountSaveContainer save, RoomItemUpdateRequestData crReq, RoomItemUpdateRequestData[] createXml, RoomItemUpdateResponseData resp, ArrayList<RoomItemUpdateRequestData> addedItems, ArrayList<RoomItemData.ItemStateBlock> statesL, ArrayList<Integer> createdItems) {
        ItemInfo def;
        if (addedItems.contains(crReq)) {
            return true;
        }
        addedItems.add(crReq);
        RoomItemInfo info = new RoomItemInfo();
        if (crReq.parentIndex != null) {
            int ind = crReq.parentIndex.value;
            if (ind < 0 || ind > createXml.length) {
                resp.status = 4;
                return false;
            }
            if (!this.handleCreate(newItemData, room, save, createXml[ind], createXml, resp, addedItems, statesL, createdItems)) {
                return false;
            }
            info.parentID = createXml[ind].result.roomItemID;
        } else if (crReq.parentID != null) {
            if (!newItemData.containsKey(crReq.parentID.value)) {
                resp.status = 3;
                return false;
            }
            info.parentID = crReq.parentID.value;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        info.itemID = crReq.itemID != null ? crReq.itemID.value : save.getInventory().getContainer(1).getItem(crReq.itemUniqueID.value).getItemDefID();
        info.itemUniqueID = crReq.itemUniqueID.value;
        info.inventoryModificationDate = fmt.format(new Date(System.currentTimeMillis()));
        if (crReq.uses != null) {
            info.uses = crReq.uses.value;
        }
        if (crReq.itemAttributes != null) {
            info.itemAttributes = crReq.itemAttributes;
        }
        if (crReq.itemStats != null) {
            info.itemStats = crReq.itemStats;
        }
        if ((def = itemManager.getItemDefinition(info.itemID)) == null) {
            resp.status = 7;
            return false;
        }
        info.position = new Vector3D(crReq.posX.value, crReq.posY.value, crReq.posZ.value);
        info.rotation = new Vector3D(crReq.rotX.value, crReq.rotY.value, crReq.rotZ.value);
        boolean addedState = false;
        ItemDefData raw = def.getRawObject();
        if (raw.states.length >= 1) {
            info.currentStateID = raw.states[0].stateID;
            addedState = true;
        }
        if (crReq.itemState != null) {
            info.currentStateID = crReq.itemState.itemStateID;
            addedState = true;
        }
        info = roomManager.createRoomItem(info, save);
        if (addedState) {
            RoomItemData.ItemStateBlock stateBlock = new RoomItemData.ItemStateBlock();
            stateBlock.itemStateID = info.currentStateID;
            stateBlock.stateChangeDate = fmt.format(new Date(info.lastStateChange));
            stateBlock.itemDefID = info.itemID;
            stateBlock.itemUniqueID = info.itemUniqueID;
            stateBlock.itemPositionID = info.roomItemID;
            statesL.add(stateBlock);
        }
        crReq.result = info;
        newItemData.put(info.roomItemID, info);
        createdItems.add(info.roomItemID);
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult setNextItemState(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, AccountSaveContainer save, @SodRequestParam(value="setNextItemStateRequest") SetItemStateRequestData request) throws IOException {
        RoomItemInfo item;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (roomManager == null) {
            roomManager = PlayerRoomManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((item = roomManager.getRoomItem(request.roomItemID, save)) == null) {
            SetItemStateResponseData resp = new SetItemStateResponseData();
            resp.errorCode = 255;
            resp.success = false;
            return this.ok("text/xml", req.generateXmlValue("SetNextItemStateResult", (Object)resp));
        }
        PlayerRoomInfo room = roomManager.getRoom(item.roomID, save);
        RoomItemInfo[] roomItems = room.getItems();
        SetItemStateResponseData resp = new SetItemStateResponseData();
        resp.errorCode = 1;
        resp.success = true;
        PlayerInventoryItem invItm = itemManager.getCommonInventory(save.getSaveData()).getContainer(1).getItem(request.itemUniqueID);
        if (invItm == null) {
            resp.errorCode = 4;
            resp.success = false;
            return this.ok("text/xml", req.generateXmlValue("SetNextItemStateResult", (Object)resp));
        }
        ItemDefData def = invItm.getItemDef().getRawObject();
        Optional<ItemStateData> stateO = Stream.of(def.states).filter(t -> t.stateID == item.currentStateID).findFirst();
        if (!stateO.isPresent()) {
            resp.errorCode = 10;
            resp.success = false;
            return this.ok("text/xml", req.generateXmlValue("SetNextItemStateResult", (Object)resp));
        }
        ItemStateData state = stateO.get();
        if (state.rules == null || state.rules.criteria.length == 0) {
            resp.errorCode = 12;
            resp.success = false;
            return this.ok("text/xml", req.generateXmlValue("SetNextItemStateResult", (Object)resp));
        }
        int nextState = -1;
        if (state.rules.completionAction != null) {
            block0 : switch (state.rules.completionAction.transitionMode) {
                case 1: {
                    ItemStateData[] states;
                    int i = 0;
                    ItemStateData[] itemStateDataArray = states = (ItemStateData[])Stream.of(def.states).sorted((t1, t2) -> Integer.compare(t1.order, t2.order)).toArray(ItemStateData[]::new);
                    int n = itemStateDataArray.length;
                    for (int j = 0; j < n; ++i, ++j) {
                        ItemStateData itemStateData = itemStateDataArray[j];
                        if (itemStateData != state || i + 1 >= states.length) continue;
                        nextState = states[i + 1].stateID;
                        break block0;
                    }
                    break;
                }
                case 3: {
                    nextState = -2;
                    break;
                }
                case 4: {
                    ItemStateData st = null;
                    for (ItemStateData st2 : def.states) {
                        if (st != null && st2.order >= st.order) continue;
                        st = st2;
                    }
                    if (st == null) break;
                    nextState = st.stateID;
                    break;
                }
            }
        }
        block13: for (ItemStateCriteriaWrapperData criteria : state.rules.criteria) {
            switch (criteria.criteriaType) {
                case 1: {
                    if (request.isSpeedUp) continue block13;
                    ItemStateLengthCriteriaData crit = (ItemStateLengthCriteriaData)criteria.criteriaData;
                    if (System.currentTimeMillis() - item.lastStateChange >= (long)(crit.period * 1000)) continue block13;
                    resp.errorCode = 3;
                    resp.success = false;
                    return this.ok("text/xml", req.generateXmlValue("SetNextItemStateResult", (Object)resp));
                }
                case 2: {
                    RoomItemInfo targetItm;
                    if (request.isSpeedUp) continue block13;
                    ItemStateConsumableCriteriaData crit = (ItemStateConsumableCriteriaData)criteria.criteriaData;
                    if (crit.appliesUses) {
                        Optional<RoomItemInfo> optional = Stream.of(roomItems).filter(t -> t.itemID == crit.itemID).findFirst();
                        if (!optional.isPresent()) {
                            resp.errorCode = 5;
                            resp.success = false;
                            return this.ok("text/xml", req.generateXmlValue("SetNextItemStateResult", (Object)resp));
                        }
                        targetItm = optional.get();
                        if (targetItm.getCurrentUses(save) < crit.amount) {
                            resp.errorCode = 5;
                            resp.success = false;
                            return this.ok("text/xml", req.generateXmlValue("SetNextItemStateResult", (Object)resp));
                        }
                        targetItm.uses = targetItm.getCurrentUses(save) - crit.amount;
                        continue block13;
                    }
                    PlayerInventoryItem playerInventoryItem = itemManager.getCommonInventory(save.getSaveData()).getContainer(1).findFirst(crit.itemID);
                    if (playerInventoryItem == null || playerInventoryItem.getQuantity() < crit.amount) {
                        resp.errorCode = 7;
                        resp.success = false;
                        return this.ok("text/xml", req.generateXmlValue("SetNextItemStateResult", (Object)resp));
                    }
                    playerInventoryItem.remove(crit.amount);
                    continue block13;
                }
                case 5: {
                    if (request.isSpeedUp) continue block13;
                    ItemStateExpiryCriteriaData crit = (ItemStateExpiryCriteriaData)criteria.criteriaData;
                    if (System.currentTimeMillis() - item.lastStateChange < (long)(crit.period * 1000)) continue block13;
                    nextState = crit.targetState;
                    continue block13;
                }
                case 4: {
                    RoomItemInfo targetItm;
                    if (!request.isSpeedUp) continue block13;
                    final ItemStateSpeedUpCriteriaData crit = (ItemStateSpeedUpCriteriaData)criteria.criteriaData;
                    if (crit.appliesUses) {
                        Optional<RoomItemInfo> optional = Stream.of(roomItems).filter(t -> t.itemID == crit.itemID).findFirst();
                        if (!optional.isPresent()) {
                            resp.errorCode = 2;
                            resp.success = false;
                            return this.ok("text/xml", req.generateXmlValue("SetNextItemStateResult", (Object)resp));
                        }
                        targetItm = optional.get();
                        if (targetItm.getCurrentUses(save) < crit.amount) {
                            resp.errorCode = 2;
                            resp.success = false;
                            return this.ok("text/xml", req.generateXmlValue("SetNextItemStateResult", (Object)resp));
                        }
                        targetItm.uses = targetItm.getCurrentUses(save) - crit.amount;
                    } else {
                        void var21_45;
                        PlayerInventoryItem playerInventoryItem = itemManager.getCommonInventory(save.getSaveData()).getContainer(1).findFirst(crit.itemID);
                        if (playerInventoryItem == null || playerInventoryItem.getQuantity() < crit.amount) {
                            final PlayerInventoryItem itmF = playerInventoryItem;
                            InventoryUpdateResponseData purchase = InventoryUtils.purchaseItems(request.storeID, new ItemRedemptionInfo[]{new ItemRedemptionInfo(){
                                {
                                    this.defID = crit.itemID;
                                    this.quantity = crit.amount;
                                    if (itmF != null) {
                                        this.quantity -= itmF.getQuantity();
                                    }
                                    this.containerID = 1;
                                }
                            }}, account, save, false);
                            if (!purchase.success) {
                                resp.errorCode = 2;
                                resp.success = false;
                                return this.ok("text/xml", req.generateXmlValue("SetNextItemStateResult", (Object)resp));
                            }
                            PlayerInventoryItem playerInventoryItem2 = itemManager.getCommonInventory(save.getSaveData()).getContainer(1).findFirst(crit.itemID);
                        }
                        var21_45.remove(crit.amount);
                    }
                    if (crit.speedUpUses) {
                        item.uses = crit.speedUpUsesCount;
                    }
                    if (!crit.changesState) continue block13;
                    nextState = crit.targetState;
                    continue block13;
                }
            }
        }
        int nextStateF = nextState;
        if (nextState == -1 || nextState != -2 && !Stream.of(def.states).anyMatch(t -> t.stateID == nextStateF)) {
            resp.errorCode = 9;
            resp.success = false;
            return this.ok("text/xml", req.generateXmlValue("SetNextItemStateResult", (Object)resp));
        }
        if (nextState == -2) {
            roomManager.deleteRoomItem(item.roomItemID, save);
            ArrayList<RoomItemInfo> newItems = new ArrayList<RoomItemInfo>();
            for (RoomItemInfo roomItemInfo : roomItems) {
                if (roomItemInfo.roomItemID == item.roomItemID) continue;
                newItems.add(roomItemInfo);
            }
            room.setItems((RoomItemInfo[])newItems.toArray(RoomItemInfo[]::new));
        } else {
            item.currentStateID = nextState;
            item.lastStateChange = System.currentTimeMillis();
            roomManager.saveRoomItem(item, save);
        }
        resp.rewards = RewardsUtil.giveRewardsTo(save, state.rewards, false, 1);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        resp.state = new RoomItemData.ItemStateBlock();
        resp.state.itemDefID = item.itemID;
        resp.state.itemUniqueID = item.itemUniqueID;
        resp.state.itemPositionID = item.roomItemID;
        resp.state.stateChangeDate = fmt.format(new Date(item.lastStateChange));
        resp.state.itemStateID = item.currentStateID;
        return this.ok("text/xml", req.generateXmlValue("SetNextItemStateResult", (Object)resp));
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult setGameCurrency(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, AccountSaveContainer save, @SodRequestParam int amount) throws IOException {
        AccountDataContainer currency = save.getSaveData().getChildContainer("currency");
        int currentC = 300;
        if (currency.entryExists("coins")) {
            currentC = currency.getEntry("coins").getAsInt();
        }
        currency.setEntry("coins", (JsonElement)new JsonPrimitive((Number)(currentC + amount)));
        return this.ok("text/xml", req.generateXmlValue("int", (Object)(currentC + amount)));
    }

    private static KeyValuePairData[] appendTo(KeyValuePairData[] arr, KeyValuePairData block) {
        KeyValuePairData[] newB = new KeyValuePairData[arr.length + 1];
        for (int i = 0; i < newB.length; ++i) {
            newB[i] = i >= arr.length ? block : arr[i];
        }
        return newB;
    }

    private static InventoryUpdateResponseData.ItemUpdateBlock[] appendTo(InventoryUpdateResponseData.ItemUpdateBlock[] arr, InventoryUpdateResponseData.ItemUpdateBlock block) {
        InventoryUpdateResponseData.ItemUpdateBlock[] newB = new InventoryUpdateResponseData.ItemUpdateBlock[arr.length + 1];
        for (int i = 0; i < newB.length; ++i) {
            newB[i] = i >= arr.length ? block : arr[i];
        }
        return newB;
    }
}

