/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.http.handlers.achievements;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.logging.log4j.LogManager;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionResult;
import org.asf.edge.common.http.apihandlerutils.functions.SodEncryptedParam;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequest;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequestParam;
import org.asf.edge.common.http.apihandlerutils.functions.SodTokenSecured;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireCapability;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireSave;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.leaderboard.Leaderboard;
import org.asf.edge.common.services.leaderboard.LeaderboardManager;
import org.asf.edge.gameplayapi.EdgeGameplayApiServer;
import org.asf.edge.gameplayapi.xmls.achievements.AchievementTaskData;
import org.asf.edge.gameplayapi.xmls.achievements.AchievementTaskSetRequestList;
import org.asf.edge.gameplayapi.xmls.achievements.AchievementTaskSetResponseData;
import org.asf.edge.gameplayapi.xmls.achievements.AchievementTaskSetResponseList;
import org.asf.edge.gameplayapi.xmls.achievements.leaderboard.UdtLeaderboardRequestData;
import org.asf.edge.gameplayapi.xmls.achievements.leaderboard.UdtLeaderboardResponseData;

public class AchievementWebServiceV2Processor
extends EdgeWebService<EdgeGameplayApiServer> {
    public AchievementWebServiceV2Processor(EdgeGameplayApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new AchievementWebServiceV2Processor((EdgeGameplayApiServer)this.getServerInstance());
    }

    public String path() {
        return "/v2/AchievementWebService.asmx";
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult setUserAchievementTask(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, AccountSaveContainer save, @SodEncryptedParam @SodRequestParam AchievementTaskSetRequestList achievementTaskSetRequest) throws IOException {
        ArrayList<AchievementTaskSetResponseData> responses = new ArrayList<AchievementTaskSetResponseData>();
        for (AchievementTaskData reqA : achievementTaskSetRequest.requests) {
            AchievementTaskSetResponseData resp = new AchievementTaskSetResponseData();
            resp.success = new AchievementTaskSetResponseData.BooleanWrapper(false);
            responses.add(resp);
        }
        AchievementTaskSetResponseList resp = new AchievementTaskSetResponseList();
        resp.responses = (AchievementTaskSetResponseData[])responses.toArray(AchievementTaskSetResponseData[]::new);
        return this.ok("text/xml", req.generateXmlValue("ArrayOfAchievementTaskSetResponse", (Object)resp));
    }

    @SodRequest
    public FunctionResult getTopAchievementPointUsers(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, @SodRequestParam UdtLeaderboardRequestData request) throws IOException {
        UdtLeaderboardResponseData resp = new UdtLeaderboardResponseData();
        ArrayList<UdtLeaderboardResponseData.UdtLeaderboardEntryBlock> responses = new ArrayList<UdtLeaderboardResponseData.UdtLeaderboardEntryBlock>();
        if (request.pointTypeID == 12) {
            int offset = (request.pageNumber - 1) * request.pageSize;
            int end = request.pageNumber * request.pageSize + 1;
            Leaderboard leaderboard = LeaderboardManager.getInstance().getLeaderboard("UDT");
            Map scores = Map.of();
            Leaderboard.DateRange dateRange = null;
            switch (request.mode) {
                case 1: {
                    scores = leaderboard.getScoresAllTime();
                    break;
                }
                case 2: {
                    dateRange = leaderboard.getDateRangeOfDailyScores();
                    scores = leaderboard.getDailyScores();
                    break;
                }
                case 3: {
                    dateRange = leaderboard.getDateRangeOfWeeklyScores();
                    scores = leaderboard.getWeeklyScores();
                    break;
                }
                case 4: {
                    dateRange = leaderboard.getDateRangeOfMonthlyScores();
                    scores = leaderboard.getMonthlyScores();
                }
            }
            int index = 0;
            for (String id : scores.keySet()) {
                if (index >= end) break;
                AccountSaveContainer save = AccountManager.getInstance().getSaveByID(id);
                if (save == null) continue;
                if (index < offset) {
                    ++index;
                    continue;
                }
                ++index;
                UdtLeaderboardResponseData.UdtLeaderboardEntryBlock entry = new UdtLeaderboardResponseData.UdtLeaderboardEntryBlock();
                entry.userID = id;
                entry.pointsTotal = (Integer)scores.get(id);
                entry.pointTypeID = request.pointTypeID;
                entry.userName = save.getUsername();
                responses.add(entry);
            }
            if (dateRange != null) {
                resp.dateRange = new UdtLeaderboardResponseData.UdtDateRangeBlock();
                fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
                fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
                resp.dateRange.dateStart = fmt.format(new Date(dateRange.dateStart));
                resp.dateRange.dateEnd = fmt.format(new Date(dateRange.dateEnd));
            } else {
                resp.dateRange = new UdtLeaderboardResponseData.UdtDateRangeBlock();
                fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ssXXX");
                fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
                resp.dateRange.dateStart = fmt.format(new Date(0L));
                resp.dateRange.dateEnd = fmt.format(new Date(System.currentTimeMillis()));
            }
        } else {
            LogManager.getLogger((String)"Leaderboards").error("Unable to retrieve leaderboard by point type ID " + request.pointTypeID + " as Edge doesnt have support for this type ID.");
        }
        resp.entries = (UdtLeaderboardResponseData.UdtLeaderboardEntryBlock[])responses.toArray(UdtLeaderboardResponseData.UdtLeaderboardEntryBlock[]::new);
        return this.ok("text/xml", req.generateXmlValue("UAIR", (Object)resp));
    }
}

