/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.entities.rooms;

import java.util.Optional;
import java.util.stream.Stream;
import org.asf.edge.common.entities.achivements.RankTypeID;
import org.asf.edge.common.entities.coordinates.Vector3D;
import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.xmls.data.KeyValuePairSetData;
import org.asf.edge.common.xmls.items.ItemDefData;
import org.asf.edge.common.xmls.items.state.ItemStateCriteriaWrapperData;
import org.asf.edge.common.xmls.items.state.ItemStateData;
import org.asf.edge.common.xmls.items.state.criteria.ItemStateReplenishableCriteriaData;
import org.asf.edge.gameplayapi.xmls.rooms.RoomItemData;

public class RoomItemInfo {
    public String roomID = null;
    public int roomItemID = -1;
    public int parentID = -1;
    public int itemID = -1;
    public int itemUniqueID = -1;
    public int uses = 0;
    public String inventoryModificationDate;
    public int currentStateID = -1;
    public long lastStateChange;
    public KeyValuePairSetData itemAttributes;
    public RoomItemData.ItemStatBlock itemStats;
    public Vector3D position;
    public Vector3D rotation;

    public int getCurrentUses(AccountSaveContainer save) {
        Optional<ItemStateData> stateO;
        ItemInfo i = ItemManager.getInstance().getItemDefinition(this.itemID);
        if (i == null) {
            return this.uses;
        }
        ItemDefData def = i.getRawObject();
        if (def.states != null && (stateO = Stream.of(def.states).filter(t -> t.stateID == this.currentStateID).findFirst()).isPresent()) {
            ItemStateData state = stateO.get();
            if (state.rules != null) {
                for (ItemStateCriteriaWrapperData criteria : state.rules.criteria) {
                    if (!(criteria.criteriaData instanceof ItemStateReplenishableCriteriaData)) continue;
                    ItemStateReplenishableCriteriaData crit = (ItemStateReplenishableCriteriaData)criteria.criteriaData;
                    for (ItemStateReplenishableCriteriaData.ReplenishRateBlock block : crit.replenishRates) {
                        int newUses;
                        AchievementManager manager;
                        int value;
                        if (crit.useRank && (value = (manager = AchievementManager.getInstance()).getRankIndex(manager.getRank(save, save.getSaveID(), RankTypeID.getByTypeID((int)crit.rankPointTypeID)).getRank()) + 1) < block.rankLevel) continue;
                        double period = block.increasePeriod * 1000.0;
                        long timePassed = System.currentTimeMillis() - this.lastStateChange;
                        int addedUses = (int)((double)block.usesPerPeriod * ((double)timePassed / period));
                        if (addedUses < 0) {
                            addedUses = 0;
                        }
                        if ((newUses = this.uses + addedUses) > block.usesLimit) {
                            newUses = block.usesLimit;
                        }
                        return newUses;
                    }
                }
            }
        }
        return this.uses;
    }
}

