/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.commands.defaultcommands.debug;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.entities.achivements.RankTypeID;
import org.asf.edge.common.entities.messages.WsMessage;
import org.asf.edge.common.entities.messages.defaultmessages.WsGenericMessage;
import org.asf.edge.common.entities.messages.defaultmessages.WsPluginMessage;
import org.asf.edge.common.permissions.PermissionLevel;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.messages.WsMessageService;
import org.asf.edge.common.services.textfilter.TextFilterService;
import org.asf.edge.common.util.TaggedMessageUtils;
import org.asf.edge.common.xmls.messages.MessageInfoData;
import org.asf.edge.gameplayapi.commands.CommandContext;
import org.asf.edge.gameplayapi.commands.IEdgeServerCommand;
import org.asf.edge.gameplayapi.commands.TaskBasedCommand;
import org.asf.edge.gameplayapi.entities.quests.UserQuestInfo;
import org.asf.edge.gameplayapi.services.quests.QuestManager;
import org.asf.edge.gameplayapi.util.InventoryUtils;
import org.asf.edge.gameplayapi.util.inventory.ItemRedemptionInfo;
import org.asf.edge.gameplayapi.xmls.inventories.InventoryUpdateResponseData;

public class DebugCommands
extends TaskBasedCommand {
    @Override
    public String id() {
        return "debug";
    }

    @Override
    public String description(CommandContext ctx) {
        return "Debug commands";
    }

    @Override
    public PermissionLevel permLevel() {
        return PermissionLevel.OPERATOR;
    }

    @Override
    public String permNode() {
        return "commands.operator.debugcommands";
    }

    @Override
    public IEdgeServerCommand[] tasks() {
        return new IEdgeServerCommand[]{new IEdgeServerCommand(){

            @Override
            public String id() {
                return "commondatatest1";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return null;
            }

            @Override
            public String description(CommandContext ctx) {
                return "Test command for common data management";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.OPERATOR;
            }

            @Override
            public String permNode() {
                return "commands.operator.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) {
                try {
                    CommonDataManager.getInstance().getContainer("test").setEntry("test", (JsonElement)new JsonPrimitive("abc"));
                    CommonDataManager.getInstance().getContainer("test").getChildContainer("test1").getChildContainer("test2").getChildContainer("test3").setEntry("abc3", (JsonElement)new JsonPrimitive("def"));
                    CommonDataManager.getInstance().getContainer("test").getChildContainer("test3").setEntry("abc3", (JsonElement)new JsonPrimitive("def2"));
                    CommonDataManager.getInstance().getContainer("test").getChildContainer("test1").getChildContainer("test2").getChildContainers();
                    CommonDataManager.getInstance().getContainer("test").getChildContainer("test1").getChildContainers();
                    CommonDataManager.getInstance().getContainer("test").getChildContainers();
                    CommonDataManager.getInstance().getContainer("test").getChildContainer("test1").getChildContainer("test2").getChildContainer("test3").getEntryKeys();
                    String r = CommonDataManager.getInstance().getContainer("test").getEntry("test").getAsString().equals("abc") ? "Test passed" : "Test failed";
                    return r;
                }
                catch (Exception exception) {
                    return "Test errored";
                }
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "commondatatest2";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return null;
            }

            @Override
            public String description(CommandContext ctx) {
                return "Test command for common data management";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.OPERATOR;
            }

            @Override
            public String permNode() {
                return "commands.operator.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) {
                try {
                    CommonDataManager.getInstance().getContainer("test").deleteContainer();
                    return "Test passed";
                }
                catch (Exception exception) {
                    return "Test errored";
                }
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "commondatatest3";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return null;
            }

            @Override
            public String description(CommandContext ctx) {
                return "Test command for common data management";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.OPERATOR;
            }

            @Override
            public String permNode() {
                return "commands.operator.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) {
                try {
                    CommonDataManager.getInstance().getContainer("test").runForEntries((key, value) -> true);
                    CommonDataManager.getInstance().getContainer("test").runForChildContainers(name -> true);
                    JsonElement e = CommonDataManager.getInstance().getContainer("test").findEntry((key, value) -> true);
                    if (e == null) {
                        return "Test failed";
                    }
                    return "Test passed";
                }
                catch (Exception exception) {
                    return "Test errored";
                }
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "resetquest";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return "<quest ID>";
            }

            @Override
            public String description(CommandContext ctx) {
                return "Resets quests";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.ADMINISTRATOR;
            }

            @Override
            public String permNode() {
                return "commands.admin.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) {
                if (!ctx.getCommandMemory().containsKey("active_profile")) {
                    outputWriteLineCallback.accept("Error: no active profile, please use 'profiles select' before using this command");
                    return null;
                }
                AccountSaveContainer save = AccountManager.getInstance().getAccount(ctx.getCommandMemory().get("active_account").toString()).getSave(ctx.getCommandMemory().get("active_profile").toString());
                UserQuestInfo q = QuestManager.getInstance().getUserQuest(save, Integer.parseInt(args[0]));
                if (q == null) {
                    outputWriteLineCallback.accept("Error: invalid quest, quest not recognized");
                    return null;
                }
                q.resetQuest();
                return "Done";
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "completequest";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return "<quest ID>";
            }

            @Override
            public String description(CommandContext ctx) {
                return "Completes quests";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.ADMINISTRATOR;
            }

            @Override
            public String permNode() {
                return "commands.admin.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) {
                if (!ctx.getCommandMemory().containsKey("active_profile")) {
                    outputWriteLineCallback.accept("Error: no active profile, please use 'profiles select' before using this command");
                    return null;
                }
                AccountSaveContainer save = AccountManager.getInstance().getAccount(ctx.getCommandMemory().get("active_account").toString()).getSave(ctx.getCommandMemory().get("active_profile").toString());
                UserQuestInfo q = QuestManager.getInstance().getUserQuest(save, Integer.parseInt(args[0]));
                if (q == null) {
                    outputWriteLineCallback.accept("Error: invalid quest, quest not recognized");
                    return null;
                }
                q.completeQuest();
                return "Done";
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "runforallaccs";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return null;
            }

            @Override
            public String description(CommandContext ctx) {
                return "Test command for account management";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.OPERATOR;
            }

            @Override
            public String permNode() {
                return "commands.operator.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) {
                AccountManager.getInstance().runForAllAccounts(t -> {
                    outputWriteLineCallback.accept(t.getUsername());
                    return true;
                });
                return "Done";
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "itemtestadd";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return "<defID> [<quantity>]";
            }

            @Override
            public String description(CommandContext ctx) {
                return "Test command for inventory management";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.OPERATOR;
            }

            @Override
            public String permNode() {
                return "commands.operator.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) throws IOException {
                if (!ctx.getCommandMemory().containsKey("active_profile")) {
                    outputWriteLineCallback.accept("Error: no active profile, please use 'profiles select' before using this command");
                    return null;
                }
                AccountSaveContainer save = AccountManager.getInstance().getAccount(ctx.getCommandMemory().get("active_account").toString()).getSave(ctx.getCommandMemory().get("active_profile").toString());
                int def = Integer.parseInt(args[0]);
                int quantity = 1;
                if (args.length > 1) {
                    quantity = Integer.parseInt(args[1]);
                }
                ItemRedemptionInfo info = new ItemRedemptionInfo();
                info.containerID = 1;
                info.defID = def;
                info.quantity = quantity;
                InventoryUpdateResponseData resp = InventoryUtils.redeemItems(new ItemRedemptionInfo[]{info}, save.getAccount(), save, false);
                return "Response:\n" + new XmlMapper().writer().withDefaultPrettyPrinter().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("CIRS").writeValueAsString((Object)resp).trim();
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "itemtestbuy";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return "<shopID> <defID> [<quantity>]";
            }

            @Override
            public String description(CommandContext ctx) {
                return "Test command for buying";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.OPERATOR;
            }

            @Override
            public String permNode() {
                return "commands.operator.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) throws IOException {
                if (!ctx.getCommandMemory().containsKey("active_profile")) {
                    outputWriteLineCallback.accept("Error: no active profile, please use 'profiles select' before using this command");
                    return null;
                }
                AccountSaveContainer save = AccountManager.getInstance().getAccount(ctx.getCommandMemory().get("active_account").toString()).getSave(ctx.getCommandMemory().get("active_profile").toString());
                int shop = Integer.parseInt(args[0]);
                int def = Integer.parseInt(args[1]);
                int quantity = 1;
                if (args.length > 2) {
                    quantity = Integer.parseInt(args[2]);
                }
                ItemRedemptionInfo info = new ItemRedemptionInfo();
                info.containerID = 1;
                info.defID = def;
                info.quantity = quantity;
                InventoryUpdateResponseData resp = InventoryUtils.purchaseItems(shop, new ItemRedemptionInfo[]{info}, save.getAccount(), save, false);
                return "Response:\n" + new XmlMapper().writer().withDefaultPrettyPrinter().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("CIRS").writeValueAsString((Object)resp).trim();
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "filtertest";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return "<text> [<strictmode>]";
            }

            @Override
            public String description(CommandContext ctx) {
                return "Test command for filtering";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.OPERATOR;
            }

            @Override
            public String permNode() {
                return "commands.operator.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) {
                return TextFilterService.getInstance().filterString(args[0], args.length > 1 ? args[1].equals("true") : false);
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "filtertest2";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return "<text> <strictmode>";
            }

            @Override
            public String description(CommandContext ctx) {
                return "Test command for filtering";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.OPERATOR;
            }

            @Override
            public String permNode() {
                return "commands.operator.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) throws IOException {
                return "Response:\n" + new XmlMapper().writer().withDefaultPrettyPrinter().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("FilterResult").writeValueAsString((Object)TextFilterService.getInstance().filter(args[0], args[1].equals("true"))).trim();
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "filtertest3";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return "<text> <strictmode>";
            }

            @Override
            public String description(CommandContext ctx) {
                return "Test command for filtering";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.OPERATOR;
            }

            @Override
            public String permNode() {
                return "commands.operator.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) throws IOException {
                return "Response: " + TextFilterService.getInstance().isFiltered(args[0], args[1].equals("true"));
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "testmessages1";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return "\"[message]\"";
            }

            @Override
            public String description(CommandContext ctx) {
                return "Test command for messaging";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.OPERATOR;
            }

            @Override
            public String permNode() {
                return "commands.operator.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) throws IOException {
                return "Result:\n" + new XmlMapper().writer().withDefaultPrettyPrinter().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("TaggedMessage").writeValueAsString((Object)TaggedMessageUtils.parseTagged((String)args[0]));
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "testmessages2";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return "";
            }

            @Override
            public String description(CommandContext ctx) {
                return "Test command for messaging";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.OPERATOR;
            }

            @Override
            public String permNode() {
                return "commands.operator.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) throws IOException {
                WsPluginMessage msg = new WsPluginMessage();
                msg.messageData.put("abc", "def");
                msg.messageData.put("e", "gh");
                msg.messageData.put(";sl;sl;sl;", ";bb;bb;bb;bb;");
                MessageInfoData obj = new MessageInfoData();
                msg.serialize(obj);
                WsPluginMessage rec = new WsPluginMessage();
                rec.deserialize(obj);
                return "Result:\n" + new XmlMapper().writer().withDefaultPrettyPrinter().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("PluginMessage").writeValueAsString((Object)obj) + "\n\nDecoded: " + new XmlMapper().writer().withDefaultPrettyPrinter().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("PluginMessageData").writeValueAsString((Object)rec.messageData);
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "sendmessage";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return "\"<message>\"";
            }

            @Override
            public String description(CommandContext ctx) {
                return "Test command for messaging";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.OPERATOR;
            }

            @Override
            public String permNode() {
                return "commands.operator.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) throws IOException {
                WsGenericMessage msg = new WsGenericMessage();
                msg.rawObject.typeID = 3;
                msg.rawObject.messageContentNonMembers = msg.rawObject.messageContentMembers = args[0];
                WsMessageService.getInstance().getMessengerFor(ctx.getAccountObject()).sendSessionMessage((WsMessage)msg);
                return "Sent";
            }
        }, new IEdgeServerCommand(){

            @Override
            public String id() {
                return "addxp";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return "<type> <amount>";
            }

            @Override
            public String description(CommandContext ctx) {
                return "Test command for XP";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.OPERATOR;
            }

            @Override
            public String permNode() {
                return "commands.operator.debugcommands";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) throws IOException {
                if (!ctx.getCommandMemory().containsKey("active_profile")) {
                    outputWriteLineCallback.accept("Error: no active profile, please use 'profiles select' before using this command");
                    return null;
                }
                AccountSaveContainer save = AccountManager.getInstance().getAccount(ctx.getCommandMemory().get("active_account").toString()).getSave(ctx.getCommandMemory().get("active_profile").toString());
                int type = Integer.parseInt(args[0]);
                int amount = Integer.parseInt(args[1]);
                AchievementManager.getInstance().getRankForUser(save, RankTypeID.getByTypeID((int)type)).addPoints(amount);
                return "Response:\n" + new XmlMapper().writer().withDefaultPrettyPrinter().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("Rank").writeValueAsString((Object)AchievementManager.getInstance().getRankForUser(save, RankTypeID.getByTypeID((int)type))).trim();
            }
        }};
    }
}

