/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.commands.defaultcommands;

import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.permissions.PermissionLevel;
import org.asf.edge.gameplayapi.commands.CommandContext;
import org.asf.edge.gameplayapi.commands.IEdgeServerCommand;
import org.asf.edge.gameplayapi.commands.TaskBasedCommand;

public class HelpCommand
implements IEdgeServerCommand {
    @Override
    public String id() {
        return "help";
    }

    @Override
    public String syntax(CommandContext ctx) {
        return null;
    }

    @Override
    public String description(CommandContext ctx) {
        return "Retrieves a list of commands";
    }

    @Override
    public PermissionLevel permLevel() {
        return PermissionLevel.GUEST;
    }

    @Override
    public String permNode() {
        return "commands.everyone.help";
    }

    @Override
    public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) {
        Object msg = "List of known commands:";
        for (IEdgeServerCommand cmd : ctx.getRegisteredCommands()) {
            if (!ctx.getPermissions().hasPermission(cmd.permNode(), cmd.permLevel())) continue;
            if (cmd instanceof TaskBasedCommand) {
                msg = (String)msg + this.handleTasks(cmd, ctx, cmd.id() + " ");
                continue;
            }
            msg = (String)msg + "\n - " + cmd.id();
            String syntax = cmd.syntax(ctx);
            if (syntax != null) {
                msg = (String)msg + " " + syntax;
            }
            msg = (String)msg + " - " + cmd.description(ctx);
        }
        return msg;
    }

    private String handleTasks(IEdgeServerCommand cmd, CommandContext ctx, String pref) {
        Object msg = "";
        if (cmd instanceof TaskBasedCommand) {
            TaskBasedCommand cmdT = (TaskBasedCommand)cmd;
            for (IEdgeServerCommand tsk : cmdT.tasks()) {
                if (!ctx.getPermissions().hasPermission(tsk.permNode(), tsk.permLevel())) continue;
                if (tsk instanceof TaskBasedCommand) {
                    msg = (String)msg + this.handleTasks(tsk, ctx, cmd.id() + " ");
                    continue;
                }
                msg = (String)msg + "\n - " + pref + tsk.id();
                String syntax = tsk.syntax(ctx);
                if (syntax != null) {
                    msg = (String)msg + " " + syntax;
                }
                msg = (String)msg + " - " + tsk.description(ctx);
            }
        }
        return msg;
    }
}

