/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.commands;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.permissions.PermissionContext;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.gameplayapi.commands.IEdgeServerCommand;
import org.asf.edge.gameplayapi.commands.defaultcommands.HelpCommand;
import org.asf.edge.gameplayapi.commands.defaultcommands.account.ProfilesCommand;
import org.asf.edge.gameplayapi.commands.defaultcommands.administration.ReloadCommand;
import org.asf.edge.gameplayapi.commands.defaultcommands.administration.RestartCommand;
import org.asf.edge.gameplayapi.commands.defaultcommands.administration.ShutdownCommand;
import org.asf.edge.gameplayapi.commands.defaultcommands.debug.DebugCommands;
import org.asf.edge.gameplayapi.events.commands.CommandSetupEvent;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class CommandContext {
    private Logger logger = LogManager.getLogger((String)"COMMANDS");
    private HashMap<String, Object> commandMemory = new HashMap();
    private ArrayList<IEdgeServerCommand> commands = new ArrayList();
    private boolean logCommands;
    protected static CommandContextImplementationProvider implementationProvider = acc -> new CommandContext(acc);
    private String account;
    private PermissionContext ctx;

    public void enableCommandLogging() {
        this.logCommands = true;
    }

    public CommandContext(AccountObject account) {
        this.account = account.getAccountID();
        this.ctx = PermissionContext.getFor((AccountObject)account);
        this.logger.info("Registering commands...");
        this.registerCommand(new ProfilesCommand());
        this.registerCommand(new ReloadCommand());
        this.registerCommand(new ShutdownCommand());
        this.registerCommand(new RestartCommand());
        if (System.getProperty("debugMode") != null) {
            this.registerCommand(new DebugCommands());
        }
        EventBus.getInstance().dispatchEvent((EventObject)new CommandSetupEvent(this));
        this.registerCommand(new HelpCommand());
    }

    public Map<String, Object> getCommandMemory() {
        return this.commandMemory;
    }

    public IEdgeServerCommand[] getRegisteredCommands() {
        return (IEdgeServerCommand[])this.commands.toArray(IEdgeServerCommand[]::new);
    }

    public void registerCommand(IEdgeServerCommand command) {
        if (this.commands.stream().anyMatch(t -> t.id().equals(command.id()))) {
            throw new IllegalArgumentException("Command already registered: " + command.id());
        }
        this.commands.add(command);
        this.logger.info("Registered command: " + command.id());
    }

    public static CommandContext getFor(AccountObject account) {
        return implementationProvider.getForAccount(account);
    }

    public AccountObject getAccountObject() {
        return AccountManager.getInstance().getAccount(this.account);
    }

    public PermissionContext getPermissions() {
        return this.ctx;
    }

    public boolean runCommand(String command, Consumer<String> outputWriteLineCallback) {
        ArrayList<String> cmd;
        try {
            cmd = this.parseCommand(command);
        }
        catch (Exception e) {
            outputWriteLineCallback.accept("Malformed command: " + command);
            return false;
        }
        if (cmd.size() <= 0) {
            outputWriteLineCallback.accept("Malformed command: " + command + ": missing command ID, please use 'help' for a list of commands");
            return false;
        }
        String id = cmd.get(0);
        cmd.remove(0);
        return this.runCommand(id, (String[])cmd.toArray(String[]::new), outputWriteLineCallback, Map.of());
    }

    public boolean runCommand(String id, String[] args, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) {
        Object cmdStr = id;
        for (String arg : args) {
            cmdStr = arg.contains(" ") ? (String)cmdStr + " \"" + arg.replace("\\\"", "\\\\\"").replace("\"", "\\\"") + "\"" : (String)cmdStr + " " + arg.replace("\\\"", "\\\\\"").replace("\"", "\\\"");
        }
        boolean success = false;
        String result = "Command not found, please use 'help' for a list of commands";
        for (IEdgeServerCommand c : this.commands) {
            if (!c.id().equalsIgnoreCase(id) || !this.getPermissions().hasPermission(c.permNode(), c.permLevel())) continue;
            try {
                result = c.run(args, this, this.logger, t -> {
                    outputWriteLineCallback.accept((String)t);
                    if (this.logCommands) {
                        this.logger.info(id + " (" + this.getAccountObject().getUsername() + ") : " + t);
                    }
                }, dataBlobs);
                if (result == null) break;
                success = true;
            }
            catch (Exception e) {
                result = "An internal server error occured while processing the command";
                success = false;
                this.logger.error("An error occured while processing command '" + (String)cmdStr + "' (issued by " + this.getAccountObject().getUsername() + ")", (Throwable)e);
            }
            break;
        }
        if (result != null) {
            outputWriteLineCallback.accept(result);
            if (this.logCommands) {
                this.logger.info(this.getAccountObject().getUsername() + " issued command: " + (String)cmdStr + " : " + result);
            }
        }
        return success;
    }

    private ArrayList<String> parseCommand(String args) {
        ArrayList<String> args3 = new ArrayList<String>();
        char[] argarray = args.toCharArray();
        boolean ignorespaces = false;
        boolean hasData = false;
        Object last = "";
        int i = 0;
        for (char c : args.toCharArray()) {
            if (c == '\"' && (i == 0 || argarray[i - 1] != '\\')) {
                if (ignorespaces) {
                    ignorespaces = false;
                } else {
                    hasData = true;
                    ignorespaces = true;
                }
            } else if (!(c != ' ' || ignorespaces || i != 0 && argarray[i - 1] == '\\')) {
                if (hasData) {
                    args3.add((String)last);
                }
                hasData = false;
                last = "";
            } else if (c != '\\' || i + 1 < argarray.length && argarray[i + 1] != '\"' && (argarray[i + 1] != ' ' || ignorespaces)) {
                hasData = true;
                last = (String)last + c;
            }
            ++i;
        }
        if (!((String)last).isEmpty()) {
            args3.add((String)last);
        }
        return args3;
    }

    public static interface CommandContextImplementationProvider {
        public CommandContext getForAccount(AccountObject var1);
    }
}

