/*
 * Decompiled with CFR 0.152.
 */
package org.asf.connective.processors;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.asf.connective.ConnectiveHttpServer;
import org.asf.connective.RemoteClient;
import org.asf.connective.headers.HeaderCollection;
import org.asf.connective.objects.HttpRequest;
import org.asf.connective.objects.HttpResponse;

public abstract class HttpRequestProcessor {
    private ConnectiveHttpServer server;
    private HttpResponse response;
    private HttpRequest request;

    public HttpRequestProcessor instantiate(ConnectiveHttpServer server, HttpRequest request, HttpResponse response) {
        HttpRequestProcessor inst = this.createNewInstance();
        inst.server = server;
        inst.response = response;
        inst.request = request;
        return inst;
    }

    protected ConnectiveHttpServer getServer() {
        return this.server;
    }

    protected HeaderCollection getHeaders() {
        return this.getRequest().getHeaders();
    }

    protected String getHeader(String name) {
        return this.getRequest().getHeaderValue(name);
    }

    protected boolean hasHeader(String name) {
        return this.getRequest().hasHeader(name);
    }

    protected void setResponseHeader(String header, String value) {
        this.getResponse().addHeader(header, value);
    }

    protected void setResponseHeader(String header, String value, boolean append) {
        this.getResponse().addHeader(header, value, append);
    }

    protected void setResponseContent(String type, String body) {
        this.getResponse().setContent(type, body);
    }

    protected void setResponseContent(String body) {
        this.setResponseContent("text/plain", body);
    }

    protected void setResponseContent(String type, byte[] body) {
        this.getResponse().setContent(type, body);
    }

    protected void setResponseContent(byte[] body) {
        this.getResponse().setContent(body);
    }

    public HttpResponse setResponseContent(String type, InputStream body) {
        return this.getResponse().setContent(type, body);
    }

    public HttpResponse setResponseContent(InputStream body) {
        return this.getResponse().setContent(body);
    }

    public HttpResponse setResponseContent(String type, InputStream body, long length) {
        return this.getResponse().setContent(type, body, length);
    }

    public HttpResponse setResponseContent(InputStream body, long length) {
        return this.getResponse().setContent(body, length);
    }

    public HttpResponse setResponseStatus(int status, String message) {
        return this.response.setResponseStatus(status, message);
    }

    protected HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public String getRequestPath() {
        return this.getRequest().getRequestPath();
    }

    public String getRequestQuery() {
        return this.getRequest().getRequestQuery();
    }

    public Map<String, String> getRequestQueryParameters() {
        return this.getRequest().getRequestQueryParameters();
    }

    public String getRawRequestResource() {
        return this.getRequest().getRawRequestResource();
    }

    public String getRequestMethod() {
        return this.getRequest().getRequestMethod();
    }

    public abstract String path();

    public boolean supportsChildPaths() {
        return false;
    }

    public abstract void process(String var1, String var2, RemoteClient var3) throws IOException;

    public abstract HttpRequestProcessor createNewInstance();
}

