/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.textfilter.result;

import org.asf.edge.common.services.textfilter.FilterSeverity;
import org.asf.edge.common.services.textfilter.PhraseFilter;

public class WordMatch {
    private String phrase;
    private String reason;
    private String[] variants;
    private FilterSeverity severity;
    private PhraseFilter filter;

    public WordMatch(PhraseFilter filter, String phrase) {
        this.phrase = phrase;
        String[] v = filter.getVariants();
        this.variants = new String[v.length + 1];
        for (int i = 0; i < v.length; ++i) {
            this.variants[i] = v[i];
        }
        this.variants[v.length] = filter.getPhrase();
        this.reason = filter.getReason();
        this.severity = filter.getSeverity();
        this.filter = filter;
    }

    public PhraseFilter getPhraseFilter() {
        return this.filter;
    }

    public FilterSeverity getSeverity() {
        return this.severity;
    }

    public String getMatchedPhrase() {
        return this.phrase;
    }

    public String[] getVariants() {
        return (String[])this.variants.clone();
    }

    public String getReason() {
        return this.reason;
    }
}

