/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.UUID;
import java.util.stream.Stream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.accounts.impl.BasicAccountManager;
import org.asf.edge.common.services.accounts.impl.BasicAccountSaveContainer;
import org.asf.edge.common.services.textfilter.TextFilterService;

public abstract class BasicAccountObject
extends AccountObject {
    private String id;
    protected String username;
    private Logger logger = LogManager.getLogger((String)"AccountManager");
    private static SecureRandom rnd = new SecureRandom();
    private BasicAccountManager manager;
    private AccountDataContainer accountData;
    private Object saveCreateLock = new Object();
    private String[] saveIDs;
    private HashMap<String, AccountSaveContainer> saves = new HashMap();

    public BasicAccountObject(String id, String username, BasicAccountManager manager) {
        this.id = id;
        this.username = username;
        this.manager = manager;
    }

    public Logger getLogger() {
        return this.logger;
    }

    protected BasicAccountManager getManager() {
        return this.manager;
    }

    public abstract boolean performUpdateUsername(String var1);

    public abstract boolean performUpdatePassword(byte[] var1);

    public abstract AccountDataContainer retrieveAccountData();

    protected abstract String[] retrieveSaveIDs();

    public abstract BasicAccountSaveContainer performCreateSave(String var1, String var2);

    public abstract BasicAccountSaveContainer findSave(String var1);

    @Override
    public void ping(boolean addIfNeeded) {
        this.manager.keepInMemory(this, addIfNeeded);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getAccountID() {
        return this.id;
    }

    @Override
    public boolean isOnline() {
        return this.manager.isOnline(this.getAccountID());
    }

    @Override
    public long getLastLoginTime() {
        try {
            JsonElement ele = this.getAccountData().getChildContainer("accountdata").getEntry("lastlogintime");
            if (ele != null) {
                return ele.getAsLong();
            }
            return -1L;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public long getRegistrationTimestamp() {
        try {
            JsonElement ele = this.getAccountData().getChildContainer("accountdata").getEntry("registrationtimestamp");
            if (ele != null) {
                return ele.getAsLong();
            }
            return -1L;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    @Override
    public boolean isGuestAccount() {
        try {
            JsonElement ele = this.getAccountData().getChildContainer("accountdata").getEntry("isguestaccount");
            if (ele == null) {
                return false;
            }
            return ele.getAsBoolean();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isMultiplayerEnabled() {
        try {
            JsonElement ele = this.getAccountData().getChildContainer("accountdata").getEntry("ismultiplayerenabled");
            if (ele == null) {
                return false;
            }
            return ele.getAsBoolean();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isChatEnabled() {
        if (this.isGuestAccount()) {
            return false;
        }
        try {
            JsonElement ele = this.getAccountData().getChildContainer("accountdata").getEntry("ischatenabled");
            if (ele == null) {
                return false;
            }
            return ele.getAsBoolean();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isStrictChatFilterEnabled() {
        try {
            JsonElement ele = this.getAccountData().getChildContainer("accountdata").getEntry("isstrictchatfilterenabled");
            if (ele == null) {
                return false;
            }
            return ele.getAsBoolean();
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean updateUsername(String name) {
        if (!this.manager.isValidUsername(name)) {
            return false;
        }
        if (!(this.isGuestAccount() && Stream.of(this.getSaveIDs()).anyMatch(t -> this.getSave((String)t).getUsername().equalsIgnoreCase(name)) || !this.manager.isUsernameTaken(name))) {
            return false;
        }
        if (TextFilterService.getInstance().isFiltered(name, true)) {
            return false;
        }
        boolean res = this.performUpdateUsername(name);
        if (res) {
            this.username = name;
        }
        return res;
    }

    @Override
    public boolean updatePassword(char[] newPassword) {
        int i;
        if (!this.manager.isValidPassword(new String(newPassword))) {
            return false;
        }
        byte[] salt = BasicAccountObject.salt();
        byte[] hash = BasicAccountObject.getHash(salt, newPassword);
        byte[] cred = new byte[48];
        for (i = 0; i < 32; ++i) {
            cred[i] = salt[i];
        }
        for (i = 32; i < 48; ++i) {
            cred[i] = hash[i - 32];
        }
        return this.performUpdatePassword(cred);
    }

    @Override
    public AccountDataContainer getAccountData() {
        if (this.accountData == null) {
            this.accountData = this.retrieveAccountData();
        }
        return this.accountData;
    }

    @Override
    public boolean migrateToNormalAccountFromGuest(String newName, String email, char[] password) {
        if (!this.isGuestAccount()) {
            return false;
        }
        if (!this.manager.isValidUsername(newName)) {
            return false;
        }
        if (!Stream.of(this.getSaveIDs()).anyMatch(t -> this.getSave((String)t).getUsername().equalsIgnoreCase(newName)) && this.manager.isUsernameTaken(newName)) {
            return false;
        }
        if (!this.manager.isValidPassword(new String(password))) {
            return false;
        }
        if (this.manager.getAccountIDByEmail(email) != null) {
            return false;
        }
        if (TextFilterService.getInstance().isFiltered(newName, true)) {
            return false;
        }
        if (!this.updateUsername(newName)) {
            return false;
        }
        if (!this.updatePassword(password)) {
            return false;
        }
        if (!this.updateEmail(email)) {
            return false;
        }
        try {
            this.getAccountData().getChildContainer("accountdata").setEntry("isguestaccount", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            return true;
        }
        catch (IOException e) {
            this.logger.error("Failed to execute database query request while trying to migrate guest account with  ID '" + this.id + "' to a normal account", (Throwable)e);
            return false;
        }
    }

    @Override
    public void setMultiplayerEnabled(boolean state) {
        try {
            this.getAccountData().getChildContainer("accountdata").setEntry("ismultiplayerenabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(state)));
        }
        catch (IOException e) {
            this.logger.error("Failed to execute database query request while trying to update multiplayer state of ID '" + this.id + "'", (Throwable)e);
        }
    }

    @Override
    public void setChatEnabled(boolean state) {
        try {
            this.getAccountData().getChildContainer("accountdata").setEntry("ischatenabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(state)));
        }
        catch (IOException e) {
            this.logger.error("Failed to execute database query request while trying to update chat state of ID '" + this.id + "'", (Throwable)e);
        }
    }

    @Override
    public void setStrictChatFilterEnabled(boolean state) {
        try {
            this.getAccountData().getChildContainer("accountdata").setEntry("isstrictchatfilterenabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(state)));
        }
        catch (IOException e) {
            this.logger.error("Failed to execute database query request while trying to update chat filter state of ID '" + this.id + "'", (Throwable)e);
        }
    }

    @Override
    public void updateLastLoginTime() {
        try {
            this.getAccountData().getChildContainer("accountdata").setEntry("lastlogintime", (JsonElement)new JsonPrimitive((Number)(System.currentTimeMillis() / 1000L)));
        }
        catch (IOException e) {
            this.logger.error("Failed to execute database query request while trying to update login time of ID '" + this.id + "'", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSaveIDs() {
        if (this.saveIDs != null) {
            return this.saveIDs;
        }
        Object object = this.saveCreateLock;
        synchronized (object) {
            if (this.saveIDs != null) {
                return this.saveIDs;
            }
            String[] ids = this.retrieveSaveIDs();
            this.saveIDs = ids;
            return ids;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountSaveContainer createSave(String username) {
        if (!this.manager.isValidUsername(username)) {
            return null;
        }
        if (!username.equalsIgnoreCase(this.username) && this.manager.isUsernameTaken(username)) {
            return null;
        }
        if (TextFilterService.getInstance().isFiltered(username, true)) {
            return null;
        }
        String saveID = UUID.randomUUID().toString();
        while (true) {
            String svID = saveID;
            if (!Stream.of(this.getSaveIDs()).anyMatch(t -> t.equals(svID))) break;
            saveID = UUID.randomUUID().toString();
        }
        BasicAccountSaveContainer sv = this.performCreateSave(saveID, username);
        if (sv != null) {
            Object object = this.saveCreateLock;
            synchronized (object) {
                if (this.saveIDs == null) {
                    String[] ids = this.retrieveSaveIDs();
                    this.saveIDs = ids;
                }
                String[] newIds = new String[this.saveIDs.length + 1];
                for (int i = 0; i < newIds.length; ++i) {
                    newIds[i] = i == this.saveIDs.length ? ((AccountSaveContainer)sv).getSaveID() : this.saveIDs[i];
                }
                this.saveIDs = newIds;
            }
        }
        return sv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AccountSaveContainer getSave(String id) {
        while (true) {
            try {
                if (this.saves.containsKey(id)) {
                    return this.saves.get(id);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        HashMap<String, AccountSaveContainer> hashMap = this.saves;
        synchronized (hashMap) {
            if (this.saves.containsKey(id)) {
                return this.saves.get(id);
            }
            BasicAccountSaveContainer sv = this.findSave(id);
            if (sv != null) {
                this.saves.put(id, sv);
            }
            return sv;
        }
    }

    public void refreshSaveList() {
        this.saveIDs = null;
        this.getSaveIDs();
    }

    private static byte[] salt() {
        byte[] salt = new byte[32];
        rnd.nextBytes(salt);
        return salt;
    }

    private static byte[] getHash(byte[] salt, char[] password) {
        PBEKeySpec spec = new PBEKeySpec(password, salt, 65536, 128);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            return factory.generateSecret(spec).getEncoded();
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            return null;
        }
    }
}

