/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.remapping;

import java.util.Arrays;
import org.asf.cyan.fluid.Fluid;
import org.asf.cyan.fluid.Transformer;
import org.asf.cyan.fluid.bytecode.FluidClassPool;
import org.asf.cyan.fluid.deobfuscation.DeobfuscationTarget;
import org.asf.cyan.fluid.deobfuscation.DeobfuscationTargetMap;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class SupertypeRemapper {
    private DeobfuscationTargetMap mappings;
    private FluidClassPool pool;

    public SupertypeRemapper(DeobfuscationTargetMap initialMappings) {
        this.mappings = initialMappings;
    }

    public SupertypeRemapper(DeobfuscationTargetMap initialMappings, FluidClassPool pool) {
        this.mappings = initialMappings;
        this.pool = pool;
    }

    public ClassNode remap(ClassNode input) {
        DeobfuscationTarget clsTarget = new DeobfuscationTarget();
        clsTarget.outputName = input.name.replace("/", ".");
        clsTarget.jvmName = input.name;
        if (input.superName != null && !input.superName.equals("java/lang/Object")) {
            if (this.pool != null) {
                try {
                    this.remap(this.pool.getClassNode(input.superName));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            this.mappings.forEach((type, target) -> {
                if (type.equals(input.superName)) {
                    for (String fieldKey : target.fields.keySet()) {
                        clsTarget.fields.putIfAbsent(fieldKey, target.fields.get(fieldKey));
                    }
                    for (String mthKey : target.methods.keySet()) {
                        clsTarget.methods.putIfAbsent(mthKey, target.methods.get(mthKey));
                    }
                    this.remap(input, (String)type, (DeobfuscationTarget)target);
                }
            });
        }
        if (input.interfaces != null) {
            for (String interfaceName : input.interfaces) {
                if (this.pool != null) {
                    try {
                        this.remap(this.pool.getClassNode(interfaceName));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                this.mappings.forEach((type, target) -> {
                    if (type.equals(interfaceName)) {
                        for (String fieldKey : target.fields.keySet()) {
                            clsTarget.fields.putIfAbsent(fieldKey, target.fields.get(fieldKey));
                        }
                        for (String mthKey : target.methods.keySet()) {
                            clsTarget.methods.putIfAbsent(mthKey, target.methods.get(mthKey));
                        }
                        this.remap(input, (String)type, (DeobfuscationTarget)target);
                    }
                });
            }
        }
        this.mappings.putIfAbsent(input.name, clsTarget);
        return input;
    }

    private void remap(ClassNode input, String typeName, DeobfuscationTarget type) {
        for (MethodNode mth : input.methods) {
            for (String method : type.methods.keySet()) {
                String deobf = type.methods.get(method);
                String name = method.substring(0, method.indexOf(" "));
                String desc = method.substring(method.indexOf(" ") + 1);
                if (!name.equals(mth.name)) continue;
                String returnType = Fluid.parseDescriptor(desc.substring(desc.indexOf(")") + 1));
                Object[] types = Fluid.parseMultipleDescriptors(desc.substring(1, desc.indexOf(")")));
                Transformer.FluidMethodInfo meth = Transformer.FluidMethodInfo.create(mth);
                if (!meth.returnType.equals(returnType) || !Arrays.equals(types, meth.types)) continue;
                mth.name = deobf;
            }
            for (AbstractInsnNode instr : mth.instructions) {
                if (!(instr instanceof FieldInsnNode)) continue;
                FieldInsnNode fld = (FieldInsnNode)instr;
                for (String field : type.fields.keySet()) {
                    String deobf = type.fields.get(field);
                    String name = field.substring(0, field.indexOf(" "));
                    String fieldType = field.substring(field.indexOf(" ") + 1);
                    if (!name.equals(fld.name) || !fld.owner.equals(input.name) && !fld.owner.equals(typeName) || !fld.desc.equals(fieldType)) continue;
                    fld.name = deobf;
                }
            }
        }
    }
}

