/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.http.apihandlerutils;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.entities.items.PlayerInventory;
import org.asf.edge.common.http.apihandlerutils.HttpException;
import org.asf.edge.common.http.apihandlerutils.functions.AccountData;
import org.asf.edge.common.http.apihandlerutils.functions.AccountInventory;
import org.asf.edge.common.http.apihandlerutils.functions.Function;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionResult;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.SaveData;
import org.asf.edge.common.http.apihandlerutils.functions.SaveInventory;
import org.asf.edge.common.http.apihandlerutils.functions.SodEncryptedParam;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequest;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequestParam;
import org.asf.edge.common.http.apihandlerutils.functions.SodTokenSecured;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireCapabilities;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireCapability;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireSave;
import org.asf.edge.common.http.cookies.CookieContext;
import org.asf.edge.common.http.cookies.CookieManager;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.common.tokens.TokenParseResult;
import org.asf.edge.common.util.TripleDesUtil;
import org.bouncycastle.util.encoders.Base32;

public abstract class EdgeWebService<T extends IBaseServer>
extends HttpPushProcessor {
    private static XmlMapper mapper = new XmlMapper();
    public static HashMap<String, String> API_SECRET_MAP;
    private Utilities utils = new Utilities();
    private HashMap<String, Method> functions = new HashMap();
    private HashMap<String, Method> legacyFunctions = new HashMap();
    private CookieContext cookies;
    private T server;

    public EdgeWebService(T server) {
        this.server = server;
        this.initialize();
    }

    private void initialize() {
        for (Method meth : ((Object)((Object)this)).getClass().getMethods()) {
            Function funcAnno;
            if (Modifier.isAbstract(meth.getModifiers()) || Modifier.isStatic(meth.getModifiers())) continue;
            if (meth.getParameterCount() == 1 && LegacyFunctionInfo.class.isAssignableFrom(meth.getParameterTypes()[0])) {
                if (!meth.isAnnotationPresent(LegacyFunction.class)) continue;
                LegacyFunction funcAnno2 = meth.getAnnotation(LegacyFunction.class);
                String name = meth.getName();
                if (!funcAnno2.value().equals("<auto>")) {
                    name = funcAnno2.value();
                }
                meth.setAccessible(true);
                this.legacyFunctions.put(name.toLowerCase(), meth);
                continue;
            }
            if (!meth.isAnnotationPresent(Function.class) && !meth.isAnnotationPresent(SodRequest.class) || !FunctionResult.class.isAssignableFrom(meth.getReturnType()) || !meth.isAnnotationPresent(SodRequest.class) && (meth.getParameterTypes().length != 1 || !meth.getParameterTypes()[0].isAssignableFrom(FunctionInfo.class))) continue;
            String name = meth.getName();
            if (meth.isAnnotationPresent(Function.class) && !(funcAnno = meth.getAnnotation(Function.class)).value().equals("<auto>")) {
                name = funcAnno.value();
            }
            meth.setAccessible(true);
            this.functions.put(name.toLowerCase(), meth);
        }
    }

    protected T getServerInstance() {
        return this.server;
    }

    protected CookieContext getCookies() {
        if (this.cookies == null) {
            this.cookies = CookieManager.getCookies(this.getRequest(), this.getResponse());
        }
        return this.cookies;
    }

    public void process(String path, String method, RemoteClient client, String contentType) throws IOException {
        block26: {
            if ((path = this.sanitizePath(path.substring(this.path().length()))).startsWith("/")) {
                path = path.substring(1);
            }
            if (path.isEmpty()) {
                this.setResponseStatus(404, "Not found");
                return;
            }
            if (path.startsWith("..") || path.endsWith("..") || path.contains("/..") || path.contains("../")) {
                this.setResponseStatus(403, "Forbidden");
                return;
            }
            try {
                if (this.functions.containsKey(path.toLowerCase())) {
                    Method mth = this.functions.get(path.toLowerCase());
                    if (mth.isAnnotationPresent(Function.class)) {
                        Function anno = mth.getAnnotation(Function.class);
                        boolean allowed = false;
                        for (String meth : anno.allowedMethods()) {
                            if (!meth.equalsIgnoreCase(method)) continue;
                            allowed = true;
                            break;
                        }
                        if (!allowed) {
                            this.setResponseStatus(405, "Method not allowed");
                            return;
                        }
                    }
                    try {
                        FunctionInfo fI = new FunctionInfo(path, this.getRequest(), this.getResponse(), this.getServer(), method, client, contentType, this.getCookies());
                        Object[] args = new Object[]{fI};
                        if (mth.isAnnotationPresent(SodRequest.class)) {
                            ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(this.getServerInstance().getLogger());
                            if (req == null) {
                                this.getResponse().setResponseStatus(400, "Bad request");
                                return;
                            }
                            args = this.populateArguments(mth, fI, req);
                        }
                        FunctionResult res = (FunctionResult)mth.invoke((Object)this, args);
                        this.setResponseStatus(res.getStatusCode(), res.getStatusMessage());
                        if (res.hasResponseBody()) {
                            if (res.getContentLength() != -1L) {
                                if (res.getResponseMediaType() != null) {
                                    this.setResponseContent(res.getResponseMediaType(), res.getResponseBodyStream(), res.getContentLength());
                                } else {
                                    this.setResponseContent(res.getResponseBodyStream(), res.getContentLength());
                                }
                            } else if (res.getResponseMediaType() != null) {
                                this.setResponseContent(res.getResponseMediaType(), res.getResponseBodyStream());
                            } else {
                                this.setResponseContent(res.getResponseBodyStream());
                            }
                        }
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    return;
                }
                if (this.legacyFunctions.containsKey(path.toLowerCase())) {
                    Method mth = this.legacyFunctions.get(path.toLowerCase());
                    LegacyFunction anno = mth.getAnnotation(LegacyFunction.class);
                    boolean allowed = false;
                    for (String meth : anno.allowedMethods()) {
                        if (!meth.equalsIgnoreCase(method)) continue;
                        allowed = true;
                        break;
                    }
                    if (!allowed) {
                        this.setResponseStatus(405, "Method not allowed");
                        return;
                    }
                    try {
                        mth.invoke((Object)this, new LegacyFunctionInfo(path, this.getRequest(), this.getResponse(), this.getServer(), method, client, contentType, this.getCookies()));
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                    return;
                }
                this.setResponseStatus(404, "Not found");
                this.fallbackRequestProcessor(path, method, client, contentType);
            }
            catch (HttpException e) {
                this.setResponseStatus(e.getStatusCode(), e.getStatusMessage());
                if (e.getBody() == null) break block26;
                if (e.getBodyMediaType() == null) {
                    this.setResponseContent(e.getBody());
                }
                this.setResponseContent(e.getBodyMediaType(), e.getBody());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private Object[] populateArguments(Method mth, FunctionInfo fI, ServiceRequestInfo req) throws IOException {
        params = mth.getParameters();
        args = new Object[params.length];
        pendingException = null;
        tkn = null;
        account = null;
        save = null;
        if (mth.isAnnotationPresent(SodTokenSecured.class)) {
            if (!req.payload.containsKey("apiToken")) {
                pendingException = new HttpException(400, "Bad request");
            } else {
                apiToken = this.getUtilities().decodeToken(req.payload.get("apiToken").toUpperCase());
                tkn = new SessionToken();
                res = tkn.parseToken(apiToken);
                account = tkn.account;
                if (res != TokenParseResult.SUCCESS) {
                    pendingException = new HttpException(401, "Unauthorized");
                    tkn = null;
                    account = null;
                }
                if (tkn != null && mth.isAnnotationPresent(TokenRequireCapabilities.class)) {
                    caps = mth.getAnnotation(TokenRequireCapabilities.class);
                    for (TokenRequireCapability c : caps.value()) {
                        if (tkn.hasCapability(c.value())) continue;
                        pendingException = new HttpException(401, "Unauthorized");
                        account = null;
                        tkn = null;
                        break;
                    }
                }
                if (tkn != null) {
                    if (tkn.saveID != null) {
                        save = account.getSave(tkn.saveID);
                    } else if (mth.isAnnotationPresent(TokenRequireSave.class)) {
                        pendingException = new HttpException(401, "Unauthorized");
                    }
                }
            }
        }
        for (i = 0; i < args.length; ++i) {
            block72: {
                block73: {
                    param = params[i];
                    if (param.getType().isAssignableFrom(FunctionInfo.class)) {
                        args[i] = fI;
                        continue;
                    }
                    if (param.getType().isAssignableFrom(ServiceRequestInfo.class)) {
                        args[i] = req;
                        continue;
                    }
                    if (param.getType().isAssignableFrom(AccountObject.class)) {
                        args[i] = account;
                        continue;
                    }
                    if (param.getType().isAssignableFrom(AccountSaveContainer.class)) {
                        args[i] = save;
                        continue;
                    }
                    if (param.getType().isAssignableFrom(SessionToken.class)) {
                        args[i] = tkn;
                        continue;
                    }
                    if (param.getType().isAssignableFrom(PlayerInventory.class) && param.isAnnotationPresent(SaveInventory.class)) {
                        if (save != null) {
                            args[i] = save.getInventory();
                            continue;
                        }
                        if (account == null) continue;
                        args[i] = account.getInventory();
                        continue;
                    }
                    if (param.getType().isAssignableFrom(PlayerInventory.class) && param.isAnnotationPresent(AccountInventory.class)) {
                        if (save != null) {
                            args[i] = save.getInventory();
                            continue;
                        }
                        if (account == null) continue;
                        pendingException = new HttpException(400, "Bad request");
                        continue;
                    }
                    if (param.getType().isAssignableFrom(PlayerInventory.class)) {
                        if (save != null) {
                            args[i] = save.getInventory();
                            continue;
                        }
                        args[i] = account.getInventory();
                        continue;
                    }
                    if (param.getType().isAssignableFrom(AccountDataContainer.class) && param.isAnnotationPresent(AccountData.class)) {
                        if (account != null) {
                            args[i] = account.getAccountData();
                            continue;
                        }
                        pendingException = new HttpException(400, "Bad request");
                        continue;
                    }
                    if (param.getType().isAssignableFrom(AccountDataContainer.class) && param.isAnnotationPresent(SaveData.class)) {
                        if (save != null) {
                            args[i] = save.getSaveData();
                            continue;
                        }
                        pendingException = new HttpException(400, "Bad request");
                        continue;
                    }
                    if (!param.isAnnotationPresent(SodRequestParam.class)) break block72;
                    name = param.getAnnotation(SodRequestParam.class).value();
                    if (name.isEmpty()) {
                        name = param.getName();
                    }
                    if ((val = req.payload.get(name)) == null) {
                        pendingException = new HttpException(400, "Bad request");
                        continue;
                    }
                    try {
                        if (param.isAnnotationPresent(SodEncryptedParam.class)) {
                            val = req.decryptString(val);
                        }
                    }
                    catch (Exception e) {
                        pendingException = new HttpException(400, "Bad request");
                    }
                    if (val == null) continue;
                    if (!param.getType().isPrimitive()) break block73;
                    e = param.getType().getTypeName();
                    var15_19 = -1;
                    switch (e.hashCode()) {
                        case 64711720: {
                            if (!e.equals("boolean")) break;
                            var15_19 = 0;
                            break;
                        }
                        case 3039496: {
                            if (!e.equals("byte")) break;
                            var15_19 = 1;
                            break;
                        }
                        case 3052374: {
                            if (!e.equals("char")) break;
                            var15_19 = 2;
                            break;
                        }
                        case 109413500: {
                            if (!e.equals("short")) break;
                            var15_19 = 3;
                            break;
                        }
                        case 104431: {
                            if (!e.equals("int")) break;
                            var15_19 = 4;
                            break;
                        }
                        case 3327612: {
                            if (!e.equals("long")) break;
                            var15_19 = 5;
                            break;
                        }
                        case 97526364: {
                            if (!e.equals("float")) break;
                            var15_19 = 6;
                            break;
                        }
                        case -1325958191: {
                            if (!e.equals("double")) break;
                            var15_19 = 7;
                        }
                    }
                    switch (var15_19) {
                        case 0: {
                            if (!val.equalsIgnoreCase("true")) ** GOTO lbl136
                            args[i] = true;
                            ** GOTO lbl140
lbl136:
                            // 1 sources

                            if (val.equalsIgnoreCase("false")) {
                                args[i] = false;
                            } else {
                                pendingException = new HttpException(400, "Bad request");
                            }
                        }
lbl140:
                        // 4 sources

                        case 1: {
                            try {
                                args[i] = Byte.parseByte(val);
                            }
                            catch (Exception e) {
                                pendingException = new HttpException(400, "Bad request");
                            }
                        }
                        case 2: {
                            try {
                                if (val.length() != 1) {
                                    throw new Exception();
                                }
                                args[i] = Character.valueOf(val.charAt(0));
                            }
                            catch (Exception e) {
                                pendingException = new HttpException(400, "Bad request");
                            }
                        }
                        case 3: {
                            try {
                                args[i] = Short.parseShort(val);
                            }
                            catch (Exception e) {
                                pendingException = new HttpException(400, "Bad request");
                            }
                        }
                        case 4: {
                            try {
                                args[i] = Integer.parseInt(val);
                            }
                            catch (Exception e) {
                                pendingException = new HttpException(400, "Bad request");
                            }
                        }
                        case 5: {
                            try {
                                args[i] = Long.parseLong(val);
                            }
                            catch (Exception e) {
                                pendingException = new HttpException(400, "Bad request");
                            }
                        }
                        case 6: {
                            try {
                                args[i] = Float.valueOf(Float.parseFloat(val));
                            }
                            catch (Exception e) {
                                pendingException = new HttpException(400, "Bad request");
                            }
                        }
                        case 7: {
                            try {
                                args[i] = Double.parseDouble(val);
                                break;
                            }
                            catch (Exception e) {
                                pendingException = new HttpException(400, "Bad request");
                            }
                        }
                    }
                    continue;
                }
                if (param.getType().isAssignableFrom(String.class)) {
                    args[i] = val;
                    continue;
                }
                try {
                    args[i] = req.parseXmlValue(val, param.getType());
                }
                catch (Exception e) {
                    pendingException = new HttpException(400, "Bad request");
                }
                continue;
            }
            throw new RuntimeException("Invalid parameter " + param.getName() + " in method " + mth.getName() + " of " + this.getClass().getTypeName() + "!");
        }
        if (pendingException != null) {
            throw pendingException;
        }
        return args;
    }

    protected void fallbackRequestProcessor(String path, String method, RemoteClient client, String contentType) throws IOException {
    }

    protected String sanitizePath(String path) {
        while (((String)path).startsWith("/")) {
            path = ((String)path).substring(1);
        }
        while (((String)path).endsWith("/")) {
            path = ((String)path).substring(0, ((String)path).length() - 1);
        }
        while (((String)path).contains("//")) {
            path = ((String)path).replace("//", "/");
        }
        if (((String)path).contains("\\")) {
            path = ((String)path).replace("\\", "/");
        }
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return path;
    }

    public boolean supportsNonPush() {
        return true;
    }

    public boolean supportsChildPaths() {
        return true;
    }

    protected Utilities getUtilities() {
        return this.utils;
    }

    public FunctionResult ok() {
        return new FunctionResult(200, "OK");
    }

    public FunctionResult ok(String mediaType, InputStream responseBody) {
        return new FunctionResult(200, "OK", mediaType, responseBody);
    }

    public FunctionResult ok(InputStream responseBody) {
        return new FunctionResult(200, "OK", responseBody);
    }

    public FunctionResult ok(String mediaType, long contentLength, InputStream responseBody) {
        return new FunctionResult(200, "OK", mediaType, contentLength, responseBody);
    }

    public FunctionResult ok(long contentLength, InputStream responseBody) {
        return new FunctionResult(200, "OK", contentLength, responseBody);
    }

    public FunctionResult ok(String mediaType, byte[] responseBody) {
        return new FunctionResult(200, "OK", mediaType, responseBody);
    }

    public FunctionResult ok(byte[] responseBody) {
        return new FunctionResult(200, "OK", responseBody);
    }

    public FunctionResult ok(String mediaType, String responseBody) {
        return new FunctionResult(200, "OK", mediaType, responseBody);
    }

    public FunctionResult ok(String responseBody) {
        return new FunctionResult(200, "OK", responseBody);
    }

    public FunctionResult response(int statusCode, String statusMessage) {
        return new FunctionResult(statusCode, statusMessage);
    }

    public FunctionResult response(int statusCode, String statusMessage, String mediaType, InputStream responseBody) {
        return new FunctionResult(statusCode, statusMessage, mediaType, responseBody);
    }

    public FunctionResult response(int statusCode, String statusMessage, InputStream responseBody) {
        return new FunctionResult(statusCode, statusMessage, responseBody);
    }

    public FunctionResult response(int statusCode, String statusMessage, String mediaType, long contentLength, InputStream responseBody) {
        return new FunctionResult(statusCode, statusMessage, mediaType, contentLength, responseBody);
    }

    public FunctionResult response(int statusCode, String statusMessage, long contentLength, InputStream responseBody) {
        return new FunctionResult(statusCode, statusMessage, contentLength, responseBody);
    }

    public FunctionResult response(int statusCode, String statusMessage, String mediaType, byte[] responseBody) {
        return new FunctionResult(statusCode, statusMessage, mediaType, responseBody);
    }

    public FunctionResult response(int statusCode, String statusMessage, byte[] responseBody) {
        return new FunctionResult(statusCode, statusMessage, responseBody);
    }

    public FunctionResult response(int statusCode, String statusMessage, String mediaType, String responseBody) {
        return new FunctionResult(statusCode, statusMessage, mediaType, responseBody);
    }

    public FunctionResult response(int statusCode, String statusMessage, String responseBody) {
        return new FunctionResult(statusCode, statusMessage, responseBody);
    }

    static {
        mapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        API_SECRET_MAP = new HashMap();
        API_SECRET_MAP.put("B99F695C-7C6E-4E9B-B0F7-22034D799013", "56BB211B-CF06-48E1-9C1D-E40B5173D759");
        API_SECRET_MAP.put("44C9E925-2D98-41E8-BF62-F8E90B4A5EE1", "AE38AF03-65C1-4952-A59A-8103A8D1BA2A");
        API_SECRET_MAP.put("E323F1BA-FDFF-458A-8F36-8A2D5AE8A9F2", "E1B45D11-19EE-4981-B32E-BC33B2459696");
        API_SECRET_MAP.put("7DA5F99D-997D-429C-B4B0-F95574A250E7", "2C0CF98F-9B36-40D1-B059-98644A30848D");
        API_SECRET_MAP.put("FE543944-3F16-4E02-986C-C68C43C16F07", "F5D573D9-CDB3-4142-9462-F2A5DEF0B7E8");
        API_SECRET_MAP.put("A4BEFEA1-DC93-4967-A9E7-5E34F74D12FD", "702189B9-B4EA-4B4D-9D9B-84D54445DEF1");
        API_SECRET_MAP.put("1E7CCC3A-4ADB-4736-B843-7B3DA5140A43", "8ADB1B50-91F7-4829-BEEF-82152C6DB752");
        API_SECRET_MAP.put("4CDC7F80-C2D1-4053-9888-8B65B1A0B504", "5469D6A0-098D-424A-BDE3-B096149B1823");
        API_SECRET_MAP.put("515AF675-BEC7-4C42-BA64-7BFAF198D8EA", "7D175215-56D3-4495-BC3E-F55EA92B06A5");
        API_SECRET_MAP.put("654A7A73-3BC2-4DD3-8DD9-FA79A1DE9835", "AF44CDF2-CEC5-4B40-940C-A9ECA7AD7587");
        API_SECRET_MAP.put("37C8DE45-EE55-4E41-8264-6F5B435D75F7", "A8EB209C-CD3E-4737-BA69-3DDCE3A87263");
    }

    protected class Utilities {
        protected Utilities() {
        }

        public Map<String, String> parseForm(String payload) {
            HashMap<String, String> frm = new HashMap<String, String>();
            Object key = "";
            Object value = "";
            boolean isKey = true;
            for (int i = 0; i < payload.length(); ++i) {
                char ch = payload.charAt(i);
                if (ch == '&') {
                    if (isKey && !((String)key).isEmpty()) {
                        frm.put((String)key, "");
                        key = "";
                        continue;
                    }
                    if (isKey || ((String)key).isEmpty()) continue;
                    try {
                        frm.put((String)key, URLDecoder.decode((String)value, "UTF-8"));
                    }
                    catch (Exception e) {
                        frm.put((String)key, (String)value);
                    }
                    isKey = true;
                    key = "";
                    value = "";
                    continue;
                }
                if (ch == '=') {
                    isKey = !isKey;
                    continue;
                }
                if (isKey) {
                    key = (String)key + ch;
                    continue;
                }
                value = (String)value + ch;
            }
            if (!((String)key).isEmpty() || !((String)value).isEmpty()) {
                try {
                    frm.put((String)key, URLDecoder.decode((String)value, "UTF-8"));
                }
                catch (Exception e) {
                    frm.put((String)key, (String)value);
                }
            }
            return frm;
        }

        public String getApiKeyFromRequest() throws IOException {
            if (!(EdgeWebService.this.getRequest().hasRequestBody() && EdgeWebService.this.getRequest().hasHeader("Content-Type") && EdgeWebService.this.getRequest().getHeaderValue("Content-Type").equals("application/x-www-form-urlencoded"))) {
                EdgeWebService.this.getResponse().setResponseStatus(400, "Bad request");
                return null;
            }
            String payload = EdgeWebService.this.getRequest().getRequestBodyAsString();
            Map<String, String> requestData = this.parseForm(payload);
            if (!requestData.containsKey("apiKey")) {
                EdgeWebService.this.getResponse().setResponseStatus(400, "Bad request");
                return null;
            }
            return requestData.get("apiKey");
        }

        public ServiceRequestInfo getServiceRequestPayload(Logger logger) throws IOException {
            if (!(EdgeWebService.this.getRequest().hasRequestBody() && EdgeWebService.this.getRequest().hasHeader("Content-Type") && EdgeWebService.this.getRequest().getHeaderValue("Content-Type").equals("application/x-www-form-urlencoded"))) {
                EdgeWebService.this.getResponse().setResponseStatus(400, "Bad request");
                return null;
            }
            String payload = EdgeWebService.this.getRequest().getRequestBodyAsString();
            Map<String, String> requestData = this.parseForm(payload);
            if (!requestData.containsKey("apiKey")) {
                EdgeWebService.this.getResponse().setResponseStatus(400, "Bad request");
                return null;
            }
            String apiKey = requestData.get("apiKey");
            String secret = EdgeWebService.this.getUtilities().getSecretFromKey(apiKey, logger);
            byte[] key = EdgeWebService.this.getUtilities().encodeMD5Key(secret, "UTF-16LE");
            ServiceRequestInfo info = new ServiceRequestInfo();
            info.apiKey = apiKey;
            info.apiSecret = secret;
            info.desKey = key;
            info.payload = requestData;
            return info;
        }

        public String getSecretFromKey(String apiKey, Logger logger) {
            String secret = "56BB211B-CF06-48E1-9C1D-E40B5173D759";
            if (API_SECRET_MAP.containsKey(apiKey.toUpperCase())) {
                secret = API_SECRET_MAP.get(apiKey.toUpperCase());
            } else {
                logger.warn("No secret for API key " + apiKey + ", using default!");
            }
            return secret;
        }

        public byte[] encodeMD5Key(String secret, String encoding) {
            byte[] key;
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                key = digest.digest(secret.getBytes(encoding));
            }
            catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            return key;
        }

        public String decodeToken(String token) throws IOException {
            return new String(Base32.decode((String)token), "UTF-8");
        }

        public String encodeToken(String token) throws IOException {
            return Base32.toBase32String((byte[])token.getBytes("UTF-8"));
        }
    }

    protected class ServiceRequestInfo {
        public String apiKey;
        public String apiSecret;
        public byte[] desKey;
        public Map<String, String> payload;

        protected ServiceRequestInfo() {
        }

        public <T2> T2 parseXmlValue(String value, Class<T2> cls) throws IOException {
            try {
                return (T2)mapper.readValue(value, cls);
            }
            catch (JsonProcessingException e) {
                throw new IOException("Invalid data", e);
            }
        }

        public String generateXmlValue(String rootElementName, Object data) throws IOException {
            try {
                return mapper.writer().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName(rootElementName).writeValueAsString(data);
            }
            catch (JsonProcessingException e) {
                throw new IOException("Encoding failure", e);
            }
        }

        public String getEncryptedValue(String key) throws IOException {
            String encrypted = this.payload.get(key);
            return this.decryptString(encrypted);
        }

        public String decryptString(String data) throws IOException {
            byte[] enc = Base64.getDecoder().decode(data);
            byte[] dec = TripleDesUtil.decrypt(enc, this.desKey);
            String val = new String(dec, "UTF-16LE");
            return val;
        }

        public String generateEncryptedResponse(String data) throws IOException {
            return this.generateXmlValue("string", this.generateEncryptedString(data));
        }

        public String generateEncryptedString(String value) throws IOException {
            byte[] enc = TripleDesUtil.encrypt(value.getBytes("UTF_16LE"), this.desKey);
            return Base64.getEncoder().encodeToString(enc);
        }
    }
}

