/*
 * Decompiled with CFR 0.152.
 */
package org.asf.connective;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.ConnectiveHttpServer;
import org.asf.connective.objects.HttpRequest;
import org.asf.connective.objects.HttpResponse;

public abstract class RemoteClient {
    private Logger logger = LogManager.getLogger((String)"connective-http");
    private ConnectiveHttpServer server;
    private Function<HttpRequest, HttpResponse> responseCreator;

    protected RemoteClient(ConnectiveHttpServer server, Function<HttpRequest, HttpResponse> responseCreator) {
        this.server = server;
        this.responseCreator = responseCreator;
    }

    protected Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processRequest(HttpRequest request) throws IOException {
        HttpResponse resp = this.createResponse(request);
        try {
            if (!this.server.getContentSource().process(request.getRequestPath(), request, resp, this, this.server)) {
                if (!(request.getRequestMethod().equals("GET") || request.getRequestMethod().equals("PUT") || request.getRequestMethod().equals("DELETE") || request.getRequestMethod().equals("PATCH") || request.getRequestMethod().equals("POST") || request.getRequestMethod().equals("HEAD"))) {
                    resp.setResponseStatus(405, "Unsupported request");
                    this.logger.error(resp.getHttpVersion() + " " + request.getRequestMethod() + " " + request.getRawRequestResource() + " : " + resp.getResponseCode() + " " + resp.getResponseMessage() + " [" + this.getRemoteAddress() + "]");
                } else {
                    resp.setResponseStatus(404, "Not found");
                    this.logger.error(resp.getHttpVersion() + " " + request.getRequestMethod() + " " + request.getRawRequestResource() + " : " + resp.getResponseCode() + " " + resp.getResponseMessage() + " [" + this.getRemoteAddress() + "]");
                }
            } else if (!resp.isSuccessResponseCode()) {
                this.logger.error(resp.getHttpVersion() + " " + request.getRequestMethod() + " " + request.getRawRequestResource() + " : " + resp.getResponseCode() + " " + resp.getResponseMessage() + " [" + this.getRemoteAddress() + "]");
            } else {
                this.logger.info(resp.getHttpVersion() + " " + request.getRequestMethod() + " " + request.getRawRequestResource() + " : " + resp.getResponseCode() + " " + resp.getResponseMessage() + " [" + this.getRemoteAddress() + "]");
            }
            if (!resp.hasResponseBody() && !resp.isSuccessResponseCode()) {
                resp.setContent("text/html", this.server.getErrorPageGenerator().apply(resp, request));
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            resp.addHeader("Date", dateFormat.format(new Date()));
            this.postProcessResponse(resp, request);
            this.sendResponse(resp, request);
        }
        finally {
            if (resp.getBodyStream() != null) {
                try {
                    resp.getBodyStream().close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected HttpResponse createResponse(HttpRequest request) {
        HttpResponse resp = this.responseCreator.apply(request);
        resp.addHeader("Server", this.server.getServerName());
        for (String name : this.server.getDefaultHeaders().getHeaderNames()) {
            if (resp.hasHeader(name)) continue;
            resp.addHeader(name, this.server.getDefaultHeaders().getHeaderValue(name));
        }
        return resp;
    }

    protected abstract void postProcessResponse(HttpResponse var1, HttpRequest var2);

    protected abstract void sendResponse(HttpResponse var1, HttpRequest var2) throws IOException;

    public abstract String getRemoteAddress();

    public abstract String getRemoteHost();

    public abstract int getRemotePort();

    public abstract OutputStream getOutputStream();

    public abstract InputStream getInputStream();

    public abstract boolean isConnected();

    public abstract void closeConnection();

    public ConnectiveHttpServer getServer() {
        return this.server;
    }
}

