/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultCaret;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.asf.connective.tasks.AsyncTaskManager;

public class LogWindow {
    public JFrame frm;
    public static boolean shown = false;
    private static ArrayList<String> commandHistory = new ArrayList();
    private static int commandIndex = -1;
    public static Consumer<String> commandCallback = null;
    private JTextArea textArea = new JTextArea();
    private JPanel contentPane;
    private JTextField textField;

    public void log(String message) {
        if (!shown) {
            return;
        }
        this.textArea.setText(this.textArea.getText() + message + "\n");
        this.textArea.setCaretPosition(this.textArea.getDocument().getLength());
    }

    public LogWindow() {
        if (shown) {
            this.frm = new JFrame();
            this.frm.setTitle("Project Edge");
            this.frm.setDefaultCloseOperation(2);
            this.frm.setBounds(100, 100, 900, 500);
            this.frm.setResizable(true);
            this.frm.setLocationRelativeTo(null);
        }
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        if (shown) {
            this.frm.setContentPane(this.contentPane);
        }
        this.textArea.setEditable(false);
        JScrollPane pane = new JScrollPane(this.textArea);
        pane.setVerticalScrollBarPolicy(22);
        DefaultCaret caret = (DefaultCaret)this.textArea.getCaret();
        caret.setUpdatePolicy(2);
        this.textField = new JTextField();
        this.textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40) {
                    if (commandIndex >= 0) {
                        if (--commandIndex >= 0) {
                            LogWindow.this.textField.setText(commandHistory.get(commandIndex));
                        } else {
                            LogWindow.this.textField.setText("");
                        }
                    } else {
                        LogWindow.this.textField.setText("");
                    }
                    e.consume();
                } else if (e.getKeyCode() == 38) {
                    if (commandIndex < commandHistory.size()) {
                        if (++commandIndex < commandHistory.size()) {
                            LogWindow.this.textField.setText(commandHistory.get(commandIndex));
                        } else {
                            --commandIndex;
                        }
                    }
                    e.consume();
                }
            }
        });
        this.textField.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = LogWindow.this.textField.getText();
                LogWindow.this.textField.setText("");
                commandIndex = -1;
                if (!cmd.isEmpty()) {
                    commandHistory.add(0, cmd);
                    if (commandHistory.size() >= 500) {
                        commandHistory.remove(commandHistory.size() - 1);
                    }
                    AsyncTaskManager.runAsync(() -> {
                        if (commandCallback != null) {
                            commandCallback.accept(cmd);
                        }
                    });
                }
            }
        });
        this.textField.setColumns(10);
        Font font = new Font("Monospaced", 0, 12);
        this.textArea.setFont(font);
        this.contentPane.add((Component)this.textField, "South");
        this.contentPane.add((Component)pane, "Center");
        if (this.frm != null) {
            this.frm.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    if (shown) {
                        shown = false;
                        commandHistory.clear();
                        commandIndex = -1;
                        LogWindow.this.frm.dispose();
                        System.exit(0);
                    }
                }
            });
        }
    }

    public static class WindowAppender
    extends AbstractAppender {
        public static LogWindow frame = new LogWindow();

        protected WindowAppender(PatternLayout layout) {
            super("Window Appender", null, (Layout)layout);
            this.start();
        }

        public void append(LogEvent event) {
            if (frame == null) {
                return;
            }
            if (!event.getLevel().isInRange(Level.FATAL, Level.INFO)) {
                return;
            }
            String message = new String(this.getLayout().toByteArray(event));
            if (message.endsWith("\n")) {
                message = message.substring(0, message.length() - 1);
            }
            Calendar cal = Calendar.getInstance();
            int h = cal.get(11);
            int m = cal.get(12);
            int s = cal.get(13);
            String timeStr = (h >= 10 ? "" : "0") + Integer.toString(h) + ":" + (m >= 10 ? "" : "0") + m + ":" + (s >= 10 ? "" : "0") + s;
            String pref = "[" + timeStr;
            pref = pref + " ";
            if (event.getLevel().toString().length() == 4) {
                pref = pref + " ";
            }
            pref = pref + event.getLevel().toString();
            pref = pref + "] - ";
            if (message.contains("\n")) {
                for (String ln : message.split("\n")) {
                    frame.log(pref + ln);
                }
            } else {
                frame.log(pref + message);
            }
        }

        public static void showWindow() {
            shown = true;
            frame = new LogWindow();
            LoggerContext context = LoggerContext.getContext((boolean)false);
            Configuration config = context.getConfiguration();
            PatternLayout layout = PatternLayout.createDefaultLayout();
            WindowAppender appender = new WindowAppender(layout);
            config.addAppender((Appender)appender);
            WindowAppender.updateLoggers((Appender)appender, context.getConfiguration());
            WindowAppender.frame.frm.setVisible(true);
            WindowAppender.frame.textField.grabFocus();
        }

        public static void closeWindow() {
            if (!shown) {
                return;
            }
            shown = false;
            commandHistory.clear();
            commandIndex = -1;
            if (frame != null) {
                WindowAppender.frame.frm.dispose();
                frame = null;
            }
            LoggerContext.getContext((boolean)false).getConfiguration().getRootLogger().removeAppender("Window Appender");
        }

        private static void updateLoggers(Appender appender, Configuration config) {
            Level level = null;
            Filter filter = null;
            for (LoggerConfig loggerConfig : config.getLoggers().values()) {
                loggerConfig.addAppender(appender, level, filter);
            }
            config.getRootLogger().addAppender(appender, level, filter);
        }

        public static void log(String message) {
            if (frame == null) {
                return;
            }
            frame.log(message);
        }
    }
}

