/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.achievements.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import org.asf.edge.common.entities.achivements.EntityRankInfo;
import org.asf.edge.common.entities.achivements.RankInfo;
import org.asf.edge.common.entities.achivements.RankTypeID;
import org.asf.edge.common.events.achievements.RankChangedEvent;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class UserRankContainer
extends EntityRankInfo {
    private AccountDataContainer data;
    private AccountSaveContainer save;
    private RankTypeID type;

    public UserRankContainer(RankTypeID type, AccountSaveContainer save) {
        this.type = type;
        this.save = save;
        try {
            this.data = save.getSaveData().getChildContainer("ranks").getChildContainer("rank-" + type.getPointTypeID());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getEntityID() {
        return this.save.getSaveID();
    }

    @Override
    public RankTypeID getTypeID() {
        return this.type;
    }

    @Override
    public int getTotalScore() {
        try {
            if (this.data.entryExists("total")) {
                return this.data.getEntry("total").getAsInt();
            }
            return 0;
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public void setTotalScore(int value) {
        try {
            int current = this.getTotalScore();
            RankInfo currentRank = this.getRank();
            this.data.setEntry("total", (JsonElement)new JsonPrimitive((Number)value));
            RankInfo newRank = this.getRank();
            EventBus.getInstance().dispatchEvent((EventObject)new RankChangedEvent(AchievementManager.getInstance(), this.save, this, currentRank, newRank, current, value));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int addPoints(int value) {
        value = AchievementManager.getInstance().applyModifiers(this.save, value, this.type);
        this.setTotalScore(this.getTotalScore() + value);
        return value;
    }
}

