/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.bytecode;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.asf.cyan.fluid.Fluid;
import org.asf.cyan.fluid.bytecode.enums.ComparisonMethod;
import org.asf.cyan.fluid.bytecode.sources.FileClassSourceProvider;
import org.asf.cyan.fluid.bytecode.sources.IClassSourceProvider;
import org.asf.cyan.fluid.bytecode.sources.LoaderClassSourceProvider;
import org.asf.cyan.fluid.bytecode.sources.URLClassSourceProvider;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class FluidClassPool
implements Closeable {
    protected static FluidClassPool implementation = new FluidClassPool();
    private ArrayList<IClassSourceProvider<?>> sources = new ArrayList();
    private ArrayList<ClassEntry> classes = new ArrayList();
    private HashMap<String, String> classHashes = new HashMap();
    private ArrayList<String> includedclasses = new ArrayList();

    protected FluidClassPool newInstance() {
        return new FluidClassPool();
    }

    protected FluidClassPool() {
    }

    public URL[] getURLSources() {
        return (URL[])this.sources.stream().filter(t -> t.providerObject() instanceof URL).map(t -> (URL)t.providerObject()).toArray(URL[]::new);
    }

    public void addIncludedClass(String name) {
        this.includedclasses.add(name);
    }

    public ClassNode[] getLoadedClasses() {
        return (ClassNode[])this.classes.stream().map(t -> t.node).toArray(ClassNode[]::new);
    }

    public static FluidClassPool create() {
        FluidClassPool pool = implementation.newInstance();
        pool.addSource(new LoaderClassSourceProvider(ClassLoader.getSystemClassLoader()));
        pool.addDefaultCp();
        return pool;
    }

    public static FluidClassPool createEmpty() {
        return implementation.newInstance();
    }

    public void addSource(URL source) {
        this.addSource(new URLClassSourceProvider(source));
    }

    public void addSource(File source) {
        this.addSource(new FileClassSourceProvider(source));
    }

    public void addSource(IClassSourceProvider<?> provider) {
        boolean present = false;
        ArrayList backupSources = new ArrayList(this.sources);
        switch (provider.getComparisonMethod()) {
            case OBJECT_EQUALS: {
                present = backupSources.stream().anyMatch(t -> t.getComparisonMethod() == ComparisonMethod.OBJECT_EQUALS && t.providerObject().equals(provider.providerObject()));
            }
            case CLASS_EQUALS: {
                present = backupSources.stream().anyMatch(t -> t.getComparisonMethod() == ComparisonMethod.CLASS_EQUALS && t.providerObject().getClass().getTypeName().equals(provider.providerObject().getClass().getTypeName()));
            }
            case CLASS_ISASSIGNABLE: {
                present = backupSources.stream().anyMatch(t -> t.getComparisonMethod() == ComparisonMethod.CLASS_ISASSIGNABLE && t.providerObject().getClass().isAssignableFrom(provider.providerObject().getClass()));
            }
            case LOGICAL_EQUALS: {
                present = backupSources.stream().anyMatch(t -> t.getComparisonMethod() == ComparisonMethod.LOGICAL_EQUALS && t.providerObject() == provider.providerObject());
            }
        }
        if (!present) {
            this.sources.add(provider);
        }
    }

    public ClassNode readClass(String name, byte[] bytecode) {
        name = name.replaceAll("\\.", "/");
        ArrayList<ClassEntry> clsLstBackup = new ArrayList<ClassEntry>(this.classes);
        for (ClassEntry cls : clsLstBackup) {
            if (!cls.node.name.equals(name)) continue;
            return cls.node;
        }
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(bytecode);
        reader.accept((ClassVisitor)node, 0);
        FluidClassPool.fixLocalVariableNames(node);
        this.removeNullable(node);
        node.name = name;
        ClassEntry entry = new ClassEntry();
        entry.node = node;
        entry.firstName = name.replace(".", "/");
        this.classHashes.put(name, this.getHash(this.getByteCode(entry.node)));
        this.classes.add(entry);
        return node;
    }

    public ClassNode addClass(String name, ClassNode cls) {
        name = name.replaceAll("\\.", "/");
        ArrayList<ClassEntry> clsLstBackup = new ArrayList<ClassEntry>(this.classes);
        for (ClassEntry cls2 : clsLstBackup) {
            if (!cls2.node.name.equals(name)) continue;
            cls2.node = cls;
            return cls2.node;
        }
        ClassEntry entry = new ClassEntry();
        entry.node = cls;
        entry.firstName = name.replace(".", "/");
        this.classes.add(entry);
        return cls;
    }

    public ClassNode readClass(String name, InputStream strm) throws IOException {
        name = name.replaceAll("\\.", "/");
        ArrayList<ClassEntry> clsLstBackup = new ArrayList<ClassEntry>(this.classes);
        for (ClassEntry cls : clsLstBackup) {
            if (!cls.node.name.equals(name)) continue;
            return cls.node;
        }
        ClassNode node = new ClassNode();
        ClassReader reader = new ClassReader(strm);
        reader.accept((ClassVisitor)node, 0);
        FluidClassPool.fixLocalVariableNames(node);
        this.removeNullable(node);
        node.name = name;
        ClassEntry entry = new ClassEntry();
        entry.node = node;
        entry.firstName = name.replace(".", "/");
        this.classes.add(entry);
        return node;
    }

    public ClassNode getClassNode(String name) throws ClassNotFoundException {
        String nameFinal = name = name.replaceAll("\\.", "/");
        Optional<ClassEntry> oldN = new ArrayList<ClassEntry>(this.classes).stream().filter(t -> t.firstName.equals(nameFinal)).findFirst();
        if (!oldN.isEmpty()) {
            return oldN.get().node;
        }
        for (ClassEntry cls : new ArrayList<ClassEntry>(this.classes)) {
            if (!cls.node.name.equals(name)) continue;
            return cls.node;
        }
        ArrayList backupProviders = new ArrayList(this.sources);
        for (IClassSourceProvider<?> provider : backupProviders) {
            try {
                ClassNode node = new ClassNode();
                InputStream strm = provider.getStream(name);
                if (strm == null) continue;
                ClassReader reader = new ClassReader(strm);
                reader.accept((ClassVisitor)node, 0);
                FluidClassPool.fixLocalVariableNames(node);
                this.removeNullable(node);
                strm.close();
                ClassEntry entry = new ClassEntry();
                entry.node = node;
                entry.firstName = name.replace(".", "/");
                this.classes.add(entry);
                return node;
            }
            catch (IOException iOException) {
            }
        }
        throw new ClassNotFoundException("Cannot find class " + name.replaceAll("/", "."));
    }

    public byte[] getByteCode(String name) {
        name = name.replaceAll("\\.", "/");
        ArrayList<ClassEntry> clsLstBackup = new ArrayList<ClassEntry>(this.classes);
        for (ClassEntry cls : clsLstBackup) {
            if (!cls.node.name.equals(name)) continue;
            return this.getByteCode(cls.node);
        }
        return null;
    }

    public byte[] getByteCode(ClassNode node) {
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public void importAllSources() {
        for (IClassSourceProvider<?> source : this.sources) {
            source.importAll(this);
        }
    }

    public void importArchive(ZipInputStream strm) throws IOException {
        ZipEntry entry = strm.getNextEntry();
        while (entry != null) {
            String path = entry.getName().replace("\\", "/");
            if (path.endsWith(".class")) {
                String name = path;
                String nameFinal = name = name.substring(0, name.lastIndexOf(".class"));
                if (!this.classes.stream().anyMatch(t -> t.node.name.equals(nameFinal) || t.firstName.equals(nameFinal)) && (this.includedclasses.size() == 0 || this.includedclasses.contains(nameFinal))) {
                    this.readClass(name, strm);
                }
            }
            entry = strm.getNextEntry();
        }
    }

    public void detachClass(String name) throws ClassNotFoundException {
        name = name.replaceAll("\\.", "/");
        ArrayList<ClassEntry> clsLstBackup = new ArrayList<ClassEntry>(this.classes);
        for (ClassEntry cls : clsLstBackup) {
            if (!cls.node.name.equals(name)) continue;
            this.classes.remove(cls);
            return;
        }
        throw new ClassNotFoundException("Could not find class " + name.replaceAll("/", "."));
    }

    private void addDefaultCp() {
        for (String path : System.getProperty("java.class.path").split(File.pathSeparator)) {
            if (path.equals(".")) continue;
            File f = new File(path);
            this.addSource(f);
        }
    }

    @Override
    public void close() throws IOException {
        this.sources.clear();
        this.classes.clear();
    }

    private static void fixLocalVariableNames(ClassNode cls) {
        for (MethodNode meth : cls.methods) {
            if (meth.localVariables == null) continue;
            int varIndex = 0;
            for (LocalVariableNode var : meth.localVariables) {
                if (var.name != null && !var.name.matches("^[A-Za-z0-9_$]+$")) {
                    String nm = "var" + var.index;
                    while (true) {
                        String nameF = nm;
                        if (!meth.localVariables.stream().anyMatch(t -> t.name.equals(nameF))) break;
                        nm = "var" + var.index + "x" + varIndex++;
                    }
                    var.name = nm;
                }
                ++varIndex;
            }
        }
    }

    public ClassNode rewriteClass(String name, byte[] bytecode) throws ClassNotFoundException {
        name = name.replaceAll("\\.", "/");
        ArrayList<ClassEntry> clsLstBackup = new ArrayList<ClassEntry>(this.classes);
        if (this.classHashes.containsKey(name) && this.classHashes.get(name).equals(this.getHash(bytecode))) {
            for (ClassEntry cls : clsLstBackup) {
                if (!cls.node.name.equals(name)) continue;
                return cls.node;
            }
        }
        for (ClassEntry cls : clsLstBackup) {
            if (!cls.node.name.equals(name)) continue;
            cls.node = new ClassNode();
            ClassReader reader = new ClassReader(bytecode);
            reader.accept((ClassVisitor)cls.node, 0);
            FluidClassPool.fixLocalVariableNames(cls.node);
            this.removeNullable(cls.node);
            this.classHashes.put(name, this.getHash(this.getByteCode(cls.node)));
            return cls.node;
        }
        throw new ClassNotFoundException("Could not find class " + name.replaceAll("/", "."));
    }

    private void removeNullable(ClassNode node) {
        if (node.visibleAnnotations != null) {
            for (AnnotationNode nd : new ArrayList(node.visibleAnnotations)) {
                if (!Fluid.parseDescriptor(nd.desc).equals("javax.annotation.Nullable")) continue;
                node.visibleAnnotations.remove(nd);
            }
        }
        if (node.invisibleAnnotations != null) {
            for (AnnotationNode nd : new ArrayList(node.invisibleAnnotations)) {
                if (!Fluid.parseDescriptor(nd.desc).equals("javax.annotation.Nullable")) continue;
                node.invisibleAnnotations.remove(nd);
            }
        }
        if (node.visibleTypeAnnotations != null) {
            for (AnnotationNode nd : new ArrayList(node.visibleTypeAnnotations)) {
                if (!Fluid.parseDescriptor(nd.desc).equals("javax.annotation.Nullable")) continue;
                node.visibleAnnotations.remove(nd);
            }
        }
        if (node.invisibleTypeAnnotations != null) {
            for (AnnotationNode nd : new ArrayList(node.invisibleTypeAnnotations)) {
                if (!Fluid.parseDescriptor(nd.desc).equals("javax.annotation.Nullable")) continue;
                node.invisibleAnnotations.remove(nd);
            }
        }
        for (AnnotationNode nd : node.fields) {
            if (nd.visibleAnnotations != null) {
                for (AnnotationNode anno : new ArrayList(nd.visibleAnnotations)) {
                    if (!Fluid.parseDescriptor(anno.desc).equals("javax.annotation.Nullable")) continue;
                    nd.visibleAnnotations.remove(anno);
                }
            }
            if (nd.invisibleAnnotations != null) {
                for (AnnotationNode anno : new ArrayList(nd.invisibleAnnotations)) {
                    if (!Fluid.parseDescriptor(anno.desc).equals("javax.annotation.Nullable")) continue;
                    nd.invisibleAnnotations.remove(anno);
                }
            }
            if (nd.visibleTypeAnnotations != null) {
                for (AnnotationNode anno : new ArrayList(nd.visibleTypeAnnotations)) {
                    if (!Fluid.parseDescriptor(anno.desc).equals("javax.annotation.Nullable")) continue;
                    nd.visibleAnnotations.remove(anno);
                }
            }
            if (nd.invisibleTypeAnnotations == null) continue;
            for (AnnotationNode anno : new ArrayList(nd.invisibleTypeAnnotations)) {
                if (!Fluid.parseDescriptor(anno.desc).equals("javax.annotation.Nullable")) continue;
                nd.invisibleAnnotations.remove(anno);
            }
        }
        for (AnnotationNode nd : node.methods) {
            if (nd.visibleParameterAnnotations != null) {
                Stream.of(nd.visibleParameterAnnotations).forEach(t -> {
                    if (t != null) {
                        for (AnnotationNode anno : new ArrayList(t)) {
                            if (!Fluid.parseDescriptor(anno.desc).equals("javax.annotation.Nullable")) continue;
                            t.remove(anno);
                        }
                    }
                });
            }
            if (nd.invisibleParameterAnnotations != null) {
                Stream.of(nd.invisibleParameterAnnotations).forEach(t -> {
                    if (t != null) {
                        for (AnnotationNode anno : new ArrayList(t)) {
                            if (!Fluid.parseDescriptor(anno.desc).equals("javax.annotation.Nullable")) continue;
                            t.remove(anno);
                        }
                    }
                });
            }
            if (nd.visibleLocalVariableAnnotations != null) {
                for (AnnotationNode anno : new ArrayList(nd.visibleLocalVariableAnnotations)) {
                    if (!Fluid.parseDescriptor(anno.desc).equals("javax.annotation.Nullable")) continue;
                    nd.visibleLocalVariableAnnotations.remove(anno);
                }
            }
            if (nd.invisibleLocalVariableAnnotations != null) {
                for (AnnotationNode anno : new ArrayList(nd.invisibleLocalVariableAnnotations)) {
                    if (!Fluid.parseDescriptor(anno.desc).equals("javax.annotation.Nullable")) continue;
                    nd.invisibleLocalVariableAnnotations.remove(anno);
                }
            }
            if (nd.visibleAnnotations != null) {
                for (AnnotationNode anno : new ArrayList(nd.visibleAnnotations)) {
                    if (!Fluid.parseDescriptor(anno.desc).equals("javax.annotation.Nullable")) continue;
                    nd.visibleAnnotations.remove(anno);
                }
            }
            if (nd.invisibleAnnotations != null) {
                for (AnnotationNode anno : new ArrayList(nd.invisibleAnnotations)) {
                    if (!Fluid.parseDescriptor(anno.desc).equals("javax.annotation.Nullable")) continue;
                    nd.invisibleAnnotations.remove(anno);
                }
            }
            if (nd.visibleTypeAnnotations != null) {
                for (AnnotationNode anno : new ArrayList(nd.visibleTypeAnnotations)) {
                    if (!Fluid.parseDescriptor(anno.desc).equals("javax.annotation.Nullable")) continue;
                    nd.visibleAnnotations.remove(anno);
                }
            }
            if (nd.invisibleTypeAnnotations == null) continue;
            for (AnnotationNode anno : new ArrayList(nd.invisibleTypeAnnotations)) {
                if (!Fluid.parseDescriptor(anno.desc).equals("javax.annotation.Nullable")) continue;
                nd.invisibleAnnotations.remove(anno);
            }
        }
    }

    public ClassNode rewriteClass(String name, InputStream input) throws ClassNotFoundException, IOException {
        name = name.replaceAll("\\.", "/");
        ArrayList<ClassEntry> clsLstBackup = new ArrayList<ClassEntry>(this.classes);
        for (ClassEntry cls : clsLstBackup) {
            if (!cls.node.name.equals(name)) continue;
            cls.node = new ClassNode();
            ClassReader reader = new ClassReader(input);
            reader.accept((ClassVisitor)cls.node, 0);
            FluidClassPool.fixLocalVariableNames(cls.node);
            this.removeNullable(cls.node);
            this.classHashes.put(name, this.getHash(this.getByteCode(cls.node)));
            return cls.node;
        }
        throw new ClassNotFoundException("Could not find class " + name.replaceAll("/", "."));
    }

    private String getHash(byte[] data) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] sha = digest.digest(data);
            StringBuilder result = new StringBuilder();
            for (byte aByte : sha) {
                result.append(String.format("%02x", aByte));
            }
            return result.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    private class ClassEntry {
        public ClassNode node;
        public String firstName;

        private ClassEntry() {
        }
    }
}

