/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.tools;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.CommonInit;
import org.asf.edge.common.services.AbstractService;
import org.asf.edge.common.services.ServiceManager;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.services.items.impl.ItemManagerImpl;
import org.asf.edge.gameplayapi.commands.CommandContext;
import org.asf.edge.gameplayapi.commands.IEdgeServerCommand;
import org.asf.edge.gameplayapi.config.GameplayApiServerConfig;
import org.asf.edge.gameplayapi.events.config.GameplayApiServerConfigLoadedEvent;
import org.asf.edge.gameplayapi.events.config.GameplayApiServerConfigPresetupEvent;
import org.asf.edge.gameplayapi.permissions.PermissionLevel;
import org.asf.edge.gameplayapi.services.quests.QuestManager;
import org.asf.edge.gameplayapi.services.quests.impl.QuestManagerImpl;
import org.asf.edge.modules.ModuleManager;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class ServerCommandTerminal {
    private static boolean exit;
    private static long lastRestartTime;
    private static long lastShutdownTime;

    public static void main(String[] args) throws IOException {
        Scanner sc = new Scanner(System.in);
        CommonInit.initAll();
        Logger logger = LogManager.getLogger((String)"TERMINAL");
        logger.info("Preparing to start terminal...");
        ModuleManager.init();
        GameplayApiServerConfig config = new GameplayApiServerConfig();
        EventBus.getInstance().dispatchEvent((EventObject)new GameplayApiServerConfigPresetupEvent(config));
        logger.info("Loading server configuration...");
        File configFile = new File("server.json");
        if (!configFile.exists()) {
            logger.debug("Creating server configuration...");
            if (config.server == null) {
                Files.writeString(configFile.toPath(), (CharSequence)"{\n\n    \"listenAddress\": \"0.0.0.0\",\n    \"listenPort\": 5320,\n    \"apiRequestListenPath\": \"/\",\n\n    \"https\": false,\n    \"tlsKeystore\": null,\n    \"tlsKeystorePassword\": null,\n\n    \"modules\": {\n    }\n\n}", new OpenOption[0]);
            } else {
                Files.writeString(configFile.toPath(), (CharSequence)"{\n\n    \"apiRequestListenPath\": \"/\",\n\n    \"modules\": {\n    }\n\n}", new OpenOption[0]);
            }
        }
        logger.debug("Loading configuration file server.json...");
        JsonObject configData = JsonParser.parseString((String)Files.readString(configFile.toPath())).getAsJsonObject();
        if (configData.has("gameplayApiServer")) {
            configData = configData.get("gameplayApiServer").getAsJsonObject();
        }
        if (config.server == null) {
            logger.debug("Loading listening settings...");
            config.listenAddress = configData.get("listenAddress").getAsString();
            config.listenPort = configData.get("listenPort").getAsInt();
        }
        logger.debug("Loading IO settings...");
        config.apiRequestListenPath = configData.get("apiRequestListenPath").getAsString();
        if (config.server == null) {
            logger.debug("Loading encryption settings...");
            config.https = configData.get("https").getAsBoolean();
            if (config.https) {
                config.tlsKeystore = configData.get("tlsKeystore").getAsString();
                config.tlsKeystorePassword = configData.get("tlsKeystorePassword").getAsString();
            }
        }
        if (configData.has("modules")) {
            logger.debug("Loading module configurations...");
            JsonObject moduleSettings = configData.get("modules").getAsJsonObject();
            for (String id : moduleSettings.keySet()) {
                JsonObject conf = moduleSettings.get(id).getAsJsonObject();
                LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
                for (String key : conf.keySet()) {
                    mp.put(key, conf.get(key).getAsString());
                }
                ModuleManager.loadedModuleConfig((String)id, mp);
            }
        }
        EventBus.getInstance().dispatchEvent((EventObject)new GameplayApiServerConfigLoadedEvent(config));
        logger.info("Setting up the terminal...");
        logger.debug("Loading account manager implementations...");
        AccountManager.initAccountManagerServices((int)0, (int)-10, (int)-5);
        logger.debug("Selecting account manager implementation...");
        ServiceManager.selectServiceImplementation(AccountManager.class);
        logger.debug("Loading account manager...");
        AccountManager.getInstance().loadManager();
        logger.debug("Loading common data manager implementations...");
        CommonDataManager.initCommonDataManagerServices((int)0, (int)-10, (int)-5);
        logger.debug("Selecting common data manager implementation...");
        ServiceManager.selectServiceImplementation(CommonDataManager.class);
        logger.debug("Loading common data manager...");
        CommonDataManager.getInstance().loadManager();
        logger.info("Setting up item manager...");
        ServiceManager.registerServiceImplementation(ItemManager.class, (AbstractService)new ItemManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(ItemManager.class);
        logger.info("Setting up quest manager...");
        ServiceManager.registerServiceImplementation(QuestManager.class, (AbstractService)new QuestManagerImpl(), (int)-10);
        ServiceManager.selectServiceImplementation(QuestManager.class);
        System.out.print("Login username: ");
        String username = sc.nextLine();
        System.out.print("Login password: ");
        Console con = System.console();
        char[] passwd = con == null ? sc.nextLine().toCharArray() : con.readPassword();
        System.out.println("Attempting to log into user: " + username + "...");
        String id = AccountManager.getInstance().getAccountID(username);
        if (id == null || !AccountManager.getInstance().verifyPassword(id, new String(passwd))) {
            System.err.println("Failed to log into your Edge account!");
            return;
        }
        AccountObject acc = AccountManager.getInstance().getAccount(id);
        if (acc == null) {
            System.err.println("Failed to log into your Edge account!");
            return;
        }
        CommandContext ctx = CommandContext.getFor(acc);
        ctx.registerCommand(new IEdgeServerCommand(){

            @Override
            public String id() {
                return "exit";
            }

            @Override
            public String syntax(CommandContext ctx) {
                return null;
            }

            @Override
            public String description(CommandContext ctx) {
                return "Closes the terminal";
            }

            @Override
            public PermissionLevel permLevel() {
                return PermissionLevel.GUEST;
            }

            @Override
            public String permNode() {
                return "any";
            }

            @Override
            public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) {
                exit = true;
                return "Exiting terminal...";
            }
        });
        CommonDataContainer cont = CommonDataManager.getInstance().getContainer("EDGECOMMON");
        try {
            if (!cont.entryExists("shutdown")) {
                lastShutdownTime = System.currentTimeMillis();
                cont.setEntry("shutdown", (JsonElement)new JsonPrimitive((Number)lastShutdownTime));
            } else {
                lastShutdownTime = cont.getEntry("shutdown").getAsLong();
            }
            if (!cont.entryExists("restart")) {
                lastRestartTime = System.currentTimeMillis();
                cont.setEntry("restart", (JsonElement)new JsonPrimitive((Number)lastRestartTime));
            } else {
                lastRestartTime = cont.getEntry("restart").getAsLong();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AsyncTaskManager.runAsync(() -> {
            while (true) {
                try {
                    long restart;
                    long shutdown = cont.getEntry("shutdown").getAsLong();
                    if (shutdown > lastShutdownTime) {
                        System.exit(0);
                    }
                    if ((restart = cont.getEntry("restart").getAsLong()) > lastRestartTime) {
                        System.exit(237);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        });
        System.out.println();
        System.out.println("Edge interactive terminal, waiting for commands.");
        System.out.println("You have access to " + ctx.getPermissions().getPermissionLevel().toString().toLowerCase() + " commands.");
        while (!exit) {
            System.out.print("> ");
            String cmd = sc.nextLine();
            ctx.runCommand(cmd, t -> System.out.println((String)t));
            System.out.println();
        }
    }
}

