/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.commands.defaultcommands.account.profilecommands;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.gameplayapi.commands.CommandContext;
import org.asf.edge.gameplayapi.commands.IEdgeServerCommand;
import org.asf.edge.gameplayapi.permissions.PermissionLevel;

public class ProfileDeleteCommand
implements IEdgeServerCommand {
    @Override
    public String id() {
        return "delete";
    }

    @Override
    public String syntax(CommandContext ctx) {
        if (ctx.getPermissions().hasPermission("commands.admin.profiles.delete", PermissionLevel.ADMINISTRATOR)) {
            return "<id> \"[owner]\"";
        }
        return "<id>";
    }

    @Override
    public String description(CommandContext ctx) {
        return "Deletes profiles";
    }

    @Override
    public PermissionLevel permLevel() {
        return PermissionLevel.GUEST;
    }

    @Override
    public String permNode() {
        return "commands.everyone.profiles.delete";
    }

    @Override
    public String run(String[] args, CommandContext ctx, Logger logger, Consumer<String> outputWriteLineCallback, Map<String, String> dataBlobs) {
        AccountObject acc = ctx.getAccountObject();
        if (args.length >= 2 && ctx.getPermissions().hasPermission("commands.admin.profiles.delete", PermissionLevel.ADMINISTRATOR)) {
            String username = args[1];
            String id = AccountManager.getInstance().getAccountIdBySaveUsername(username);
            if (id == null) {
                id = AccountManager.getInstance().getAccountID(username);
            }
            if (id == null) {
                outputWriteLineCallback.accept("Error: username not recognized");
                return null;
            }
            acc = AccountManager.getInstance().getAccount(id);
        }
        String id = null;
        if (args.length >= 1) {
            id = args[0];
            if (ctx.getAccountObject().getSave(id) == null) {
                id = null;
            }
        }
        if (id == null) {
            outputWriteLineCallback.accept("Error: invalid profile");
            return null;
        }
        if (acc.getAccountID().equalsIgnoreCase(ctx.getAccountObject().getAccountID())) {
            try {
                AccountDataContainer currencyAccWide = acc.getAccountData().getChildContainer("currency");
                int current = 0;
                if (currencyAccWide.entryExists("gems")) {
                    current = currencyAccWide.getEntry("gems").getAsInt();
                }
                if (current < 50) {
                    outputWriteLineCallback.accept("Error: not enough gems");
                    return null;
                }
                currencyAccWide.setEntry("gems", (JsonElement)new JsonPrimitive((Number)(current -= 50)));
            }
            catch (IOException e) {
                outputWriteLineCallback.accept("Error: failed to modify currency data");
                return null;
            }
        }
        outputWriteLineCallback.accept("Deleting profile...");
        acc.getSave(id).deleteSave();
        return "Profile deleted successfully";
    }
}

