/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.achievements.impl;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import org.asf.edge.common.entities.achivements.EntityRankInfo;
import org.asf.edge.common.entities.achivements.RankInfo;
import org.asf.edge.common.entities.achivements.RankTypeID;
import org.asf.edge.common.events.achievements.RankChangedEvent;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class DragonRankContainer
extends EntityRankInfo {
    private AccountSaveContainer save;
    private AccountDataContainer data;
    private String dragonEntityID;

    public DragonRankContainer(AccountSaveContainer save, String dragonEntityID) throws IOException {
        this.save = save;
        this.dragonEntityID = dragonEntityID;
        try {
            this.data = save.getSaveData().getChildContainer("dragons").getChildContainer("dragonrank-" + dragonEntityID);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (!this.data.entryExists("total")) {
            AccountDataContainer d = save.getSaveData().getChildContainer("dragons");
            if (!d.entryExists("dragonlist")) {
                throw new IOException("Dragon not found");
            }
            JsonArray dragonIds = d.getEntry("dragonlist").getAsJsonArray();
            boolean found = false;
            for (JsonElement ele : dragonIds) {
                ObjectNode dragon;
                String id;
                String did = ele.getAsString();
                if (!d.entryExists("dragon-" + did) || !(id = (dragon = (ObjectNode)new XmlMapper().readValue(d.getEntry("dragon-" + did).getAsString(), ObjectNode.class)).get("eid").asText()).equals(dragonEntityID)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new IOException("Dragon not found");
            }
        }
    }

    @Override
    public String getEntityID() {
        return this.dragonEntityID;
    }

    @Override
    public RankTypeID getTypeID() {
        return RankTypeID.DRAGON;
    }

    @Override
    public int getTotalScore() {
        try {
            if (this.data.entryExists("total")) {
                return this.data.getEntry("total").getAsInt();
            }
            return 0;
        }
        catch (IOException e) {
            return 0;
        }
    }

    @Override
    public void setTotalScore(int value) {
        try {
            int current = this.getTotalScore();
            RankInfo currentRank = this.getRank();
            this.data.setEntry("total", (JsonElement)new JsonPrimitive((Number)value));
            RankInfo newRank = this.getRank();
            EventBus.getInstance().dispatchEvent((EventObject)new RankChangedEvent(AchievementManager.getInstance(), this.save, this, currentRank, newRank, current, value));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public int addPoints(int value) {
        value = AchievementManager.getInstance().applyModifiers(this.save, value, RankTypeID.DRAGON);
        this.setTotalScore(this.getTotalScore() + value);
        return value;
    }
}

