/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.reports;

import java.util.ArrayList;
import java.util.function.Supplier;
import org.asf.cyan.fluid.implementation.FluidReportBuilder;
import org.asf.cyan.fluid.reports.ReportCategory;
import org.asf.cyan.fluid.reports.ReportEntry;
import org.asf.cyan.fluid.reports.ReportEntryList;
import org.asf.cyan.fluid.reports.ReportNode;

public abstract class ReportBuilder {
    private static ReportBuilder selectedImplementation = new FluidReportBuilder();

    public static ReportBuilder getImplementationInstance() {
        return selectedImplementation;
    }

    protected ReportBuilder() {
    }

    protected static void setImplementation(ReportBuilder implementation) {
        selectedImplementation = implementation;
    }

    public static ReportBuilder create(String head) {
        return selectedImplementation.getNewInstance(head);
    }

    protected abstract String getImplementationName();

    protected abstract ReportBuilder getNewInstance(String var1);

    protected abstract void buildHeadString(StringBuilder var1);

    protected abstract void buildNodeHead(StringBuilder var1, ReportNode var2);

    protected abstract void buildCategoryHead(StringBuilder var1, String var2, int var3);

    protected abstract void buildEntry(StringBuilder var1, ReportEntry<?> var2, int var3);

    public abstract String getHead();

    public abstract void setHead(String var1);

    public abstract ReportCategory[] getCategories();

    public abstract void append(ReportCategory var1);

    public abstract void remove(ReportCategory var1);

    public abstract ReportCategory newCategory(String var1);

    public abstract ReportCategory newCategory(String var1, ArrayList<ReportNode> var2);

    public abstract ReportNode newNode(ReportCategory var1, String var2);

    public abstract ReportNode newNode(ReportCategory var1, String var2, ReportEntryList var3);

    public abstract ReportNode appendNode(ReportCategory var1, ReportNode var2);

    public abstract ReportEntry<Integer> newEntry(String var1, int var2);

    public abstract ReportEntry<Boolean> newEntry(String var1, boolean var2);

    public abstract ReportEntry<Float> newEntry(String var1, float var2);

    public abstract ReportEntry<Double> newEntry(String var1, double var2);

    public abstract ReportEntry<Byte> newEntry(String var1, byte var2);

    public abstract ReportEntry<Character> newEntry(String var1, char var2);

    public abstract ReportEntry<String> newEntry(String var1, String var2);

    public abstract ReportEntry<Object> newEntry(String var1, Object var2);

    public abstract ReportEntry<?> newEntry(String var1, Supplier<?> var2);

    public ReportNode[] appendNode(ReportCategory category, ReportNode ... nodes) {
        for (ReportNode n : nodes) {
            this.appendNode(category, n);
        }
        return nodes;
    }

    public ReportEntry<Integer>[] newEntry(ReportNode node, int ... values) {
        ArrayList<ReportEntry<Integer>> nodes = new ArrayList<ReportEntry<Integer>>();
        for (int value : values) {
            nodes.add(this.newEntry(node, (String)null, value));
        }
        return (ReportEntry[])nodes.toArray(ReportEntry[]::new);
    }

    public ReportEntry<Boolean>[] newEntry(ReportNode node, boolean ... values) {
        ArrayList<ReportEntry<Boolean>> nodes = new ArrayList<ReportEntry<Boolean>>();
        boolean[] blArray = values;
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            Boolean value = blArray[i];
            nodes.add(this.newEntry(node, (String)null, (boolean)value));
        }
        return (ReportEntry[])nodes.toArray(ReportEntry[]::new);
    }

    public ReportEntry<Float>[] newEntry(ReportNode node, float ... values) {
        ArrayList<ReportEntry<Float>> nodes = new ArrayList<ReportEntry<Float>>();
        float[] fArray = values;
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            Float value = Float.valueOf(fArray[i]);
            nodes.add(this.newEntry(node, (String)null, value.floatValue()));
        }
        return (ReportEntry[])nodes.toArray(ReportEntry[]::new);
    }

    public ReportEntry<Double>[] newEntry(ReportNode node, double ... values) {
        ArrayList<ReportEntry<Double>> nodes = new ArrayList<ReportEntry<Double>>();
        double[] dArray = values;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double value = dArray[i];
            nodes.add(this.newEntry(node, (String)null, (double)value));
        }
        return (ReportEntry[])nodes.toArray(ReportEntry[]::new);
    }

    public ReportEntry<Byte>[] newEntry(ReportNode node, byte ... values) {
        ArrayList<ReportEntry<Byte>> nodes = new ArrayList<ReportEntry<Byte>>();
        byte[] byArray = values;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte value = byArray[i];
            nodes.add(this.newEntry(node, (String)null, (byte)value));
        }
        return (ReportEntry[])nodes.toArray(ReportEntry[]::new);
    }

    public ReportEntry<Character>[] newEntry(ReportNode node, char ... values) {
        ArrayList<ReportEntry<Character>> nodes = new ArrayList<ReportEntry<Character>>();
        char[] cArray = values;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character value = Character.valueOf(cArray[i]);
            nodes.add(this.newEntry(node, (String)null, value.charValue()));
        }
        return (ReportEntry[])nodes.toArray(ReportEntry[]::new);
    }

    public ReportEntry<String>[] newEntry(ReportNode node, String ... values) {
        ArrayList<ReportEntry<String>> nodes = new ArrayList<ReportEntry<String>>();
        for (String value : values) {
            nodes.add(this.newEntry(node, (String)null, value));
        }
        return (ReportEntry[])nodes.toArray(ReportEntry[]::new);
    }

    public ReportEntry<Integer> newEntry(ReportNode node, String name, int value) {
        ReportEntry<Integer> rEntry = this.newEntry(name, value);
        node.add(rEntry);
        return rEntry;
    }

    public ReportEntry<Boolean> newEntry(ReportNode node, String name, boolean value) {
        ReportEntry<Boolean> rEntry = this.newEntry(name, value);
        node.add(rEntry);
        return rEntry;
    }

    public ReportEntry<Float> newEntry(ReportNode node, String name, float value) {
        ReportEntry<Float> rEntry = this.newEntry(name, value);
        node.add(rEntry);
        return rEntry;
    }

    public ReportEntry<Double> newEntry(ReportNode node, String name, double value) {
        ReportEntry<Double> rEntry = this.newEntry(name, value);
        node.add(rEntry);
        return rEntry;
    }

    public ReportEntry<Byte> newEntry(ReportNode node, String name, byte value) {
        ReportEntry<Byte> rEntry = this.newEntry(name, value);
        node.add(rEntry);
        return rEntry;
    }

    public ReportEntry<Character> newEntry(ReportNode node, String name, char value) {
        ReportEntry<Character> rEntry = this.newEntry(name, value);
        node.add(rEntry);
        return rEntry;
    }

    public ReportEntry<String> newEntry(ReportNode node, String name, String value) {
        ReportEntry<String> rEntry = this.newEntry(name, value);
        node.add(rEntry);
        return rEntry;
    }

    public ReportEntry<Object> newEntry(ReportNode node, String name, Object value) {
        ReportEntry<Object> rEntry = this.newEntry(name, value);
        node.add(rEntry);
        return rEntry;
    }

    public void build(StringBuilder builder) {
        this.buildHeadString(builder);
        builder.append("\n");
        builder.append("\n");
        int longest = 0;
        for (ReportCategory category : this.getCategories()) {
            String name = category.name;
            if (name.length() <= longest) continue;
            longest = name.length();
        }
        boolean first = true;
        for (ReportCategory category : this.getCategories()) {
            String name = category.name;
            if (!first) {
                builder.append("\n");
            } else {
                first = false;
            }
            if (name != null) {
                this.buildCategoryHead(builder, name, longest);
                builder.append("\n");
            }
            int longestName = 0;
            for (ReportNode node : category.nodes) {
                if (node.name == null) continue;
                for (ReportEntry ent : node.entries) {
                    if (ent.key == null || ent.key.length() <= longestName) continue;
                    longestName = ent.key.length();
                }
            }
            for (ReportNode node : category.nodes) {
                this.buildNodeHead(builder, node);
                builder.append("\n");
                for (ReportEntry ent : node.entries) {
                    this.buildEntry(builder, ent, longestName);
                }
                builder.append("\n");
            }
        }
    }
}

