/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid;

import java.nio.ByteBuffer;
import java.util.HashMap;

public class BinaryClassLoader
extends ClassLoader {
    private HashMap<String, byte[]> classes = new HashMap();
    private HashMap<String, Class<?>> loadedClasses = new HashMap();

    public void addClass(String name, byte[] bytecode) {
        this.classes.put(name.replace(".", "/"), bytecode);
    }

    public Class<?> loadClass(String name, byte[] bytecode) {
        this.classes.put(name.replace(".", "/"), bytecode);
        this.loadedClasses.put(name, this.defineClass(name, ByteBuffer.wrap(bytecode), null));
        return this.loadedClasses.get(name);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.loadedClasses.containsKey(name.replace(".", "/"))) {
            return this.loadedClasses.get(name.replace(".", "/"));
        }
        if (!this.classes.containsKey(name)) {
            ClassLoader l = this.getParent();
            if (l == null) {
                l = Thread.currentThread().getContextClassLoader();
            }
            if (l == this) {
                l = ClassLoader.getSystemClassLoader();
            }
            return Class.forName(name.replace("/", "."), true, l);
        }
        return super.findClass(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.loadedClasses.containsKey(name.replace(".", "/"))) {
            return this.loadedClasses.get(name.replace(".", "/"));
        }
        return this.loadClass(name, true);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.loadedClasses.containsKey(name.replace(".", "/"))) {
            return this.loadedClasses.get(name.replace(".", "/"));
        }
        if (!this.classes.containsKey(name = name.replace(".", "/"))) {
            ClassLoader l = this.getParent();
            if (l == null) {
                l = Thread.currentThread().getContextClassLoader();
            }
            if (l == this) {
                l = ClassLoader.getSystemClassLoader();
            }
            return Class.forName(name.replace("/", "."), true, l);
        }
        byte[] data = this.classes.get(name);
        this.loadedClasses.put(name, this.defineClass(name, ByteBuffer.wrap(data), null));
        return this.loadedClasses.get(name);
    }
}

