/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.util.inventory.defaulthandlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.gameplayapi.util.inventory.AbstractItemRedemptionHandler;
import org.asf.edge.gameplayapi.util.inventory.ItemRedemptionInfo;
import org.asf.edge.gameplayapi.xmls.inventories.InventoryUpdateResponseData;

public class GemItemRedemptionHandler
extends AbstractItemRedemptionHandler {
    @Override
    public boolean canHandle(ItemInfo item) {
        ObjectNode raw = item.getRawObject();
        if (!raw.has("at")) {
            return false;
        }
        JsonNode node = raw.get("at");
        if (node.isArray()) {
            for (JsonNode n : node) {
                if (!n.has("k") || !n.get("k").asText().equalsIgnoreCase("VCashRedemptionValue")) continue;
                return true;
            }
        } else if (node.has("k") && node.get("k").asText().equalsIgnoreCase("VCashRedemptionValue")) {
            return true;
        }
        return false;
    }

    @Override
    public AbstractItemRedemptionHandler.RedemptionResult handleRedemption(ItemInfo item, ItemRedemptionInfo req, AccountObject account, AccountSaveContainer save, InventoryUpdateResponseData.CurrencyUpdateBlock currencyUpdate) {
        int amount = 0;
        ObjectNode raw = item.getRawObject();
        JsonNode node = raw.get("at");
        if (node.isArray()) {
            for (JsonNode n : node) {
                if (!n.has("k") || !n.get("k").asText().equalsIgnoreCase("VCashRedemptionValue")) continue;
                amount = n.get("v").asInt();
            }
        } else if (node.has("k") && node.get("k").asText().equalsIgnoreCase("VCashRedemptionValue")) {
            amount = node.get("v").asInt();
        }
        currencyUpdate.gemCount += amount * req.quantity;
        return AbstractItemRedemptionHandler.RedemptionResult.success();
    }
}

