/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.http.handlers.gameplayapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.asf.connective.RemoteClient;
import org.asf.connective.TlsSecuredHttpServer;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.entities.items.PlayerInventory;
import org.asf.edge.common.entities.items.PlayerInventoryContainer;
import org.asf.edge.common.entities.items.PlayerInventoryItem;
import org.asf.edge.common.entities.minigamedata.MinigameData;
import org.asf.edge.common.entities.minigamedata.MinigameDataRequest;
import org.asf.edge.common.entities.minigamedata.MinigameSaveRequest;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionResult;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequest;
import org.asf.edge.common.http.apihandlerutils.functions.SodRequestParam;
import org.asf.edge.common.http.apihandlerutils.functions.SodTokenSecured;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireCapability;
import org.asf.edge.common.http.apihandlerutils.functions.TokenRequireSave;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.common.services.minigamedata.MinigameDataManager;
import org.asf.edge.common.services.textfilter.TextFilterService;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.common.tokens.TokenParseResult;
import org.asf.edge.gameplayapi.EdgeGameplayApiServer;
import org.asf.edge.gameplayapi.entities.quests.UserQuestInfo;
import org.asf.edge.gameplayapi.services.quests.QuestManager;
import org.asf.edge.gameplayapi.util.InventoryUtils;
import org.asf.edge.gameplayapi.util.inventory.ItemRedemptionInfo;
import org.asf.edge.gameplayapi.xmls.data.EmptyKeyValuePairSetData;
import org.asf.edge.gameplayapi.xmls.data.KeyValuePairData;
import org.asf.edge.gameplayapi.xmls.data.KeyValuePairSetData;
import org.asf.edge.gameplayapi.xmls.dragons.DragonData;
import org.asf.edge.gameplayapi.xmls.dragons.DragonListData;
import org.asf.edge.gameplayapi.xmls.inventories.CommonInventoryData;
import org.asf.edge.gameplayapi.xmls.inventories.InventoryUpdateResponseData;
import org.asf.edge.gameplayapi.xmls.inventories.SetCommonInventoryRequestData;
import org.asf.edge.gameplayapi.xmls.items.ItemRedeemRequestData;
import org.asf.edge.gameplayapi.xmls.minigamedata.GameDataSummaryData;
import org.asf.edge.gameplayapi.xmls.names.DisplayNameUniqueResponseData;
import org.asf.edge.gameplayapi.xmls.quests.MissionData;
import org.asf.edge.gameplayapi.xmls.quests.QuestListResponseData;
import org.asf.edge.gameplayapi.xmls.quests.RequestFilterDataLegacy;

public class ContentWebServiceV1Processor
extends EdgeWebService<EdgeGameplayApiServer> {
    private static AccountManager manager;
    private static ItemManager itemManager;
    private static QuestManager questManager;

    public ContentWebServiceV1Processor(EdgeGameplayApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new ContentWebServiceV1Processor((EdgeGameplayApiServer)this.getServerInstance());
    }

    public String path() {
        return "/ContentWebService.asmx";
    }

    public void fallbackRequestProcessor(String path, String method, RemoteClient client, String contentType) throws IOException {
        this.setResponseStatus(404, "Not found");
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getDefaultNameSuggestion(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger());
        if (req == null) {
            return;
        }
        DisplayNameUniqueResponseData resp = new DisplayNameUniqueResponseData();
        resp.suggestions = new DisplayNameUniqueResponseData.SuggestionResultBlock();
        resp.suggestions.suggestions = new String[0];
        this.setResponseContent("text/xml", req.generateXmlValue("DisplayNameUniqueResponse", (Object)resp));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getAuthoritativeTime(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger());
        if (req == null) {
            return;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.setResponseContent("text/xml", req.generateXmlValue("dateTime", (Object)fmt.format(new Date(System.currentTimeMillis()))));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void purchaseItems(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger());
        if (req == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        if (!tkn.hasCapability("gp")) {
            String[] saves = account.getSaveIDs();
            if (saves.length == 0) {
                this.setResponseStatus(404, "Not found");
                return;
            }
            tkn.saveID = account.getSaveIDs()[0];
        }
        AccountSaveContainer save = account.getSave(tkn.saveID);
        int storeID = Integer.parseInt((String)req.payload.get("storeId"));
        int containerID = Integer.parseInt(req.payload.getOrDefault("ContainerID", "1"));
        int[] itemIds = (int[])req.parseXmlValue((String)req.payload.get("itemIDArrayXml"), int[].class);
        HashMap<Integer, ItemRedemptionInfo> items = new HashMap<Integer, ItemRedemptionInfo>();
        for (int id : itemIds) {
            if (!items.containsKey(id)) {
                ItemRedemptionInfo itm = new ItemRedemptionInfo();
                itm.containerID = containerID;
                itm.defID = id;
                items.put(id, itm);
            }
            ++((ItemRedemptionInfo)items.get((Object)Integer.valueOf((int)id))).quantity;
        }
        InventoryUpdateResponseData response = InventoryUtils.purchaseItems(storeID, (ItemRedemptionInfo[])items.values().toArray(ItemRedemptionInfo[]::new), account, save, true);
        if (!tkn.hasCapability("gp") && response.currencyUpdate != null) {
            response.currencyUpdate.userID = account.getAccountID();
        }
        this.setResponseContent("text/xml", req.generateXmlValue("CIRS", (Object)response));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getUserGameCurrency(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (questManager == null) {
            questManager = QuestManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        AccountSaveContainer save = account.getSave(userID);
        if (save == null) {
            this.setResponseStatus(403, "Forbidden");
            return;
        }
        InventoryUpdateResponseData.CurrencyUpdateBlock c = new InventoryUpdateResponseData.CurrencyUpdateBlock();
        AccountDataContainer currency = save.getSaveData().getChildContainer("currency");
        int currentC = 300;
        if (currency.entryExists("coins")) {
            currentC = currency.getEntry("coins").getAsInt();
        }
        AccountDataContainer currencyAccWide = save.getAccount().getAccountData().getChildContainer("currency");
        int currentG = 0;
        if (currencyAccWide.entryExists("gems")) {
            currentG = currencyAccWide.getEntry("gems").getAsInt();
        }
        c.coinCount = currentC;
        c.gemCount = currentG;
        c.userID = save.getSaveID();
        this.setResponseContent("text/xml", req.generateXmlValue("UserGameCurrency", (Object)c));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void acceptMission(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (questManager == null) {
            questManager = QuestManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        AccountSaveContainer save = account.getSave(userID);
        if (save != null) {
            int missionId = Integer.parseInt((String)req.payload.get("missionId"));
            UserQuestInfo quest = questManager.getUserQuest(save, missionId);
            if (quest == null) {
                this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)false));
                return;
            }
            quest.acceptQuest();
            this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
        } else {
            this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)false));
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getCommonInventory(LegacyFunctionInfo func) throws IOException {
        ItemInfo def;
        CommonInventoryData.ItemBlock block;
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        AccountDataContainer data = account.getAccountData();
        int containerID = Integer.parseInt((String)req.payload.get("ContainerId"));
        CommonInventoryData resp = new CommonInventoryData();
        resp.userID = account.getAccountID();
        ArrayList<CommonInventoryData.ItemBlock> items = new ArrayList<CommonInventoryData.ItemBlock>();
        for (PlayerInventoryItem itm : itemManager.getCommonInventory(data).getContainer(containerID).getItems()) {
            block = new CommonInventoryData.ItemBlock();
            block.itemID = itm.getItemDefID();
            block.quantity = itm.getQuantity();
            block.uses = itm.getUses();
            block.uniqueItemID = itm.getUniqueID();
            def = ItemManager.getInstance().getItemDefinition(block.itemID);
            if (def != null) {
                block.data = def.getRawObject();
            }
            items.add(block);
        }
        if (tkn.saveID != null) {
            data = account.getSave(tkn.saveID).getSaveData();
            resp = new CommonInventoryData();
            resp.userID = account.getAccountID();
            for (PlayerInventoryItem itm : itemManager.getCommonInventory(data).getContainer(containerID).getItems()) {
                block = new CommonInventoryData.ItemBlock();
                block.itemID = itm.getItemDefID();
                block.quantity = itm.getQuantity();
                block.uses = itm.getUses();
                block.uniqueItemID = itm.getUniqueID();
                def = ItemManager.getInstance().getItemDefinition(block.itemID);
                if (def != null) {
                    block.data = def.getRawObject();
                }
                items.add(block);
            }
        }
        resp.items = (CommonInventoryData.ItemBlock[])items.toArray(CommonInventoryData.ItemBlock[]::new);
        this.setResponseContent("text/xml", req.generateXmlValue("CI", (Object)resp));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setCommonInventory(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        SetCommonInventoryRequestData[] requests = (SetCommonInventoryRequestData[])req.parseXmlValue((String)req.payload.get("commonInventoryRequestXml"), SetCommonInventoryRequestData[].class);
        AccountDataContainer data = account.getAccountData();
        if (tkn.saveID != null) {
            data = account.getSave(tkn.saveID).getSaveData();
        }
        this.setResponseContent("text/xml", req.generateXmlValue("CIRS", (Object)InventoryUtils.processCommonInventorySet(requests, data, Integer.parseInt((String)req.payload.get("ContainerId")))));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getKeyValuePair(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        AccountDataContainer data = account.getAccountData();
        if (tkn.saveID != null) {
            data = account.getSave(tkn.saveID).getSaveData();
        }
        data = data.getChildContainer("keyvaluedata");
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        if (data.entryExists("pairs-" + pair)) {
            int i = 0;
            JsonObject pairs = data.getEntry("pairs-" + pair).getAsJsonObject();
            KeyValuePairSetData setData = new KeyValuePairSetData();
            setData.items = new KeyValuePairData[pairs.size()];
            for (String key : pairs.keySet()) {
                JsonObject obj = pairs.get(key).getAsJsonObject();
                KeyValuePairData p = new KeyValuePairData();
                p.key = key;
                p.value = obj.get("value").getAsString();
                p.updateDate = fmt.format(new Date(obj.get("time").getAsLong()));
                setData.items[i++] = p;
            }
            if (setData.items.length != 0) {
                this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)setData));
            } else {
                this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)new EmptyKeyValuePairSetData()));
            }
        } else {
            this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)new EmptyKeyValuePairSetData()));
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getKeyValuePairByUserID(LegacyFunctionInfo func) throws IOException {
        AccountDataContainer data;
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        String userID = (String)req.payload.get("userId");
        boolean isDragon = false;
        AccountDataContainer dragonData = null;
        if (!userID.equals(account.getAccountID()) && account.getSave(userID) == null && tkn.hasCapability("gp")) {
            data = account.getSave(tkn.saveID).getSaveData().getChildContainer("dragons");
            JsonArray dragonIds = new JsonArray();
            if (data.entryExists("dragonlist")) {
                dragonIds = data.getEntry("dragonlist").getAsJsonArray();
            } else {
                data.setEntry("dragonlist", (JsonElement)dragonIds);
            }
            for (JsonElement ele : dragonIds) {
                String id = ele.getAsString();
                ObjectNode dragon = (ObjectNode)req.parseXmlValue(data.getEntry("dragon-" + id).getAsString(), ObjectNode.class);
                if (!dragon.get("eid").asText().equals(userID)) continue;
                isDragon = true;
                dragonData = data.getChildContainer("dragondata-" + userID);
                break;
            }
        }
        if (isDragon || userID.equals(account.getAccountID()) || account.getSave(userID) != null) {
            data = dragonData;
            if (data == null) {
                data = account.getAccountData();
                if (!userID.equals(account.getAccountID())) {
                    data = account.getSave(userID).getSaveData();
                }
            }
            data = data.getChildContainer("keyvaluedata");
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
            fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
            if (data.entryExists("pairs-" + pair)) {
                int i = 0;
                JsonObject pairs = data.getEntry("pairs-" + pair).getAsJsonObject();
                KeyValuePairSetData setData = new KeyValuePairSetData();
                setData.items = new KeyValuePairData[pairs.size()];
                for (String key : pairs.keySet()) {
                    JsonObject obj = pairs.get(key).getAsJsonObject();
                    KeyValuePairData p = new KeyValuePairData();
                    p.key = key;
                    p.value = obj.get("value").getAsString();
                    p.updateDate = fmt.format(new Date(obj.get("time").getAsLong()));
                    setData.items[i++] = p;
                }
                if (setData.items.length != 0) {
                    this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)setData));
                } else {
                    this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)new EmptyKeyValuePairSetData()));
                }
            } else {
                this.setResponseContent("text/xml", req.generateXmlValue("Pairs", (Object)new EmptyKeyValuePairSetData()));
            }
        } else {
            this.setResponseStatus(403, "Forbidden");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setKeyValuePair(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        KeyValuePairSetData updateData = (KeyValuePairSetData)req.parseXmlValue((String)req.payload.get("contentXML"), KeyValuePairSetData.class);
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        AccountDataContainer data = account.getAccountData();
        if (tkn.saveID != null) {
            data = account.getSave(tkn.saveID).getSaveData();
        }
        data = data.getChildContainer("keyvaluedata");
        JsonObject pairData = new JsonObject();
        if (data.entryExists("pairs-" + pair)) {
            pairData = data.getEntry("pairs-" + pair).getAsJsonObject();
        }
        if (updateData != null && updateData.items != null) {
            for (KeyValuePairData pairI : updateData.items) {
                JsonObject p = new JsonObject();
                p.addProperty("value", pairI.value);
                p.addProperty("time", (Number)System.currentTimeMillis());
                pairData.add(pairI.key, (JsonElement)p);
            }
            data.setEntry("pairs-" + pair, (JsonElement)pairData);
        }
        this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setKeyValuePairByUserID(LegacyFunctionInfo func) throws IOException {
        AccountDataContainer data;
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        KeyValuePairSetData updateData = (KeyValuePairSetData)req.parseXmlValue((String)req.payload.get("contentXML"), KeyValuePairSetData.class);
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        String userID = (String)req.payload.get("userId");
        boolean isDragon = false;
        AccountDataContainer dragonData = null;
        if (!userID.equals(account.getAccountID()) && account.getSave(userID) == null && tkn.hasCapability("gp")) {
            data = account.getSave(tkn.saveID).getSaveData().getChildContainer("dragons");
            JsonArray dragonIds = new JsonArray();
            if (data.entryExists("dragonlist")) {
                dragonIds = data.getEntry("dragonlist").getAsJsonArray();
            } else {
                data.setEntry("dragonlist", (JsonElement)dragonIds);
            }
            for (JsonElement ele : dragonIds) {
                String id = ele.getAsString();
                ObjectNode dragon = (ObjectNode)req.parseXmlValue(data.getEntry("dragon-" + id).getAsString(), ObjectNode.class);
                if (!dragon.get("eid").asText().equals(userID)) continue;
                isDragon = true;
                dragonData = data.getChildContainer("dragondata-" + userID);
                break;
            }
        }
        if (isDragon || userID.equals(account.getAccountID()) || account.getSave(userID) != null) {
            data = dragonData;
            if (data == null) {
                data = account.getAccountData();
                if (!userID.equals(account.getAccountID())) {
                    data = account.getSave(userID).getSaveData();
                }
            }
            data = data.getChildContainer("keyvaluedata");
            JsonObject pairData = new JsonObject();
            if (data.entryExists("pairs-" + pair)) {
                pairData = data.getEntry("pairs-" + pair).getAsJsonObject();
            }
            for (KeyValuePairData pairI : updateData.items) {
                JsonObject p = new JsonObject();
                p.addProperty("value", pairI.value);
                p.addProperty("time", (Number)System.currentTimeMillis());
                pairData.add(pairI.key, (JsonElement)p);
            }
            data.setEntry("pairs-" + pair, (JsonElement)pairData);
            this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
        } else {
            this.setResponseStatus(403, "Forbidden");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void delKeyValuePair(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        AccountDataContainer data = account.getAccountData();
        if (tkn.saveID != null) {
            data = account.getSave(tkn.saveID).getSaveData();
        }
        if ((data = data.getChildContainer("keyvaluedata")).entryExists("pairs-" + pair)) {
            data.deleteEntry("pairs-" + pair);
        }
        this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void delKeyValuePairByUserID(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        String userID = (String)req.payload.get("userId");
        if (userID.equals(account.getAccountID()) || account.getSave(userID) != null) {
            AccountDataContainer data = account.getAccountData();
            if (!userID.equals(account.getAccountID())) {
                data = account.getSave(userID).getSaveData();
            }
            if ((data = data.getChildContainer("keyvaluedata")).entryExists("pairs-" + pair)) {
                data.deleteEntry("pairs-" + pair);
            }
            this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
        } else {
            this.setResponseStatus(403, "Forbidden");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void delKeyValuePairByKey(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        int pair = Integer.parseInt((String)req.payload.get("pairId"));
        String userID = (String)req.payload.get("userId");
        if (userID.equals(account.getAccountID()) || account.getSave(userID) != null) {
            JsonObject pairData;
            AccountDataContainer data = account.getAccountData();
            if (!userID.equals(account.getAccountID())) {
                data = account.getSave(userID).getSaveData();
            }
            if ((data = data.getChildContainer("keyvaluedata")).entryExists("pairs-" + pair) && (pairData = data.getEntry("pairs-" + pair).getAsJsonObject()).has((String)req.payload.get("pairKey"))) {
                pairData.remove((String)req.payload.get("pairKey"));
                data.setEntry("pairs-" + pair, (JsonElement)pairData);
            }
            this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
        } else {
            this.setResponseStatus(403, "Forbidden");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getSelectedRaisedPet(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        if (userID.equals(account.getAccountID()) || account.getSave(userID) != null) {
            AccountDataContainer data = account.getAccountData();
            if (!userID.equals(account.getAccountID())) {
                data = account.getSave(userID).getSaveData();
            }
            data = data.getChildContainer("dragons");
            JsonArray dragonIds = new JsonArray();
            if (data.entryExists("dragonlist")) {
                dragonIds = data.getEntry("dragonlist").getAsJsonArray();
            } else {
                data.setEntry("dragonlist", (JsonElement)dragonIds);
            }
            ArrayList<DragonData> dragons = new ArrayList<DragonData>();
            for (JsonElement ele : dragonIds) {
                String id = ele.getAsString();
                DragonData dragon = (DragonData)req.parseXmlValue(data.getEntry("dragon-" + id).getAsString(), DragonData.class);
                if (TextFilterService.getInstance().isFiltered(dragon.name, true)) {
                    dragon.name = TextFilterService.getInstance().filterString(dragon.name, account.isStrictChatFilterEnabled());
                    ArrayList<ObjectNode> attrs = new ArrayList<ObjectNode>(List.of(dragon.attributes));
                    Optional<ObjectNode> att = attrs.stream().filter(t -> t.get("k").asText().equalsIgnoreCase("NameCustomized")).findFirst();
                    if (att.isPresent()) {
                        attrs.remove(att.get());
                    }
                    dragon.attributes = (ObjectNode[])attrs.toArray(ObjectNode[]::new);
                    data.setEntry("dragon-" + id, (JsonElement)new JsonPrimitive(req.generateXmlValue("RaisedPetData", (Object)dragon)));
                }
                if (!dragon.isSelected) continue;
                dragons.add(dragon);
            }
            if (dragons.size() != 0) {
                DragonListData ls = new DragonListData();
                ls.dragons = (DragonData[])dragons.toArray(DragonData[]::new);
                this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfRaisedPetData", (Object)ls));
            } else {
                this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfRaisedPetData", null));
            }
        } else {
            this.setResponseStatus(403, "Forbidden, attempted to interact with other user's data (devs please inspect)");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setSelectedPet(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String dragonID = (String)req.payload.get("raisedPetID");
        AccountDataContainer data = account.getSave(tkn.saveID).getSaveData();
        data = data.getChildContainer("dragons");
        JsonArray dragonIds = new JsonArray();
        if (data.entryExists("dragonlist")) {
            dragonIds = data.getEntry("dragonlist").getAsJsonArray();
        } else {
            data.setEntry("dragonlist", (JsonElement)dragonIds);
        }
        boolean found = false;
        for (JsonElement ele : dragonIds) {
            String id = ele.getAsString();
            ObjectNode dragon = (ObjectNode)req.parseXmlValue(data.getEntry("dragon-" + id).getAsString(), ObjectNode.class);
            if (!id.equals(dragonID) && !dragon.get("is").asBoolean()) continue;
            if (id.equals(dragonID)) {
                dragon.set("is", (JsonNode)BooleanNode.TRUE);
                found = true;
            } else {
                dragon.set("is", (JsonNode)BooleanNode.FALSE);
            }
            data.setEntry("dragon-" + id, (JsonElement)new JsonPrimitive(req.generateXmlValue("RaisedPetData", (Object)dragon)));
        }
        this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)found));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getUnselectedPetByTypes(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        String[] types = ((String)req.payload.get("petTypeIDs")).split(",");
        if (userID.equals(account.getAccountID()) || account.getSave(userID) != null) {
            AccountDataContainer data = account.getAccountData();
            if (!userID.equals(account.getAccountID())) {
                data = account.getSave(userID).getSaveData();
            }
            data = data.getChildContainer("dragons");
            JsonArray dragonIds = new JsonArray();
            if (data.entryExists("dragonlist")) {
                dragonIds = data.getEntry("dragonlist").getAsJsonArray();
            } else {
                data.setEntry("dragonlist", (JsonElement)dragonIds);
            }
            ArrayList<DragonData> dragons = new ArrayList<DragonData>();
            for (JsonElement ele : dragonIds) {
                String id = ele.getAsString();
                DragonData dragon = (DragonData)req.parseXmlValue(data.getEntry("dragon-" + id).getAsString(), DragonData.class);
                if (TextFilterService.getInstance().isFiltered(dragon.name, true)) {
                    dragon.name = TextFilterService.getInstance().filterString(dragon.name, account.isStrictChatFilterEnabled());
                    ArrayList<ObjectNode> attrs = new ArrayList<ObjectNode>(List.of(dragon.attributes));
                    Optional<ObjectNode> att = attrs.stream().filter(t -> t.get("k").asText().equalsIgnoreCase("NameCustomized")).findFirst();
                    if (att.isPresent()) {
                        attrs.remove(att.get());
                    }
                    dragon.attributes = (ObjectNode[])attrs.toArray(ObjectNode[]::new);
                    data.setEntry("dragon-" + id, (JsonElement)new JsonPrimitive(req.generateXmlValue("RaisedPetData", (Object)dragon)));
                }
                if (types.length != 0 && !Stream.of(types).anyMatch(t -> t.equals(dragon.typeID))) continue;
                dragons.add(dragon);
            }
            if (dragons.size() != 0) {
                DragonListData ls = new DragonListData();
                ls.dragons = (DragonData[])dragons.toArray(DragonData[]::new);
                this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfRaisedPetData", (Object)ls));
            } else {
                this.setResponseContent("text/xml", req.generateXmlValue("ArrayOfRaisedPetData", null));
            }
        } else {
            this.setResponseStatus(403, "Forbidden");
        }
    }

    @LegacyFunction(allowedMethods={"POST", "GET"})
    public void getImage(LegacyFunctionInfo func) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (func.getQuery().containsKey("edgereq") && ((String)func.getQuery().get("edgereq")).equals("true")) {
            String slot = (String)func.getQuery().get("slot");
            String type = (String)func.getQuery().get("type");
            String account = (String)func.getQuery().get("account");
            String save = (String)func.getQuery().get("save");
            AccountObject acc = manager.getAccount(account);
            if (acc == null || acc.getSave(save) == null) {
                this.setResponseStatus(404, "Not found");
                return;
            }
            AccountDataContainer data = acc.getSave(save).getSaveData().getChildContainer("images");
            if (!data.entryExists("imagefile-" + slot + "-" + type)) {
                this.setResponseStatus(404, "Not found");
                return;
            }
            this.getResponse().setContent("image/jpeg", Base64.getDecoder().decode(data.getEntry("imagefile-" + slot + "-" + type).getAsString()));
            return;
        }
        EdgeWebService.ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger());
        if (req == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String slot = (String)req.payload.get("ImageSlot");
        String type = (String)req.payload.get("ImageType");
        AccountDataContainer data = account.getSave(tkn.saveID).getSaveData().getChildContainer("images");
        if (!data.entryExists("imageslotinfo-" + slot + "-" + type)) {
            this.setResponseContent("text/xml", req.generateXmlValue("ImageData", null));
            return;
        }
        this.setResponseContent("text/xml", data.getEntry("imageslotinfo-" + slot + "-" + type).getAsString());
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void setImage(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String xml = (String)req.payload.get("contentXML");
        String slot = (String)req.payload.get("ImageSlot");
        String type = (String)req.payload.get("ImageType");
        AccountDataContainer data = account.getSave(tkn.saveID).getSaveData().getChildContainer("images");
        ObjectNode imgD = (ObjectNode)req.parseXmlValue(xml, ObjectNode.class);
        String prot = "http://";
        if (((EdgeGameplayApiServer)this.getServerInstance()).getServer() instanceof TlsSecuredHttpServer) {
            prot = "https://";
        }
        imgD.set("ImageURL", (JsonNode)new TextNode(prot + this.getHeader("Host") + "/" + this.getRequest().getRequestPath().substring(0, this.getRequest().getRequestPath().toLowerCase().lastIndexOf("setimage")) + "GetImage?edgereq=true&slot=" + URLEncoder.encode(slot, "UTF-8") + "&account=" + URLEncoder.encode(account.getAccountID(), "UTF-8") + "&save=" + URLEncoder.encode(tkn.saveID, "UTF-8") + "&type=" + URLEncoder.encode(type, "UTF-8") + "&file=image.jpg"));
        data.setEntry("imageslotinfo-" + slot + "-" + type, (JsonElement)new JsonPrimitive(req.generateXmlValue("ImageData", (Object)imgD)));
        data.setEntry("imagefile-" + slot + "-" + type, (JsonElement)new JsonPrimitive((String)req.payload.get("imageFile")));
        this.setResponseContent("text/xml", req.generateXmlValue("boolean", (Object)true));
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getUserMissionState(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (questManager == null) {
            questManager = QuestManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        String userID = (String)req.payload.get("userId");
        AccountSaveContainer save = account.getSave(userID);
        if (save != null) {
            MissionData[] quests = questManager.getAllQuestDefs();
            RequestFilterDataLegacy filter = (RequestFilterDataLegacy)req.parseXmlValue((String)req.payload.get("filter"), RequestFilterDataLegacy.class);
            ArrayList<Integer> addedQuests = new ArrayList<Integer>();
            ArrayList<MissionData> questLst = new ArrayList<MissionData>();
            QuestListResponseData resp = new QuestListResponseData();
            resp.userID = userID;
            boolean hasExplicitRequests = false;
            if (filter.missionID != -1) {
                hasExplicitRequests = true;
                UserQuestInfo quest = questManager.getUserQuest(save, filter.missionID);
                if (quest != null && (filter.getCompletedMissions || !quest.isCompleted())) {
                    questLst.add(quest.getData());
                    addedQuests.add(quest.getQuestID());
                }
            }
            if (filter.groupID != -1) {
                hasExplicitRequests = true;
                for (MissionData data : quests) {
                    UserQuestInfo quest;
                    if (addedQuests.contains(data.id) || data.groupID != filter.groupID || (quest = questManager.getUserQuest(save, data.id)) == null || !filter.getCompletedMissions && quest.isCompleted()) continue;
                    questLst.add(quest.getData());
                    addedQuests.add(quest.getQuestID());
                }
            }
            if (!hasExplicitRequests) {
                if (filter.getCompletedMissions) {
                    for (UserQuestInfo quest : questManager.getCompletedQuests(save)) {
                        if (addedQuests.contains(quest.getQuestID())) continue;
                        MissionData d = quest.getData();
                        questLst.add(d);
                        addedQuests.add(quest.getQuestID());
                    }
                } else {
                    questLst.add(questManager.getUserQuest(save, 999).getData());
                }
            }
            resp.quests = (MissionData[])questLst.toArray(MissionData[]::new);
            this.setResponseContent("text/xml", req.generateXmlValue("UserMissionStateResult", (Object)resp));
        } else {
            this.setResponseStatus(404, "Not found");
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void redeemMysteryBoxItems(LegacyFunctionInfo func) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        String apiToken = this.getUtilities().decodeToken(((String)req.payload.get("apiToken")).toUpperCase());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(apiToken);
        AccountObject account = tkn.account;
        if (res != TokenParseResult.SUCCESS || !tkn.hasCapability("gp")) {
            this.setResponseStatus(404, "Not found");
            return;
        }
        AccountSaveContainer save = account.getSave(tkn.saveID);
        ItemRedeemRequestData request = (ItemRedeemRequestData)req.parseXmlValue((String)req.payload.get("request"), ItemRedeemRequestData.class);
        int id = request.itemID;
        int containerId = Integer.parseInt(req.payload.getOrDefault("ContainerId", "1"));
        PlayerInventoryContainer cont = save.getInventory().getContainer(containerId);
        PlayerInventoryItem itm = cont.findFirst(id);
        if (itm == null || itm.getQuantity() < 1) {
            InventoryUpdateResponseData resp = new InventoryUpdateResponseData();
            resp.success = false;
            this.setResponseContent("text/xml", req.generateXmlValue("CIRS", (Object)resp));
            return;
        }
        itm.remove(1);
        ItemRedemptionInfo rReq = new ItemRedemptionInfo();
        rReq.containerID = containerId;
        rReq.defID = id;
        rReq.quantity = 1;
        InventoryUpdateResponseData response = InventoryUtils.redeemItems(new ItemRedemptionInfo[]{rReq}, account, save, true);
        if (itm.getQuantity() > 0) {
            if (response.updateItems == null) {
                response.updateItems = new InventoryUpdateResponseData.ItemUpdateBlock[0];
            }
            InventoryUpdateResponseData.ItemUpdateBlock b = new InventoryUpdateResponseData.ItemUpdateBlock();
            b.itemID = itm.getItemDefID();
            b.itemUniqueID = itm.getUniqueID();
            b.addedQuantity = -1;
            response.updateItems = ContentWebServiceV1Processor.appendTo(response.updateItems, b);
        }
        this.setResponseContent("text/xml", req.generateXmlValue("CIRS", (Object)response));
    }

    @SodRequest
    public FunctionResult getDisplayNameByUserID(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, @SodRequestParam String userId) throws IOException {
        AccountSaveContainer save;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((save = manager.getSaveByID(userId)) == null) {
            return this.response(404, "Not found");
        }
        return this.ok("text/xml", req.generateXmlValue("string", (Object)save.getUsername()));
    }

    @SodRequest
    @SodTokenSecured
    @TokenRequireSave
    @TokenRequireCapability(value="gp")
    public FunctionResult useInventory(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, @SodRequestParam int userInventoryId, @SodRequestParam int uses) throws IOException {
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        AccountDataContainer data = account.getAccountData();
        if (tkn.saveID != null) {
            data = account.getSave(tkn.saveID).getSaveData();
        }
        int containerId = Integer.parseInt(req.payload.getOrDefault("ContainerId", "1"));
        PlayerInventory inv = itemManager.getCommonInventory(data);
        PlayerInventoryContainer cont = inv.getContainer(containerId);
        PlayerInventoryItem itm = cont.getItem(userInventoryId);
        if (itm == null) {
            return this.ok("text/xml", req.generateXmlValue("boolean", (Object)false));
        }
        int usesLeft = itm.getUses();
        if (usesLeft == -1) {
            usesLeft = 1;
        }
        if (uses > usesLeft) {
            return this.ok("text/xml", req.generateXmlValue("boolean", (Object)false));
        }
        if (!itm.useItem(uses)) {
            return this.ok("text/xml", req.generateXmlValue("boolean", (Object)false));
        }
        return this.ok("text/xml", req.generateXmlValue("boolean", (Object)true));
    }

    @SodRequest
    @SodTokenSecured
    public FunctionResult getGameDataByUser(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, @SodRequestParam String userId) throws IOException {
        AccountSaveContainer save;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((save = account.getSave(userId)) == null) {
            return this.response(404, "Not found");
        }
        MinigameDataRequest srq = new MinigameDataRequest();
        srq.gameLevel = Integer.parseInt((String)req.payload.get("gameLevel"));
        srq.difficulty = Integer.parseInt((String)req.payload.get("difficulty"));
        srq.friendsOnly = ((String)req.payload.get("buddyFilter")).equalsIgnoreCase("true");
        srq.maxEntries = Integer.parseInt((String)req.payload.get("count"));
        srq.key = (String)req.payload.get("key");
        MinigameData data = MinigameDataManager.getInstance().getGameDataOf(save, Integer.parseInt((String)req.payload.get("gameId")), srq);
        GameDataSummaryData resp = new GameDataSummaryData();
        resp.gameID = Integer.parseInt((String)req.payload.get("gameId"));
        resp.difficulty = srq.difficulty;
        resp.isMultiplayer = ((String)req.payload.get("isMultiplayer")).equalsIgnoreCase("true");
        resp.userPosition = 0;
        resp.key = srq.key;
        resp.entries = new GameDataSummaryData.GameDataBlock[1];
        resp.entries[0] = new GameDataSummaryData.GameDataBlock();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        resp.entries[0].datePlayed = fmt.format(new Date(data.timePlayed));
        resp.entries[0].rankID = 1;
        resp.entries[0].timesLost = data.timesLost;
        resp.entries[0].timesWon = data.timesWon;
        resp.entries[0].userID = data.userID;
        resp.entries[0].userName = AccountManager.getInstance().getSaveByID(data.userID).getUsername();
        resp.entries[0].value = data.value;
        return this.ok("text/xml", req.generateXmlValue("GameDataSummary", (Object)resp));
    }

    @SodRequest
    @SodTokenSecured
    public FunctionResult getGameDataByGame(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, @SodRequestParam String userId) throws IOException {
        AccountSaveContainer save;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((save = account.getSave(userId)) == null) {
            return this.response(404, "Not found");
        }
        MinigameDataRequest srq = new MinigameDataRequest();
        srq.gameLevel = Integer.parseInt((String)req.payload.get("gameLevel"));
        srq.difficulty = Integer.parseInt((String)req.payload.get("difficulty"));
        srq.friendsOnly = ((String)req.payload.get("buddyFilter")).equalsIgnoreCase("true");
        srq.maxEntries = Integer.parseInt((String)req.payload.get("count"));
        srq.key = (String)req.payload.get("key");
        MinigameData[] list = MinigameDataManager.getInstance().getAllGameData(userId, Integer.parseInt((String)req.payload.get("gameId")), srq);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
        fmt.setTimeZone(TimeZone.getTimeZone("UTC"));
        GameDataSummaryData resp = new GameDataSummaryData();
        resp.gameID = Integer.parseInt((String)req.payload.get("gameId"));
        resp.difficulty = srq.difficulty;
        resp.isMultiplayer = ((String)req.payload.get("isMultiplayer")).equalsIgnoreCase("true");
        resp.key = srq.key;
        resp.userPosition = -1;
        resp.entries = new GameDataSummaryData.GameDataBlock[list.length];
        for (int i = 0; i < resp.entries.length; ++i) {
            MinigameData data = list[i];
            resp.entries[i] = new GameDataSummaryData.GameDataBlock();
            resp.entries[i].datePlayed = fmt.format(new Date(data.timePlayed));
            resp.entries[i].rankID = i + 1;
            resp.entries[i].timesLost = data.timesLost;
            resp.entries[i].timesWon = data.timesWon;
            resp.entries[i].userID = data.userID;
            resp.entries[i].userName = AccountManager.getInstance().getSaveByID(data.userID).getUsername();
            resp.entries[i].value = data.value;
            if (!resp.entries[i].userID.equals(userId)) continue;
            resp.userPosition = i;
        }
        return this.ok("text/xml", req.generateXmlValue("GameDataSummary", (Object)resp));
    }

    @SodRequest
    @SodTokenSecured
    public FunctionResult sendRawGameData(FunctionInfo func, EdgeWebService.ServiceRequestInfo req, SessionToken tkn, AccountObject account, @SodRequestParam String userId) throws IOException {
        AccountSaveContainer save;
        if (manager == null) {
            manager = AccountManager.getInstance();
        }
        if ((save = account.getSave(userId)) == null) {
            return this.ok("text/xml", req.generateXmlValue("boolean", (Object)false));
        }
        MinigameSaveRequest srq = new MinigameSaveRequest();
        srq.gameLevel = Integer.parseInt((String)req.payload.get("gameLevel"));
        srq.difficulty = Integer.parseInt((String)req.payload.get("difficulty"));
        srq.isLoss = ((String)req.payload.get("loss")).equalsIgnoreCase("true");
        srq.isWin = ((String)req.payload.get("win")).equalsIgnoreCase("true");
        srq.data = new HashMap();
        ObjectNode nd = (ObjectNode)req.parseXmlValue((String)req.payload.get("xmlDocumentData"), ObjectNode.class);
        Iterator names = nd.fieldNames();
        while (names.hasNext()) {
            String key = (String)names.next();
            srq.data.put(key, nd.get(key).asInt());
        }
        MinigameDataManager.getInstance().saveGameData(save, Integer.parseInt((String)req.payload.get("gameId")), srq);
        return this.ok("text/xml", req.generateXmlValue("boolean", (Object)true));
    }

    private static InventoryUpdateResponseData.ItemUpdateBlock[] appendTo(InventoryUpdateResponseData.ItemUpdateBlock[] arr, InventoryUpdateResponseData.ItemUpdateBlock block) {
        InventoryUpdateResponseData.ItemUpdateBlock[] newB = new InventoryUpdateResponseData.ItemUpdateBlock[arr.length + 1];
        for (int i = 0; i < newB.length; ++i) {
            newB[i] = i >= arr.length ? block : arr[i];
        }
        return newB;
    }
}

