/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.http.handlers.edgespecific;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.stream.Stream;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.entities.achivements.EntityRankInfo;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.Function;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionInfo;
import org.asf.edge.common.http.apihandlerutils.functions.FunctionResult;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountManager;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.common.services.textfilter.TextFilterService;
import org.asf.edge.common.services.textfilter.result.FilterResult;
import org.asf.edge.common.services.textfilter.result.WordMatch;
import org.asf.edge.common.tokens.SessionToken;
import org.asf.edge.common.tokens.TokenParseResult;
import org.asf.edge.gameplayapi.EdgeGameplayApiServer;

public class EdgeApiService
extends EdgeWebService<EdgeGameplayApiServer> {
    public EdgeApiService(EdgeGameplayApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new EdgeApiService((EdgeGameplayApiServer)this.getServerInstance());
    }

    public String path() {
        return "/API/ProjectEdge/";
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult getProfileByID(FunctionInfo func) throws IOException {
        JsonObject request;
        try {
            request = JsonParser.parseString((String)func.getRequest().getRequestBodyAsString()).getAsJsonObject();
            if (!request.has("id")) {
                throw new IOException();
            }
        }
        catch (Exception e) {
            return this.response(400, "Bad request", "text/json", "{\"error\":\"Invalid request body, expecting a JSON with a 'id' field\"}");
        }
        String id = request.get("id").getAsString();
        AccountManager manager = AccountManager.getInstance();
        AccountSaveContainer save = manager.getSaveByID(id);
        if (save == null) {
            return this.response(404, "Not found", "text/json", "{\"error\":\"save_not_found\"}");
        }
        AccountObject acc = save.getAccount();
        JsonObject resp = new JsonObject();
        resp.addProperty("saveId", save.getSaveID());
        resp.addProperty("saveUsername", save.getUsername());
        resp.addProperty("registrationTime", (Number)acc.getRegistrationTimestamp());
        resp.addProperty("saveCreationTime", (Number)save.getCreationTime());
        JsonElement ele = save.getSaveData().getEntry("avatar");
        if (ele != null) {
            resp.add("avatar", ele);
        }
        JsonArray rankData = new JsonArray();
        for (EntityRankInfo rank : AchievementManager.getInstance().getRanks(save, id)) {
            if (rank.getRank() == null) continue;
            JsonObject rObj = new JsonObject();
            rObj.addProperty("rankID", (Number)rank.getRank().getID());
            rObj.addProperty("rankGlobalID", (Number)rank.getRank().getGlobalID());
            rObj.addProperty("pointTypeID", (Number)rank.getRank().getPointTypeID());
            rObj.addProperty("level", (Number)(AchievementManager.getInstance().getRankIndex(rank.getRank()) + 1));
            rObj.addProperty("points", (Number)rank.getTotalScore());
            rankData.add((JsonElement)rObj);
        }
        resp.add("ranks", (JsonElement)rankData);
        return this.ok("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult getProfileByName(FunctionInfo func) throws IOException {
        JsonObject request;
        try {
            request = JsonParser.parseString((String)func.getRequest().getRequestBodyAsString()).getAsJsonObject();
            if (!request.has("name")) {
                throw new IOException();
            }
        }
        catch (Exception e) {
            return this.response(400, "Bad request", "text/json", "{\"error\":\"Invalid request body, expecting a JSON with a 'name' field\"}");
        }
        String name = request.get("name").getAsString();
        AccountManager manager = AccountManager.getInstance();
        String accID = manager.getAccountIdBySaveUsername(name);
        if (accID == null) {
            return this.response(404, "Not found", "text/json", "{\"error\":\"save_not_found\"}");
        }
        AccountObject acc = manager.getAccount(accID);
        if (acc == null) {
            return this.response(404, "Not found", "text/json", "{\"error\":\"save_not_found\"}");
        }
        AccountSaveContainer save = null;
        for (String saveID : acc.getSaveIDs()) {
            AccountSaveContainer sv = acc.getSave(saveID);
            if (!sv.getUsername().equalsIgnoreCase(name)) continue;
            save = sv;
            break;
        }
        if (save == null) {
            return this.response(404, "Not found", "text/json", "{\"error\":\"save_not_found\"}");
        }
        JsonObject resp = new JsonObject();
        resp.addProperty("saveId", save.getSaveID());
        resp.addProperty("saveUsername", save.getUsername());
        resp.addProperty("registrationTime", (Number)acc.getRegistrationTimestamp());
        resp.addProperty("saveCreationTime", (Number)save.getCreationTime());
        JsonElement ele = save.getSaveData().getEntry("avatar");
        if (ele != null) {
            resp.add("avatar", ele);
        }
        JsonArray rankData = new JsonArray();
        for (EntityRankInfo rank : AchievementManager.getInstance().getRanks(save, save.getSaveID())) {
            if (rank.getRank() == null) continue;
            JsonObject rObj = new JsonObject();
            rObj.addProperty("rankID", (Number)rank.getRank().getID());
            rObj.addProperty("rankGlobalID", (Number)rank.getRank().getGlobalID());
            rObj.addProperty("pointTypeID", (Number)rank.getRank().getPointTypeID());
            rObj.addProperty("level", (Number)(AchievementManager.getInstance().getRankIndex(rank.getRank()) + 1));
            rObj.addProperty("points", (Number)rank.getTotalScore());
            rankData.add((JsonElement)rObj);
        }
        resp.add("ranks", (JsonElement)rankData);
        return this.ok("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult registerAccount(FunctionInfo func) throws IOException {
        JsonObject request;
        try {
            request = JsonParser.parseString((String)func.getRequest().getRequestBodyAsString()).getAsJsonObject();
            if (!(request.has("email") && request.has("username") && request.has("password") && request.has("subscribeEmailNotifications") && request.has("isUnderageUser"))) {
                throw new IOException();
            }
        }
        catch (Exception e) {
            return this.response(400, "Bad request", "text/json", "{\"error\":\"Invalid request body, expecting a JSON with a 'email', 'username', 'password', 'subscribeEmailNotifications' and 'isUnderageUser' field\"}");
        }
        String email = request.get("email").getAsString();
        String username = request.get("username").getAsString();
        String password = request.get("password").getAsString();
        boolean subscribeEmail = request.get("subscribeEmailNotifications").getAsBoolean();
        boolean isUnderageUser = request.get("isUnderageUser").getAsBoolean();
        AccountManager manager = AccountManager.getInstance();
        if (!manager.isValidUsername(username)) {
            return this.response(400, "Bad request", "text/json", "{\"error\":\"invalid_username\"}");
        }
        if (TextFilterService.getInstance().isFiltered(username, true)) {
            return this.response(400, "Bad request", "text/json", "{\"error\":\"imappropriate_username\"}");
        }
        if (!manager.isValidPassword(password)) {
            return this.response(400, "Bad request", "text/json", "{\"error\":\"invalid_password\"}");
        }
        if (!email.toLowerCase().matches("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)\\])")) {
            return this.response(400, "Bad request", "text/json", "{\"error\":\"invalid_email\"}");
        }
        if (manager.getAccountIDByEmail(email) != null) {
            return this.response(400, "Bad request", "text/json", "{\"error\":\"email_in_use\"}");
        }
        if (manager.isUsernameTaken(username)) {
            return this.response(400, "Bad request", "text/json", "{\"error\":\"username_in_use\"}");
        }
        AccountObject acc = manager.registerAccount(username, email, password.toCharArray());
        if (acc == null) {
            return this.response(500, "Bad request", "text/json", "{\"error\":\"server_error\"}");
        }
        AccountDataContainer cont = acc.getAccountData().getChildContainer("accountdata");
        cont.setEntry("sendupdates", (JsonElement)new JsonPrimitive(Boolean.valueOf(subscribeEmail)));
        cont.setEntry("isunderage", (JsonElement)new JsonPrimitive(Boolean.valueOf(isUnderageUser)));
        if (isUnderageUser) {
            acc.setChatEnabled(false);
            acc.setStrictChatFilterEnabled(true);
        }
        AccountDataContainer currencyAccWide = acc.getAccountData().getChildContainer("currency");
        int current = 0;
        if (currencyAccWide.entryExists("gems")) {
            current = currencyAccWide.getEntry("gems").getAsInt();
        }
        currencyAccWide.setEntry("gems", (JsonElement)new JsonPrimitive((Number)(current + 75)));
        SessionToken tkn = new SessionToken();
        tkn.accountID = acc.getAccountID();
        tkn.lastLoginTime = acc.getLastLoginTime();
        tkn.capabilities = new String[]{"api"};
        ((EdgeGameplayApiServer)this.getServerInstance()).getLogger().info("API account registration from IP " + func.getClient().getRemoteAddress() + ": registered " + acc.getAccountID() + " (username: " + acc.getUsername() + ")");
        String token = tkn.toTokenString();
        acc.ping(true);
        JsonObject resp = new JsonObject();
        resp.addProperty("token", token);
        resp.addProperty("accountId", acc.getAccountID());
        resp.addProperty("accountUsername", acc.getUsername());
        resp.addProperty("lastLoginTime", (Number)acc.getLastLoginTime());
        resp.addProperty("registrationTime", (Number)acc.getRegistrationTimestamp());
        resp.addProperty("multiplayerEnabled", Boolean.valueOf(acc.isMultiplayerEnabled()));
        resp.addProperty("chatEnabled", Boolean.valueOf(acc.isChatEnabled()));
        resp.addProperty("strictChat", Boolean.valueOf(acc.isStrictChatFilterEnabled()));
        JsonObject profiles = new JsonObject();
        for (String save : acc.getSaveIDs()) {
            AccountSaveContainer sv = acc.getSave(save);
            if (sv == null) continue;
            JsonObject profile = new JsonObject();
            profile.addProperty("username", sv.getUsername());
            JsonElement ele = sv.getSaveData().getEntry("avatar");
            if (ele != null) {
                profile.add("avatar", ele);
            }
            JsonArray rankData = new JsonArray();
            for (EntityRankInfo rank : AchievementManager.getInstance().getRanks(sv, save)) {
                if (rank.getRank() == null) continue;
                JsonObject rObj = new JsonObject();
                rObj.addProperty("rankID", (Number)rank.getRank().getID());
                rObj.addProperty("rankGlobalID", (Number)rank.getRank().getGlobalID());
                rObj.addProperty("pointTypeID", (Number)rank.getRank().getPointTypeID());
                rObj.addProperty("level", (Number)(AchievementManager.getInstance().getRankIndex(rank.getRank()) + 1));
                rObj.addProperty("points", (Number)rank.getTotalScore());
                rankData.add((JsonElement)rObj);
            }
            profile.add("ranks", (JsonElement)rankData);
            profile.addProperty("creationTime", (Number)sv.getCreationTime());
            profiles.add(save, (JsonElement)profile);
        }
        resp.add("profiles", (JsonElement)profiles);
        acc.updateLastLoginTime();
        return this.ok("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult authenticate(FunctionInfo func) throws IOException {
        JsonObject request;
        try {
            request = JsonParser.parseString((String)func.getRequest().getRequestBodyAsString()).getAsJsonObject();
            if (!request.has("username") || !request.has("password")) {
                throw new IOException();
            }
        }
        catch (Exception e) {
            return this.response(400, "Bad request", "text/json", "{\"error\":\"Invalid request body, expecting a JSON with a 'username' and 'password' field\"}");
        }
        String username = request.get("username").getAsString();
        String password = request.get("password").getAsString();
        AccountManager manager = AccountManager.getInstance();
        if (!manager.isValidUsername(username)) {
            return this.invalidUserCallback(username, null);
        }
        if (!manager.isUsernameTaken(username)) {
            ((EdgeGameplayApiServer)this.getServerInstance()).getLogger().warn("API login from IP " + func.getClient().getRemoteAddress() + " rejected for " + username + ": account not found");
            return this.invalidUserCallback(username, null);
        }
        String id = manager.getAccountID(username);
        if (!manager.accountExists(id)) {
            ((EdgeGameplayApiServer)this.getServerInstance()).getLogger().warn("API login from IP " + func.getClient().getRemoteAddress() + " rejected for " + id + ": account not found");
            return this.invalidUserCallback(username, null);
        }
        AccountObject acc = manager.getAccount(id);
        if (acc.isGuestAccount()) {
            ((EdgeGameplayApiServer)this.getServerInstance()).getLogger().warn("API login from IP " + func.getClient().getRemoteAddress() + " rejected for " + acc.getAccountID() + ": guest accounts may not be directly logged in on");
            return this.invalidUserCallback(username, acc);
        }
        JsonElement lock = acc.getAccountData().getChildContainer("accountdata").getEntry("lockedsince");
        if (lock != null && System.currentTimeMillis() - lock.getAsLong() < 8000L) {
            ((EdgeGameplayApiServer)this.getServerInstance()).getLogger().warn("API login from IP " + func.getClient().getRemoteAddress() + " rejected for " + acc.getAccountID() + ": login rejected by antibruteforce");
            return this.response(401, "Unauthorized", "text/json", "{\"error\":\"invalid_credentials\"}");
        }
        if (!manager.verifyPassword(id, password)) {
            ((EdgeGameplayApiServer)this.getServerInstance()).getLogger().warn("API login from IP " + func.getClient().getRemoteAddress() + " rejected for " + id + ": invalid password");
            return this.invalidUserCallback(username, acc);
        }
        SessionToken tkn = new SessionToken();
        tkn.accountID = acc.getAccountID();
        tkn.lastLoginTime = acc.getLastLoginTime();
        tkn.capabilities = new String[]{"api"};
        ((EdgeGameplayApiServer)this.getServerInstance()).getLogger().info("API login from IP " + func.getClient().getRemoteAddress() + " to " + acc.getAccountID() + ": logged in as " + acc.getUsername());
        String token = tkn.toTokenString();
        acc.ping(true);
        JsonObject resp = new JsonObject();
        resp.addProperty("token", token);
        resp.addProperty("accountId", acc.getAccountID());
        resp.addProperty("accountUsername", acc.getUsername());
        resp.addProperty("lastLoginTime", (Number)acc.getLastLoginTime());
        resp.addProperty("registrationTime", (Number)acc.getRegistrationTimestamp());
        resp.addProperty("multiplayerEnabled", Boolean.valueOf(acc.isMultiplayerEnabled()));
        resp.addProperty("chatEnabled", Boolean.valueOf(acc.isChatEnabled()));
        resp.addProperty("strictChat", Boolean.valueOf(acc.isStrictChatFilterEnabled()));
        JsonObject profiles = new JsonObject();
        for (String save : acc.getSaveIDs()) {
            AccountSaveContainer sv = acc.getSave(save);
            if (sv == null) continue;
            JsonObject profile = new JsonObject();
            profile.addProperty("username", sv.getUsername());
            JsonElement ele = sv.getSaveData().getEntry("avatar");
            if (ele != null) {
                profile.add("avatar", ele);
            }
            JsonArray rankData = new JsonArray();
            for (EntityRankInfo rank : AchievementManager.getInstance().getRanks(sv, save)) {
                if (rank.getRank() == null) continue;
                JsonObject rObj = new JsonObject();
                rObj.addProperty("rankID", (Number)rank.getRank().getID());
                rObj.addProperty("rankGlobalID", (Number)rank.getRank().getGlobalID());
                rObj.addProperty("pointTypeID", (Number)rank.getRank().getPointTypeID());
                rObj.addProperty("level", (Number)(AchievementManager.getInstance().getRankIndex(rank.getRank()) + 1));
                rObj.addProperty("points", (Number)rank.getTotalScore());
                rankData.add((JsonElement)rObj);
            }
            profile.add("ranks", (JsonElement)rankData);
            profile.addProperty("creationTime", (Number)sv.getCreationTime());
            profiles.add(save, (JsonElement)profile);
        }
        resp.add("profiles", (JsonElement)profiles);
        acc.updateLastLoginTime();
        return this.ok("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult authenticateGuest(FunctionInfo func) throws IOException {
        JsonObject request;
        try {
            request = JsonParser.parseString((String)func.getRequest().getRequestBodyAsString()).getAsJsonObject();
            if (!request.has("guestID")) {
                throw new IOException();
            }
        }
        catch (Exception e) {
            return this.response(400, "Bad request", "text/json", "{\"error\":\"Invalid request body, expecting a JSON with a 'guestID' field\"}");
        }
        String guestID = request.get("guestID").getAsString();
        AccountManager manager = AccountManager.getInstance();
        AccountObject acc = manager.getGuestAccount(guestID);
        if (acc == null) {
            return this.response(404, "Guest not found", "text/json", "{\"error\":\"guest_not_found\"}");
        }
        SessionToken tkn = new SessionToken();
        tkn.accountID = acc.getAccountID();
        tkn.lastLoginTime = acc.getLastLoginTime();
        tkn.capabilities = new String[]{"api"};
        ((EdgeGameplayApiServer)this.getServerInstance()).getLogger().info("API login from IP " + func.getClient().getRemoteAddress() + " to " + acc.getAccountID() + ": logged in as " + acc.getUsername());
        String token = tkn.toTokenString();
        acc.ping(true);
        JsonObject resp = new JsonObject();
        resp.addProperty("token", token);
        resp.addProperty("accountId", acc.getAccountID());
        resp.addProperty("accountUsername", acc.getUsername());
        resp.addProperty("lastLoginTime", (Number)acc.getLastLoginTime());
        resp.addProperty("registrationTime", (Number)acc.getRegistrationTimestamp());
        resp.addProperty("multiplayerEnabled", Boolean.valueOf(acc.isMultiplayerEnabled()));
        resp.addProperty("chatEnabled", Boolean.valueOf(acc.isChatEnabled()));
        resp.addProperty("strictChat", Boolean.valueOf(acc.isStrictChatFilterEnabled()));
        JsonObject profiles = new JsonObject();
        for (String save : acc.getSaveIDs()) {
            AccountSaveContainer sv = acc.getSave(save);
            if (sv == null) continue;
            JsonObject profile = new JsonObject();
            profile.addProperty("username", sv.getUsername());
            JsonElement ele = sv.getSaveData().getEntry("avatar");
            if (ele != null) {
                profile.add("avatar", ele);
            }
            JsonArray rankData = new JsonArray();
            for (EntityRankInfo rank : AchievementManager.getInstance().getRanks(sv, save)) {
                if (rank.getRank() == null) continue;
                JsonObject rObj = new JsonObject();
                rObj.addProperty("rankID", (Number)rank.getRank().getID());
                rObj.addProperty("rankGlobalID", (Number)rank.getRank().getGlobalID());
                rObj.addProperty("pointTypeID", (Number)rank.getRank().getPointTypeID());
                rObj.addProperty("level", (Number)(AchievementManager.getInstance().getRankIndex(rank.getRank()) + 1));
                rObj.addProperty("points", (Number)rank.getTotalScore());
                rankData.add((JsonElement)rObj);
            }
            profile.add("ranks", (JsonElement)rankData);
            profile.addProperty("creationTime", (Number)sv.getCreationTime());
            profiles.add(save, (JsonElement)profile);
        }
        resp.add("profiles", (JsonElement)profiles);
        acc.updateLastLoginTime();
        return this.ok("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult authenticateSave(FunctionInfo func) throws IOException {
        JsonObject request;
        if (!func.getRequest().hasHeader("Authorization") || !func.getRequest().getHeader("Authorization").getValue().toLowerCase().startsWith("bearer ")) {
            return this.response(401, "Unauthorized", "text/json", "{\"error\":\"Missing authorization token\"}");
        }
        String token = func.getRequest().getHeader("Authorization").getValue().substring("bearer ".length());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(token);
        AccountObject acc = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            return this.response(401, "Unauthorized", "text/json", "{\"error\":\"Authorization token invalid\"}");
        }
        try {
            request = JsonParser.parseString((String)func.getRequest().getRequestBodyAsString()).getAsJsonObject();
            if (!request.has("saveID")) {
                throw new IOException();
            }
        }
        catch (Exception e) {
            return this.response(400, "Bad request", "text/json", "{\"error\":\"Invalid request body, expecting a JSON with a 'saveID' field\"}");
        }
        String saveID = request.get("saveID").getAsString();
        AccountSaveContainer save = acc.getSave(saveID);
        if (save == null) {
            return this.response(404, "Not found", "text/json", "{\"error\":\"save_not_found\"}");
        }
        tkn = new SessionToken();
        tkn.accountID = acc.getAccountID();
        tkn.saveID = saveID;
        tkn.lastLoginTime = acc.getLastLoginTime();
        tkn.capabilities = new String[]{"api", "gp"};
        ((EdgeGameplayApiServer)this.getServerInstance()).getLogger().info("Viking selected for account " + acc.getAccountID() + ": selected viking '" + save.getUsername() + "' (ID " + save.getSaveID() + ") from API.");
        save.getAccount().ping(true);
        token = tkn.toTokenString();
        JsonObject resp = new JsonObject();
        resp.addProperty("token", token);
        resp.addProperty("accountId", acc.getAccountID());
        resp.addProperty("accountUsername", acc.getUsername());
        resp.addProperty("saveId", save.getSaveID());
        resp.addProperty("saveUsername", save.getUsername());
        resp.addProperty("lastLoginTime", (Number)acc.getLastLoginTime());
        resp.addProperty("registrationTime", (Number)acc.getRegistrationTimestamp());
        resp.addProperty("saveCreationTime", (Number)save.getCreationTime());
        resp.addProperty("multiplayerEnabled", Boolean.valueOf(acc.isMultiplayerEnabled()));
        resp.addProperty("chatEnabled", Boolean.valueOf(acc.isChatEnabled()));
        resp.addProperty("strictChat", Boolean.valueOf(acc.isStrictChatFilterEnabled()));
        JsonElement ele = save.getSaveData().getEntry("avatar");
        if (ele != null) {
            resp.add("avatar", ele);
        }
        JsonArray rankData = new JsonArray();
        for (EntityRankInfo rank : AchievementManager.getInstance().getRanks(save, saveID)) {
            if (rank.getRank() == null) continue;
            JsonObject rObj = new JsonObject();
            rObj.addProperty("rankID", (Number)rank.getRank().getID());
            rObj.addProperty("rankGlobalID", (Number)rank.getRank().getGlobalID());
            rObj.addProperty("pointTypeID", (Number)rank.getRank().getPointTypeID());
            rObj.addProperty("level", (Number)(AchievementManager.getInstance().getRankIndex(rank.getRank()) + 1));
            rObj.addProperty("points", (Number)rank.getTotalScore());
            rankData.add((JsonElement)rObj);
        }
        resp.add("ranks", (JsonElement)rankData);
        return this.ok("text/json", resp.toString());
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult textFilter(FunctionInfo func) {
        JsonObject request;
        try {
            request = JsonParser.parseString((String)func.getRequest().getRequestBodyAsString()).getAsJsonObject();
            if (!request.has("message") || !request.has("strictMode")) {
                throw new IOException();
            }
        }
        catch (Exception e) {
            return this.response(400, "Bad request");
        }
        String message = request.get("message").getAsString();
        boolean strictMode = request.get("strictMode").getAsBoolean();
        FilterResult result = TextFilterService.getInstance().filter(message, strictMode);
        JsonArray matches = new JsonArray();
        for (WordMatch match : result.getMatches()) {
            JsonObject m = new JsonObject();
            m.addProperty("phrase", match.getPhraseFilter().getPhrase());
            m.addProperty("matchedPhrase", match.getMatchedPhrase());
            m.addProperty("reason", match.getReason());
            m.addProperty("severity", match.getSeverity().toString());
            matches.add((JsonElement)m);
        }
        JsonObject res = new JsonObject();
        res.addProperty("isFiltered", Boolean.valueOf(result.isMatch()));
        res.addProperty("resultMessage", result.getFilterResult());
        res.addProperty("resultSeverity", result.getSeverity().toString());
        res.add("matches", (JsonElement)matches);
        return this.ok("text/json", res.toString());
    }

    @Function(allowedMethods={"POST"})
    public FunctionResult downloadAccount(FunctionInfo func) {
        if (!func.getRequest().hasHeader("Authorization") || !func.getRequest().getHeader("Authorization").getValue().toLowerCase().startsWith("bearer ")) {
            return this.response(401, "Unauthorized", "text/json", "{\"error\":\"Missing authorization token\"}");
        }
        String token = func.getRequest().getHeader("Authorization").getValue().substring("bearer ".length());
        SessionToken tkn = new SessionToken();
        TokenParseResult res = tkn.parseToken(token);
        AccountObject acc = tkn.account;
        if (res != TokenParseResult.SUCCESS) {
            return this.response(401, "Unauthorized", "text/json", "{\"error\":\"Authorization token invalid\"}");
        }
        if (!this.getRequest().hasHeader("Upgrade") || !this.getRequest().getHeaderValue("Upgrade").equals("EDGEBINPROT/EDGESERVICES/DOWNLOADACCOUNT")) {
            return this.response(400, "Bad request");
        }
        this.setResponseHeader("X-Response-ID", UUID.randomUUID().toString());
        this.setResponseHeader("Upgrade", "EDGEBINPROT/EDGESERVICES/DOWNLOADACCOUNT");
        AsyncTaskManager.runAsync(() -> {
            while (!(!func.getClient().isConnected() || func.getResponse().hasHeader("Upgraded") && func.getResponse().getHeaderValue("Upgraded").equalsIgnoreCase("true"))) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            if (func.getClient().isConnected()) {
                InputStream input = func.getClient().getInputStream();
                OutputStream output = func.getClient().getOutputStream();
                try {
                    this.writeString(output, acc.getAccountID());
                    this.writeString(output, acc.getUsername());
                    String email = acc.getAccountEmail();
                    this.writeBoolean(output, email != null);
                    if (email != null) {
                        this.writeString(output, email);
                    }
                    this.writeLong(output, acc.getLastLoginTime());
                    this.writeLong(output, acc.getRegistrationTimestamp());
                    this.writeBoolean(output, acc.isGuestAccount());
                    this.writeBoolean(output, acc.isMultiplayerEnabled());
                    this.writeBoolean(output, acc.isChatEnabled());
                    this.writeBoolean(output, acc.isStrictChatFilterEnabled());
                    String[] ids = acc.getSaveIDs();
                    long index = this.indexData(acc.getAccountData());
                    for (String id : ids) {
                        ++index;
                        index += this.indexData(acc.getSave(id).getSaveData());
                    }
                    this.writeLong(output, index);
                    this.writeData(output, acc.getAccountData());
                    this.writeInt(output, ids.length);
                    for (String id : ids) {
                        AccountSaveContainer save = acc.getSave(id);
                        this.writeString(output, id);
                        this.writeString(output, save.getUsername());
                        this.writeLong(output, save.getCreationTime());
                        this.writeData(output, save.getSaveData());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    input.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    output.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                func.getClient().closeConnection();
            }
        });
        return this.response(101, "Switching Protocols");
    }

    private void writeData(OutputStream output, AccountDataContainer cont) throws IOException {
        String[] keys = cont.getEntryKeys();
        String[] conts = cont.getChildContainers();
        this.writeInt(output, (int)Stream.of(keys).filter(t -> !t.equals("chholder")).count());
        for (String key : keys) {
            if (key.equals("chholder")) continue;
            this.writeString(output, key);
            JsonElement ele = cont.getEntry(key);
            this.writeBoolean(output, ele != null);
            if (ele == null) continue;
            this.writeString(output, ele.toString());
        }
        this.writeInt(output, conts.length);
        for (String contN : conts) {
            this.writeString(output, contN);
            this.writeData(output, cont.getChildContainer(contN));
        }
    }

    private long indexData(AccountDataContainer cont) throws IOException {
        long i = 0L;
        i += (long)((int)Stream.of(cont.getEntryKeys()).filter(t -> !t.equals("chholder")).count());
        i += (long)cont.getChildContainers().length;
        for (String childContName : cont.getChildContainers()) {
            i += this.indexData(cont.getChildContainer(childContName));
        }
        return i;
    }

    private FunctionResult invalidUserCallback(String username, AccountObject account) throws IOException {
        if (account != null) {
            account.getAccountData().getChildContainer("accountdata").setEntry("lockedsince", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
        }
        try {
            Thread.sleep(8000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.response(401, "Unauthorized", "text/json", "{\"error\":\"invalid_credentials\"}");
    }

    private void writeInt(OutputStream strm, int val) throws IOException {
        strm.write(ByteBuffer.allocate(4).putInt(val).array());
    }

    private void writeLong(OutputStream strm, long val) throws IOException {
        strm.write(ByteBuffer.allocate(8).putLong(val).array());
    }

    private void writeString(OutputStream strm, String str) throws IOException {
        byte[] data = str.getBytes("UTF-8");
        this.writeByteArray(strm, data);
    }

    private void writeByteArray(OutputStream strm, byte[] data) throws IOException {
        this.writeInt(strm, data.length);
        strm.write(data);
    }

    private void writeBoolean(OutputStream strm, boolean b) throws IOException {
        strm.write(b ? 1 : 0);
    }
}

