/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.modules;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.cyan.fluid.DynamicClassLoader;
import org.asf.cyan.fluid.bytecode.FluidClassPool;
import org.asf.edge.modules.IEdgeModule;
import org.asf.edge.modules.dependencies.IMavenRepositoryProvider;
import org.asf.edge.modules.dependencies.IModuleMavenDependencyProvider;
import org.asf.edge.modules.eventbus.EventBus;
import org.objectweb.asm.tree.ClassNode;

public class ModuleManager {
    private static boolean inited = false;
    private static boolean postInited = false;
    private static Logger logger;
    private static DynamicClassLoader moduleLoader;
    private static ArrayList<IEdgeModule> modules;

    public static void init() {
        DynamicClassLoader loader;
        if (inited) {
            throw new IllegalStateException("Already initialized");
        }
        inited = true;
        logger = LogManager.getLogger((String)"MODULEMANAGER");
        File modulesDir = new File("modules");
        logger.info("Searching for modules...");
        modulesDir.mkdirs();
        logger.debug("Scanning modules folder...");
        FluidClassPool pool = FluidClassPool.create();
        moduleLoader = loader = new DynamicClassLoader();
        ModuleManager.findAndLoadModules(pool, modulesDir);
        ModuleManager.resolveDependencies(pool);
        logger.info("Dependencies are up-to-date, loading modules...");
        ModuleManager.initModules(pool);
        logger.info("Clearing module pool...");
        try {
            pool.close();
            pool = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void resolveDependencies(FluidClassPool pool) {
        logger.info("Searching for dependency repository definitions...");
        ArrayList<IMavenRepositoryProvider> repos = new ArrayList<IMavenRepositoryProvider>();
        for (ClassNode node : pool.getLoadedClasses()) {
            if (!ModuleManager.nodeExtends(node, pool, IMavenRepositoryProvider.class) || Modifier.isAbstract(node.access) || Modifier.isInterface(node.access)) continue;
            try {
                logger.debug("Loading repository definition from: " + node.name.replace("/", ".") + "...");
                Class repoCls = moduleLoader.loadClass(node.name.replace("/", "."));
                IMavenRepositoryProvider repoDef = (IMavenRepositoryProvider)repoCls.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (repos.stream().anyMatch(t -> t.serverBaseURL().equals(repoDef.serverBaseURL()) && t.priority() >= repoDef.priority())) continue;
                if (repos.stream().anyMatch(t -> t.serverBaseURL().equals(repoDef.serverBaseURL()))) {
                    repos.remove(repos.stream().filter(t -> t.serverBaseURL().equals(repoDef.serverBaseURL())).findFirst().get());
                } else {
                    logger.info("Added maven repository: " + repoDef.serverBaseURL());
                }
                repos.add(repoDef);
            }
            catch (Exception e) {
                logger.error("Failed to load repository definition from " + node.name.replace("/", "."), (Throwable)e);
            }
        }
        repos.sort((t1, t2) -> Integer.compare(t1.priority(), t2.priority()));
        ArrayList<IModuleMavenDependencyProvider> deps = new ArrayList<IModuleMavenDependencyProvider>();
        logger.info("Scanning for dependency definitions...");
        for (ClassNode node : pool.getLoadedClasses()) {
            if (!ModuleManager.nodeExtends(node, pool, IModuleMavenDependencyProvider.class) || Modifier.isAbstract(node.access) || Modifier.isInterface(node.access)) continue;
            try {
                logger.debug("Loading dependency definition from: " + node.name.replace("/", ".") + "...");
                Class depCls = moduleLoader.loadClass(node.name.replace("/", "."));
                IModuleMavenDependencyProvider depDef = (IModuleMavenDependencyProvider)depCls.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (deps.stream().anyMatch(t -> t.group().equals(depDef.group()) && t.name().equals(depDef.name()) && !ModuleManager.checkVersionGreaterThan(depDef.version(), t.version()))) continue;
                if (deps.stream().anyMatch(t -> t.group().equals(depDef.group()) && t.name().equals(depDef.name()) && !ModuleManager.checkVersionGreaterThan(depDef.version(), t.version()))) {
                    deps.remove(deps.stream().filter(t -> t.group().equals(depDef.group()) && t.name().equals(depDef.name()) && !ModuleManager.checkVersionGreaterThan(depDef.version(), t.version())).findFirst().get());
                } else {
                    logger.info("Found dependency: " + depDef.group() + ":" + depDef.name() + ":" + depDef.version());
                }
                deps.add(depDef);
            }
            catch (Exception e) {
                logger.error("Failed to load repository definition from " + node.name.replace("/", "."), (Throwable)e);
            }
        }
        File depsDir = new File("libs");
        depsDir.mkdirs();
        boolean updatedDeps = false;
        logger.info("Verifying dependencies...");
        for (IModuleMavenDependencyProvider depDef : deps) {
            logger.debug("Verifying dependency: " + depDef.group() + ":" + depDef.name() + ":" + depDef.version());
            String oldHash = "";
            String filePath = depDef.name() + (String)(depDef.classifier() != null ? "-" + depDef.classifier() : "") + depDef.extension();
            File file = new File(depsDir, filePath);
            if (file.exists()) {
                try {
                    FileInputStream strm = new FileInputStream(file);
                    oldHash = ModuleManager.hashFile(strm);
                    strm.close();
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    oldHash = "";
                }
            }
            Object url = null;
            String remoteHash = null;
            for (IMavenRepositoryProvider repo : repos) {
                try {
                    Object urlR = repo.serverBaseURL();
                    if (!((String)urlR).endsWith("/")) {
                        urlR = (String)urlR + "/";
                    }
                    urlR = (String)urlR + depDef.group().replace(".", "/");
                    urlR = (String)urlR + "/";
                    urlR = (String)urlR + depDef.name();
                    urlR = (String)urlR + "/";
                    urlR = (String)urlR + depDef.version();
                    urlR = (String)urlR + "/";
                    urlR = (String)urlR + depDef.name();
                    urlR = (String)urlR + "-";
                    urlR = (String)urlR + depDef.version();
                    if (depDef.classifier() != null) {
                        urlR = (String)urlR + "-";
                        urlR = (String)urlR + depDef.classifier();
                    }
                    urlR = (String)urlR + depDef.extension();
                    URL u = new URL((String)urlR + ".sha1");
                    InputStream strm = u.openStream();
                    remoteHash = new String(strm.readAllBytes(), "UTF-8").replace("\r", "").replace("\n", "");
                    url = urlR;
                    strm.close();
                    break;
                }
                catch (Exception urlR) {
                }
            }
            if (url == null) {
                if (oldHash.isEmpty()) {
                    logger.fatal("Unable to find a repository that contains dependency " + depDef.group() + ":" + depDef.name() + ":" + depDef.version() + "!");
                    System.exit(1);
                    continue;
                }
                logger.warn("Unable to find a repository that contains dependency " + depDef.group() + ":" + depDef.name() + ":" + depDef.version() + ", unable to check for updates and cannot verify integrity!");
                continue;
            }
            if (oldHash.equals(remoteHash)) continue;
            try {
                logger.info("Updating dependency " + depDef.group() + ":" + depDef.name() + ":" + depDef.version() + "...");
                FileOutputStream fOut = new FileOutputStream(file);
                URL u = new URL((String)url);
                InputStream strm = u.openStream();
                strm.transferTo(fOut);
                strm.close();
                fOut.close();
                updatedDeps = true;
            }
            catch (IOException e) {
                logger.error("Failed to update dependency " + depDef.group() + ":" + depDef.name() + ":" + depDef.version() + "!", (Throwable)e);
                System.exit(1);
            }
        }
        if (updatedDeps) {
            logger.info("Updated server dependencies, please restart the server.");
            System.exit(0);
        }
    }

    private static void findAndLoadModules(FluidClassPool pool, File modulesDir) {
        String moduleList;
        if (System.getProperty("debugMode") != null && (moduleList = System.getProperty("debugModeLoadModules")) != null) {
            String[] stringArray = moduleList.split(":");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String type = stringArray[i];
                logger.info("Loading debug type: " + type);
                try {
                    pool.getClassNode(type);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    logger.error("Failed to load debug module: " + type + ": an error occured while trying to load the class", (Throwable)e);
                }
            }
        }
        for (File f : modulesDir.listFiles(t -> t.isFile())) {
            logger.info("Attempting to load module file: " + f.getName() + "...");
            try {
                FileInputStream fIn = new FileInputStream(f);
                ZipInputStream zIn = new ZipInputStream(fIn);
                pool.importArchive(zIn);
                zIn.close();
                fIn.close();
                moduleLoader.addUrl(f.toURI().toURL());
            }
            catch (Exception e) {
                logger.error("Failed to load module file: " + f.getName() + ": an error occured while reading the file", (Throwable)e);
            }
        }
    }

    private static void initModules(FluidClassPool pool) {
        logger.debug("Scanning for module classes...");
        for (ClassNode classNode : pool.getLoadedClasses()) {
            if (!ModuleManager.nodeExtends(classNode, pool, IEdgeModule.class) || Modifier.isAbstract(classNode.access) || Modifier.isInterface(classNode.access)) continue;
            try {
                logger.debug("Loading module class from: " + classNode.name.replace("/", ".") + "...");
                Class modCls = moduleLoader.loadClass(classNode.name.replace("/", "."));
                try {
                    IEdgeModule modInst = (IEdgeModule)modCls.getConstructor(new Class[0]).newInstance(new Object[0]);
                    logger.info("Loading module " + modInst.moduleID() + " version " + modInst.version() + "...");
                    if (modules.stream().anyMatch(t -> t.moduleID().equalsIgnoreCase(modInst.moduleID()))) {
                        IEdgeModule modInst2 = ModuleManager.getLoadedModule(modInst.moduleID());
                        logger.error("Duplicate module ID detected: " + modInst.moduleID() + "\n\n" + modInst.moduleID() + " " + modInst.version() + ": " + new File(modInst.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getName() + "\n\n" + modInst2.moduleID() + " " + modInst2.version() + ": " + new File(modInst2.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getName());
                        System.exit(1);
                    }
                    modules.add(modInst);
                    try {
                        modInst.preInit();
                        EventBus.getInstance().addAllEventsFromReceiver(modInst);
                    }
                    catch (Exception e) {
                        logger.error("Failed to pre-initialize module: " + modInst.moduleID() + ", module source file: " + new File(modCls.getProtectionDomain().getCodeSource().getLocation().toURI()).getName(), (Throwable)e);
                        modules.remove(modInst);
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to load module from: " + classNode.name.replace("/", ".") + ", module source file: " + new File(modCls.getProtectionDomain().getCodeSource().getLocation().toURI()).getName(), (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("Failed to load module from: " + classNode.name.replace("/", "."), (Throwable)e);
            }
        }
        logger.info("Initializing modules...");
        for (IEdgeModule iEdgeModule : ModuleManager.getLoadedModules()) {
            logger.info("Initializing module: " + iEdgeModule.moduleID() + "...");
            try {
                iEdgeModule.init();
            }
            catch (Exception e) {
                logger.error("Failed to initialize module " + iEdgeModule.moduleID(), (Throwable)e);
                modules.remove(iEdgeModule);
            }
        }
    }

    public static void loadedModuleConfig(String id, Map<String, String> config) {
        IEdgeModule mod = ModuleManager.getLoadedModule(id);
        if (mod != null) {
            logger.info("Loaded configuration for module: " + id);
            mod.onLoadModuleConfig(config);
        } else {
            logger.warn("Loaded configuration for module " + id + ", however no loaded module has the given ID!");
        }
    }

    public static void runModulePostInit() {
        if (postInited) {
            throw new IllegalStateException("Already post-initialized all modules");
        }
        postInited = true;
        logger.info("Post-initializing modules...");
        for (IEdgeModule module : ModuleManager.getLoadedModules()) {
            try {
                logger.info("Post-initializing module: " + module.moduleID() + "...");
                module.postInit();
            }
            catch (Exception e) {
                logger.error("Failed to post-initialize module " + module.moduleID(), (Throwable)e);
            }
        }
    }

    public static IEdgeModule getLoadedModule(String id) {
        for (IEdgeModule module : modules) {
            if (!module.moduleID().equalsIgnoreCase(id)) continue;
            return module;
        }
        return null;
    }

    public static <T extends IEdgeModule> T getLoadedModule(Class<T> type) {
        return (T)modules.stream().filter(t -> type.isAssignableFrom(t.getClass())).findFirst().orElseGet(() -> null);
    }

    public static IEdgeModule[] getLoadedModules() {
        return (IEdgeModule[])modules.toArray(IEdgeModule[]::new);
    }

    private static boolean checkVersionGreaterThan(String newversion, String version) {
        newversion = ModuleManager.convertVerToVCheckString(newversion.replace("-", ".").replaceAll("[^0-9A-Za-z.]", ""));
        String oldver = ModuleManager.convertVerToVCheckString(version.replace("-", ".").replaceAll("[^0-9A-Za-z.]", ""));
        int ind = 0;
        String[] old = oldver.split("\\.");
        for (String vn : newversion.split("\\.")) {
            if (ind < old.length) {
                String vnold = old[ind];
                if (Integer.valueOf(vn) > Integer.valueOf(vnold)) {
                    return true;
                }
                if (Integer.valueOf(vn) < Integer.valueOf(vnold)) {
                    return false;
                }
                ++ind;
                continue;
            }
            return false;
        }
        return false;
    }

    private static String convertVerToVCheckString(String version) {
        char[] ver = ((String)version).toCharArray();
        version = "";
        boolean lastWasAlpha = false;
        for (char ch : ver) {
            if (ch == '.') {
                version = (String)version + ".";
                continue;
            }
            if (Character.isAlphabetic(ch) && !lastWasAlpha && !((String)version).endsWith(".")) {
                version = (String)version + ".";
                lastWasAlpha = true;
                continue;
            }
            if (lastWasAlpha && !((String)version).endsWith(".")) {
                version = (String)version + ".";
                lastWasAlpha = false;
                continue;
            }
            version = (String)version + Integer.toString(ch);
        }
        return version;
    }

    private static boolean nodeExtends(ClassNode node, FluidClassPool pool, Class<?> target) {
        while (true) {
            if (node.name.equals(target.getTypeName().replace(".", "/"))) {
                return true;
            }
            if (node.interfaces != null) {
                for (String inter : node.interfaces) {
                    try {
                        if (!ModuleManager.nodeExtends(pool.getClassNode(inter), pool, target)) continue;
                        return true;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                    }
                }
            }
            if (node.superName == null || node.superName.equals("java/lang/Object")) break;
            try {
                node = pool.getClassNode(node.superName);
            }
            catch (ClassNotFoundException e) {
                break;
            }
        }
        return false;
    }

    private static String hashFile(InputStream strm) throws IOException, NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        byte[] hash = digest.digest(strm.readAllBytes());
        Object hashTxt = "";
        for (byte b : hash) {
            hashTxt = (String)hashTxt + Integer.toString((b & 0xFF) + 256, 16).substring(1);
        }
        return hashTxt;
    }

    static {
        modules = new ArrayList();
    }
}

