/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.function.BiFunction;
import org.asf.connective.tasks.AsyncTaskManager;

public class SimpleBinaryMessageClient {
    private BiFunction<Packet, SimpleBinaryMessageClient, Boolean> handler;
    public Object container;
    private InputStream input;
    private OutputStream output;
    private long lastSent;
    private Object packetLock = new Object();
    private boolean connected;

    public SimpleBinaryMessageClient(BiFunction<Packet, SimpleBinaryMessageClient, Boolean> handler, InputStream input, OutputStream output) {
        this.handler = handler;
        this.input = input;
        this.output = output;
    }

    public void send(byte type, byte[] packet) throws IOException {
        if (type < 2) {
            throw new IllegalArgumentException("Invalid packet type, must be above or equal to 2");
        }
        this.sendPacketInternal(type, packet);
    }

    public void send(byte[] packet) throws IOException {
        this.sendPacketInternal((byte)2, packet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPacketInternal(byte type, byte[] packet) throws IOException {
        Object object = this.packetLock;
        synchronized (object) {
            try {
                this.output.write(type);
                if (type >= 2) {
                    this.output.write(ByteBuffer.allocate(4).putInt(packet.length).array());
                    this.output.write(packet);
                }
                this.lastSent = System.currentTimeMillis();
            }
            catch (IOException e) {
                if (this.connected) {
                    this.stop();
                }
                throw e;
            }
        }
    }

    public void stop() {
        this.connected = false;
        try {
            this.sendPacketInternal((byte)0, new byte[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void startAsync() {
        this.lastSent = System.currentTimeMillis();
        this.connected = true;
        AsyncTaskManager.runAsync(() -> this.start());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        this.lastSent = System.currentTimeMillis();
        this.connected = true;
        AsyncTaskManager.runAsync(() -> {
            while (this.connected) {
                if (System.currentTimeMillis() - this.lastSent >= 5000L) {
                    try {
                        this.sendPacketInternal((byte)1, new byte[0]);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        try {
            block10: while (this.connected) {
                int type = this.input.read();
                switch (type) {
                    case 0: {
                        try {
                            this.input.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            this.output.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        this.connected = false;
                        continue block10;
                    }
                    case 1: {
                        continue block10;
                    }
                }
                byte[] l = this.input.readNBytes(4);
                int length = ByteBuffer.wrap(l).getInt();
                Packet pk = new Packet();
                pk.type = (byte)type;
                pk.data = this.input.readNBytes(length);
                if (this.handler.apply(pk, this).booleanValue()) continue;
                this.stop();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.connected = false;
    }

    public static class Packet {
        public byte type;
        public byte[] data;
    }
}

