/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.achievements.impl;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.entities.achivements.EntityRankInfo;
import org.asf.edge.common.entities.achivements.RankInfo;
import org.asf.edge.common.entities.achivements.RankMultiplierInfo;
import org.asf.edge.common.entities.achivements.RankTypeID;
import org.asf.edge.common.events.achievements.AchievementManagerLoadEvent;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.achievements.AchievementManager;
import org.asf.edge.common.services.achievements.impl.DragonRankContainer;
import org.asf.edge.common.services.achievements.impl.UserRankContainer;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.config.ConfigProviderService;
import org.asf.edge.common.xmls.achievements.UserRankData;
import org.asf.edge.common.xmls.achievements.UserRankList;
import org.asf.edge.modules.IEdgeModule;
import org.asf.edge.modules.ModuleManager;
import org.asf.edge.modules.eventbus.EventBus;
import org.asf.edge.modules.eventbus.EventObject;

public class AchievementManagerImpl
extends AchievementManager {
    private Logger logger;
    private HashMap<Integer, RankInfo> ranks = new HashMap();
    private long lastReloadTime;

    @Override
    public void initService() {
        this.logger = LogManager.getLogger((String)"AchievementManager");
        CommonDataContainer cont = CommonDataManager.getInstance().getContainer("ACHIEVEMENTMANAGER");
        try {
            if (!cont.entryExists("lastreload")) {
                this.lastReloadTime = System.currentTimeMillis();
                cont.setEntry("lastreload", (JsonElement)new JsonPrimitive((Number)this.lastReloadTime));
            } else {
                this.lastReloadTime = cont.getEntry("lastreload").getAsLong();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        AsyncTaskManager.runAsync(() -> {
            while (true) {
                try {
                    long reload = cont.getEntry("lastreload").getAsLong();
                    if (reload > this.lastReloadTime) {
                        this.lastReloadTime = reload;
                        this.loadData();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        });
        this.loadData();
    }

    private void loadData() {
        HashMap<Integer, RankInfo> ranks = new HashMap<Integer, RankInfo>();
        this.logger.info("Loading rank definitions...");
        try {
            InputStream strm = this.getClass().getClassLoader().getResourceAsStream("ranks.xml");
            String data = new String(strm.readAllBytes(), "UTF-8");
            strm.close();
            XmlMapper mapper = new XmlMapper();
            UserRankList rs = (UserRankList)mapper.reader().readValue(data, UserRankList.class);
            for (UserRankData.UserRankDataWrapper rank : rs.ranks) {
                ranks.put(rank.rankID.value, new RankInfo(rank.getUnwrapped()));
                this.logger.debug("Registered rank: " + rank.getUnwrapped().rankID + ": " + rank.getUnwrapped().rankName);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.logger.info("Loading rank transformers...");
        this.loadTransformers(this.getClass(), ranks);
        for (IEdgeModule module : ModuleManager.getLoadedModules()) {
            this.loadTransformers(module.getClass(), ranks);
        }
        File transformersRanks = new File("ranktransformers");
        if (transformersRanks.exists()) {
            for (File transformer : transformersRanks.listFiles(t -> t.getName().endsWith(".xml") || t.isDirectory())) {
                this.loadRankTransformer(transformer, ranks);
            }
        }
        this.ranks = ranks;
        this.logger.info("Dispatching load event...");
        EventBus.getInstance().dispatchEvent((EventObject)new AchievementManagerLoadEvent(this));
    }

    private void loadTransformers(Class<?> cls, HashMap<Integer, RankInfo> ranks) {
        URL source = cls.getProtectionDomain().getCodeSource().getLocation();
        Object baseURL = "";
        String fileName = "";
        try {
            File sourceFile = new File(source.toURI());
            fileName = sourceFile.getName();
            baseURL = sourceFile.isDirectory() ? source + (source.toString().endsWith("/") ? "" : "/") : "jar:" + source + "!/";
        }
        catch (Exception e) {
            return;
        }
        try {
            this.logger.debug("Loading transformers from " + fileName + "...");
            InputStream strm = new URL((String)baseURL + "ranktransformers/index.json").openStream();
            JsonArray index = JsonParser.parseString((String)new String(strm.readAllBytes(), "UTF-8")).getAsJsonArray();
            strm.close();
            for (JsonElement ele : index) {
                this.logger.debug("Loading transformer: 'ranktransformers/" + ele.getAsString() + ".xml'...");
                try {
                    strm = new URL((String)baseURL + "ranktransformers/" + ele.getAsString() + ".xml").openStream();
                    XmlMapper mapper = new XmlMapper();
                    UserRankData def = (UserRankData)mapper.reader().readValue(new String(strm.readAllBytes(), "UTF-8"), UserRankData.class);
                    strm.close();
                    if (!ranks.containsKey(def.rankID)) {
                        ranks.put(def.rankID, new RankInfo(def));
                        this.logger.debug("Registered rank: " + def.rankID + ": " + def.rankName);
                        continue;
                    }
                    RankInfo r = ranks.get(def.rankID);
                    if (r == null) {
                        throw new IllegalArgumentException("Rank definition not found: " + def.rankID);
                    }
                    UserRankData raw = r.getRawObject();
                    raw.audio = def.audio;
                    raw.globalRankID = def.globalRankID;
                    raw.image = def.image;
                    raw.pointTypeID = def.pointTypeID;
                    raw.rankDescription = def.rankDescription;
                    raw.rankID = def.rankID;
                    raw.rankName = def.rankName;
                    raw.value = def.value;
                    r.reload();
                    this.logger.debug("Updated rank: " + r.getID() + ": " + r.getName());
                }
                catch (Exception e) {
                    this.logger.error("Transformer failed to load: " + ele.getAsString() + " (" + fileName + ")", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                return;
            }
            throw new RuntimeException(e);
        }
    }

    private void loadRankTransformer(File transformer, HashMap<Integer, RankInfo> ranks) {
        block7: {
            if (transformer.isFile()) {
                this.logger.debug("Loading transformer: '" + transformer.getPath() + "'...");
                try {
                    FileInputStream strm = new FileInputStream(transformer);
                    XmlMapper mapper = new XmlMapper();
                    UserRankData def = (UserRankData)mapper.reader().readValue(new String(((InputStream)strm).readAllBytes(), "UTF-8"), UserRankData.class);
                    ((InputStream)strm).close();
                    if (!ranks.containsKey(def.rankID)) {
                        ranks.put(def.rankID, new RankInfo(def));
                        this.logger.debug("Registered rank: " + def.rankID + ": " + def.rankName);
                        break block7;
                    }
                    RankInfo r = ranks.get(def.rankID);
                    if (r == null) {
                        throw new IllegalArgumentException("Rank definition not found: " + def.rankID);
                    }
                    UserRankData raw = r.getRawObject();
                    raw.audio = def.audio;
                    raw.globalRankID = def.globalRankID;
                    raw.image = def.image;
                    raw.pointTypeID = def.pointTypeID;
                    raw.rankDescription = def.rankDescription;
                    raw.rankID = def.rankID;
                    raw.rankName = def.rankName;
                    raw.value = def.value;
                    r.reload();
                    this.logger.debug("Updated rank: " + r.getID() + ": " + r.getName());
                }
                catch (Exception e) {
                    this.logger.error("Transformer failed to load: " + transformer.getPath(), (Throwable)e);
                }
            } else {
                this.logger.debug("Loading transformers from " + transformer.getPath() + "...");
                for (File tr : transformer.listFiles(t -> t.getName().endsWith(".xml") || t.isDirectory())) {
                    this.loadRankTransformer(tr, ranks);
                }
            }
        }
    }

    @Override
    public RankInfo[] getRankDefinitions() {
        return (RankInfo[])Stream.of((RankInfo[])this.ranks.values().toArray(RankInfo[]::new)).sorted((t1, t2) -> Integer.compare(t1.getValue(), t2.getValue())).toArray(RankInfo[]::new);
    }

    @Override
    public RankInfo getRankDefinition(int id) {
        return this.ranks.get(id);
    }

    @Override
    public void registerRankDefinition(int id, UserRankData def) {
        if (this.ranks.containsKey(id)) {
            throw new IllegalArgumentException("Rank definition already exists " + id);
        }
        def.rankID = id;
        this.ranks.put(id, new RankInfo(def));
        this.logger.debug("Registered rank: " + def.rankID + ": " + def.rankName);
    }

    @Override
    public void updateRankDefinition(int id, UserRankData def) {
        RankInfo r = this.getRankDefinition(id);
        if (r == null) {
            throw new IllegalArgumentException("Rank definition not found: " + id);
        }
        UserRankData raw = r.getRawObject();
        raw.audio = def.audio;
        raw.globalRankID = def.globalRankID;
        raw.image = def.image;
        raw.pointTypeID = def.pointTypeID;
        raw.rankDescription = def.rankDescription;
        raw.rankID = def.rankID;
        raw.rankName = def.rankName;
        raw.value = def.value;
        r.reload();
        this.logger.debug("Updated rank: " + r.getID() + ": " + r.getName());
    }

    @Override
    public void reload() {
        this.loadData();
    }

    @Override
    public RankInfo[] getRankDefinitionsByPointType(int pointTypeID) {
        return (RankInfo[])Stream.of(this.getRankDefinitions()).filter(t -> t.getPointTypeID() == pointTypeID).toArray(RankInfo[]::new);
    }

    @Override
    public EntityRankInfo getRankForUser(AccountSaveContainer save, RankTypeID type) {
        return new UserRankContainer(type, save);
    }

    @Override
    public EntityRankInfo getRankForDragon(AccountSaveContainer save, String dragonEntityID) {
        try {
            return new DragonRankContainer(save, dragonEntityID);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public EntityRankInfo getRankForClan(AccountSaveContainer save, String clanID) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int applyModifiers(AccountSaveContainer save, int value, RankTypeID type) {
        int factor = 1;
        boolean first = true;
        for (RankMultiplierInfo m : this.getRankMultipliers(save)) {
            if (!m.isValid() || m.getPointType().getPointTypeID() != type.getPointTypeID()) continue;
            factor = first ? m.getMultiplicationFactor() : (factor += m.getMultiplicationFactor());
            first = false;
        }
        return value * factor;
    }

    @Override
    public synchronized RankMultiplierInfo[] getServerwideRankMultipliers() {
        SimpleDateFormat fmt = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        if (!ConfigProviderService.getInstance().configExists("server", "multipliers")) {
            Calendar cal = Calendar.getInstance();
            cal.set(10, 12);
            cal.set(12, 0);
            cal.add(5, 10);
            Date t = cal.getTime();
            try {
                JsonObject conf = new JsonObject();
                conf.addProperty("__COMMENT__", "This file defines the active multipliers used in the game.");
                conf.addProperty("__COMMENT2__", "The example below is generated at first run and is configured to create 3 multipliers that are valid for 10 days.");
                JsonArray ml = new JsonArray();
                conf.add("multipliers", (JsonElement)ml);
                JsonObject m1 = new JsonObject();
                m1.addProperty("type", (Number)1);
                m1.addProperty("factor", (Number)2);
                m1.addProperty("expiry", fmt.format(t));
                ml.add((JsonElement)m1);
                JsonObject m2 = new JsonObject();
                m2.addProperty("type", (Number)12);
                m2.addProperty("factor", (Number)2);
                m2.addProperty("expiry", fmt.format(t));
                ml.add((JsonElement)m2);
                JsonObject m3 = new JsonObject();
                m3.addProperty("type", (Number)8);
                m3.addProperty("factor", (Number)2);
                m3.addProperty("expiry", fmt.format(t));
                ml.add((JsonElement)m3);
                ConfigProviderService.getInstance().saveConfig("server", "multipliers", conf);
            }
            catch (IOException e) {
                this.logger.error("Failed to save rank multipliers", (Throwable)e);
            }
        }
        ArrayList<RankMultiplierInfo> multipliers = new ArrayList<RankMultiplierInfo>();
        try {
            JsonObject conf = ConfigProviderService.getInstance().loadConfig("server", "multipliers");
            for (JsonElement ele : conf.get("multipliers").getAsJsonArray()) {
                JsonObject m = ele.getAsJsonObject();
                Date t = fmt.parse(m.get("expiry").getAsString());
                int typeID = m.get("type").getAsInt();
                int factor = m.get("factor").getAsInt();
                multipliers.add(new RankMultiplierInfo(RankTypeID.getByTypeID(typeID), factor, t.getTime()));
            }
        }
        catch (IOException | ParseException e) {
            this.logger.error("Failed to load rank multipliers", (Throwable)e);
        }
        return (RankMultiplierInfo[])multipliers.toArray(RankMultiplierInfo[]::new);
    }

    @Override
    public RankMultiplierInfo[] getUserRankMultipliers(AccountSaveContainer save) {
        ArrayList<RankMultiplierInfo> multipliers = new ArrayList<RankMultiplierInfo>();
        try {
            AccountDataContainer rewardMultipliers = save.getSaveData().getChildContainer("reward_multipliers");
            if (!rewardMultipliers.entryExists("active")) {
                rewardMultipliers.setEntry("active", (JsonElement)new JsonArray());
            }
            boolean edited = false;
            JsonArray lst = rewardMultipliers.getEntry("active").getAsJsonArray();
            ArrayList<JsonObject> multipliersToRemove = new ArrayList<JsonObject>();
            for (JsonElement ele : lst) {
                JsonObject multiplierInfo = ele.getAsJsonObject();
                if (multiplierInfo.get("expiry").getAsLong() < System.currentTimeMillis()) {
                    edited = true;
                    multipliersToRemove.add(multiplierInfo);
                }
                multipliers.add(new RankMultiplierInfo(RankTypeID.getByTypeID(multiplierInfo.get("typeID").getAsInt()), multiplierInfo.get("factor").getAsInt(), multiplierInfo.get("expiry").getAsLong()));
            }
            if (edited) {
                for (JsonObject m : multipliersToRemove) {
                    lst.remove((JsonElement)m);
                }
                rewardMultipliers.setEntry("active", (JsonElement)lst);
            }
        }
        catch (IOException e) {
            this.logger.error("Failed to load user rank multipliers", (Throwable)e);
        }
        return (RankMultiplierInfo[])multipliers.toArray(RankMultiplierInfo[]::new);
    }

    @Override
    public void addUserRankMultiplier(AccountSaveContainer save, RankMultiplierInfo multiplier) {
        try {
            AccountDataContainer rewardMultipliers = save.getSaveData().getChildContainer("reward_multipliers");
            if (!rewardMultipliers.entryExists("active")) {
                rewardMultipliers.setEntry("active", (JsonElement)new JsonArray());
            }
            JsonObject multiplierJ = null;
            JsonArray lst = rewardMultipliers.getEntry("active").getAsJsonArray();
            for (JsonElement ele : lst) {
                JsonObject multiplierInfo = ele.getAsJsonObject();
                if (multiplierInfo.get("typeID").getAsInt() != multiplier.getPointType().getPointTypeID()) continue;
                multiplierJ = multiplierInfo;
            }
            if (multiplierJ == null) {
                multiplierJ = new JsonObject();
                lst.add((JsonElement)multiplierJ);
            }
            multiplierJ.addProperty("typeID", (Number)multiplier.getPointType().getPointTypeID());
            multiplierJ.addProperty("factor", (Number)multiplier.getMultiplicationFactor());
            multiplierJ.addProperty("expiry", (Number)multiplier.getExpiryTime());
            rewardMultipliers.setEntry("active", (JsonElement)lst);
        }
        catch (IOException e) {
            this.logger.error("Failed to add user rank multiplier", (Throwable)e);
        }
    }
}

