/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts.impl.accounts.http;

import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.accounts.impl.RemoteHttpAccountManager;
import org.asf.edge.common.services.accounts.impl.accounts.http.RemoteHttpSaveDataContainer;

public class RemoteHttpSaveContainer
extends AccountSaveContainer {
    private String id;
    private long time;
    private String username;
    private String acc;
    private AccountObject account;
    private RemoteHttpAccountManager mgr;
    private Logger logger = LogManager.getLogger((String)"AccountManager");

    public RemoteHttpSaveContainer(String id, long time, String username, String acc, RemoteHttpAccountManager mgr, AccountObject account) {
        this.id = id;
        this.time = time;
        this.username = username;
        this.acc = acc;
        this.account = account;
        this.mgr = mgr;
    }

    @Override
    public long getCreationTime() {
        return this.time;
    }

    @Override
    public String getSaveID() {
        return this.id;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean updateUsername(String name) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.acc);
            payload.addProperty("save", this.id);
            payload.addProperty("newName", name);
            JsonObject response = this.mgr.accountManagerRequest("accounts/updateSaveUsername", payload);
            boolean res = response.get("success").getAsBoolean();
            if (res) {
                this.username = name;
            }
            return res;
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in updateSaveUsername!", (Throwable)e);
            return false;
        }
    }

    @Override
    public AccountDataContainer getSaveData() {
        return new RemoteHttpSaveDataContainer(this.account, this, this.acc, this.mgr);
    }

    @Override
    public void deleteSave() {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.acc);
            payload.addProperty("save", this.id);
            JsonObject response = this.mgr.accountManagerRequest("accounts/deleteSave", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in deleteSave!", (Throwable)e);
        }
    }

    @Override
    public AccountObject getAccount() {
        return this.account;
    }
}

