/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.remapping;

import org.asf.cyan.fluid.Fluid;
import org.asf.cyan.fluid.deobfuscation.DeobfuscationTarget;
import org.asf.cyan.fluid.deobfuscation.DeobfuscationTargetMap;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.MethodRemapper;
import org.objectweb.asm.commons.Remapper;

public class FluidMemberRemapper
extends Remapper {
    private DeobfuscationTargetMap map;

    public FluidMemberRemapper(DeobfuscationTargetMap mp) {
        this.map = mp;
    }

    public String mapInvokeDynamicMethodName(String name, String descriptor, Object[] bsmArgs) {
        if (bsmArgs.length > 1 && bsmArgs[0] instanceof Type && descriptor.contains(")")) {
            String owner = Fluid.parseDescriptor(descriptor.substring(descriptor.indexOf(")") + 1)).replace(".", "/");
            String desc = ((Type)bsmArgs[0]).getDescriptor();
            return this.mapMethodName(owner, name, desc);
        }
        return name;
    }

    public String mapMethodName(String owner, String name, String descriptor) {
        if (this.map.containsKey(owner)) {
            DeobfuscationTarget cls = (DeobfuscationTarget)this.map.get(owner);
            return cls.methods.getOrDefault(name + " " + descriptor, name);
        }
        return name;
    }

    public String mapFieldName(String owner, String name, String descriptor) {
        if (this.map.containsKey(owner)) {
            DeobfuscationTarget cls = (DeobfuscationTarget)this.map.get(owner);
            return cls.fields.getOrDefault(name + " " + descriptor, name);
        }
        return name;
    }

    public static class FluidMemberVisitor
    extends MethodRemapper {
        public FluidMemberVisitor(MethodVisitor methodVisitor, Remapper remapper) {
            super(methodVisitor, remapper);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            if (this.remapper instanceof FluidMemberRemapper) {
                name = ((FluidMemberRemapper)this.remapper).mapInvokeDynamicMethodName(name, descriptor, bootstrapMethodArguments);
            }
            super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        }
    }
}

