/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.util.inventory.defaulthandlers;

import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.entities.items.PlayerInventoryContainer;
import org.asf.edge.common.entities.items.PlayerInventoryItem;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.gameplayapi.util.inventory.AbstractItemRedemptionHandler;
import org.asf.edge.gameplayapi.util.inventory.ItemRedemptionInfo;
import org.asf.edge.gameplayapi.xmls.inventories.InventoryUpdateResponseData;

public class DefaultItemRedemptionHandler
extends AbstractItemRedemptionHandler {
    @Override
    public boolean canHandle(ItemInfo item) {
        return true;
    }

    @Override
    public AbstractItemRedemptionHandler.RedemptionResult handleRedemption(ItemInfo item, ItemRedemptionInfo req, AccountObject account, AccountSaveContainer save, InventoryUpdateResponseData.CurrencyUpdateBlock currencyUpdate) {
        PlayerInventoryContainer cont = save.getInventory().getContainer(req.containerID);
        PlayerInventoryItem itm = cont.findFirst(req.defID);
        if (itm == null) {
            itm = cont.createItem(req.defID, 0);
        }
        int newQuant = itm.getQuantity() + req.quantity;
        itm.setQuantity(newQuant);
        InventoryUpdateResponseData.ItemUpdateBlock update = null;
        if (newQuant > 0 || req.quantity == 0) {
            InventoryUpdateResponseData.ItemUpdateBlock b = new InventoryUpdateResponseData.ItemUpdateBlock();
            b.itemID = itm.getItemDefID();
            b.itemUniqueID = itm.getUniqueID();
            b.addedQuantity = req.quantity;
            update = b;
        }
        return AbstractItemRedemptionHandler.RedemptionResult.success(itm.getItemDef().getRawObject(), update);
    }
}

