/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.tools;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;

public class QuestConverter {
    public static void main(String[] args) throws JsonSyntaxException, IOException {
        XmlMapper mapper = new XmlMapper();
        mapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        mapper.configure(ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL, true);
        QuestRegistryManifest outp = new QuestRegistryManifest();
        outp.defaultQuestDefs = new QuestRegistryManifest.QuestDefsBlock();
        ArrayList<ObjectNode> nodes = new ArrayList<ObjectNode>();
        for (File file : new File(args[0]).listFiles(t -> t.getName().endsWith(".xml") && t.isFile())) {
            ObjectNode node = (ObjectNode)mapper.readValue(Files.readString(file.toPath()), ObjectNode.class);
            if (node.get("I").asInt() == 0) continue;
            nodes.add(node);
            System.out.println("Quest registered: " + node.get("I").asInt());
        }
        System.out.println(nodes.size() + " quests registered");
        outp.defaultQuestDefs.questDefs = (ObjectNode[])nodes.toArray(ObjectNode[]::new);
        Files.writeString(Path.of("questdata.xml", new String[0]), (CharSequence)mapper.writer().withDefaultPrettyPrinter().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("QuestRegistryManifest").writeValueAsString((Object)outp), new OpenOption[0]);
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
    private static class QuestRegistryManifest {
        public QuestDefsBlock defaultQuestDefs;

        private QuestRegistryManifest() {
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
        public static class QuestDefsBlock {
            @JsonProperty(value="QuestDef")
            @JacksonXmlElementWrapper(useWrapping=false)
            public ObjectNode[] questDefs;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.UpperCamelCaseStrategy.class)
    private static class QuestListData {
        @JsonProperty(value="Mission")
        @JacksonXmlElementWrapper(useWrapping=false)
        public ObjectNode[] missions;

        private QuestListData() {
        }
    }
}

