/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.gameplayapi.http.handlers.itemstore;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.asf.connective.RemoteClient;
import org.asf.connective.processors.HttpPushProcessor;
import org.asf.connective.tasks.AsyncTaskManager;
import org.asf.edge.common.IBaseServer;
import org.asf.edge.common.entities.items.ItemCategoryInfo;
import org.asf.edge.common.entities.items.ItemInfo;
import org.asf.edge.common.entities.items.ItemSaleInfo;
import org.asf.edge.common.entities.items.ItemStoreInfo;
import org.asf.edge.common.http.apihandlerutils.EdgeWebService;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunction;
import org.asf.edge.common.http.apihandlerutils.functions.LegacyFunctionInfo;
import org.asf.edge.common.services.commondata.CommonDataContainer;
import org.asf.edge.common.services.commondata.CommonDataManager;
import org.asf.edge.common.services.items.ItemManager;
import org.asf.edge.gameplayapi.EdgeGameplayApiServer;
import org.asf.edge.gameplayapi.xmls.items.GetStoreRequestData;
import org.asf.edge.gameplayapi.xmls.items.GetStoreResponseData;
import org.asf.edge.gameplayapi.xmls.items.ItemStoreResponseObject;

public class ItemStoreWebServiceProcessor
extends EdgeWebService<EdgeGameplayApiServer> {
    private static ItemManager itemManager;
    private static boolean popularItemManagementInited;

    public ItemStoreWebServiceProcessor(EdgeGameplayApiServer server) {
        super((IBaseServer)server);
    }

    public HttpPushProcessor createNewInstance() {
        return new ItemStoreWebServiceProcessor((EdgeGameplayApiServer)this.getServerInstance());
    }

    public String path() {
        return "/ItemStoreWebService.asmx";
    }

    public void fallbackRequestProcessor(String path, String method, RemoteClient client, String contentType) throws IOException {
        this.setResponseStatus(404, "Not found");
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getRankAttributeData(LegacyFunctionInfo info) throws IOException {
        EdgeWebService.ServiceRequestInfo req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger());
        if (req == null) {
            return;
        }
        InputStream strm = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("rankattrs.xml");
        String data = new String(strm.readAllBytes(), "UTF-8");
        strm.close();
        this.setResponseContent("text/xml", data);
    }

    private static synchronized void initPopularItemManager() {
        if (popularItemManagementInited) {
            return;
        }
        popularItemManagementInited = true;
        ItemStoreWebServiceProcessor.initPopularItemManager();
        CommonDataContainer cont = CommonDataManager.getInstance().getContainer("POPULARITEMS");
        AsyncTaskManager.runAsync(() -> {
            while (true) {
                try {
                    boolean requiresRefresh = false;
                    if (!cont.entryExists("lastupdate") || System.currentTimeMillis() - cont.getEntry("lastupdate").getAsLong() > 604800000L) {
                        requiresRefresh = true;
                    }
                    if (requiresRefresh) {
                        int[] storeIDs;
                        cont.setEntry("lastupdate", (JsonElement)new JsonPrimitive((Number)System.currentTimeMillis()));
                        for (int store : storeIDs = ItemManager.getInstance().getStoreIds()) {
                            if (!cont.entryExists("current-" + store)) continue;
                            JsonObject current = cont.getEntry("current-" + store).getAsJsonObject();
                            cont.setEntry("last-" + store, (JsonElement)current);
                            cont.setEntry("current-" + store, (JsonElement)new JsonObject());
                        }
                    }
                }
                catch (IOException e) {
                    LogManager.getLogger((String)"ItemManager").error("Failed to check if popular items need to be refreshed due to a database error.", (Throwable)e);
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        });
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getStore(LegacyFunctionInfo info) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if (!popularItemManagementInited) {
            ItemStoreWebServiceProcessor.initPopularItemManager();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        GetStoreRequestData stores = (GetStoreRequestData)req.parseXmlValue((String)req.payload.get("getStoreRequest"), GetStoreRequestData.class);
        GetStoreResponseData resp = new GetStoreResponseData();
        resp.stores = new ItemStoreResponseObject[stores.storeIDs.length];
        for (int i = 0; i < resp.stores.length; ++i) {
            ItemStoreInfo store = itemManager.getStore(stores.storeIDs[i]);
            if (store != null) {
                ItemStoreResponseObject storeData = new ItemStoreResponseObject();
                storeData.storeID = store.getID();
                storeData.storeName = store.getName();
                storeData.storeDescription = store.getDescription();
                storeData.items = (ObjectNode[])Stream.of(store.getItems()).map(t -> t.getRawObject()).toArray(ObjectNode[]::new);
                ArrayList<ItemStoreResponseObject.PopularItemBlock> items = new ArrayList<ItemStoreResponseObject.PopularItemBlock>();
                CommonDataContainer cont = CommonDataManager.getInstance().getContainer("POPULARITEMS");
                if (cont.entryExists("last-" + storeData.storeID)) {
                    JsonObject popularItems = cont.getEntry("last-" + storeData.storeID).getAsJsonObject();
                    ItemInfo[] itms = new HashMap();
                    for (String key : popularItems.keySet()) {
                        itms.put(Integer.parseInt(key), popularItems.get(key).getAsInt());
                    }
                    int i2 = 0;
                    ItemInfo[] storeItems = ItemManager.getInstance().getStore(storeData.storeID).getItems();
                    int limit = storeItems.length / 15;
                    if (limit <= 0) {
                        limit = 1;
                    }
                    for (Integer id : (Integer[])itms.keySet().stream().sorted((arg_0, arg_1) -> ItemStoreWebServiceProcessor.lambda$getStore$3((HashMap)itms, arg_0, arg_1)).toArray(Integer[]::new)) {
                        if (i2 >= limit) break;
                        ItemStoreResponseObject.PopularItemBlock itm = new ItemStoreResponseObject.PopularItemBlock();
                        itm.itemID = id;
                        itm.rank = (Integer)itms.get(id);
                        items.add(itm);
                        ++i2;
                    }
                }
                storeData.popularItems = (ItemStoreResponseObject.PopularItemBlock[])items.toArray(ItemStoreResponseObject.PopularItemBlock[]::new);
                ArrayList<Integer> categoryIds = new ArrayList<Integer>();
                for (ItemInfo itm : store.getItems()) {
                    ItemCategoryInfo[] cats;
                    for (ItemCategoryInfo cat : cats = itm.getCategories()) {
                        if (categoryIds.contains(cat.getCategoryID())) continue;
                        categoryIds.add(cat.getCategoryID());
                    }
                }
                ArrayList<ItemStoreResponseObject.SaleBlock> sales = new ArrayList<ItemStoreResponseObject.SaleBlock>();
                ObjectMapper mapper = new ObjectMapper();
                for (ItemSaleInfo sale : itemManager.getSales()) {
                    if (!sale.isActive() && !sale.isUpcoming()) continue;
                    boolean valid = false;
                    if (IntStream.of(sale.getItemIDs()).anyMatch(t -> Stream.of(store.getItems()).anyMatch(t2 -> t2.getID() == t))) {
                        valid = true;
                    } else if (IntStream.of(sale.getCategories()).anyMatch(t -> categoryIds.stream().anyMatch(t2 -> t2 == t))) {
                        valid = true;
                    }
                    if (!valid) continue;
                    SimpleDateFormat fmt2 = new SimpleDateFormat("yyyy'-'MM'-'dd'T'HH':'mm':'ss");
                    fmt2.setTimeZone(TimeZone.getTimeZone("UTC"));
                    ItemStoreResponseObject.SaleBlock block = new ItemStoreResponseObject.SaleBlock();
                    block.modifier = sale.getSaleModifier();
                    block.saleID = this.idHash(mapper.writeValueAsString((Object)sale));
                    block.memberOnly = sale.isMemberOnly();
                    block.categoryIDs = sale.getCategories();
                    block.itemIDs = sale.getItemIDs();
                    block.startDate = fmt2.format(new Date(sale.getStartTime()));
                    block.endDate = fmt2.format(new Date(sale.getEndTime()));
                    if (sales.stream().anyMatch(t -> t.saleID == block.saleID)) {
                        LogManager.getLogger((String)"ItemManager").error("Duplicate sale ID due to failure in hashing code for sale '" + sale.getName() + "', this must immediately be reported as the store will break down!");
                    }
                    sales.add(block);
                }
                storeData.itemSales = (ItemStoreResponseObject.SaleBlock[])sales.toArray(ItemStoreResponseObject.SaleBlock[]::new);
                resp.stores[i] = storeData;
                continue;
            }
            resp.stores[i] = new ItemStoreResponseObject();
        }
        this.setResponseContent("text/xml", new XmlMapper().writer().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_XML_DECLARATION}).withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withDefaultPrettyPrinter().withRootName("GetStoreResponse").writeValueAsString((Object)resp));
    }

    private int idHash(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] digest = md.digest(s.getBytes("UTF-8"));
            byte[] sub1 = Arrays.copyOfRange(digest, 0, 4);
            byte[] sub2 = Arrays.copyOfRange(digest, 4, 8);
            byte[] sub3 = Arrays.copyOfRange(digest, 8, 12);
            byte[] sub4 = Arrays.copyOfRange(digest, 12, 16);
            int x1 = ByteBuffer.wrap(sub1).getInt();
            int x2 = ByteBuffer.wrap(sub2).getInt();
            int x3 = ByteBuffer.wrap(sub3).getInt();
            int x4 = ByteBuffer.wrap(sub4).getInt();
            return x1 ^ x2 ^ x3 ^ x4;
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    @LegacyFunction(allowedMethods={"POST"})
    public void getItem(LegacyFunctionInfo info) throws IOException {
        EdgeWebService.ServiceRequestInfo req;
        if (itemManager == null) {
            itemManager = ItemManager.getInstance();
        }
        if ((req = this.getUtilities().getServiceRequestPayload(((EdgeGameplayApiServer)this.getServerInstance()).getLogger())) == null) {
            return;
        }
        int item = Integer.parseInt((String)req.payload.get("itemId"));
        ItemInfo def = itemManager.getItemDefinition(item);
        if (def == null) {
            this.setResponseContent("text/xml", "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<I xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n  <ct>0</ct>\n  <ct2>0</ct2>\n  <cp>0</cp>\n  <im>0</im>\n  <id>0</id>\n  <l>false</l>\n  <ro xsi:nil=\"true\" />\n  <rid xsi:nil=\"true\" />\n  <s>false</s>\n  <as>false</as>\n  <sf>0</sf>\n  <u>0</u>\n  <g xsi:nil=\"true\" />\n  <rf>0</rf>\n  <rtid>0</rtid>\n  <p xsi:nil=\"true\" />\n  <ir xsi:nil=\"true\" />\n  <ipsm xsi:nil=\"true\" />\n  <ism xsi:nil=\"true\" />\n  <bp xsi:nil=\"true\" />\n</I>\n");
            return;
        }
        this.setResponseContent("text/xml", new XmlMapper().writer().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_XML_DECLARATION}).withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withDefaultPrettyPrinter().withRootName("I").writeValueAsString((Object)def.getRawObject()));
    }

    private static /* synthetic */ int lambda$getStore$3(HashMap itms, Integer t1, Integer t2) {
        return -Integer.compare((Integer)itms.get(t1), (Integer)itms.get(t2));
    }

    static {
        popularItemManagementInited = false;
    }
}

