/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.tools;

import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import org.asf.edge.common.xmls.items.edgespecific.ItemRegistryManifest;

public class ItemConverter {
    public static void main(String[] args) throws JsonMappingException, JsonProcessingException, IOException {
        XmlMapper mapper = new XmlMapper();
        mapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        mapper.configure(ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL, true);
        ItemRegistryManifest outp = new ItemRegistryManifest();
        outp.defaultItems = new ItemRegistryManifest.DefaultItemsBlock();
        outp.defaultItems.defaultItems = new ItemRegistryManifest.DefaultItemBlock[]{ItemConverter.defaultItem(1, 8977, 1, -1)};
        ArrayList<ObjectNode> objs = new ArrayList<ObjectNode>();
        for (File file : new File(args[0]).listFiles(t -> t.getName().endsWith(".xml") && t.isFile())) {
            ObjectNode node = (ObjectNode)mapper.readValue(Files.readString(file.toPath()), ObjectNode.class);
            if (node.get("id").asInt() == 0) continue;
            objs.add(node);
            System.out.println("Item registered: " + node.get("id").asInt() + ": " + node.get("itn").asText());
        }
        System.out.println(objs.size() + " items registered");
        outp.itemDefs = (ObjectNode[])objs.toArray(ObjectNode[]::new);
        Files.writeString(Path.of("itemdefs.xml", new String[0]), (CharSequence)mapper.writer().withDefaultPrettyPrinter().withFeatures(new FormatFeature[]{ToXmlGenerator.Feature.WRITE_NULLS_AS_XSI_NIL}).withRootName("ItemRegistryManifest").writeValueAsString((Object)outp), new OpenOption[0]);
    }

    private static ItemRegistryManifest.DefaultItemBlock defaultItem(int container, int id, int quantity, int uses) {
        ItemRegistryManifest.DefaultItemBlock b = new ItemRegistryManifest.DefaultItemBlock();
        b.itemID = id;
        b.uses = uses;
        b.quantity = quantity;
        b.inventoryID = container;
        return b;
    }
}

