/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts.impl.accounts.http;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.accounts.impl.RemoteHttpAccountManager;
import org.asf.edge.common.services.accounts.impl.accounts.http.RemoteHttpDataContainer;
import org.asf.edge.common.services.accounts.impl.accounts.http.RemoteHttpSaveContainer;

public class RemoteHttpAccountObject
extends AccountObject {
    private String id;
    private String username;
    private RemoteHttpAccountManager mgr;
    private Logger logger = LogManager.getLogger((String)"AccountManager");

    public RemoteHttpAccountObject(String id, String username, RemoteHttpAccountManager mgr) {
        this.id = id;
        this.username = username;
        this.mgr = mgr;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getAccountID() {
        return this.id;
    }

    @Override
    public long getLastLoginTime() {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            JsonObject response = this.mgr.accountManagerRequest("accounts/getLastLoginTime", payload);
            return response.get("time").getAsLong();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getLastLoginTime!", (Throwable)e);
            return -1L;
        }
    }

    @Override
    public String getAccountEmail() {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            JsonObject response = this.mgr.accountManagerRequest("accounts/getAccountEmail", payload);
            return response.get("email").getAsString();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getAccountEmail!", (Throwable)e);
            return null;
        }
    }

    @Override
    public long getRegistrationTimestamp() {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            JsonObject response = this.mgr.accountManagerRequest("accounts/getRegistrationTimestamp", payload);
            return response.get("time").getAsLong();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getRegistrationTimestamp!", (Throwable)e);
            return -1L;
        }
    }

    @Override
    public boolean updateUsername(String name) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("newName", name);
            JsonObject response = this.mgr.accountManagerRequest("accounts/updateUsername", payload);
            boolean res = response.get("success").getAsBoolean();
            if (res) {
                this.username = name;
            }
            return res;
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in updateUsername!", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean updateEmail(String email) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("email", email);
            JsonObject response = this.mgr.accountManagerRequest("accounts/updateEmail", payload);
            return response.get("success").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in updateEmail!", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean updatePassword(char[] newPassword) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("newPassword", new String(newPassword));
            JsonObject response = this.mgr.accountManagerRequest("accounts/updatePassword", payload);
            return response.get("success").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in updatePassword!", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean migrateToNormalAccountFromGuest(String newName, String email, char[] password) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("newName", newName);
            payload.addProperty("email", email);
            payload.addProperty("password", new String(password));
            JsonObject response = this.mgr.accountManagerRequest("accounts/migrateToNormalAccountFromGuest", payload);
            return response.get("success").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in migrateToNormalAccountFromGuest!", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isGuestAccount() {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            JsonObject response = this.mgr.accountManagerRequest("accounts/isGuestAccount", payload);
            return response.get("result").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in isGuestAccount!", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isMultiplayerEnabled() {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            JsonObject response = this.mgr.accountManagerRequest("accounts/isMultiplayerEnabled", payload);
            return response.get("result").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in isMultiplayerEnabled!", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isChatEnabled() {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            JsonObject response = this.mgr.accountManagerRequest("accounts/isChatEnabled", payload);
            return response.get("result").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in isChatEnabled!", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean isStrictChatFilterEnabled() {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            JsonObject response = this.mgr.accountManagerRequest("accounts/isStrictChatFilterEnabled", payload);
            return response.get("result").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in isStrictChatFilterEnabled!", (Throwable)e);
            return false;
        }
    }

    @Override
    public void setMultiplayerEnabled(boolean state) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("state", Boolean.valueOf(state));
            JsonObject response = this.mgr.accountManagerRequest("accounts/setMultiplayerEnabled", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in setMultiplayerEnabled!", (Throwable)e);
        }
    }

    @Override
    public void setChatEnabled(boolean state) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("state", Boolean.valueOf(state));
            JsonObject response = this.mgr.accountManagerRequest("accounts/setChatEnabled", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in setChatEnabled!", (Throwable)e);
        }
    }

    @Override
    public void setStrictChatFilterEnabled(boolean state) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("state", Boolean.valueOf(state));
            JsonObject response = this.mgr.accountManagerRequest("accounts/setStrictChatFilterEnabled", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in setStrictChatFilterEnabled!", (Throwable)e);
        }
    }

    @Override
    public void updateLastLoginTime() {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            JsonObject response = this.mgr.accountManagerRequest("accounts/updateLastLoginTime", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in updateLastLoginTime!", (Throwable)e);
        }
    }

    @Override
    public void deleteAccount() {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            JsonObject response = this.mgr.accountManagerRequest("accounts/deleteAccount", payload);
            if (!response.get("success").getAsBoolean()) {
                throw new IOException("Server returned success=false");
            }
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in deleteAccount!", (Throwable)e);
        }
    }

    @Override
    public AccountDataContainer getAccountData() {
        return new RemoteHttpDataContainer(this, this.id, this.mgr);
    }

    @Override
    public String[] getSaveIDs() {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            JsonObject response = this.mgr.accountManagerRequest("accounts/getSaveIDs", payload);
            JsonArray arr = response.get("saves").getAsJsonArray();
            String[] saves = new String[arr.size()];
            int i = 0;
            for (JsonElement ele : arr) {
                saves[i++] = ele.getAsString();
            }
            return saves;
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getSaveIDs!", (Throwable)e);
            return new String[0];
        }
    }

    @Override
    public AccountSaveContainer createSave(String username) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("username", username);
            JsonObject response = this.mgr.accountManagerRequest("accounts/createSave", payload);
            if (!response.get("success").getAsBoolean()) {
                return null;
            }
            String id = response.get("id").getAsString();
            return new RemoteHttpSaveContainer(id, response.get("time").getAsLong(), username, this.id, this.mgr, this);
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in createSave!", (Throwable)e);
            return null;
        }
    }

    @Override
    public AccountSaveContainer getSave(String id) {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("save", id);
            JsonObject response = this.mgr.accountManagerRequest("accounts/getSave", payload);
            if (!response.get("success").getAsBoolean()) {
                return null;
            }
            return new RemoteHttpSaveContainer(id, response.get("time").getAsLong(), response.get("username").getAsString(), this.id, this.mgr, this);
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in getSave!", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean isOnline() {
        try {
            JsonObject payload = new JsonObject();
            payload.addProperty("id", this.id);
            payload.addProperty("save", this.id);
            JsonObject response = this.mgr.accountManagerRequest("accounts/isOnline", payload);
            return response.get("result").getAsBoolean();
        }
        catch (IOException e) {
            this.logger.error("Account server query failure occurred in isOnline!", (Throwable)e);
            return false;
        }
    }
}

