/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts.impl.accounts.db;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asf.edge.common.services.accounts.AccountDataContainer;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.accounts.impl.DatabaseAccountManager;
import org.asf.edge.common.services.accounts.impl.accounts.db.DatabaseRequest;

public class DatabaseSaveDataContainer
extends AccountDataContainer {
    private AccountSaveContainer save;
    private String id;
    private AccountObject account;
    private Logger logger = LogManager.getLogger((String)"AccountManager");
    private DatabaseAccountManager manager;
    private HashMap<String, JsonElement> dataCache = new HashMap();

    public DatabaseSaveDataContainer(AccountObject account, AccountSaveContainer save, DatabaseAccountManager manager) {
        this.save = save;
        this.id = save.getSaveID();
        this.account = account;
        this.manager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected JsonElement get(String key) throws IOException {
        String keyF = key;
        while (true) {
            try {
                if (this.dataCache.containsKey(key)) {
                    if (this.dataCache.get(key) == null) {
                        return null;
                    }
                    JsonElement jsonElement = this.dataCache.get(key).deepCopy();
                    return jsonElement;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        HashMap<String, JsonElement> hashMap = this.dataCache;
        synchronized (hashMap) {
            if (this.dataCache.containsKey(key)) {
                if (this.dataCache.get(key) == null) {
                    return null;
                }
                JsonElement jsonElement = this.dataCache.get(key).deepCopy();
                return jsonElement;
            }
            try (DatabaseRequest req = this.manager.createRequest();){
                String parent = "";
                String parentContainer = "";
                if (key.contains("/")) {
                    parent = key.substring(0, key.lastIndexOf("/"));
                    key = key.substring(key.lastIndexOf("/") + 1);
                    if (parent.contains("/")) {
                        parentContainer = parent.substring(0, parent.lastIndexOf("/"));
                        parent = parent.substring(parent.lastIndexOf("/") + 1);
                    }
                }
                PreparedStatement statement = req.prepareStatement("SELECT DATA FROM SAVESPECIFICPLAYERDATA_V2 WHERE DATAKEY = ? AND PARENT = ? AND PARENTCONTAINER = ? AND SVID = ?");
                statement.setString(1, key);
                statement.setString(2, parent);
                statement.setString(3, parentContainer);
                statement.setString(4, this.id);
                ResultSet res = statement.executeQuery();
                if (!res.next()) {
                    res.close();
                    statement.close();
                    this.dataCache.put(keyF, null);
                    JsonElement jsonElement = null;
                    return jsonElement;
                }
                String data = res.getString("DATA");
                if (data == null) {
                    res.close();
                    statement.close();
                    this.dataCache.put(keyF, null);
                    JsonElement jsonElement = null;
                    return jsonElement;
                }
                res.close();
                statement.close();
                JsonElement r = JsonParser.parseString((String)data);
                this.dataCache.put(keyF, r);
                JsonElement jsonElement = r;
                return jsonElement;
            }
            catch (SQLException e) {
                this.logger.error("Failed to execute database query request while trying to retrieve save data entry '" + key + "' of ID '" + this.id + "'", (Throwable)e);
                throw new IOException("SQL error", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void set(String key, JsonElement value) throws IOException {
        String keyF = key;
        try (DatabaseRequest req = this.manager.createRequest();){
            String parent = "";
            String parentContainer = "";
            if (key.contains("/")) {
                parent = key.substring(0, key.lastIndexOf("/"));
                key = key.substring(key.lastIndexOf("/") + 1);
                if (parent.contains("/")) {
                    parentContainer = parent.substring(0, parent.lastIndexOf("/"));
                    parent = parent.substring(parent.lastIndexOf("/") + 1);
                }
            }
            PreparedStatement statement = req.prepareStatement("UPDATE SAVESPECIFICPLAYERDATA_V2 SET DATA = ? WHERE DATAKEY = ? AND PARENT = ? AND PARENTCONTAINER = ? AND SVID = ?");
            req.setDataObject(1, value.toString(), statement);
            statement.setString(2, key);
            statement.setString(3, parent);
            statement.setString(4, parentContainer);
            statement.setString(5, this.id);
            statement.execute();
            statement.close();
            this.dataCache.put(keyF, value);
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to update save data entry '" + key + "' of ID '" + this.id + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void create(String key, String root, JsonElement value) throws IOException {
        String keyF = key;
        try (DatabaseRequest req = this.manager.createRequest();){
            String parent = "";
            String parentContainer = "";
            if (key.contains("/")) {
                parent = key.substring(0, key.lastIndexOf("/"));
                key = key.substring(key.lastIndexOf("/") + 1);
                if (parent.contains("/")) {
                    parentContainer = parent.substring(0, parent.lastIndexOf("/"));
                    parent = parent.substring(parent.lastIndexOf("/") + 1);
                }
            }
            PreparedStatement statement = req.prepareStatement("INSERT INTO SAVESPECIFICPLAYERDATA_V2 VALUES(?, ?, ?, ?, ?)");
            statement.setString(1, this.id);
            statement.setString(2, key);
            statement.setString(3, parent);
            statement.setString(4, parentContainer);
            req.setDataObject(5, value.toString(), statement);
            statement.execute();
            statement.close();
            this.dataCache.put(keyF, value);
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to create save data entry '" + key + "' of ID '" + this.id + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean exists(String key) throws IOException {
        boolean bl;
        String keyF = key;
        while (true) {
            try {
                if (this.dataCache.containsKey(key)) {
                    return this.dataCache.get(key) != null;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        DatabaseRequest req = this.manager.createRequest();
        try {
            String parent = "";
            String parentContainer = "";
            if (key.contains("/")) {
                parent = key.substring(0, key.lastIndexOf("/"));
                key = key.substring(key.lastIndexOf("/") + 1);
                if (parent.contains("/")) {
                    parentContainer = parent.substring(0, parent.lastIndexOf("/"));
                    parent = parent.substring(parent.lastIndexOf("/") + 1);
                }
            }
            PreparedStatement statement = req.prepareStatement("SELECT DATA FROM SAVESPECIFICPLAYERDATA_V2 WHERE DATAKEY = ? AND PARENT = ? AND PARENTCONTAINER = ? AND SVID = ?");
            statement.setString(1, key);
            statement.setString(2, parent);
            statement.setString(3, parentContainer);
            statement.setString(4, this.id);
            ResultSet res = statement.executeQuery();
            boolean r = res.next();
            if (!r) {
                this.dataCache.put(keyF, null);
            } else if (res.getString("DATA") == null) {
                this.dataCache.put(keyF, null);
            }
            res.close();
            statement.close();
            bl = r;
        }
        catch (Throwable throwable) {
            try {
                req.close();
                throw throwable;
            }
            catch (SQLException e) {
                this.logger.error("Failed to execute database query request while trying to check save data entry '" + key + "' of ID '" + this.id + "'", (Throwable)e);
                throw new IOException("SQL error", e);
            }
        }
        req.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void delete(String key) throws IOException {
        String keyF = key;
        try (DatabaseRequest req = this.manager.createRequest();){
            String parent = "";
            String parentContainer = "";
            if (key.contains("/")) {
                parent = key.substring(0, key.lastIndexOf("/"));
                key = key.substring(key.lastIndexOf("/") + 1);
                if (parent.contains("/")) {
                    parentContainer = parent.substring(0, parent.lastIndexOf("/"));
                    parent = parent.substring(parent.lastIndexOf("/") + 1);
                }
            }
            PreparedStatement statement = req.prepareStatement("DELETE FROM SAVESPECIFICPLAYERDATA_V2 WHERE DATAKEY = ? AND PARENT = ? AND PARENTCONTAINER = ? AND SVID = ?");
            statement.setString(1, key);
            statement.setString(2, parent);
            statement.setString(3, parentContainer);
            statement.setString(4, this.id);
            statement.execute();
            statement.close();
            this.dataCache.remove(keyF);
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to delete save data entry '" + key + "' of ID '" + this.id + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] getEntryKeys(String key) throws IOException {
        String parent = key;
        String parentContainer = "";
        if (parent.contains("/")) {
            parentContainer = parent.substring(0, parent.lastIndexOf("/"));
            parent = parent.substring(parent.lastIndexOf("/") + 1);
        }
        ArrayList<String> keys = new ArrayList<String>();
        try (DatabaseRequest req = this.manager.createRequest();){
            PreparedStatement statement = req.prepareStatement("SELECT DATAKEY FROM SAVESPECIFICPLAYERDATA_V2 WHERE PARENT = ? AND PARENTCONTAINER = ? AND SVID = ?");
            statement.setString(1, parent);
            statement.setString(2, parentContainer);
            statement.setString(3, this.id);
            ResultSet res = statement.executeQuery();
            while (res.next()) {
                String cont = res.getString("DATAKEY");
                if (cont.isEmpty() || keys.contains(cont)) continue;
                keys.add(cont);
            }
            res.close();
            statement.close();
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to retrieve child containers of save data container '" + key + "' of ID '" + this.id + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
        return (String[])keys.toArray(String[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] getChildContainers(String key) throws IOException {
        ArrayList<String> containers = new ArrayList<String>();
        try (DatabaseRequest req = this.manager.createRequest();){
            PreparedStatement statement = req.prepareStatement("SELECT PARENT FROM SAVESPECIFICPLAYERDATA_V2 WHERE PARENTCONTAINER = ? AND SVID = ?");
            statement.setString(1, key);
            statement.setString(2, this.id);
            ResultSet res = statement.executeQuery();
            while (res.next()) {
                String cont = res.getString("PARENT");
                if (cont.isEmpty() || containers.contains(cont)) continue;
                containers.add(cont);
            }
            res.close();
            statement.close();
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to retrieve child containers of save data container '" + key + "' of ID '" + this.id + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
        return (String[])containers.toArray(String[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteContainer(String root) throws IOException {
        String parent = root;
        String parentContainer = "";
        if (parent.contains("/")) {
            parentContainer = parent.substring(0, parent.lastIndexOf("/"));
            parent = parent.substring(parent.lastIndexOf("/") + 1);
        }
        try {
            for (String ent : this.getEntryKeys()) {
                String k = (String)(root.isEmpty() ? "" : root + "/") + ent;
                if (!this.dataCache.containsKey(k)) continue;
                this.dataCache.remove(k);
            }
            for (String ch : this.getChildContainers(root)) {
                this.deleteContainer((String)(root.isEmpty() ? "" : root + "/") + ch);
            }
            try (DatabaseRequest req = this.manager.createRequest();){
                PreparedStatement statement = req.prepareStatement("DELETE FROM SAVESPECIFICPLAYERDATA_V2 WHERE PARENT = ? AND PARENTCONTAINER = ? AND SVID = ?");
                statement.setString(1, parent);
                statement.setString(2, parentContainer);
                statement.setString(3, this.id);
                statement.execute();
                statement.close();
            }
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to delete save data container '" + (root.isEmpty() ? "<root>" : root) + "' of ID '" + this.id + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }

    @Override
    public AccountObject getAccount() {
        return this.account;
    }

    @Override
    public AccountSaveContainer getSave() {
        return this.save;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected JsonElement find(BiFunction<String, JsonElement, Boolean> function, String root) throws IOException {
        JsonElement resO = null;
        String parent = root;
        String parentContainer = "";
        if (parent.contains("/")) {
            parentContainer = parent.substring(0, parent.lastIndexOf("/"));
            parent = parent.substring(parent.lastIndexOf("/") + 1);
        }
        ArrayList<String> keys = new ArrayList<String>();
        try (DatabaseRequest req = this.manager.createRequest();){
            PreparedStatement statement = req.prepareStatement("SELECT * FROM SAVESPECIFICPLAYERDATA_V2 WHERE PARENT = ? AND PARENTCONTAINER = ? AND SVID = ?");
            statement.setString(1, parent);
            statement.setString(2, parentContainer);
            statement.setString(3, this.id);
            ResultSet res = statement.executeQuery();
            while (res.next()) {
                String cont = res.getString("DATAKEY");
                String data = res.getString("DATA");
                if (cont.isEmpty() || keys.contains(cont)) continue;
                keys.add(cont);
                JsonElement d = JsonParser.parseString((String)data);
                if (!function.apply(cont, d).booleanValue()) continue;
                resO = d;
                break;
            }
            res.close();
            statement.close();
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to retrieve child containers of save data container '" + root + "' of ID '" + this.id + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
        return resO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runFor(BiFunction<String, JsonElement, Boolean> function, String root) throws IOException {
        String parent = root;
        String parentContainer = "";
        if (parent.contains("/")) {
            parentContainer = parent.substring(0, parent.lastIndexOf("/"));
            parent = parent.substring(parent.lastIndexOf("/") + 1);
        }
        ArrayList<String> keys = new ArrayList<String>();
        try (DatabaseRequest req = this.manager.createRequest();){
            PreparedStatement statement = req.prepareStatement("SELECT * FROM SAVESPECIFICPLAYERDATA_V2 WHERE PARENT = ? AND PARENTCONTAINER = ? AND SVID = ?");
            statement.setString(1, parent);
            statement.setString(2, parentContainer);
            statement.setString(3, this.id);
            ResultSet res = statement.executeQuery();
            while (res.next()) {
                String cont = res.getString("DATAKEY");
                String data = res.getString("DATA");
                if (cont.isEmpty() || keys.contains(cont)) continue;
                keys.add(cont);
                JsonElement d = JsonParser.parseString((String)data);
                if (function.apply(cont, d).booleanValue()) continue;
                break;
            }
            res.close();
            statement.close();
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to retrieve child containers of save data container '" + root + "' of ID '" + this.id + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runForChildren(Function<String, Boolean> function, String root) throws IOException {
        ArrayList<String> containers = new ArrayList<String>();
        try (DatabaseRequest req = this.manager.createRequest();){
            PreparedStatement statement = req.prepareStatement("SELECT PARENT FROM SAVESPECIFICPLAYERDATA_V2 WHERE PARENTCONTAINER = ? AND SVID = ?");
            statement.setString(1, root);
            statement.setString(2, this.id);
            ResultSet res = statement.executeQuery();
            while (res.next()) {
                String cont = res.getString("PARENT");
                if (cont.isEmpty() || containers.contains(cont)) continue;
                containers.add(cont);
                if (function.apply(cont).booleanValue()) continue;
                break;
            }
            res.close();
            statement.close();
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to retrieve child containers of save data container '" + root + "' of ID '" + this.id + "'", (Throwable)e);
            throw new IOException("SQL error", e);
        }
    }
}

