/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.services.accounts.impl;

import com.google.gson.JsonParser;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.function.Function;
import org.asf.edge.common.services.accounts.AccountObject;
import org.asf.edge.common.services.accounts.AccountSaveContainer;
import org.asf.edge.common.services.accounts.impl.BasicAccountManager;
import org.asf.edge.common.services.accounts.impl.BasicAccountObject;
import org.asf.edge.common.services.accounts.impl.accounts.db.DatabaseAccountObject;
import org.asf.edge.common.services.accounts.impl.accounts.db.DatabaseRequest;

public abstract class DatabaseAccountManager
extends BasicAccountManager {
    @Override
    public void initService() {
    }

    public abstract DatabaseRequest createRequest() throws SQLException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isLoginNameInUse(String username) {
        try (DatabaseRequest conn = this.createRequest();){
            PreparedStatement statement = conn.prepareStatement("SELECT COUNT(ID) FROM USERMAP_V2 WHERE USERNAME = ?");
            statement.setString(1, username);
            ResultSet res = statement.executeQuery();
            if (!res.next()) {
                res.close();
                statement.close();
                boolean bl = false;
                return bl;
            }
            boolean r = res.getInt(1) != 0;
            res.close();
            statement.close();
            boolean bl = r;
            return bl;
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to check if username '" + username + "' is taken", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isVikingNameInUse(String username) {
        try (DatabaseRequest conn = this.createRequest();){
            PreparedStatement statement = conn.prepareStatement("SELECT COUNT(ID) FROM SAVEUSERNAMEMAP_V2 WHERE USERNAME = ?");
            statement.setString(1, username);
            ResultSet res = statement.executeQuery();
            if (!res.next()) {
                res.close();
                statement.close();
                boolean bl = false;
                return bl;
            }
            boolean r = res.getInt(1) != 0;
            res.close();
            statement.close();
            boolean bl = r;
            return bl;
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to check if username '" + username + "' is taken", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getAccountID(String username) {
        try (DatabaseRequest conn = this.createRequest();){
            PreparedStatement statement = conn.prepareStatement("SELECT ID FROM USERMAP_V2 WHERE USERNAME = ?");
            statement.setString(1, username);
            ResultSet res = statement.executeQuery();
            if (!res.next()) {
                res.close();
                statement.close();
                String string = null;
                return string;
            }
            String r = res.getString("ID");
            res.close();
            statement.close();
            String string = r;
            return string;
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to pull user ID of username '" + username + "'", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getAccountIdBySaveUsername(String username) {
        try {
            String id;
            try (DatabaseRequest conn = this.createRequest();){
                PreparedStatement statement = conn.prepareStatement("SELECT ID FROM SAVEUSERNAMEMAP_V2 WHERE USERNAME = ?");
                statement.setString(1, username);
                ResultSet res = statement.executeQuery();
                if (!res.next()) {
                    res.close();
                    statement.close();
                    String string = null;
                    return string;
                }
                id = res.getString("ID");
                res.close();
                statement.close();
            }
            AccountSaveContainer save = this.getSaveByID(id);
            if (save != null) return save.getAccount().getAccountID();
            return null;
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to pull user ID of save username '" + username + "'", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] getPasswordCheckData(String id) {
        try (DatabaseRequest conn = this.createRequest();){
            PreparedStatement statement = conn.prepareStatement("SELECT CREDS FROM USERMAP_V2 WHERE ID = ?");
            statement.setString(1, id);
            ResultSet res = statement.executeQuery();
            if (!res.next()) {
                res.close();
                statement.close();
                byte[] byArray = null;
                return byArray;
            }
            byte[] data = res.getBytes("CREDS");
            res.close();
            statement.close();
            if (data == null) {
                byte[] byArray = null;
                return byArray;
            }
            if (data.length != 48) {
                this.logger.error("Detected corrupted credentials for ID '" + id + "' during password verification.");
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = data;
            return byArray;
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to verify password for ID '" + id + "'", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runForAllAccounts(Function<AccountObject, Boolean> func) {
        try (DatabaseRequest conn = this.createRequest();){
            PreparedStatement statement = conn.prepareStatement("SELECT ID, USERNAME FROM USERMAP_V2");
            ResultSet res = statement.executeQuery();
            while (res.next()) {
                String id = res.getString("ID");
                if (id == null) {
                    res.close();
                    statement.close();
                    return;
                }
                DatabaseAccountObject acc = new DatabaseAccountObject(id, res.getString("USERNAME"), this);
                try {
                    if (func.apply(acc).booleanValue()) continue;
                }
                catch (Exception e) {
                    this.logger.error("Exception occurred while running runForAllAccounts!", (Throwable)e);
                }
                break;
            }
            res.close();
            statement.close();
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to run a function for all accounts", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean accountExists(String id) {
        try (DatabaseRequest conn = this.createRequest();){
            PreparedStatement statement = conn.prepareStatement("SELECT COUNT(USERNAME) FROM USERMAP_V2 WHERE ID = ?");
            statement.setString(1, id);
            ResultSet res = statement.executeQuery();
            if (!res.next()) {
                res.close();
                statement.close();
                boolean bl = false;
                return bl;
            }
            boolean r = res.getInt(1) != 0;
            res.close();
            statement.close();
            boolean bl = r;
            return bl;
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to check if ID '" + id + "' exists", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected AccountObject getAccountByID(String aid, boolean guest) {
        if (!guest) {
            try (DatabaseRequest conn = this.createRequest();){
                DatabaseAccountObject acc2;
                PreparedStatement statement = conn.prepareStatement("SELECT USERNAME FROM USERMAP_V2 WHERE ID = ?");
                statement.setString(1, aid);
                ResultSet res = statement.executeQuery();
                if (!res.next()) {
                    res.close();
                    statement.close();
                    AccountObject accountObject = null;
                    return accountObject;
                }
                String username = res.getString("USERNAME");
                if (username == null) {
                    res.close();
                    statement.close();
                    AccountObject accountObject = null;
                    return accountObject;
                }
                res.close();
                statement.close();
                DatabaseAccountObject databaseAccountObject = acc2 = new DatabaseAccountObject(aid, username, this);
                return databaseAccountObject;
            }
            catch (SQLException e) {
                this.logger.error("Failed to execute database query request while trying to pull account object of ID '" + aid + "'", (Throwable)e);
                return null;
            }
        }
        try (DatabaseRequest conn = this.createRequest();){
            DatabaseAccountObject acc;
            PreparedStatement statement = conn.prepareStatement("SELECT ID FROM USERMAP_V2 WHERE USERNAME = ?");
            statement.setString(1, "g/" + aid);
            ResultSet res = statement.executeQuery();
            if (!res.next()) {
                res.close();
                statement.close();
                AccountObject username = null;
                return username;
            }
            String id = res.getString("ID");
            if (id == null) {
                res.close();
                statement.close();
                AccountObject acc2 = null;
                return acc2;
            }
            res.close();
            statement.close();
            DatabaseAccountObject databaseAccountObject = acc = new DatabaseAccountObject(id, "g/" + aid, this);
            return databaseAccountObject;
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to pull account object of guest ID '" + aid + "'", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getAccountIDByEmail(String email) {
        try (DatabaseRequest conn = this.createRequest();){
            PreparedStatement statement = conn.prepareStatement("SELECT ID FROM EMAILMAP_V2 WHERE EMAIL = ?");
            statement.setString(1, email);
            ResultSet res = statement.executeQuery();
            if (!res.next()) {
                res.close();
                statement.close();
                String string = null;
                return string;
            }
            String r = res.getString("ID");
            res.close();
            statement.close();
            String string = r;
            return string;
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to pull user ID of email '" + email + "'", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AccountSaveContainer getSaveByID(String id) {
        try (DatabaseRequest conn = this.createRequest();){
            PreparedStatement statement = conn.prepareStatement("SELECT DATA FROM SAVESPECIFICPLAYERDATA_V2 WHERE SVID = ? AND DATAKEY = ? AND PARENT = ? AND PARENTCONTAINER = ?");
            statement.setString(1, id);
            statement.setString(2, "accountid");
            statement.setString(3, "");
            statement.setString(4, "");
            ResultSet res = statement.executeQuery();
            if (!res.next()) {
                res.close();
                statement.close();
                AccountSaveContainer accountSaveContainer = null;
                return accountSaveContainer;
            }
            String data = res.getString("DATA");
            if (data == null) {
                res.close();
                statement.close();
                AccountSaveContainer accountSaveContainer = null;
                return accountSaveContainer;
            }
            res.close();
            statement.close();
            String accID = JsonParser.parseString((String)data).getAsString();
            AccountObject acc = this.getAccount(accID);
            if (acc == null) {
                AccountSaveContainer accountSaveContainer = null;
                return accountSaveContainer;
            }
            AccountSaveContainer accountSaveContainer = acc.getSave(id);
            return accountSaveContainer;
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to retrieve save '" + id + "'", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicAccountObject registerGuest(String id, String guestID) {
        DatabaseAccountObject obj = null;
        try (DatabaseRequest conn = this.createRequest();){
            obj = new DatabaseAccountObject(id, "g/" + guestID, this);
            PreparedStatement statement = conn.prepareStatement("INSERT INTO USERMAP_V2 VALUES(?, ?, ?)");
            statement.setString(1, "g/" + guestID);
            statement.setString(2, id);
            statement.setBytes(3, new byte[0]);
            statement.execute();
            statement.close();
            statement = conn.prepareStatement("INSERT INTO SAVEMAP_V2 VALUES(?, ?)");
            statement.setString(1, id);
            conn.setDataObject(2, "[]", statement);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to register account '" + id + "'", (Throwable)e);
            return null;
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicAccountObject registerAccount(String accID, String email, String username, byte[] cred) {
        DatabaseAccountObject obj = null;
        try (DatabaseRequest conn = this.createRequest();){
            PreparedStatement statement;
            obj = new DatabaseAccountObject(accID, username, this);
            if (email != null) {
                statement = conn.prepareStatement("INSERT INTO EMAILMAP_V2 VALUES(?, ?)");
                statement.setString(1, email);
                statement.setString(2, accID);
                statement.execute();
                statement.close();
            }
            statement = conn.prepareStatement("INSERT INTO USERMAP_V2 VALUES(?, ?, ?)");
            statement.setString(1, username);
            statement.setString(2, accID);
            statement.setBytes(3, cred);
            statement.execute();
            statement.close();
            statement = conn.prepareStatement("INSERT INTO SAVEMAP_V2 VALUES(?, ?)");
            statement.setString(1, accID);
            conn.setDataObject(2, "[]", statement);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            this.logger.error("Failed to execute database query request while trying to register account '" + accID + "'", (Throwable)e);
            return null;
        }
        return obj;
    }
}

