/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.http.apihandlerutils;

import java.nio.charset.StandardCharsets;

public class HttpException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private int statusCode;
    private String statusMessage;
    private String bodyMediaType;
    private byte[] body;

    public HttpException(int statusCode, String statusMessage) {
        super(statusCode + " " + statusMessage);
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
    }

    public HttpException(int statusCode, String statusMessage, byte[] body) {
        this(statusCode, statusMessage);
        this.body = body;
    }

    public HttpException(int statusCode, String statusMessage, String body) {
        this(statusCode, statusMessage, body.getBytes(StandardCharsets.UTF_8));
    }

    public HttpException(int statusCode, String statusMessage, String bodyMediaType, byte[] body) {
        this(statusCode, statusMessage);
        this.body = body;
        this.bodyMediaType = bodyMediaType;
    }

    public HttpException(int statusCode, String statusMessage, String bodyMediaType, String body) {
        this(statusCode, statusMessage, bodyMediaType, body.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getBodyMediaType() {
        return this.bodyMediaType;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public int getStatusCode() {
        return this.statusCode;
    }
}

