/*
 * Decompiled with CFR 0.152.
 */
package org.asf.edge.common.entities.items;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.asf.edge.common.entities.items.ItemAttributeInfo;
import org.asf.edge.common.entities.items.ItemCategoryInfo;
import org.asf.edge.common.entities.items.ItemSaleInfo;
import org.asf.edge.common.services.items.ItemManager;

public class ItemInfo {
    private int id;
    private String name;
    private String description;
    private ObjectNode raw;
    private ItemCategoryInfo[] categories;
    private ItemAttributeInfo[] attributes;
    private int costGems;
    private int costCoins;

    public ItemInfo(int id, String name, String description, ObjectNode raw) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.raw = raw;
        this.costCoins = raw.get("ct").asInt();
        this.costGems = raw.get("ct2").asInt();
        this.loadCategories();
        this.loadAttributes();
    }

    private void loadAttributes() {
        ObjectNode raw = this.getRawObject();
        if (!raw.has("at")) {
            this.attributes = new ItemAttributeInfo[0];
            return;
        }
        ArrayList<ItemAttributeInfo> attrs = new ArrayList<ItemAttributeInfo>();
        JsonNode node = raw.get("at");
        if (node.isArray()) {
            for (JsonNode n : node) {
                if (!n.has("k") || !n.has("v")) continue;
                ItemAttributeInfo attr = new ItemAttributeInfo(n.get("k").asText(), n.get("v"));
                attrs.add(attr);
            }
        } else if (node.has("k") && node.has("v")) {
            ItemAttributeInfo attr = new ItemAttributeInfo(node.get("k").asText(), node.get("v"));
            attrs.add(attr);
        }
        this.attributes = (ItemAttributeInfo[])attrs.toArray(ItemAttributeInfo[]::new);
    }

    private void loadCategories() {
        if (!this.raw.has("c")) {
            this.categories = new ItemCategoryInfo[0];
            return;
        }
        ArrayList<ItemCategoryInfo> cats = new ArrayList<ItemCategoryInfo>();
        JsonNode node = this.raw.get("c");
        if (node.isArray()) {
            for (JsonNode n : node) {
                if (!n.has("cid") || !n.has("cn") || !n.has("i")) continue;
                ItemCategoryInfo c = new ItemCategoryInfo(n.get("cid").asInt(), n.get("cn").asText(), n.get("i").asText());
                cats.add(c);
            }
        } else if (node.has("cid") && node.has("cn") && node.has("i")) {
            ItemCategoryInfo c = new ItemCategoryInfo(node.get("cid").asInt(), node.get("cn").asText(), node.get("i").asText());
            cats.add(c);
        }
        this.categories = (ItemCategoryInfo[])cats.toArray(ItemCategoryInfo[]::new);
    }

    public CostInfo getFinalCost(boolean member) {
        float modifier;
        boolean valid;
        CostInfo cost = this.getCost();
        ItemManager manager = ItemManager.getInstance();
        float costFinal = cost.cost;
        if (member) {
            for (ItemSaleInfo sale : manager.getActiveSales()) {
                if (!sale.isMemberOnly()) continue;
                valid = false;
                if (IntStream.of(sale.getItemIDs()).anyMatch(t -> t == this.id)) {
                    valid = true;
                } else if (IntStream.of(sale.getCategories()).anyMatch(t -> Stream.of(this.getCategories()).anyMatch(t2 -> t2.getCategoryID() == t))) {
                    valid = true;
                }
                if (!valid) continue;
                modifier = 0.0f;
                modifier = sale.getSaleModifier() >= 1.0f ? 0.0f : (sale.getSaleModifier() >= 0.0f ? 1.0f - sale.getSaleModifier() : 1.0f);
                costFinal *= modifier;
            }
        }
        for (ItemSaleInfo sale : manager.getActiveSales()) {
            if (sale.isMemberOnly()) continue;
            valid = false;
            if (IntStream.of(sale.getItemIDs()).anyMatch(t -> t == this.id)) {
                valid = true;
            } else if (IntStream.of(sale.getCategories()).anyMatch(t -> Stream.of(this.getCategories()).anyMatch(t2 -> t2.getCategoryID() == t))) {
                valid = true;
            }
            if (!valid) continue;
            modifier = 0.0f;
            modifier = sale.getSaleModifier() >= 1.0f ? 0.0f : (sale.getSaleModifier() >= 0.0f ? 1.0f - sale.getSaleModifier() : 1.0f);
            costFinal *= modifier;
        }
        costFinal = new BigDecimal(costFinal).setScale(0, RoundingMode.HALF_UP).floatValue();
        cost.cost = (int)costFinal;
        return cost;
    }

    public CostInfo getCost() {
        if (this.costsGems()) {
            CostInfo cost = new CostInfo();
            cost.isGems = true;
            cost.cost = this.costGems;
            return cost;
        }
        CostInfo cost = new CostInfo();
        if (this.costCoins <= 0) {
            cost.isFree = true;
        } else {
            cost.isCoins = true;
        }
        cost.cost = this.costCoins;
        return cost;
    }

    public int getCoinCost() {
        return this.costCoins;
    }

    public int getGemCost() {
        return this.costGems;
    }

    public boolean isFree() {
        return this.costGems <= 0 && this.costCoins <= 0;
    }

    public boolean costsGems() {
        return this.costGems > 0;
    }

    public boolean costsCoins() {
        return this.costGems <= 0;
    }

    public ItemCategoryInfo[] getCategories() {
        return this.categories;
    }

    public ItemAttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public boolean hasAttribute(String key) {
        return Stream.of(this.attributes).anyMatch(t -> t.getKey().equals(key));
    }

    public ItemAttributeInfo getAttribute(String key) {
        Optional<ItemAttributeInfo> attr = Stream.of(this.attributes).filter(t -> t.getKey().equals(key)).findFirst();
        if (attr.isEmpty()) {
            return null;
        }
        return attr.get();
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ObjectNode getRawObject() {
        return this.raw;
    }

    public void reloadDef() {
        this.id = this.raw.get("id").asInt();
        this.name = this.raw.get("itn").asText();
        this.description = this.raw.get("d").asText();
        this.costCoins = this.raw.get("ct").asInt();
        this.costGems = this.raw.get("ct2").asInt();
        this.loadCategories();
        this.loadAttributes();
    }

    public static class CostInfo {
        public boolean isGems;
        public boolean isCoins;
        public boolean isFree;
        public int cost;
    }
}

