/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.ec;

import java.security.InvalidKeyException;
import java.security.PublicKey;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;

class ECUtils {
    ECUtils() {
    }

    static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) throws InvalidKeyException {
        return publicKey instanceof BCECPublicKey ? ((BCECPublicKey)publicKey).engineGetKeyParameters() : ECUtil.generatePublicKeyParameter(publicKey);
    }

    static X962Parameters getDomainParametersFromName(ECParameterSpec eCParameterSpec, boolean bl) {
        X962Parameters x962Parameters;
        if (eCParameterSpec instanceof ECNamedCurveParameterSpec) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ECUtil.getNamedCurveOid(((ECNamedCurveParameterSpec)eCParameterSpec).getName());
            if (aSN1ObjectIdentifier == null) {
                aSN1ObjectIdentifier = new ASN1ObjectIdentifier(((ECNamedCurveParameterSpec)eCParameterSpec).getName());
            }
            x962Parameters = new X962Parameters(aSN1ObjectIdentifier);
        } else if (eCParameterSpec == null) {
            x962Parameters = new X962Parameters(DERNull.INSTANCE);
        } else {
            ECParameterSpec eCParameterSpec2 = eCParameterSpec;
            X9ECParameters x9ECParameters = new X9ECParameters(eCParameterSpec2.getCurve(), new X9ECPoint(eCParameterSpec2.getG(), bl), eCParameterSpec2.getN(), eCParameterSpec2.getH(), eCParameterSpec2.getSeed());
            x962Parameters = new X962Parameters(x9ECParameters);
        }
        return x962Parameters;
    }

    static X9ECParameters getDomainParametersFromName(String string, ProviderConfiguration providerConfiguration) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        if (null == string || string.length() < 1) {
            return null;
        }
        int n = string.indexOf(32);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        if (null == (aSN1ObjectIdentifier = ECUtils.getOID(string))) {
            return ECUtil.getNamedCurveByName(string);
        }
        X9ECParameters x9ECParameters = ECUtil.getNamedCurveByOid(aSN1ObjectIdentifier);
        if (null == x9ECParameters && null != providerConfiguration) {
            Map map = providerConfiguration.getAdditionalECParameters();
            x9ECParameters = (X9ECParameters)map.get(aSN1ObjectIdentifier);
        }
        return x9ECParameters;
    }

    private static ASN1ObjectIdentifier getOID(String string) {
        char c = string.charAt(0);
        if (c >= '0' && c <= '2') {
            try {
                return new ASN1ObjectIdentifier(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

