/*
 * Decompiled with CFR 0.152.
 */
package org.asf.cyan.fluid.remapping;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.asf.cyan.fluid.Fluid;
import org.asf.cyan.fluid.remapping.MAPTYPE;
import org.asf.cyan.fluid.remapping.SimpleMappings;

public class Mapping<T extends Mapping<T>> {
    public MAPTYPE mappingType = MAPTYPE.TOPLEVEL;
    public String type = null;
    public String[] argumentTypes = new String[0];
    public String name = null;
    public String mappingsVersion = null;
    public String obfuscated = null;
    public Mapping<?>[] mappings = new Mapping[0];

    protected Mapping() {
    }

    public boolean allowSupertypeFinalOverride() {
        return false;
    }

    public MAPTYPE getMappingType() {
        return this.mappingType;
    }

    public <M extends Mapping<M>> T parseProGuardMappings(String mappings) {
        String[] lines;
        this.mappingType = MAPTYPE.TOPLEVEL;
        this.name = null;
        this.type = null;
        this.obfuscated = null;
        mappings = mappings.replace("\r", "");
        mappings = mappings.replace("\t", "    ");
        ArrayList<Object> mappingsLst = new ArrayList<Object>();
        ArrayList<M> mappingsLstFmp = new ArrayList<M>();
        Object mp = null;
        for (String line : lines = mappings.split("\n")) {
            if (line.startsWith("#")) continue;
            if (line.startsWith("    ")) {
                mappingsLstFmp.add(new Mapping<T>().parseProGuardEntry(line.substring(4)));
                continue;
            }
            if (mp != null) {
                mp.mappings = (Mapping[])mappingsLstFmp.toArray(Mapping[]::new);
                mappingsLst.add(mp);
                mappingsLstFmp.clear();
                mp = null;
            }
            mp = new Mapping<T>().parseProGuardEntry(line);
        }
        if (mp != null) {
            mp.mappings = (Mapping[])mappingsLstFmp.toArray(Mapping[]::new);
            mappingsLst.add(mp);
            mappingsLstFmp.clear();
            mp = null;
        }
        this.mappings = (Mapping[])mappingsLst.toArray(Mapping[]::new);
        return (T)this;
    }

    private <M extends Mapping<M>> M parseProGuardEntry(String entry) {
        this.mappingType = MAPTYPE.PROPERTY;
        if (entry.endsWith(":")) {
            entry = entry.substring(0, entry.length() - 1);
            this.mappingType = MAPTYPE.CLASS;
        }
        String output = entry.substring(entry.indexOf(" -> ") + 4);
        String input = entry.substring(0, entry.indexOf(" -> "));
        if (input.matches("^([0-9]+:[0-9]+:)?[A-Za-z0-9.$_\\[\\]]+ .*\\(.*\\).*$")) {
            this.mappingType = MAPTYPE.METHOD;
            Matcher m = Pattern.compile("^([0-9]+:[0-9]+:)?([A-Za-z0-9.$_\\[\\]]+) (.*)").matcher(input);
            m.matches();
            if (m.group(1) != null) {
                input = input.substring(m.group(1).length());
            }
            String arguments = input.substring(input.indexOf("(") + 1);
            if (!(arguments = arguments.substring(0, arguments.lastIndexOf(")"))).isEmpty()) {
                arguments = arguments.replace(", ", ",");
                this.argumentTypes = arguments.split(",");
            }
            input = input.substring(0, input.indexOf("("));
        }
        switch (this.mappingType) {
            case CLASS: {
                this.name = input;
                this.obfuscated = output;
                break;
            }
            default: {
                this.name = input.substring(input.indexOf(" ") + 1);
                this.type = input.substring(0, input.indexOf(" "));
                this.obfuscated = output;
            }
        }
        return (M)this;
    }

    public <M extends Mapping<M>> T parseTSRGMappings(String mappings) {
        this.mappingType = MAPTYPE.TOPLEVEL;
        this.name = null;
        this.type = null;
        this.obfuscated = null;
        mappings = mappings.replace("\r", "");
        mappings = mappings.replace("\t", "    ");
        ArrayList<Object> mappingsLst = new ArrayList<Object>();
        ArrayList<M> mappingsLstFmp = new ArrayList<M>();
        Object mp = null;
        String[] lines = mappings.split("\n");
        int version = 1;
        if (lines.length > 0 && lines[0].split(" ").length > 2) {
            String TSRGversion = lines[0].split(" ")[0];
            if (TSRGversion.equals("tsrg2")) {
                version = 2;
            } else {
                throw new RuntimeException("Unsupported TSRG version: " + TSRGversion);
            }
        }
        boolean firstLine = true;
        for (String line : lines) {
            if (firstLine && version > 1) {
                firstLine = false;
                continue;
            }
            if (line.startsWith("#")) continue;
            if (line.startsWith("    ")) {
                if (version == 2 && line.startsWith("        ")) continue;
                mappingsLstFmp.add(new Mapping<T>().parseTSRGEntry(line.substring(4), false, version));
                continue;
            }
            if (mp != null) {
                mp.mappings = (Mapping[])mappingsLstFmp.toArray(Mapping[]::new);
                mappingsLst.add(mp);
                mappingsLstFmp.clear();
                mp = null;
            }
            mp = new Mapping<T>().parseTSRGEntry(line, true, version);
        }
        if (mp != null) {
            mp.mappings = (Mapping[])mappingsLstFmp.toArray(Mapping[]::new);
            mappingsLst.add(mp);
            mappingsLstFmp.clear();
            mp = null;
        }
        this.mappings = (Mapping[])mappingsLst.toArray(Mapping[]::new);
        for (Mapping mapping : mappingsLst) {
            for (Mapping<?> t : mapping.mappings) {
                Mapping<?> map2;
                if (!t.mappingType.equals((Object)MAPTYPE.METHOD)) continue;
                String[] types = t.argumentTypes;
                if (types.length != 0) {
                    int ind = 0;
                    for (String type : types) {
                        Mapping<?> map;
                        String tSuffix = "";
                        if (type.contains("[]")) {
                            tSuffix = type.substring(type.indexOf("["));
                            type = type.substring(0, type.indexOf("["));
                        }
                        if ((map = this.mapClassToMapping(type, t2 -> true, true)) != null) {
                            types[ind++] = map.name + tSuffix;
                            continue;
                        }
                        ++ind;
                    }
                    t.argumentTypes = types;
                }
                if ((map2 = this.mapClassToMapping(t.type, t2 -> true, true)) == null) continue;
                t.type = map2.name;
            }
        }
        this.mappings = (Mapping[])mappingsLst.toArray(Mapping[]::new);
        return (T)this;
    }

    private <M extends Mapping<M>> M parseTSRGEntry(String entry, boolean isClass, int tsrgVersion) {
        this.mappingType = isClass ? MAPTYPE.CLASS : MAPTYPE.PROPERTY;
        String output = entry.substring(entry.indexOf(" ") + 1);
        String input = entry.substring(0, entry.indexOf(" "));
        if (output.matches(TsrgFormats.forVersion(tsrgVersion))) {
            String returnT;
            this.mappingType = MAPTYPE.METHOD;
            Matcher m = Pattern.compile(TsrgFormats.forVersionMatcher(tsrgVersion)).matcher(output);
            m.matches();
            String arguments = m.group(1);
            String[] argumentTypes = Fluid.parseMultipleDescriptors(arguments);
            this.type = returnT = Fluid.parseDescriptor(m.group(2));
            output = m.group(3);
            this.argumentTypes = argumentTypes;
        } else if (tsrgVersion == 2) {
            output = output.substring(0, output.lastIndexOf(" "));
        }
        this.name = output;
        this.obfuscated = input;
        if (this.mappingType.equals((Object)MAPTYPE.CLASS) && this.name.contains("/")) {
            this.name = this.name.replace("/", ".");
        }
        if (this.mappingType.equals((Object)MAPTYPE.CLASS) && this.obfuscated.contains("/")) {
            this.obfuscated = this.obfuscated.replace("/", ".");
        }
        return (M)this;
    }

    public T parseTinyV1Mappings(String mappings, String inputClassifier, String outputClassifier) {
        String[] tagsHeader;
        this.mappingType = MAPTYPE.TOPLEVEL;
        this.name = null;
        this.type = null;
        this.obfuscated = null;
        mappings = mappings.replace("\r", "");
        String[] lines = mappings.split("\n");
        TargetMap mp = new TargetMap();
        int id1 = 0;
        int id2 = 0;
        int index = 0;
        for (String str : tagsHeader = lines[0].split("\t")) {
            if (str.equals(inputClassifier)) {
                id1 = index;
            } else if (str.equals(outputClassifier)) {
                id2 = index;
            }
            ++index;
        }
        block11: for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            String[] tags = line.split("\t");
            switch (tags[0]) {
                case "CLASS": {
                    Target t3 = new Target();
                    t3.in = tags[id1];
                    t3.out = tags[id2];
                    mp.put(tags[id1], t3);
                    continue block11;
                }
                case "FIELD": {
                    String clsF = tags[1];
                    String returnTypeF = tags[2];
                    Target field = new Target();
                    field.in = tags[2 + id1];
                    field.out = tags[2 + id2];
                    field.type = Fluid.parseDescriptor(returnTypeF);
                    Target cF = (Target)mp.get(clsF);
                    cF.fields.add(field);
                    mp.put(cF.in, cF);
                    continue block11;
                }
                case "METHOD": {
                    String clsM = tags[1];
                    String descriptor = tags[2];
                    String returnTypeM = Fluid.parseDescriptor(descriptor.substring(descriptor.lastIndexOf(")") + 1));
                    String types = descriptor.substring(0, descriptor.lastIndexOf(")"));
                    types = types.substring(1);
                    String[] argTypes = Fluid.parseMultipleDescriptors(types);
                    Target method = new Target();
                    method.in = tags[2 + id1];
                    method.out = tags[2 + id2];
                    method.types = argTypes;
                    method.type = returnTypeM;
                    Target cM = (Target)mp.get(clsM);
                    cM.methods.add(method);
                    mp.put(cM.in, cM);
                    continue block11;
                }
            }
        }
        for (Mapping<?> m : this.mappings = (Mapping[])mp.values().stream().map(t -> {
            Mapping map = new Mapping();
            map.type = t.out.replace("/", ".");
            map.mappingType = MAPTYPE.CLASS;
            map.obfuscated = t.in.replace("/", ".");
            map.name = t.out.replace("/", ".");
            ArrayList localmappings = new ArrayList();
            for (Target meth : t.methods) {
                Mapping methmap = new Mapping();
                methmap.argumentTypes = meth.types;
                methmap.name = meth.out;
                methmap.obfuscated = meth.in;
                methmap.type = meth.type.replace("/", ".");
                methmap.mappingType = MAPTYPE.METHOD;
                localmappings.add(methmap);
            }
            for (Target field : t.fields) {
                Mapping fieldmap = new Mapping();
                fieldmap.name = field.out;
                fieldmap.obfuscated = field.in;
                fieldmap.type = field.type.replace("/", ".");
                fieldmap.mappingType = MAPTYPE.PROPERTY;
                localmappings.add(fieldmap);
            }
            map.mappings = (Mapping[])localmappings.toArray(Mapping[]::new);
            return map;
        }).toArray(Mapping[]::new)) {
            for (Mapping<?> t4 : m.mappings) {
                Mapping<?> map2;
                if (t4.mappingType.equals((Object)MAPTYPE.METHOD)) {
                    Mapping<?> map22;
                    String[] types = t4.argumentTypes;
                    if (types.length != 0) {
                        int ind = 0;
                        for (String type : types) {
                            Mapping<?> map;
                            String tSuffix = "";
                            if (type.contains("[]")) {
                                tSuffix = type.substring(type.indexOf("["));
                                type = type.substring(0, type.indexOf("["));
                            }
                            if ((map = this.mapClassToMapping(type, t2 -> true, true)) != null) {
                                types[ind++] = map.name + tSuffix;
                                continue;
                            }
                            ++ind;
                        }
                        t4.argumentTypes = types;
                    }
                    if ((map22 = this.mapClassToMapping(t4.type, t2 -> true, true)) == null) continue;
                    t4.type = map22.name;
                    continue;
                }
                if (!t4.mappingType.equals((Object)MAPTYPE.PROPERTY) || (map2 = this.mapClassToMapping(t4.type, t2 -> true, true)) == null) continue;
                t4.type = map2.name;
            }
        }
        return (T)this;
    }

    public T parseTinyV2Mappings(String mappings, String inputClassifier, String outputClassifier) {
        this.mappingType = MAPTYPE.TOPLEVEL;
        this.name = null;
        this.type = null;
        this.obfuscated = null;
        mappings = mappings.replace("\r", "");
        String[] lines = mappings.split("\n");
        TargetMap mp = new TargetMap();
        int id1 = 0;
        int id2 = 0;
        int index = 0;
        int count = lines.length;
        for (String line : lines) {
            if (!line.startsWith("#") && !line.isEmpty()) continue;
            --count;
        }
        String[] newlines = new String[count];
        count = 0;
        for (String line : lines) {
            if (line.startsWith("#") || line.isEmpty()) continue;
            newlines[count++] = line;
        }
        lines = newlines;
        String[] tagsHeader = lines[0].split("\t");
        if (tagsHeader[0].equals("v1")) {
            LogManager.getLogger().warn("WARNING: Called the Tiny 2.0 parser for Tiny v1 mappings! The request is delegated to the legacy parser, this behaviour will be removed in Cyan 2.0!");
            return this.parseTinyV1Mappings(mappings, inputClassifier, outputClassifier);
        }
        for (String str : tagsHeader) {
            if (str.equals(inputClassifier)) {
                id1 = index;
            } else if (str.equals(outputClassifier)) {
                id2 = index;
            }
            ++index;
        }
        Target last = null;
        block13: for (int i = 1; i < lines.length; ++i) {
            String line = lines[i];
            String[] tags = line.split("\t");
            if (tags[0].isEmpty()) {
                if (tags[1].equals("c")) continue;
                tags = Arrays.copyOfRange(tags, 1, tags.length);
            }
            switch (tags[0]) {
                case "c": {
                    Target t3 = new Target();
                    t3.in = tags[id1 - 2];
                    t3.out = tags[id2 - 2];
                    last = t3;
                    mp.put(t3.in, t3);
                    continue block13;
                }
                case "f": {
                    String returnTypeF = tags[1];
                    Target field = new Target();
                    field.in = tags[id1 - 1];
                    field.out = tags[id2 - 1];
                    field.type = Fluid.parseDescriptor(returnTypeF);
                    last.fields.add(field);
                    continue block13;
                }
                case "m": {
                    String descriptor = tags[1];
                    String returnType = Fluid.parseDescriptor(descriptor.substring(descriptor.lastIndexOf(")") + 1));
                    String types = descriptor.substring(0, descriptor.lastIndexOf(")"));
                    types = types.substring(1);
                    String[] argTypes = Fluid.parseMultipleDescriptors(types);
                    Target method = new Target();
                    method.in = tags[id1 - 1];
                    method.out = tags[id2 - 1];
                    method.types = argTypes;
                    method.type = returnType;
                    last.methods.add(method);
                    continue block13;
                }
            }
        }
        for (Mapping<?> m : this.mappings = (Mapping[])mp.values().stream().map(t -> {
            Mapping map = new Mapping();
            map.mappingType = MAPTYPE.CLASS;
            map.obfuscated = t.in.replace("/", ".");
            map.name = t.out.replace("/", ".");
            ArrayList localmappings = new ArrayList();
            for (Target meth : t.methods) {
                Mapping methmap = new Mapping();
                methmap.argumentTypes = meth.types;
                methmap.name = meth.out;
                methmap.obfuscated = meth.in;
                methmap.type = meth.type;
                methmap.mappingType = MAPTYPE.METHOD;
                localmappings.add(methmap);
            }
            for (Target field : t.fields) {
                Mapping fieldmap = new Mapping();
                fieldmap.name = field.out;
                fieldmap.obfuscated = field.in;
                fieldmap.type = field.type;
                fieldmap.mappingType = MAPTYPE.PROPERTY;
                localmappings.add(fieldmap);
            }
            map.mappings = (Mapping[])localmappings.toArray(Mapping[]::new);
            return map;
        }).toArray(Mapping[]::new)) {
            for (Mapping<?> t4 : m.mappings) {
                Mapping<?> map2;
                if (t4.mappingType.equals((Object)MAPTYPE.METHOD)) {
                    Mapping<?> map22;
                    String[] types = t4.argumentTypes;
                    if (types.length != 0) {
                        int ind = 0;
                        for (String type : types) {
                            Mapping<?> map;
                            String tSuffix = "";
                            if (type.contains("[]")) {
                                tSuffix = type.substring(type.indexOf("["));
                                type = type.substring(0, type.indexOf("["));
                            }
                            if ((map = this.mapClassToMapping(type, t2 -> true, true)) != null) {
                                types[ind++] = map.name + tSuffix;
                                continue;
                            }
                            ++ind;
                        }
                        t4.argumentTypes = types;
                    }
                    if ((map22 = this.mapClassToMapping(t4.type, t2 -> true, true)) == null) continue;
                    t4.type = map22.name;
                    continue;
                }
                if (!t4.mappingType.equals((Object)MAPTYPE.PROPERTY) || (map2 = this.mapClassToMapping(t4.type, t2 -> true, true)) == null) continue;
                t4.type = map2.name;
            }
        }
        return (T)this;
    }

    public T parseCSRGMappings(String mappings) {
        this.mappingType = MAPTYPE.TOPLEVEL;
        this.name = null;
        this.type = null;
        this.obfuscated = null;
        mappings = mappings.replace("\r", "");
        String[] mappingsLines = mappings.split("\n");
        HashMap<String, Mapping> mappingsCache = new HashMap<String, Mapping>();
        block5: for (String line : mappingsLines) {
            if (line.startsWith("#")) continue;
            String[] entries = line.split(" ");
            switch (entries.length) {
                case 2: {
                    String obfus = entries[0].replace(".", "").replace("/", ".");
                    String deobf = entries[1].replace(".", "").replace("/", ".");
                    Mapping clsMapping = new SimpleMappings();
                    if (mappingsCache.containsKey(deobf)) {
                        clsMapping = (Mapping)mappingsCache.get(deobf);
                    }
                    clsMapping.mappingType = MAPTYPE.CLASS;
                    clsMapping.obfuscated = obfus;
                    clsMapping.name = deobf;
                    mappingsCache.put(deobf, clsMapping);
                    continue block5;
                }
                case 3: {
                    String owner = entries[0].replace(".", "").replace("/", ".");
                    String obfus = entries[1].replace(".", "").replace("/", ".");
                    String deobf = entries[2].replace(".", "").replace("/", ".");
                    Mapping fOwnerMap = (Mapping)mappingsCache.get(owner);
                    if (fOwnerMap == null) {
                        fOwnerMap = new SimpleMappings();
                        fOwnerMap.mappingType = MAPTYPE.CLASS;
                        fOwnerMap.obfuscated = owner;
                        fOwnerMap.name = owner;
                        mappingsCache.put(owner, fOwnerMap);
                    }
                    SimpleMappings fieldMap = new SimpleMappings();
                    fieldMap.mappingType = MAPTYPE.PROPERTY;
                    fieldMap.obfuscated = obfus;
                    fieldMap.name = deobf;
                    fOwnerMap.mappings = this.appendMapping(fieldMap, fOwnerMap.mappings);
                    continue block5;
                }
                case 4: {
                    String owner = entries[0].replace(".", "").replace("/", ".");
                    String obfus = entries[1].replace(".", "").replace("/", ".");
                    String desc = entries[2];
                    String deobf = entries[3].replace(".", "").replace("/", ".");
                    Mapping mOwnerMap = (Mapping)mappingsCache.get(owner);
                    if (mOwnerMap == null) {
                        mOwnerMap = new SimpleMappings();
                        mOwnerMap.mappingType = MAPTYPE.CLASS;
                        mOwnerMap.obfuscated = owner;
                        mOwnerMap.name = owner;
                        mappingsCache.put(owner, mOwnerMap);
                    }
                    SimpleMappings methMap = new SimpleMappings();
                    methMap.mappingType = MAPTYPE.METHOD;
                    methMap.obfuscated = obfus;
                    methMap.name = deobf;
                    methMap.argumentTypes = Fluid.parseMultipleDescriptors(desc.substring(1, desc.lastIndexOf(")")));
                    methMap.type = Fluid.parseDescriptor(desc.substring(desc.lastIndexOf(")") + 1));
                    mOwnerMap.mappings = this.appendMapping(methMap, mOwnerMap.mappings);
                    continue block5;
                }
            }
        }
        this.mappings = (Mapping[])mappingsCache.values().toArray(Mapping[]::new);
        return (T)this;
    }

    private Mapping<?>[] appendMapping(Mapping<?> append, Mapping<?>[] old) {
        Mapping[] newMaps = new Mapping[old.length + 1];
        for (int i = 0; i < old.length; ++i) {
            newMaps[i] = old[i];
        }
        newMaps[newMaps.length - 1] = append;
        return newMaps;
    }

    public T parseMultiMappings(Mapping<?> fallback, String classMappingsCsrg, String memberMappingsCsrg, String packageMappingsSrg, Map<String, String> finalPackageMappings) {
        Object type;
        Mapping<T> map;
        this.mappingType = MAPTYPE.TOPLEVEL;
        this.name = null;
        this.type = null;
        this.obfuscated = null;
        classMappingsCsrg = classMappingsCsrg.replace("\r", "");
        memberMappingsCsrg = memberMappingsCsrg.replace("\r", "");
        packageMappingsSrg = packageMappingsSrg.replace("\r", "");
        String[] linesClasses = classMappingsCsrg.split("\n");
        String[] linesMembers = memberMappingsCsrg.split("\n");
        String[] linesPackages = packageMappingsSrg.split("\n");
        HashMap<String, String> packages = new HashMap<String, String>();
        for (String string : linesPackages) {
            if (string.startsWith("#") || string.isEmpty()) continue;
            String[] entries = string.split(" ");
            String obfus = entries[0];
            String deobf = entries[1];
            if (obfus.endsWith("/")) {
                obfus = obfus.substring(0, obfus.length() - 1);
            }
            if (deobf.endsWith("/")) {
                deobf = deobf.substring(0, deobf.length() - 1);
            }
            obfus = obfus.replace(".", "");
            deobf = deobf.replace(".", "");
            obfus = obfus.replace("/", ".");
            deobf = deobf.replace("/", ".");
            packages.put(obfus, deobf);
        }
        ArrayList<String> obfusCache = new ArrayList<String>();
        HashMap<String, Mapping<T>> tempMappings = new HashMap<String, Mapping<T>>();
        HashMap<String, Mapping<T>> classes = new HashMap<String, Mapping<T>>();
        for (String line : linesClasses) {
            if (line.startsWith("#")) continue;
            String[] entries = line.split(" ");
            String string = entries[0];
            String deobf = entries[1];
            String string2 = string.replace(".", "");
            deobf = deobf.replace(".", "");
            String string3 = string2.replace("/", ".");
            deobf = deobf.replace("/", ".");
            String obfusPackage = "";
            if (string3.contains(".")) {
                obfusPackage = string3.substring(0, string3.lastIndexOf("."));
            }
            String deobfPackage = packages.getOrDefault(obfusPackage, obfusPackage);
            String deobfOld = deobf;
            if (deobf.contains(".")) {
                deobfPackage = deobf.substring(0, deobf.lastIndexOf("."));
                deobf = deobf.substring(deobf.lastIndexOf(".") + 1);
                deobfPackage = packages.getOrDefault(deobfPackage, deobfPackage);
            }
            map = new Mapping<T>();
            map.mappingType = MAPTYPE.CLASS;
            map.obfuscated = string3;
            map.name = (String)(deobfPackage.isEmpty() ? "" : deobfPackage + ".") + deobf;
            classes.put(deobfOld, map);
            tempMappings.put(map.obfuscated, map);
            obfusCache.add(string3);
        }
        HashMap<CallSite, String> hashMap = new HashMap<CallSite, String>();
        for (Mapping<?> clsMapping : fallback.mappings) {
            if (clsMapping.mappingType != MAPTYPE.CLASS) continue;
            if (!obfusCache.contains(clsMapping.obfuscated)) {
                String owner;
                Mapping<T> mapping = new Mapping<T>();
                mapping.mappingType = MAPTYPE.CLASS;
                mapping.obfuscated = clsMapping.obfuscated;
                mapping.name = clsMapping.name;
                if (clsMapping.obfuscated.contains("$") && tempMappings.containsKey(owner = clsMapping.obfuscated.substring(0, clsMapping.obfuscated.indexOf("$")))) {
                    owner = ((Mapping)tempMappings.get((Object)owner)).name;
                    mapping.name = owner + "$" + clsMapping.obfuscated.substring(clsMapping.obfuscated.indexOf("$") + 1);
                }
                classes.put(mapping.name, mapping);
                tempMappings.put(mapping.obfuscated, mapping);
                obfusCache.add(clsMapping.name);
            }
            for (Mapping<?> member : clsMapping.mappings) {
                if (member.mappingType != MAPTYPE.PROPERTY) continue;
                type = member.type;
                Mapping<?> mp = fallback.mapClassToMapping((String)type, t -> true, false);
                if (mp != null) {
                    type = mp.obfuscated;
                }
                hashMap.put((CallSite)((Object)(clsMapping.obfuscated + " " + member.obfuscated)), (String)type);
            }
        }
        for (String line : linesMembers) {
            String pkg;
            if (line.startsWith("#")) continue;
            String[] stringArray = line.split(" ");
            String owner = stringArray[0];
            owner = owner.replace(".", "");
            owner = owner.replace("/", ".");
            String obfus = stringArray[1];
            Mapping ownerClass = (Mapping)classes.get(owner);
            type = (String)hashMap.get(ownerClass.obfuscated + " " + obfus);
            if (type != null) {
                for (Mapping clsMapping : classes.values()) {
                    if (!clsMapping.obfuscated.equals(type)) continue;
                    type = clsMapping.name;
                    break;
                }
            }
            map = new Mapping<T>();
            String name = "";
            if (stringArray.length == 3) {
                name = stringArray[2];
                map.mappingType = MAPTYPE.PROPERTY;
            } else {
                name = stringArray[3];
                String[] types = Fluid.parseMultipleDescriptors(stringArray[2].substring(1, stringArray[2].lastIndexOf(")")));
                type = Fluid.parseDescriptor(stringArray[2].substring(stringArray[2].lastIndexOf(")") + 1));
                if (classes.containsKey(type)) {
                    pkg = "";
                    if (((String)type).contains(".")) {
                        pkg = ((String)type).substring(0, ((String)type).lastIndexOf("."));
                        type = ((String)type).substring(((String)type).lastIndexOf(".") + 1);
                    }
                    type = (String)((pkg = packages.getOrDefault(pkg, pkg)).isEmpty() ? "" : pkg + ".") + (String)type;
                }
                map.argumentTypes = types;
                map.mappingType = MAPTYPE.METHOD;
            }
            if (map.argumentTypes != null && map.mappingType == MAPTYPE.METHOD) {
                for (int i = 0; i < map.argumentTypes.length; ++i) {
                    if (!classes.containsKey(map.argumentTypes[i])) continue;
                    pkg = "";
                    if (map.argumentTypes[i].contains(".")) {
                        pkg = map.argumentTypes[i].substring(0, map.argumentTypes[i].lastIndexOf("."));
                        map.argumentTypes[i] = map.argumentTypes[i].substring(map.argumentTypes[i].lastIndexOf(".") + 1);
                    }
                    pkg = packages.getOrDefault(pkg, pkg);
                    map.argumentTypes[i] = (String)(pkg.isEmpty() ? "" : pkg + ".") + map.argumentTypes[i];
                }
            }
            map.type = type;
            map.name = name;
            map.obfuscated = obfus;
            ArrayList<Mapping<T>> mappings = new ArrayList<Mapping<T>>();
            mappings.addAll(Arrays.asList(ownerClass.mappings));
            mappings.add(map);
            ownerClass.mappings = (Mapping[])mappings.toArray(Mapping[]::new);
        }
        for (Mapping cls : classes.values()) {
            cls.name = Mapping.getNewName(cls.name, finalPackageMappings);
            for (Mapping<?> member : cls.mappings) {
                member.type = Mapping.getNewName(member.type, finalPackageMappings);
                if (member.argumentTypes == null) continue;
                for (int i = 0; i < member.argumentTypes.length; ++i) {
                    member.argumentTypes[i] = Mapping.getNewName(member.argumentTypes[i], finalPackageMappings);
                }
            }
        }
        this.mappings = (Mapping[])classes.values().toArray(Mapping[]::new);
        return (T)this;
    }

    /*
     * WARNING - void declaration
     */
    public static String getNewName(String clsIn, Map<String, String> finalPackageMappings) {
        for (String string : finalPackageMappings.keySet()) {
            Object base;
            String endPkg;
            Object packageOut = finalPackageMappings.get(string);
            boolean match = false;
            Object pkg = "";
            String clName = clsIn;
            if (clName.contains(".")) {
                pkg = clName.substring(0, clName.lastIndexOf("."));
                clName = clName.substring(clName.lastIndexOf(".") + 1);
            }
            if ((endPkg = pkg).contains(".")) {
                endPkg = endPkg.substring(endPkg.lastIndexOf(".") + 1);
            }
            if (string.endsWith("**")) {
                Object pkgIn = string.substring(0, string.length() - 2);
                if (!((String)pkgIn).endsWith(".")) {
                    pkgIn = (String)pkgIn + ".";
                }
                if (((String)pkg + ".").startsWith((String)pkgIn)) {
                    match = true;
                }
            } else if (string.endsWith("*")) {
                String basePackage = string;
                if (basePackage.endsWith(".*")) {
                    if (((basePackage = basePackage.substring(0, basePackage.lastIndexOf("."))) + "." + endPkg).equals(pkg) || ((String)pkg).equals(basePackage)) {
                        match = true;
                    }
                } else if (basePackage.equals("*") && endPkg.equals(pkg)) {
                    match = true;
                }
            } else {
                match = ((String)pkg).equals(string);
            }
            if (!match) continue;
            if (((String)packageOut).endsWith("**")) {
                void var3_7;
                void var3_4;
                while (var3_4.endsWith("*")) {
                    String string2 = var3_4.substring(0, var3_4.lastIndexOf("*"));
                }
                if (((String)(packageOut = ((String)packageOut).substring(0, ((String)packageOut).lastIndexOf("**")))).endsWith(".")) {
                    packageOut = ((String)packageOut).substring(0, ((String)packageOut).lastIndexOf("."));
                }
                if (!var3_4.endsWith(".")) {
                    String string3 = (String)var3_4 + ".";
                }
                if (!((String)(base = pkg)).endsWith(".")) {
                    base = (String)base + ".";
                }
                if (((String)(packageOut = (String)(((String)(base = ((String)base).substring(var3_7.length()))).isEmpty() ? packageOut : (String)packageOut + ".") + (String)base)).endsWith(".")) {
                    packageOut = ((String)packageOut).substring(0, ((String)packageOut).lastIndexOf("."));
                }
            } else if (((String)packageOut).endsWith("*")) {
                void var3_11;
                void var3_8;
                while (var3_8.endsWith("*")) {
                    String string4 = var3_8.substring(0, var3_8.lastIndexOf("*"));
                }
                if (!var3_8.endsWith(".")) {
                    String string5 = (String)var3_8 + ".";
                }
                if (!((String)pkg).endsWith(".")) {
                    pkg = (String)pkg + ".";
                }
                packageOut = ((String)packageOut).substring(0, ((String)packageOut).lastIndexOf("*"));
                base = ((String)pkg).substring(var3_11.length());
                if (((String)base).contains(".")) {
                    base = ((String)base).substring(0, ((String)base).indexOf("."));
                }
                if (((String)packageOut).contains(".")) {
                    packageOut = ((String)packageOut).substring(0, ((String)packageOut).lastIndexOf("."));
                }
                packageOut = (String)(((String)packageOut).isEmpty() || ((String)base).isEmpty() ? packageOut : (String)packageOut + ".") + (String)base;
            }
            if (((String)packageOut).isEmpty()) {
                return clName;
            }
            return (String)packageOut + "." + clName;
        }
        return clsIn;
    }

    public Mapping<?> mapClassToMapping(String input, Function<Mapping<?>, Boolean> fn, boolean obfuscated) {
        if (input.contains("[]")) {
            input = input.substring(0, input.indexOf("[]"));
        }
        for (Mapping<?> map : this.mappings) {
            if (!(obfuscated ? map.obfuscated : map.name).equals(input) || map.mappingType != MAPTYPE.CLASS || !fn.apply(map).booleanValue()) continue;
            return map;
        }
        return null;
    }

    private static class TsrgFormats {
        public static String tsrg1 = "^\\(.*\\).* [A-Za-z0-9.$_\\[\\]]+$";
        public static String trsg1_mtc = "^\\((.*)\\)(.*) ([A-Za-z0-9.$_\\[\\]]+)$";
        public static String tsrg2 = "^\\(.*\\).* [A-Za-z0-9.$_\\[\\]<>]+ [0-9]+$";
        public static String trsg2_mtc = "^\\((.*)\\)(.*) ([A-Za-z0-9.$_\\[\\]<>]+) [0-9]+$";

        private TsrgFormats() {
        }

        public static String forVersion(int version) {
            switch (version) {
                case 1: {
                    return tsrg1;
                }
                case 2: {
                    return tsrg2;
                }
            }
            return null;
        }

        public static String forVersionMatcher(int version) {
            switch (version) {
                case 1: {
                    return trsg1_mtc;
                }
                case 2: {
                    return trsg2_mtc;
                }
            }
            return null;
        }
    }

    private class TargetMap
    extends HashMap<String, Target> {
        private static final long serialVersionUID = 7415810166801904059L;

        private TargetMap() {
        }
    }

    private class Target {
        public String in = "";
        public String out = "";
        public String type = "";
        public String[] types = new String[0];
        public ArrayList<Target> fields = new ArrayList();
        public ArrayList<Target> methods = new ArrayList();

        private Target() {
        }
    }
}

